/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.tests.AbstractTests;

public class FacetActionsTests
extends AbstractTests {
    private static IProjectFacet f1 = ProjectFacetsManager.getProjectFacet((String)"fat_f1");
    private static IProjectFacetVersion f1v1 = f1.getVersion("1.0");
    private static IProjectFacetVersion f1v2 = f1.getVersion("2.0");

    private FacetActionsTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("Facet Actions Tests");
        suite.addTest((Test)new FacetActionsTests("testMultiVersionInstall1"));
        suite.addTest((Test)new FacetActionsTests("testMultiVersionInstall2"));
        return suite;
    }

    public void testMultiVersionInstall1() throws CoreException {
        IFacetedProject fpj = this.createFacetedProject();
        IProject pj = fpj.getProject();
        fpj.installProjectFacet(f1v1, null, null);
        FacetActionsTests.assertTrue((boolean)F1v1InstallDelegate.getMarkerFile(pj).exists());
        FacetActionsTests.assertFalse((boolean)F1v2InstallDelegate.getMarkerFile(pj).exists());
    }

    public void testMultiVersionInstall2() throws CoreException {
        IFacetedProject fpj = this.createFacetedProject();
        IProject pj = fpj.getProject();
        fpj.installProjectFacet(f1v2, null, null);
        FacetActionsTests.assertFalse((boolean)F1v1InstallDelegate.getMarkerFile(pj).exists());
        FacetActionsTests.assertTrue((boolean)F1v2InstallDelegate.getMarkerFile(pj).exists());
    }

    public static final class F1v1InstallDelegate
    implements IDelegate {
        public static IFile getMarkerFile(IProject project) {
            return project.getFile("v1marker");
        }

        public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
            IFile marker = F1v1InstallDelegate.getMarkerFile(project);
            ByteArrayInputStream emptyStream = new ByteArrayInputStream(new byte[0]);
            marker.create((InputStream)emptyStream, false, null);
        }
    }

    public static final class F1v2InstallDelegate
    implements IDelegate {
        public static IFile getMarkerFile(IProject project) {
            return project.getFile("v2marker");
        }

        public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
            IFile marker = F1v2InstallDelegate.getMarkerFile(project);
            ByteArrayInputStream emptyStream = new ByteArrayInputStream(new byte[0]);
            marker.create((InputStream)emptyStream, false, null);
        }
    }
}

