/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.tests;

import java.io.IOException;
import java.util.HashSet;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.project.facet.core.IGroup;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.tests.AbstractTests;

public final class ProjectFacetGroupsTests
extends AbstractTests {
    private static IProjectFacet f1 = ProjectFacetsManager.getProjectFacet((String)"grp-f1");
    private static IProjectFacetVersion f1v10 = f1.getVersion("1.0");
    private static IProjectFacetVersion f1v12 = f1.getVersion("1.2");
    private static IProjectFacetVersion f1v20 = f1.getVersion("2.0");
    private static IProjectFacet f2 = ProjectFacetsManager.getProjectFacet((String)"grp-f2");
    private static IProjectFacetVersion f2v10 = f2.getVersion("1.0");
    private static IProjectFacetVersion f2v12 = f2.getVersion("1.2");
    private static IProjectFacetVersion f2v20 = f2.getVersion("2.0");
    private static IProjectFacet f3 = ProjectFacetsManager.getProjectFacet((String)"grp-f3");
    private static IProjectFacetVersion f3v10 = f3.getVersion("1.0");
    private static IProjectFacetVersion f3v12 = f3.getVersion("1.2");
    private static IProjectFacetVersion f3v20 = f3.getVersion("2.0");
    private static IProjectFacet f4 = ProjectFacetsManager.getProjectFacet((String)"grp-f4");
    private static IProjectFacetVersion f4v10 = f4.getVersion("1.0");
    private static IProjectFacetVersion f4v12 = f4.getVersion("1.2");
    private static IProjectFacetVersion f4v20 = f4.getVersion("2.0");
    private static IProjectFacet f5 = ProjectFacetsManager.getProjectFacet((String)"grp-f5");
    private static IProjectFacetVersion f5v10 = f5.getVersion("1.0");
    private static IProjectFacetVersion f5v12 = f5.getVersion("1.2");
    private static IProjectFacetVersion f5v20 = f5.getVersion("2.0");
    private static IProjectFacet f6 = ProjectFacetsManager.getProjectFacet((String)"grp-f6");
    private static IProjectFacetVersion f6v10 = f6.getVersion("1.0");
    private static IProjectFacetVersion f6v12 = f6.getVersion("1.2");
    private static IProjectFacetVersion f6v20 = f6.getVersion("2.0");

    private ProjectFacetGroupsTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("Project Facet Groups Tests");
        suite.addTest((Test)new ProjectFacetGroupsTests("testCreationAndEnlistment"));
        return suite;
    }

    public void testCreationAndEnlistment() throws CoreException, IOException {
        HashSet<IProjectFacetVersion> expected = new HashSet<IProjectFacetVersion>();
        expected.add(f1v10);
        expected.add(f1v12);
        expected.add(f1v20);
        expected.add(f2v12);
        expected.add(f3v12);
        expected.add(f3v20);
        expected.add(f4v10);
        expected.add(f4v12);
        expected.add(f4v20);
        expected.add(f5v10);
        expected.add(f5v12);
        expected.add(f6v12);
        expected.add(f6v20);
        ProjectFacetGroupsTests.assertTrue((boolean)ProjectFacetsManager.isGroupDefined((String)"grp-g1"));
        IGroup g1 = ProjectFacetsManager.getGroup((String)"grp-g1");
        ProjectFacetGroupsTests.assertEquals(expected, (Object)g1.getMembers());
        ProjectFacetGroupsTests.assertEquals((String)"Group 1", (String)g1.getLabel());
        ProjectFacetGroupsTests.assertEquals((String)"Description for Group 1.", (String)g1.getDescription());
        ProjectFacetGroupsTests.assertTrue((boolean)ProjectFacetsManager.isGroupDefined((String)"grp-g2"));
        IGroup g2 = ProjectFacetsManager.getGroup((String)"grp-g2");
        ProjectFacetGroupsTests.assertEquals(expected, (Object)g2.getMembers());
        ProjectFacetGroupsTests.assertEquals((String)"Group 2", (String)g2.getLabel());
        ProjectFacetGroupsTests.assertEquals((String)"Description for Group 2.", (String)g2.getDescription());
        ProjectFacetGroupsTests.assertTrue((boolean)ProjectFacetsManager.isGroupDefined((String)"grp-g3"));
        IGroup g3 = ProjectFacetsManager.getGroup((String)"grp-g3");
        ProjectFacetGroupsTests.assertEquals(expected, (Object)g3.getMembers());
        ProjectFacetGroupsTests.assertEquals((String)"grp-g3", (String)g3.getLabel());
        ProjectFacetGroupsTests.assertEquals((String)"", (String)g3.getDescription());
    }
}

