/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.validation.sample.parser;

import java.io.File;
import java.io.IOException;
import org.eclipse.jst.validation.sample.parser.APropertyFile;
import org.eclipse.jst.validation.sample.parser.MessageMetaData;
import org.eclipse.jst.validation.sample.parser.ResourceHandler;

public class PropertyFile
extends APropertyFile {
    private String _enclosingZipFileName = null;
    private String _propertyFileName = null;
    private String _fileName = null;

    public PropertyFile(String fileName) throws IOException {
        this(fileName, false);
    }

    public PropertyFile(String fileName, boolean trace) throws IOException {
        this(new File(fileName), trace);
    }

    public PropertyFile(File propertyFile) throws IOException {
        this(propertyFile, false);
    }

    public PropertyFile(File propertyFile, boolean trace) throws IOException {
        this(null, propertyFile, trace);
    }

    public PropertyFile(String enclosingZipFileName, File propertyFile) throws IOException {
        this(enclosingZipFileName, propertyFile, false);
    }

    public PropertyFile(String enclosingZipFileName, File propertyFile, boolean debug) throws IOException {
        if (!propertyFile.exists()) {
            throw new IOException("Cannot find file " + propertyFile.getName());
        }
        if (!propertyFile.isFile()) {
            throw new IOException(String.valueOf(propertyFile.getName()) + " is not a file");
        }
        if (!propertyFile.canRead()) {
            throw new IOException("Cannot read " + propertyFile.getName());
        }
        if (!propertyFile.getName().endsWith("properties")) {
            throw new IOException("Can parse only .properties files; ignoring " + propertyFile.getName());
        }
        this.setDebug(debug);
        this._enclosingZipFileName = enclosingZipFileName;
        this._fileName = propertyFile.getName();
        this.report("File name: " + this._fileName);
        this.parseFile(propertyFile);
        this.report("");
        propertyFile = null;
    }

    public void report(String str) {
        System.out.println(str);
    }

    public void report(MessageMetaData message) {
        StringBuffer buffer = new StringBuffer(message.getText(this.getClass().getClassLoader()));
        buffer.append(ResourceHandler.getExternalizedMessage("propertiesValidator", "LINE_LOC", new String[]{String.valueOf(message.getLineNumber()), this.getQualifiedFileName()}));
        this.report(buffer.toString());
    }

    public String getQualifiedFileName() {
        if (this._propertyFileName == null) {
            this._propertyFileName = this._enclosingZipFileName == null ? this._fileName : String.valueOf(this._enclosingZipFileName) + "::" + this._fileName;
        }
        return this._propertyFileName;
    }

    public String getFileName() {
        return this._fileName;
    }
}

