/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.validation.sample.workbenchimpl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Locale;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.validation.sample.parser.APropertyFile;
import org.eclipse.jst.validation.sample.parser.MessageMetaData;
import org.eclipse.jst.validation.sample.workbenchimpl.PropertiesValidatorPlugin;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public class PluginPropertyFile
extends APropertyFile {
    private String _bundleName;
    private String _pluginId;
    private String _langVariant;
    private ClassLoader _classLoader;

    public PluginPropertyFile(String pluginId, String bundleName) {
        ClassLoader cl;
        block6: {
            Logger logger;
            InputStream inS;
            block5: {
                this._bundleName = null;
                this._pluginId = null;
                this._langVariant = null;
                this._classLoader = null;
                this._pluginId = pluginId;
                this._bundleName = bundleName;
                cl = null;
                inS = null;
                Plugin plugin = PluginPropertyFile.getPlugin(pluginId);
                cl = bundleName.equals("plugin") ? PluginPropertyFile.getPluginPropertiesClassLoader(plugin) : plugin.getDescriptor().getPluginClassLoader();
                inS = this.getInputStream(cl, bundleName);
                InputStreamReader inR = new InputStreamReader(inS);
                LineNumberReader lineR = new LineNumberReader(inR);
                this.parseFile(lineR);
                try {
                    lineR.close();
                    inR.close();
                }
                catch (IOException exc) {
                    logger = PropertiesValidatorPlugin.getPlugin().getMsgLogger();
                    if (!logger.isLoggingLevel(Level.SEVERE)) break block5;
                    logger.write(Level.SEVERE, (Exception)exc);
                }
            }
            try {
                if (inS != null) {
                    inS.close();
                }
            }
            catch (IOException exc) {
                logger = PropertiesValidatorPlugin.getPlugin().getMsgLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) break block6;
                logger.write(Level.SEVERE, (Exception)exc);
            }
        }
        this._classLoader = cl;
    }

    private InputStream getInputStream(ClassLoader cl, String bundleName) {
        Locale l = Locale.getDefault();
        String language = l.getLanguage();
        String country = l.getCountry();
        String variant = l.getVariant();
        String lang = null;
        String lang_country = null;
        String lang_country_variant = null;
        if (language != null && !language.equals("")) {
            lang = "_" + language;
        }
        if (country != null && !country.equals("")) {
            lang_country = String.valueOf(lang) + "_" + country;
        }
        if (variant != null && !variant.equals("")) {
            lang_country_variant = String.valueOf(lang_country) + "_" + variant;
        }
        InputStream inS = null;
        if (lang_country_variant != null && (inS = PluginPropertyFile.getResourceAsStream(cl, bundleName, lang_country_variant)) != null) {
            this._langVariant = lang_country_variant;
            return inS;
        }
        if (lang_country != null && (inS = PluginPropertyFile.getResourceAsStream(cl, bundleName, lang_country)) != null) {
            this._langVariant = lang_country;
            return inS;
        }
        if (lang != null && (inS = PluginPropertyFile.getResourceAsStream(cl, bundleName, lang)) != null) {
            this._langVariant = lang;
            return inS;
        }
        if (Locale.getDefault().equals(Locale.US) && (inS = PluginPropertyFile.getResourceAsStream(cl, bundleName, "")) != null) {
            this._langVariant = "";
            return inS;
        }
        return null;
    }

    private static final InputStream getResourceAsStream(ClassLoader cl, String bundleName, String language) {
        String resName = String.valueOf(bundleName.replace('.', '/')) + language + ".properties";
        return cl.getResourceAsStream(resName);
    }

    private static ClassLoader getPluginPropertiesClassLoader(Plugin p) {
        URL[] cp = ((URLClassLoader)p.getDescriptor().getPluginClassLoader()).getURLs();
        URL[] newcp = new URL[cp.length + 1];
        int i = 0;
        while (i < cp.length) {
            newcp[i + 1] = cp[i];
            ++i;
        }
        try {
            newcp[0] = Platform.resolve((URL)p.getBundle().getEntry("/"));
        }
        catch (IOException iOException) {
            newcp[0] = p.getBundle().getEntry("/");
        }
        URLClassLoader resourceLoader = new URLClassLoader(newcp, null);
        return resourceLoader;
    }

    private static Plugin getPlugin(String pluginId) {
        if (pluginId == null) {
            return null;
        }
        IPluginRegistry registry = Platform.getPluginRegistry();
        IPluginDescriptor pluginDesc = registry.getPluginDescriptor(pluginId);
        if (pluginDesc == null) {
            return null;
        }
        try {
            return pluginDesc.getPlugin();
        }
        catch (CoreException exc) {
            Logger logger = PropertiesValidatorPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                logger.write(Level.SEVERE, (Exception)((Object)exc));
            }
            return null;
        }
    }

    public void report(String str) {
        this.addParseWarning(new MessageMetaData(str));
    }

    public void report(IMessage message) {
        MessageMetaData mmd = new MessageMetaData(message.getBundleName(), message.getSeverity(), message.getId(), message.getParams(), message.getTargetObject(), message.getLineNumber(), message.getOffset(), message.getLength());
        this.addParseWarning(mmd);
    }

    public void report(MessageMetaData mmd) {
        this.addParseWarning(mmd);
    }

    public void addParseWarning(IMessage message) {
        MessageMetaData mmd = new MessageMetaData(message.getBundleName(), message.getSeverity(), message.getId(), message.getParams(), message.getTargetObject(), message.getLineNumber(), message.getOffset(), message.getLength());
        this.addParseWarning(mmd);
    }

    public String getPluginId() {
        return this._pluginId;
    }

    public String getBundleName() {
        return this._bundleName;
    }

    public String getQualifiedFileName() {
        StringBuffer buffer = new StringBuffer(this.getPluginId());
        buffer.append("::");
        buffer.append(this.getBundleName());
        buffer.append(this._langVariant);
        return buffer.toString();
    }

    public String getLangVariant() {
        return this._langVariant;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }
}

