package oracle.adfdemo.view.faces.survey;

/***
 *  class TextQuestionBean
 *
 * This bean represents a single question with a text field as its answer form.
 * It has fields for the question prompt and the correct answer.
 *
 * ***/


public class TextQuestionBean implements java.io.Serializable
{
  /** The question as a String object. */
  private String    _prompt;

  /** The correct answer. */
  private String    _correctAnswer;

 /**
  *  Class constructor (no arguments).
  */
  public TextQuestionBean()
  {
    _prompt = "";
    _correctAnswer = "";
  }

 /**
  *  Class constructor.
  */
  public TextQuestionBean(String prompt, String correctAnswer)
  {
    _prompt = prompt;
    _correctAnswer = correctAnswer;
  }


  /*** JDev generated accessors ***/

  public void setPrompt(String prompt)
  {
    _prompt = prompt;
  }

  public String getPrompt()
  {
    return _prompt;
  }

  public String getCorrectAnswer()
  {
    return _correctAnswer;
  }

  public String getCorrectAnswerMessage()
  {
    return "The correct answer is: " + _correctAnswer;
  }


}
