/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.AssociationOverride;
import org.eclipse.jpt.jpa.core.context.AttributeOverride;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.Embeddable;
import org.eclipse.jpt.jpa.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.ManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.ManyToOneMapping;
import org.eclipse.jpt.jpa.core.context.OneToManyMapping;
import org.eclipse.jpt.jpa.core.context.OneToOneMapping;
import org.eclipse.jpt.jpa.core.context.SpecifiedAssociationOverride;
import org.eclipse.jpt.jpa.core.context.SpecifiedAttributeOverride;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinTableRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.TransientMapping;
import org.eclipse.jpt.jpa.core.context.VersionMapping;
import org.eclipse.jpt.jpa.core.context.VirtualAssociationOverride;
import org.eclipse.jpt.jpa.core.context.VirtualAttributeOverride;
import org.eclipse.jpt.jpa.core.context.VirtualJoinColumn;
import org.eclipse.jpt.jpa.core.context.VirtualJoinColumnRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.VirtualJoinTable;
import org.eclipse.jpt.jpa.core.context.VirtualJoinTableRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.java.JavaAssociationOverrideContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaEmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedAssociationOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedAttributeOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaVirtualAssociationOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaVirtualAttributeOverride;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.java.GenericJavaNullAttributeMapping;
import org.eclipse.jpt.jpa.core.jpa2.context.ElementCollectionMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.VirtualOverrideRelationship2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaEmbeddedMapping2_0;
import org.eclipse.jpt.jpa.core.resource.java.AssociationOverrideAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.AttributeOverrideAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.Generic2_0ContextModelTestCase;

public class GenericJavaEmbeddedMapping2_0Tests
extends Generic2_0ContextModelTestCase {
    public static final String EMBEDDABLE_TYPE_NAME = "MyEmbeddable";
    public static final String FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME = "test.MyEmbeddable";

    private ICompilationUnit createTestEntityWithEmbeddedMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Embedded", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Embedded").append(CR);
                sb.append("    private MyEmbeddable myEmbedded;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    private void createEmbeddableType() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append("import ");
                sb.append("javax.persistence.OneToOne");
                sb.append(";");
                sb.append("import ");
                sb.append("javax.persistence.OneToMany");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append(GenericJavaEmbeddedMapping2_0Tests.EMBEDDABLE_TYPE_NAME).append(" {");
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private String state;").append(CR);
                sb.append(CR);
                sb.append("    @OneToOne").append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private java.util.Collection<Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    ");
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "MyEmbeddable.java", sourceWriter);
    }

    private void createAddressEntity() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class Address {");
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private String id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private String state;").append(CR);
                sb.append(CR);
                sb.append("    ");
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEntityCustomer() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Customer").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private String id;").append(CR);
                sb.append(CR);
                sb.append("    private String name;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Customer.java", sourceWriter);
    }

    private void createTestEmbeddableAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String street;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private String state;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private ZipCode zipCode;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEmbeddableZipCode() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("ZipCode").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String zip;").append(CR);
                sb.append(CR);
                sb.append("    private String plusfour;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "ZipCode.java", sourceWriter);
    }

    public GenericJavaEmbeddedMapping2_0Tests(String name) {
        super(name);
    }

    public void testMorphToBasicMapping() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaSpecifiedPersistentAttribute persistentAttribute = this.getJavaPersistentType().getAttributeNamed("myEmbedded");
        JavaEmbeddedMapping embeddedMapping = (JavaEmbeddedMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        resourceField.addAnnotation(0, "javax.persistence.AssociationOverride");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        persistentAttribute.setMappingKey("basic");
        GenericJavaEmbeddedMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof BasicMapping));
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Embedded"));
        GenericJavaEmbeddedMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Basic"));
        GenericJavaEmbeddedMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.AttributeOverride"));
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.AssociationOverride"));
    }

    public void testMorphToDefault() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        JavaSpecifiedPersistentAttribute persistentAttribute = this.getJavaPersistentType().getAttributeNamed("myEmbedded");
        JavaEmbeddedMapping embeddedMapping = (JavaEmbeddedMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        resourceField.addAnnotation(0, "javax.persistence.AssociationOverride");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        persistentAttribute.setMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        GenericJavaEmbeddedMapping2_0Tests.assertTrue((boolean)((JavaEmbeddedMapping)persistentAttribute.getMapping()).getAttributeOverrideContainer().getOverrides().iterator().hasNext());
        GenericJavaEmbeddedMapping2_0Tests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Embedded"));
        GenericJavaEmbeddedMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaEmbeddedMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.AttributeOverride"));
        GenericJavaEmbeddedMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.AssociationOverride"));
    }

    public void testDefaultEmbeddedMapping() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaSpecifiedPersistentAttribute persistentAttribute = this.getJavaPersistentType().getAttributeNamed("myEmbedded");
        JavaEmbeddedMapping embeddedMapping = (JavaEmbeddedMapping)persistentAttribute.getMapping();
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        persistentAttribute.setMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        GenericJavaEmbeddedMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof GenericJavaNullAttributeMapping));
        GenericJavaEmbeddedMapping2_0Tests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        this.createEmbeddableType();
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        GenericJavaEmbeddedMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof JavaEmbeddedMapping));
        GenericJavaEmbeddedMapping2_0Tests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
    }

    public void testDefaultEmbeddedMappingGenericEmbeddable() throws Exception {
        this.createTestEntityWithDefaultEmbeddedMapping();
        this.createTestGenericEmbeddable();
        this.addXmlClassRef("test.Entity1");
        this.addXmlClassRef("test.Embeddable1");
        JavaSpecifiedPersistentAttribute persistentAttribute = this.getJavaPersistentType().getAttributeNamed("myEmbeddable");
        GenericJavaEmbeddedMapping2_0Tests.assertNotNull((Object)persistentAttribute.getMapping());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"embedded", (String)persistentAttribute.getDefaultMappingKey());
        GenericJavaEmbeddedMapping2_0Tests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
    }

    private void createTestEntityWithDefaultEmbeddedMapping() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class Entity1 { ").append(CR);
                sb.append("private Embeddable1<Integer> myEmbeddable;").append(CR);
                sb.append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Entity1.java", sourceWriter);
    }

    private void createTestGenericEmbeddable() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class Embeddable1<T> {}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Embeddable1.java", sourceWriter);
    }

    private void createSelfReferentialEmbedded() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR).append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("Foo").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private Foo embedded;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Foo.java", sourceWriter);
    }

    public void testMorphToVersionMapping() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaSpecifiedPersistentAttribute persistentAttribute = this.getJavaPersistentType().getAttributeNamed("myEmbedded");
        JavaEmbeddedMapping embeddedMapping = (JavaEmbeddedMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        resourceField.addAnnotation(0, "javax.persistence.AssociationOverride");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        persistentAttribute.setMappingKey("version");
        GenericJavaEmbeddedMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof VersionMapping));
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Embedded"));
        GenericJavaEmbeddedMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Version"));
        GenericJavaEmbeddedMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.AttributeOverride"));
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.AssociationOverride"));
    }

    public void testMorphToTransientMapping() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaSpecifiedPersistentAttribute persistentAttribute = this.getJavaPersistentType().getAttributeNamed("myEmbedded");
        JavaEmbeddedMapping embeddedMapping = (JavaEmbeddedMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        persistentAttribute.setMappingKey("transient");
        GenericJavaEmbeddedMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof TransientMapping));
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Embedded"));
        GenericJavaEmbeddedMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Transient"));
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.AttributeOverride"));
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.AssociationOverride"));
    }

    public void testMorphToIdMapping() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaSpecifiedPersistentAttribute persistentAttribute = this.getJavaPersistentType().getAttributeNamed("myEmbedded");
        JavaEmbeddedMapping embeddedMapping = (JavaEmbeddedMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        resourceField.addAnnotation(0, "javax.persistence.AssociationOverride");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        persistentAttribute.setMappingKey("id");
        GenericJavaEmbeddedMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof IdMapping));
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Embedded"));
        GenericJavaEmbeddedMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaEmbeddedMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.AttributeOverride"));
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.AssociationOverride"));
    }

    public void testMorphToEmbeddedIdMapping() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaSpecifiedPersistentAttribute persistentAttribute = this.getJavaPersistentType().getAttributeNamed("myEmbedded");
        JavaEmbeddedMapping embeddedMapping = (JavaEmbeddedMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        resourceField.addAnnotation(0, "javax.persistence.AssociationOverride");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        persistentAttribute.setMappingKey("embeddedId");
        GenericJavaEmbeddedMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Embedded"));
        GenericJavaEmbeddedMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.EmbeddedId"));
        GenericJavaEmbeddedMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaEmbeddedMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.AttributeOverride"));
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.AssociationOverride"));
    }

    public void testMorphToOneToOneMapping() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaSpecifiedPersistentAttribute persistentAttribute = this.getJavaPersistentType().getAttributeNamed("myEmbedded");
        JavaEmbeddedMapping embeddedMapping = (JavaEmbeddedMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        resourceField.addAnnotation(0, "javax.persistence.AssociationOverride");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        persistentAttribute.setMappingKey("oneToOne");
        GenericJavaEmbeddedMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToOneMapping));
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Embedded"));
        GenericJavaEmbeddedMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.OneToOne"));
        GenericJavaEmbeddedMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.AttributeOverride"));
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.AssociationOverride"));
    }

    public void testMorphToOneToManyMapping() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaSpecifiedPersistentAttribute persistentAttribute = this.getJavaPersistentType().getAttributeNamed("myEmbedded");
        JavaEmbeddedMapping embeddedMapping = (JavaEmbeddedMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        resourceField.addAnnotation(0, "javax.persistence.AssociationOverride");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        persistentAttribute.setMappingKey("oneToMany");
        GenericJavaEmbeddedMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToManyMapping));
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Embedded"));
        GenericJavaEmbeddedMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.OneToMany"));
        GenericJavaEmbeddedMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.AttributeOverride"));
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.AssociationOverride"));
    }

    public void testMorphToManyToOneMapping() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaSpecifiedPersistentAttribute persistentAttribute = this.getJavaPersistentType().getAttributeNamed("myEmbedded");
        JavaEmbeddedMapping embeddedMapping = (JavaEmbeddedMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        resourceField.addAnnotation(0, "javax.persistence.AssociationOverride");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        persistentAttribute.setMappingKey("manyToOne");
        GenericJavaEmbeddedMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToOneMapping));
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Embedded"));
        GenericJavaEmbeddedMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.ManyToOne"));
        GenericJavaEmbeddedMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.AttributeOverride"));
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.AssociationOverride"));
    }

    public void testMorphToManyToManyMapping() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaSpecifiedPersistentAttribute persistentAttribute = this.getJavaPersistentType().getAttributeNamed("myEmbedded");
        JavaEmbeddedMapping embeddedMapping = (JavaEmbeddedMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        resourceField.addAnnotation(0, "javax.persistence.AssociationOverride");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        persistentAttribute.setMappingKey("manyToMany");
        GenericJavaEmbeddedMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToManyMapping));
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Embedded"));
        GenericJavaEmbeddedMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.ManyToMany"));
        GenericJavaEmbeddedMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaEmbeddedMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.AttributeOverride"));
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.AssociationOverride"));
    }

    public void testMorphToElementCollectionMapping() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaSpecifiedPersistentAttribute persistentAttribute = this.getJavaPersistentType().getAttributeNamed("myEmbedded");
        JavaEmbeddedMapping embeddedMapping = (JavaEmbeddedMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        resourceField.addAnnotation(0, "javax.persistence.AssociationOverride");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        persistentAttribute.setMappingKey("elementCollection");
        GenericJavaEmbeddedMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ElementCollectionMapping2_0));
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Embedded"));
        GenericJavaEmbeddedMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.ElementCollection"));
        GenericJavaEmbeddedMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaEmbeddedMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.AttributeOverride"));
        GenericJavaEmbeddedMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.AssociationOverride"));
    }

    public void testSpecifiedAttributeOverrides() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        JavaEmbeddedMapping embeddedMapping = (JavaEmbeddedMapping)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        JavaAttributeOverrideContainer attributeOverrideContainer = embeddedMapping.getAttributeOverrideContainer();
        ListIterator specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(1, "javax.persistence.AttributeOverride");
        attributeOverride.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        resourceField.moveAnnotation(1, 0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
    }

    public void testVirtualAttributeOverrides() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        JavaEmbeddedMapping embeddedMapping = (JavaEmbeddedMapping)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        JavaAttributeOverrideContainer attributeOverrideContainer = embeddedMapping.getAttributeOverrideContainer();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"myEmbedded", (String)resourceField.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.AttributeOverride"));
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)2, (int)attributeOverrideContainer.getVirtualOverridesSize());
        AttributeOverride defaultAttributeOverride = (AttributeOverride)attributeOverrideContainer.getVirtualOverrides().iterator().next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"city", (String)defaultAttributeOverride.getColumn().getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"AnnotationTestType", (String)defaultAttributeOverride.getColumn().getTableName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals(null, (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUnique());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isNullable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)255, (int)defaultAttributeOverride.getColumn().getLength());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getPrecision());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getScale());
        ListIterator classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        classRefs.next();
        Embeddable embeddable = (Embeddable)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        BasicMapping cityMapping = (BasicMapping)embeddable.getPersistentType().getAttributeNamed("city").getMapping();
        cityMapping.getColumn().setSpecifiedName("FOO");
        cityMapping.getColumn().setSpecifiedTableName("BAR");
        cityMapping.getColumn().setColumnDefinition("COLUMN_DEF");
        cityMapping.getColumn().setSpecifiedInsertable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedUpdatable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedUnique(Boolean.TRUE);
        cityMapping.getColumn().setSpecifiedNullable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedLength(Integer.valueOf(5));
        cityMapping.getColumn().setSpecifiedPrecision(Integer.valueOf(6));
        cityMapping.getColumn().setSpecifiedScale(Integer.valueOf(7));
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"myEmbedded", (String)resourceField.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.AttributeOverride"));
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)2, (int)attributeOverrideContainer.getVirtualOverridesSize());
        defaultAttributeOverride = (AttributeOverride)attributeOverrideContainer.getVirtualOverrides().iterator().next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)defaultAttributeOverride.getColumn().getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)defaultAttributeOverride.getColumn().getTableName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"COLUMN_DEF", (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUnique());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isNullable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)5, (int)defaultAttributeOverride.getColumn().getLength());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)6, (int)defaultAttributeOverride.getColumn().getPrecision());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)7, (int)defaultAttributeOverride.getColumn().getScale());
        cityMapping.getColumn().setSpecifiedName(null);
        cityMapping.getColumn().setSpecifiedTableName(null);
        cityMapping.getColumn().setColumnDefinition(null);
        cityMapping.getColumn().setSpecifiedInsertable(null);
        cityMapping.getColumn().setSpecifiedUpdatable(null);
        cityMapping.getColumn().setSpecifiedUnique(null);
        cityMapping.getColumn().setSpecifiedNullable(null);
        cityMapping.getColumn().setSpecifiedLength(null);
        cityMapping.getColumn().setSpecifiedPrecision(null);
        cityMapping.getColumn().setSpecifiedScale(null);
        defaultAttributeOverride = (AttributeOverride)attributeOverrideContainer.getVirtualOverrides().iterator().next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"city", (String)defaultAttributeOverride.getColumn().getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"AnnotationTestType", (String)defaultAttributeOverride.getColumn().getTableName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals(null, (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUnique());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isNullable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)255, (int)defaultAttributeOverride.getColumn().getLength());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getPrecision());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getScale());
        AttributeOverrideAnnotation annotation = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        annotation.setName("city");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)1, (int)attributeOverrideContainer.getVirtualOverridesSize());
    }

    public void testSpecifiedAttributeOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        JavaEmbeddedMapping embeddedMapping = (JavaEmbeddedMapping)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        JavaAttributeOverrideContainer attributeOverrideContainer = embeddedMapping.getAttributeOverrideContainer();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)attributeOverrideContainer.getSpecifiedOverridesSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)2, (int)attributeOverrideContainer.getSpecifiedOverridesSize());
    }

    public void testAttributeOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        JavaEmbeddedMapping embeddedMapping = (JavaEmbeddedMapping)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        JavaAttributeOverrideContainer attributeOverrideContainer = embeddedMapping.getAttributeOverrideContainer();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)2, (int)attributeOverrideContainer.getOverridesSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)4, (int)attributeOverrideContainer.getOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("city");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)4, (int)attributeOverrideContainer.getOverridesSize());
    }

    public void testVirtualAttributeOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        JavaEmbeddedMapping embeddedMapping = (JavaEmbeddedMapping)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        JavaAttributeOverrideContainer attributeOverrideContainer = embeddedMapping.getAttributeOverrideContainer();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)2, (int)attributeOverrideContainer.getVirtualOverridesSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)2, (int)attributeOverrideContainer.getVirtualOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("city");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)1, (int)attributeOverrideContainer.getVirtualOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("state");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)attributeOverrideContainer.getVirtualOverridesSize());
    }

    public void testAttributeOverrideSetVirtual() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        JavaEmbeddedMapping embeddedMapping = (JavaEmbeddedMapping)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        JavaAttributeOverrideContainer attributeOverrideContainer = embeddedMapping.getAttributeOverrideContainer();
        ((JavaVirtualAttributeOverride)attributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((JavaVirtualAttributeOverride)attributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ListIterator attributeOverrides = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"city", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"state", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        ((JavaSpecifiedAttributeOverride)attributeOverrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        attributeOverrides = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"state", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"city", (String)((JavaVirtualAttributeOverride)attributeOverrideContainer.getVirtualOverrides().iterator().next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)1, (int)attributeOverrideContainer.getVirtualOverridesSize());
        ((JavaSpecifiedAttributeOverride)attributeOverrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        attributeOverrides = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        ListIterator virtualAttributeOverrides = attributeOverrideContainer.getVirtualOverrides().iterator();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"city", (String)((JavaVirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"state", (String)((JavaVirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)2, (int)attributeOverrideContainer.getVirtualOverridesSize());
    }

    public void testAttributeOverrideSetVirtual2() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        JavaEmbeddedMapping embeddedMapping = (JavaEmbeddedMapping)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        JavaAttributeOverrideContainer attributeOverrideContainer = embeddedMapping.getAttributeOverrideContainer();
        ListIterator virtualAttributeOverrides = attributeOverrideContainer.getVirtualOverrides().iterator();
        virtualAttributeOverrides.next();
        ((JavaVirtualAttributeOverride)virtualAttributeOverrides.next()).convertToSpecified();
        ((JavaVirtualAttributeOverride)attributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ListIterator attributeOverrides = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"state", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"city", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
    }

    public void testMoveSpecifiedAttributeOverride() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        JavaEmbeddedMapping embeddedMapping = (JavaEmbeddedMapping)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        JavaAttributeOverrideContainer attributeOverrideContainer = embeddedMapping.getAttributeOverrideContainer();
        ((JavaVirtualAttributeOverride)attributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((JavaVirtualAttributeOverride)attributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.moveAnnotation(1, 0, "javax.persistence.AttributeOverride");
        ListIterator attributeOverrides = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"state", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"city", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
    }

    public void testSpecifiedAssociationOverrides() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        JavaEmbeddedMapping2_0 embeddedMapping = (JavaEmbeddedMapping2_0)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        JavaAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        ListIterator specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE)).getFields().iterator().next();
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AssociationOverride");
        associationOverride.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        associationOverride = (AssociationOverrideAnnotation)resourceField.addAnnotation(1, "javax.persistence.AssociationOverride");
        associationOverride.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((JavaSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        associationOverride = (AssociationOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AssociationOverride");
        associationOverride.setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((JavaSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((JavaSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        resourceField.moveAnnotation(1, 0, "javax.persistence.AssociationOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((JavaSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((JavaSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.AssociationOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((JavaSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((JavaSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.AssociationOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((JavaSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.AssociationOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
    }

    public void testVirtualAssociationOverrideDefaults() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        JavaEmbeddedMapping2_0 embeddedMapping = (JavaEmbeddedMapping2_0)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        JavaAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE)).getFields().iterator().next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.AssociationOverride"));
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)2, (int)overrideContainer.getVirtualOverridesSize());
        VirtualAssociationOverride virtualAssociationOverride = (VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next();
        VirtualJoinColumnRelationshipStrategy joiningStrategy = virtualAssociationOverride.getRelationship().getJoinColumnStrategy();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)virtualAssociationOverride.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)1, (int)joiningStrategy.getJoinColumnsSize());
        VirtualJoinColumn virtualJoinColumn = (VirtualJoinColumn)joiningStrategy.getJoinColumns().iterator().next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"address_id", (String)virtualJoinColumn.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"id", (String)virtualJoinColumn.getReferencedColumnName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"AnnotationTestType", (String)virtualJoinColumn.getTableName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals(null, (String)virtualJoinColumn.getColumnDefinition());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualJoinColumn.isInsertable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualJoinColumn.isUpdatable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isUnique());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualJoinColumn.isNullable());
        ListIterator classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        classRefs.next();
        JavaPersistentType javaEmbeddable = ((ClassRef)classRefs.next()).getJavaPersistentType();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)javaEmbeddable.getAttributeNamed("address").getMapping();
        SpecifiedJoinColumn joinColumn = oneToOneMapping.getRelationship().getJoinColumnStrategy().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("MY_JOIN_COLUMN");
        joinColumn.setSpecifiedReferencedColumnName("MY_REFERENCE_COLUMN");
        joinColumn.setSpecifiedTableName("BAR");
        joinColumn.setColumnDefinition("COLUMN_DEF");
        joinColumn.setSpecifiedInsertable(Boolean.FALSE);
        joinColumn.setSpecifiedUpdatable(Boolean.FALSE);
        joinColumn.setSpecifiedUnique(Boolean.TRUE);
        joinColumn.setSpecifiedNullable(Boolean.FALSE);
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.AssociationOverride"));
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)2, (int)overrideContainer.getVirtualOverridesSize());
        virtualAssociationOverride = (VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next();
        joiningStrategy = virtualAssociationOverride.getRelationship().getJoinColumnStrategy();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)virtualAssociationOverride.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)1, (int)joiningStrategy.getJoinColumnsSize());
        virtualAssociationOverride = (VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next();
        virtualJoinColumn = (VirtualJoinColumn)joiningStrategy.getJoinColumns().iterator().next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"MY_JOIN_COLUMN", (String)virtualJoinColumn.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"MY_REFERENCE_COLUMN", (String)virtualJoinColumn.getReferencedColumnName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)virtualJoinColumn.getTableName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"COLUMN_DEF", (String)virtualJoinColumn.getColumnDefinition());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isInsertable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isUpdatable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualJoinColumn.isUnique());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isNullable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"MY_JOIN_COLUMN", (String)((VirtualJoinColumn)joiningStrategy.getJoinColumns().iterator().next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.AssociationOverride"));
        virtualAssociationOverride = (VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)virtualAssociationOverride.getName());
        virtualAssociationOverride.convertToSpecified();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)1, (int)overrideContainer.getVirtualOverridesSize());
    }

    public void testSpecifiedAssociationOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        JavaEmbeddedMapping2_0 embeddedMapping = (JavaEmbeddedMapping2_0)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        JavaAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE)).getFields().iterator().next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)overrideContainer.getSpecifiedOverridesSize());
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AssociationOverride");
        associationOverride.setName("FOO");
        associationOverride = (AssociationOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AssociationOverride");
        associationOverride.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)2, (int)overrideContainer.getSpecifiedOverridesSize());
    }

    public void testVirtualAssociationOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        JavaEmbeddedMapping2_0 embeddedMapping = (JavaEmbeddedMapping2_0)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        JavaAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)2, (int)overrideContainer.getVirtualOverridesSize());
        ((JavaVirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)1, (int)overrideContainer.getVirtualOverridesSize());
        ((JavaVirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)overrideContainer.getVirtualOverridesSize());
    }

    public void testAssociationOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        JavaEmbeddedMapping2_0 embeddedMapping = (JavaEmbeddedMapping2_0)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        JavaAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)2, (int)overrideContainer.getOverridesSize());
        ((JavaVirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)2, (int)overrideContainer.getOverridesSize());
        ((JavaVirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)2, (int)overrideContainer.getOverridesSize());
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE)).getFields().iterator().next();
        AssociationOverrideAnnotation annotation = (AssociationOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AssociationOverride");
        annotation.setName("bar");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)3, (int)overrideContainer.getOverridesSize());
    }

    public void testAssociationOverrideSetVirtual() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        JavaEmbeddedMapping2_0 embeddedMapping = (JavaEmbeddedMapping2_0)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        JavaAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        ((JavaVirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((JavaVirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE)).getFields().iterator().next();
        ListIterator associationOverrides = resourceField.getAnnotations("javax.persistence.AssociationOverride").iterator();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)((AssociationOverrideAnnotation)associationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)((AssociationOverrideAnnotation)associationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
    }

    public void testAssociationOverrideSetVirtual2() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        JavaEmbeddedMapping2_0 embeddedMapping = (JavaEmbeddedMapping2_0)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        JavaAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        ListIterator virtualAssociationOverrides = overrideContainer.getVirtualOverrides().iterator();
        virtualAssociationOverrides.next();
        ((JavaVirtualAssociationOverride)virtualAssociationOverrides.next()).convertToSpecified();
        ((JavaVirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE)).getFields().iterator().next();
        ListIterator associationOverrides = resourceField.getAnnotations("javax.persistence.AssociationOverride").iterator();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)((AssociationOverrideAnnotation)associationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)((AssociationOverrideAnnotation)associationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
    }

    public void testAssociationOverrideSetVirtualTrue() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        JavaEmbeddedMapping2_0 embeddedMapping = (JavaEmbeddedMapping2_0)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        JavaAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        ((JavaVirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((JavaVirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE)).getFields().iterator().next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)2, (int)IteratorTools.size((Iterator)resourceField.getAnnotations("javax.persistence.AssociationOverride").iterator()));
        ((JavaSpecifiedAssociationOverride)overrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        ListIterator associationOverrideResources = resourceField.getAnnotations("javax.persistence.AssociationOverride").iterator();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)((AssociationOverrideAnnotation)associationOverrideResources.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)associationOverrideResources.hasNext());
        ListIterator associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
        ((JavaSpecifiedAssociationOverride)overrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        associationOverrideResources = resourceField.getAnnotations("javax.persistence.AssociationOverride").iterator();
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)associationOverrideResources.hasNext());
        associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.AssociationOverride"));
    }

    public void testMoveSpecifiedAssociationOverride() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        JavaEmbeddedMapping2_0 embeddedMapping = (JavaEmbeddedMapping2_0)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        JavaAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        ((JavaVirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((JavaVirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE)).getFields().iterator().next();
        ListIterator javaAssociationOverrides = resourceField.getAnnotations("javax.persistence.AssociationOverride").iterator();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)2, (int)IteratorTools.size((Iterator)javaAssociationOverrides));
        overrideContainer.moveSpecifiedOverride(1, 0);
        ListIterator associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        javaAssociationOverrides = resourceField.getAnnotations("javax.persistence.AssociationOverride").iterator();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)((AssociationOverrideAnnotation)javaAssociationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)((AssociationOverrideAnnotation)javaAssociationOverrides.next()).getName());
        overrideContainer.moveSpecifiedOverride(0, 1);
        associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        javaAssociationOverrides = resourceField.getAnnotations("javax.persistence.AssociationOverride").iterator();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)((AssociationOverrideAnnotation)javaAssociationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)((AssociationOverrideAnnotation)javaAssociationOverrides.next()).getName());
    }

    public void testUpdateSpecifiedAssociationOverrides() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        JavaEmbeddedMapping2_0 embeddedMapping = (JavaEmbeddedMapping2_0)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        JavaAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE)).getFields().iterator().next();
        ((AssociationOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AssociationOverride")).setName("FOO");
        ((AssociationOverrideAnnotation)resourceField.addAnnotation(1, "javax.persistence.AssociationOverride")).setName("BAR");
        ((AssociationOverrideAnnotation)resourceField.addAnnotation(2, "javax.persistence.AssociationOverride")).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
        resourceField.moveAnnotation(2, 0, "javax.persistence.AssociationOverride");
        this.getJpaProject().synchronizeContextModel();
        associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
        resourceField.moveAnnotation(0, 1, "javax.persistence.AssociationOverride");
        this.getJpaProject().synchronizeContextModel();
        associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
        resourceField.removeAnnotation(1, "javax.persistence.AssociationOverride");
        this.getJpaProject().synchronizeContextModel();
        associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
        resourceField.removeAnnotation(1, "javax.persistence.AssociationOverride");
        this.getJpaProject().synchronizeContextModel();
        associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.AssociationOverride");
        this.getJpaProject().synchronizeContextModel();
        associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
    }

    public void testAssociationOverrideIsVirtual() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        JavaEmbeddedMapping2_0 embeddedMapping = (JavaEmbeddedMapping2_0)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        JavaAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        ListIterator virtualAssociationOverrides = overrideContainer.getVirtualOverrides().iterator();
        AssociationOverride virtualAssociationOverride = (AssociationOverride)virtualAssociationOverrides.next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)virtualAssociationOverride.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        virtualAssociationOverride = (AssociationOverride)virtualAssociationOverrides.next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)virtualAssociationOverride.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)virtualAssociationOverrides.hasNext());
        ((JavaVirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        SpecifiedAssociationOverride specifiedAssociationOverride = (SpecifiedAssociationOverride)overrideContainer.getSpecifiedOverrides().iterator().next();
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAssociationOverride.isVirtual());
        virtualAssociationOverrides = overrideContainer.getVirtualOverrides().iterator();
        virtualAssociationOverride = (AssociationOverride)virtualAssociationOverrides.next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)virtualAssociationOverride.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)virtualAssociationOverrides.hasNext());
    }

    public void testVirtualAssociationOverrideJoinTableDefaults() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        JavaEmbeddedMapping2_0 embeddedMapping = (JavaEmbeddedMapping2_0)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        JavaAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE)).getFields().iterator().next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.AssociationOverride"));
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)2, (int)overrideContainer.getVirtualOverridesSize());
        VirtualAssociationOverride virtualAssociationOverride = (VirtualAssociationOverride)IterableTools.get((Iterable)overrideContainer.getVirtualOverrides(), (int)1);
        VirtualJoinTableRelationshipStrategy joiningStrategy = ((VirtualOverrideRelationship2_0)virtualAssociationOverride.getRelationship()).getJoinTableStrategy();
        VirtualJoinTable joinTable = joiningStrategy.getJoinTable();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)virtualAssociationOverride.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)joinTable.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)1, (int)joinTable.getJoinColumnsSize());
        VirtualJoinColumn virtualJoinColumn = (VirtualJoinColumn)joinTable.getJoinColumns().iterator().next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"AnnotationTestType_id", (String)virtualJoinColumn.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"id", (String)virtualJoinColumn.getReferencedColumnName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)virtualJoinColumn.getTableName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals(null, (String)virtualJoinColumn.getColumnDefinition());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualJoinColumn.isInsertable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualJoinColumn.isUpdatable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isUnique());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualJoinColumn.isNullable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)1, (int)joinTable.getInverseJoinColumnsSize());
        VirtualJoinColumn virtualInverseJoinColumn = (VirtualJoinColumn)joinTable.getInverseJoinColumns().iterator().next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"addresses_id", (String)virtualInverseJoinColumn.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"id", (String)virtualInverseJoinColumn.getReferencedColumnName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)virtualInverseJoinColumn.getTableName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals(null, (String)virtualInverseJoinColumn.getColumnDefinition());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualInverseJoinColumn.isInsertable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualInverseJoinColumn.isUpdatable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualInverseJoinColumn.isUnique());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualInverseJoinColumn.isNullable());
        ListIterator classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        classRefs.next();
        JavaPersistentType javaEmbeddable = ((ClassRef)classRefs.next()).getJavaPersistentType();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)javaEmbeddable.getAttributeNamed("addresses").getMapping();
        SpecifiedJoinTableRelationshipStrategy joinTableStrategy = oneToManyMapping.getRelationship().getJoinTableStrategy();
        joinTableStrategy.getJoinTable().setSpecifiedName("MY_JOIN_TABLE");
        SpecifiedJoinColumn joinColumn = joinTableStrategy.getJoinTable().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("MY_JOIN_COLUMN");
        joinColumn.setSpecifiedReferencedColumnName("MY_REFERENCE_COLUMN");
        joinColumn.setSpecifiedTableName("BAR");
        joinColumn.setColumnDefinition("COLUMN_DEF");
        joinColumn.setSpecifiedInsertable(Boolean.FALSE);
        joinColumn.setSpecifiedUpdatable(Boolean.FALSE);
        joinColumn.setSpecifiedUnique(Boolean.TRUE);
        joinColumn.setSpecifiedNullable(Boolean.FALSE);
        SpecifiedJoinColumn inverseJoinColumn = joinTableStrategy.getJoinTable().addSpecifiedInverseJoinColumn(0);
        inverseJoinColumn.setSpecifiedName("MY_INVERSE_JOIN_COLUMN");
        inverseJoinColumn.setSpecifiedReferencedColumnName("MY_INVERSE_REFERENCE_COLUMN");
        inverseJoinColumn.setSpecifiedTableName("INVERSE_BAR");
        inverseJoinColumn.setColumnDefinition("INVERSE_COLUMN_DEF");
        inverseJoinColumn.setSpecifiedInsertable(Boolean.FALSE);
        inverseJoinColumn.setSpecifiedUpdatable(Boolean.FALSE);
        inverseJoinColumn.setSpecifiedUnique(Boolean.TRUE);
        inverseJoinColumn.setSpecifiedNullable(Boolean.FALSE);
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.AssociationOverride"));
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)2, (int)overrideContainer.getVirtualOverridesSize());
        virtualAssociationOverride = (VirtualAssociationOverride)IterableTools.get((Iterable)overrideContainer.getVirtualOverrides(), (int)1);
        joiningStrategy = ((VirtualOverrideRelationship2_0)virtualAssociationOverride.getRelationship()).getJoinTableStrategy();
        joinTable = joiningStrategy.getJoinTable();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)virtualAssociationOverride.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)1, (int)joinTable.getJoinColumnsSize());
        virtualJoinColumn = (VirtualJoinColumn)joinTable.getJoinColumns().iterator().next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"MY_JOIN_COLUMN", (String)virtualJoinColumn.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"MY_REFERENCE_COLUMN", (String)virtualJoinColumn.getReferencedColumnName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)virtualJoinColumn.getTableName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"COLUMN_DEF", (String)virtualJoinColumn.getColumnDefinition());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isInsertable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isUpdatable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualJoinColumn.isUnique());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isNullable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)1, (int)joinTable.getInverseJoinColumnsSize());
        virtualInverseJoinColumn = (VirtualJoinColumn)joinTable.getInverseJoinColumns().iterator().next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"MY_INVERSE_JOIN_COLUMN", (String)virtualInverseJoinColumn.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"MY_INVERSE_REFERENCE_COLUMN", (String)virtualInverseJoinColumn.getReferencedColumnName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"INVERSE_BAR", (String)virtualInverseJoinColumn.getTableName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"INVERSE_COLUMN_DEF", (String)virtualInverseJoinColumn.getColumnDefinition());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualInverseJoinColumn.isInsertable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualInverseJoinColumn.isUpdatable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualInverseJoinColumn.isUnique());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualInverseJoinColumn.isNullable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.AssociationOverride"));
        virtualAssociationOverride = (VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)virtualAssociationOverride.getName());
        virtualAssociationOverride.convertToSpecified();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)1, (int)overrideContainer.getVirtualOverridesSize());
    }

    public void testNestedVirtualAttributeOverrides() throws Exception {
        this.createTestEntityCustomer();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableZipCode();
        this.addXmlClassRef("test.Customer");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.ZipCode");
        ListIterator specifiedClassRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        JavaPersistentType customerPersistentType = ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        JavaEmbeddedMapping embeddedMapping = (JavaEmbeddedMapping)customerPersistentType.getAttributeNamed("address").getMapping();
        JavaAttributeOverrideContainer attributeOverrideContainer = embeddedMapping.getAttributeOverrideContainer();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)5, (int)attributeOverrideContainer.getVirtualOverridesSize());
        ListIterator virtualAttributeOverrides = attributeOverrideContainer.getVirtualOverrides().iterator();
        VirtualAttributeOverride virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"street", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"city", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"state", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"zipCode.zip", (String)virtualAttributeOverride.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"zip", (String)virtualAttributeOverride.getColumn().getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"Customer", (String)virtualAttributeOverride.getColumn().getTableName());
        virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"zipCode.plusfour", (String)virtualAttributeOverride.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"plusfour", (String)virtualAttributeOverride.getColumn().getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"Customer", (String)virtualAttributeOverride.getColumn().getTableName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals(null, (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUnique());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isNullable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)255, (int)virtualAttributeOverride.getColumn().getLength());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getPrecision());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getScale());
        JavaPersistentType addressPersistentType = ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        JavaEmbeddedMapping nestedEmbeddedMapping = (JavaEmbeddedMapping)addressPersistentType.getAttributeNamed("zipCode").getMapping();
        JavaAttributeOverrideContainer nestedAttributeOverrideContainer = nestedEmbeddedMapping.getAttributeOverrideContainer();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)2, (int)nestedAttributeOverrideContainer.getVirtualOverridesSize());
        virtualAttributeOverrides = nestedAttributeOverrideContainer.getVirtualOverrides().iterator();
        virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"zip", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"plusfour", (String)virtualAttributeOverride.getName());
        JavaPersistentType zipCodePersistentType = ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        BasicMapping plusFourMapping = (BasicMapping)zipCodePersistentType.getAttributeNamed("plusfour").getMapping();
        plusFourMapping.getColumn().setSpecifiedName("BLAH");
        plusFourMapping.getColumn().setSpecifiedTableName("BLAH_TABLE");
        plusFourMapping.getColumn().setColumnDefinition("COLUMN_DEFINITION");
        plusFourMapping.getColumn().setSpecifiedInsertable(Boolean.FALSE);
        plusFourMapping.getColumn().setSpecifiedUpdatable(Boolean.FALSE);
        plusFourMapping.getColumn().setSpecifiedUnique(Boolean.TRUE);
        plusFourMapping.getColumn().setSpecifiedNullable(Boolean.FALSE);
        plusFourMapping.getColumn().setSpecifiedLength(Integer.valueOf(5));
        plusFourMapping.getColumn().setSpecifiedPrecision(Integer.valueOf(6));
        plusFourMapping.getColumn().setSpecifiedScale(Integer.valueOf(7));
        virtualAttributeOverride = (VirtualAttributeOverride)((JavaEmbeddedMapping)addressPersistentType.getAttributeNamed("zipCode").getMapping()).getAttributeOverrideContainer().getOverrideNamed("plusfour");
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"plusfour", (String)virtualAttributeOverride.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BLAH", (String)virtualAttributeOverride.getColumn().getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BLAH_TABLE", (String)virtualAttributeOverride.getColumn().getTableName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"COLUMN_DEFINITION", (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUnique());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isNullable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)5, (int)virtualAttributeOverride.getColumn().getLength());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)6, (int)virtualAttributeOverride.getColumn().getPrecision());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)7, (int)virtualAttributeOverride.getColumn().getScale());
        virtualAttributeOverride = (VirtualAttributeOverride)((JavaEmbeddedMapping)customerPersistentType.getAttributeNamed("address").getMapping()).getAttributeOverrideContainer().getOverrideNamed("zipCode.plusfour");
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"zipCode.plusfour", (String)virtualAttributeOverride.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BLAH", (String)virtualAttributeOverride.getColumn().getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BLAH_TABLE", (String)virtualAttributeOverride.getColumn().getTableName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"COLUMN_DEFINITION", (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUnique());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isNullable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)5, (int)virtualAttributeOverride.getColumn().getLength());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)6, (int)virtualAttributeOverride.getColumn().getPrecision());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)7, (int)virtualAttributeOverride.getColumn().getScale());
        SpecifiedAttributeOverride specifiedAttributeOverride = ((VirtualAttributeOverride)((JavaEmbeddedMapping)addressPersistentType.getAttributeNamed("zipCode").getMapping()).getAttributeOverrideContainer().getOverrideNamed("plusfour")).convertToSpecified();
        specifiedAttributeOverride.getColumn().setSpecifiedName("BLAH_OVERRIDE");
        specifiedAttributeOverride.getColumn().setSpecifiedTableName("BLAH_TABLE_OVERRIDE");
        specifiedAttributeOverride.getColumn().setColumnDefinition("COLUMN_DEFINITION_OVERRIDE");
        virtualAttributeOverride = (VirtualAttributeOverride)((JavaEmbeddedMapping)customerPersistentType.getAttributeNamed("address").getMapping()).getAttributeOverrideContainer().getOverrideNamed("zipCode.plusfour");
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"zipCode.plusfour", (String)virtualAttributeOverride.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BLAH_OVERRIDE", (String)virtualAttributeOverride.getColumn().getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BLAH_TABLE_OVERRIDE", (String)virtualAttributeOverride.getColumn().getTableName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"COLUMN_DEFINITION_OVERRIDE", (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUnique());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isNullable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)255, (int)virtualAttributeOverride.getColumn().getLength());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getPrecision());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getScale());
        specifiedAttributeOverride = virtualAttributeOverride.convertToSpecified();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)specifiedAttributeOverride.isVirtual());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"zipCode.plusfour", (String)specifiedAttributeOverride.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BLAH_OVERRIDE", (String)specifiedAttributeOverride.getColumn().getSpecifiedName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BLAH_TABLE_OVERRIDE", (String)specifiedAttributeOverride.getColumn().getSpecifiedTableName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"COLUMN_DEFINITION_OVERRIDE", (String)specifiedAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)specifiedAttributeOverride.getColumn().isInsertable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)specifiedAttributeOverride.getColumn().isUpdatable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)specifiedAttributeOverride.getColumn().isUnique());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)specifiedAttributeOverride.getColumn().isNullable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)255, (int)specifiedAttributeOverride.getColumn().getLength());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)specifiedAttributeOverride.getColumn().getPrecision());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)specifiedAttributeOverride.getColumn().getScale());
    }

    public void testSelfReferentialEmbeddedMapping() throws Exception {
        this.createSelfReferentialEmbedded();
        this.addXmlClassRef("test.Foo");
        JavaEmbeddedMapping2_0 embeddedMapping = (JavaEmbeddedMapping2_0)this.getJavaPersistentType().getAttributeNamed("embedded").getMapping();
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.getAllOverridableAttributeMappingNames().iterator().hasNext());
    }
}

