/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.platform;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jpa.core.JpaPlatform;
import org.eclipse.jpt.jpa.core.JpaPreferences;
import org.eclipse.jpt.jpa.core.internal.facet.JpaFacetInstallDataModelProvider;
import org.eclipse.jpt.jpa.core.internal.plugin.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.tests.extension.resource.TestExtensionPlugin;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.jpa.core.tests.internal.projects.TestJpaProject;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class JpaPlatformExtensionTests
extends ContextModelTestCase {
    public static final String TEST_PLATFORM_ID = "core.testJpaPlatform";
    public static final String TEST_PLATFORM_LABEL = "Test Jpa Platform";
    protected TestJpaProject testProject;

    public JpaPlatformExtensionTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        JpaPlatformExtensionTests.verifyExtensionTestProjectExists();
    }

    protected TestJavaProject buildJavaProject(boolean autoBuild) throws Exception {
        return super.buildJpaProject("AnnotationTestProject", autoBuild, this.buildConfig());
    }

    protected IDataModel buildConfig() throws Exception {
        JpaFacetInstallDataModelProvider configFactory = new JpaFacetInstallDataModelProvider();
        IDataModel config = (IDataModel)configFactory.create();
        config.setProperty("IFacetDataModelProperties.FACET_VERSION_STR", (Object)"1.0");
        config.setProperty("JpaFacetDataModelProperties.PLATFORM", (Object)this.getJpaPlatformManager().getJpaPlatformConfig(TEST_PLATFORM_ID));
        return config;
    }

    public static void verifyExtensionTestProjectExists() {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(JptJpaCorePlugin.instance().getPluginID(), "jpaPlatform");
        IExtension[] extensions = extensionPoint.getExtensions();
        boolean extensionFound = false;
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            if (extension.getContributor().getName().equals(TestExtensionPlugin.instance().getPluginID())) {
                extensionFound = true;
            }
            ++n2;
        }
        if (!extensionFound) {
            throw new RuntimeException("Missing Extension core.testJpaPlatform. The ExtensionTestProject plugin must be in your testing workspace.");
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testAllJpaPlatformIds() {
        JpaPlatformExtensionTests.assertTrue((IterableTools.size((Iterable)this.getJpaPlatformManager().getJpaPlatformConfigs()) >= 2 ? 1 : 0) != 0);
    }

    public void testJpaPlatformLabel() {
        JpaPlatformExtensionTests.assertEquals((String)TEST_PLATFORM_LABEL, (String)this.getJpaPlatformManager().getJpaPlatformConfig(TEST_PLATFORM_ID).getLabel());
    }

    public void testJpaPlatform() {
        JpaPlatformExtensionTests.assertNotNull((Object)this.getJpaPlatform());
    }

    protected JpaPlatform getJpaPlatform() {
        return this.getJpaPlatformManager().getJpaPlatform(JpaPreferences.getJpaPlatformID((IProject)this.testProject.getProject()));
    }
}

