/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.collection.IdentityHashSet;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityHashSetTests
extends TestCase {
    private IdentityHashSet<String> set;
    private String one = "one";
    private String two = "two";
    private String three = "three";
    private String four = "four";
    private String foo = "foo";
    private String bar = "bar";

    public IdentityHashSetTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.set = this.buildSet();
    }

    protected IdentityHashSet<String> buildSet() {
        IdentityHashSet result = new IdentityHashSet();
        result.add(null);
        result.add((Object)this.one);
        result.add((Object)this.two);
        result.add((Object)this.two);
        result.add((Object)this.three);
        result.add((Object)this.three);
        result.add((Object)this.three);
        result.add((Object)this.four);
        result.add((Object)this.four);
        result.add((Object)this.four);
        result.add((Object)this.four);
        return result;
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    private Collection<String> buildCollection() {
        ArrayList<String> c = new ArrayList<String>();
        c.add(this.foo);
        c.add(this.foo);
        c.add(this.bar);
        c.add(this.bar);
        c.add(this.bar);
        return c;
    }

    public void testCtorCollection() {
        Collection<String> c = this.buildCollection();
        IdentityHashSet localBag = new IdentityHashSet(c);
        for (String s : c) {
            IdentityHashSetTests.assertTrue((boolean)localBag.contains((Object)s));
        }
    }

    public void testCtorInt() {
        boolean exCaught = false;
        try {
            this.set = new IdentityHashSet(-20);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        IdentityHashSetTests.assertTrue((boolean)exCaught);
    }

    public void testAdd() {
        String five = "five";
        IdentityHashSetTests.assertTrue((boolean)this.set.add((Object)five));
        IdentityHashSetTests.assertTrue((boolean)this.set.contains((Object)this.one));
        IdentityHashSetTests.assertTrue((boolean)this.set.contains((Object)this.two));
        IdentityHashSetTests.assertTrue((boolean)this.set.contains((Object)this.three));
        IdentityHashSetTests.assertTrue((boolean)this.set.contains((Object)this.four));
        IdentityHashSetTests.assertTrue((boolean)this.set.contains((Object)five));
    }

    public void testAddAll() {
        Collection<String> c = this.buildCollection();
        IdentityHashSetTests.assertTrue((boolean)this.set.addAll(c));
        for (String s : c) {
            IdentityHashSetTests.assertTrue((boolean)this.set.contains((Object)s));
        }
    }

    public void testClear() {
        IdentityHashSetTests.assertTrue((boolean)this.set.contains((Object)this.one));
        IdentityHashSetTests.assertTrue((boolean)this.set.contains((Object)this.two));
        IdentityHashSetTests.assertTrue((boolean)this.set.contains((Object)this.three));
        IdentityHashSetTests.assertTrue((boolean)this.set.contains((Object)this.four));
        IdentityHashSetTests.assertTrue((boolean)this.set.contains(null));
        IdentityHashSetTests.assertEquals((int)5, (int)this.set.size());
        this.set.clear();
        IdentityHashSetTests.assertFalse((boolean)this.set.contains((Object)this.one));
        IdentityHashSetTests.assertFalse((boolean)this.set.contains((Object)this.two));
        IdentityHashSetTests.assertFalse((boolean)this.set.contains((Object)this.three));
        IdentityHashSetTests.assertFalse((boolean)this.set.contains((Object)this.four));
        IdentityHashSetTests.assertFalse((boolean)this.set.contains(null));
        IdentityHashSetTests.assertEquals((int)0, (int)this.set.size());
    }

    public void testClone() {
        IdentityHashSet set2 = this.set.clone();
        IdentityHashSetTests.assertTrue((String)"bad clone", (this.set != set2 ? 1 : 0) != 0);
        IdentityHashSetTests.assertEquals((String)"bad clone", this.set, (Object)set2);
        IdentityHashSetTests.assertTrue((String)"bad clone", (this.set.hashCode() == set2.hashCode() ? 1 : 0) != 0);
    }

    public void testContains() {
        IdentityHashSetTests.assertTrue((boolean)this.set.contains(null));
        IdentityHashSetTests.assertTrue((boolean)this.set.contains((Object)this.one));
        IdentityHashSetTests.assertTrue((boolean)this.set.contains((Object)this.two));
        IdentityHashSetTests.assertTrue((boolean)this.set.contains((Object)this.three));
        IdentityHashSetTests.assertTrue((boolean)this.set.contains((Object)this.four));
        IdentityHashSetTests.assertFalse((boolean)this.set.contains((Object)new String("four")));
        IdentityHashSetTests.assertFalse((boolean)this.set.contains((Object)"five"));
    }

    public void testContainsAll() {
        ArrayList<String> c = new ArrayList<String>();
        c.add(null);
        c.add(this.one);
        c.add(this.two);
        c.add(this.three);
        c.add(this.four);
        IdentityHashSetTests.assertTrue((boolean)this.set.containsAll(c));
        c.add(new String(this.four));
        IdentityHashSetTests.assertFalse((boolean)this.set.containsAll(c));
    }

    public void testEquals() {
        IdentityHashSet<String> set2 = this.buildSet();
        IdentityHashSetTests.assertEquals(this.set, set2);
        set2.add((Object)"five");
        IdentityHashSetTests.assertFalse((boolean)this.set.equals(set2));
        ArrayList<String> c = new ArrayList<String>((Collection<String>)this.set);
        IdentityHashSetTests.assertFalse((boolean)this.set.equals(c));
    }

    public void testHashCode() {
        IdentityHashSet<String> set2 = this.buildSet();
        IdentityHashSetTests.assertEquals((int)this.set.hashCode(), (int)set2.hashCode());
    }

    public void testIsEmpty() {
        IdentityHashSetTests.assertFalse((boolean)this.set.isEmpty());
        this.set.clear();
        IdentityHashSetTests.assertTrue((boolean)this.set.isEmpty());
        this.set.add((Object)"foo");
        IdentityHashSetTests.assertFalse((boolean)this.set.isEmpty());
    }

    public void testEmptyIterator() {
        this.set.clear();
        Iterator iterator = this.set.iterator();
        IdentityHashSetTests.assertFalse((boolean)iterator.hasNext());
        boolean exCaught = false;
        Object element = null;
        try {
            element = iterator.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        IdentityHashSetTests.assertTrue((String)("NoSuchElementException not thrown: " + element), (boolean)exCaught);
        exCaught = false;
        try {
            iterator.remove();
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        IdentityHashSetTests.assertTrue((String)"IllegalStateException not thrown", (boolean)exCaught);
    }

    public void testIterator() {
        int i = 0;
        Iterator iterator = this.set.iterator();
        IdentityHashSetTests.assertTrue((boolean)iterator.hasNext());
        while (iterator.hasNext()) {
            iterator.next();
            ++i;
        }
        IdentityHashSetTests.assertEquals((int)5, (int)i);
        IdentityHashSetTests.assertFalse((boolean)iterator.hasNext());
        boolean exCaught = false;
        Object element = null;
        try {
            element = iterator.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        IdentityHashSetTests.assertTrue((String)("NoSuchElementException not thrown: " + element), (boolean)exCaught);
        iterator.remove();
        IdentityHashSetTests.assertEquals((int)4, (int)this.set.size());
        exCaught = false;
        try {
            iterator.remove();
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        IdentityHashSetTests.assertTrue((String)"IllegalStateException not thrown", (boolean)exCaught);
        iterator = this.set.iterator();
        this.set.add((Object)"five");
        exCaught = false;
        try {
            iterator.next();
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            exCaught = true;
        }
        IdentityHashSetTests.assertTrue((String)"ConcurrentModificationException not thrown", (boolean)exCaught);
    }

    public void testRemove() {
        IdentityHashSetTests.assertTrue((boolean)this.set.remove((Object)this.one));
        IdentityHashSetTests.assertFalse((boolean)this.set.contains((Object)this.one));
        IdentityHashSetTests.assertFalse((boolean)this.set.remove((Object)this.one));
        IdentityHashSetTests.assertTrue((boolean)this.set.remove((Object)this.two));
        IdentityHashSetTests.assertFalse((boolean)this.set.remove((Object)this.two));
        IdentityHashSetTests.assertFalse((boolean)this.set.contains((Object)this.two));
        IdentityHashSetTests.assertFalse((boolean)this.set.remove((Object)this.two));
        IdentityHashSetTests.assertFalse((boolean)this.set.remove((Object)new String(this.three)));
    }

    public void testRemoveAll() {
        ArrayList<String> c = new ArrayList<String>();
        c.add(this.one);
        c.add(new String(this.two));
        c.add(this.three);
        IdentityHashSetTests.assertTrue((boolean)this.set.removeAll(c));
        IdentityHashSetTests.assertFalse((boolean)this.set.contains((Object)this.one));
        IdentityHashSetTests.assertTrue((boolean)this.set.contains((Object)this.two));
        IdentityHashSetTests.assertFalse((boolean)this.set.contains((Object)this.three));
        IdentityHashSetTests.assertFalse((boolean)this.set.remove((Object)this.one));
        IdentityHashSetTests.assertTrue((boolean)this.set.remove((Object)this.two));
        IdentityHashSetTests.assertFalse((boolean)this.set.remove((Object)this.three));
        IdentityHashSetTests.assertFalse((boolean)this.set.removeAll(c));
    }

    public void testRetainAll() {
        ArrayList<String> c = new ArrayList<String>();
        c.add(this.one);
        c.add(new String(this.two));
        c.add(this.three);
        IdentityHashSetTests.assertTrue((boolean)this.set.retainAll(c));
        IdentityHashSetTests.assertTrue((boolean)this.set.contains((Object)this.one));
        IdentityHashSetTests.assertFalse((boolean)this.set.contains((Object)this.two));
        IdentityHashSetTests.assertTrue((boolean)this.set.contains((Object)this.three));
        IdentityHashSetTests.assertFalse((boolean)this.set.contains((Object)this.four));
        IdentityHashSetTests.assertFalse((boolean)this.set.remove((Object)this.two));
        IdentityHashSetTests.assertFalse((boolean)this.set.remove((Object)this.four));
        IdentityHashSetTests.assertFalse((boolean)this.set.retainAll(c));
    }

    public void testSize() {
        IdentityHashSetTests.assertEquals((int)5, (int)this.set.size());
        String five = "five";
        this.set.add((Object)five);
        this.set.add((Object)five);
        this.set.add((Object)five);
        this.set.add((Object)five);
        this.set.add((Object)new String(five));
        IdentityHashSetTests.assertEquals((int)7, (int)this.set.size());
    }

    public void testSerialization() throws Exception {
        IdentityHashSet<String> set2 = TestTools.serialize(this.set);
        IdentityHashSetTests.assertTrue((String)"same object?", (this.set != set2 ? 1 : 0) != 0);
        IdentityHashSetTests.assertEquals((int)5, (int)set2.size());
        IdentityHashSetTests.assertEquals((Object)CollectionTools.set((Iterator)this.set.iterator()), (Object)CollectionTools.set((Iterator)set2.iterator()));
        IdentityHashSetTests.assertTrue((boolean)CollectionTools.set((Iterator)set2.iterator()).contains(null));
        IdentityHashSetTests.assertTrue((boolean)CollectionTools.set((Iterator)set2.iterator()).contains("one"));
        IdentityHashSetTests.assertTrue((boolean)CollectionTools.set((Iterator)set2.iterator()).contains("two"));
        IdentityHashSetTests.assertTrue((boolean)CollectionTools.set((Iterator)set2.iterator()).contains("three"));
        IdentityHashSetTests.assertTrue((boolean)CollectionTools.set((Iterator)set2.iterator()).contains("four"));
        int nullCount = 0;
        int oneCount = 0;
        int twoCount = 0;
        int threeCount = 0;
        int fourCount = 0;
        for (String next : set2) {
            if (next == null) {
                ++nullCount;
                continue;
            }
            if (next.equals("one")) {
                ++oneCount;
                continue;
            }
            if (next.equals("two")) {
                ++twoCount;
                continue;
            }
            if (next.equals("three")) {
                ++threeCount;
                continue;
            }
            if (!next.equals("four")) continue;
            ++fourCount;
        }
        IdentityHashSetTests.assertEquals((int)1, (int)nullCount);
        IdentityHashSetTests.assertEquals((int)1, (int)oneCount);
        IdentityHashSetTests.assertEquals((int)1, (int)twoCount);
        IdentityHashSetTests.assertEquals((int)1, (int)threeCount);
        IdentityHashSetTests.assertEquals((int)1, (int)fourCount);
    }

    public void testToArray() {
        Object[] a = this.set.toArray();
        IdentityHashSetTests.assertEquals((int)5, (int)a.length);
        IdentityHashSetTests.assertTrue((boolean)ArrayTools.contains((Object[])a, null));
        IdentityHashSetTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)this.one));
        IdentityHashSetTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)this.two));
        IdentityHashSetTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)this.three));
        IdentityHashSetTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)this.four));
    }

    public void testToArrayObjectArray() {
        Object[] a = new String[12];
        a[5] = "not null";
        String[] b = (String[])this.set.toArray(a);
        IdentityHashSetTests.assertEquals((Object)a, (Object)b);
        IdentityHashSetTests.assertEquals((int)12, (int)a.length);
        IdentityHashSetTests.assertTrue((boolean)ArrayTools.contains((Object[])a, null));
        IdentityHashSetTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)this.one));
        IdentityHashSetTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)this.two));
        IdentityHashSetTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)this.three));
        IdentityHashSetTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)this.four));
        IdentityHashSetTests.assertTrue((a[5] == null ? 1 : 0) != 0);
    }

    public void testToString() {
        String s = this.set.toString();
        IdentityHashSetTests.assertTrue((boolean)s.startsWith("["));
        IdentityHashSetTests.assertTrue((boolean)s.endsWith("]"));
        int commaCount = 0;
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == ',') {
                ++commaCount;
            }
            ++i;
        }
        IdentityHashSetTests.assertEquals((String)"invalid number of commas", (int)4, (int)commaCount);
        IdentityHashSetTests.assertTrue((s.indexOf("one") != -1 ? 1 : 0) != 0);
        IdentityHashSetTests.assertTrue((s.indexOf("two") != -1 ? 1 : 0) != 0);
        IdentityHashSetTests.assertTrue((s.indexOf("three") != -1 ? 1 : 0) != 0);
        IdentityHashSetTests.assertTrue((s.indexOf("four") != -1 ? 1 : 0) != 0);
        IdentityHashSetTests.assertTrue((s.indexOf("null") != -1 ? 1 : 0) != 0);
    }
}

