/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.model.listener;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.model.event.ListAddEvent;
import org.eclipse.jpt.common.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.common.utility.model.event.ListClearEvent;
import org.eclipse.jpt.common.utility.model.event.ListEvent;
import org.eclipse.jpt.common.utility.model.event.ListMoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListReplaceEvent;
import org.eclipse.jpt.common.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.common.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.common.utility.model.listener.ReflectiveChangeListener;

public class ReflectiveListChangeListenerTests
extends TestCase {
    public ReflectiveListChangeListenerTests(String name) {
        super(name);
    }

    private ListChangeListener buildZeroArgumentListener(Object target) {
        return ReflectiveChangeListener.buildListChangeListener((Object)target, (String)"itemAddedZeroArgument", (String)"itemRemovedZeroArgument", (String)"itemReplacedZeroArgument", (String)"itemMovedZeroArgument", (String)"listClearedZeroArgument", (String)"listChangedZeroArgument");
    }

    private ListChangeListener buildSingleArgumentListener(Object target) {
        return ReflectiveChangeListener.buildListChangeListener((Object)target, (String)"itemAddedSingleArgument", (String)"itemRemovedSingleArgument", (String)"itemReplacedSingleArgument", (String)"itemMovedSingleArgument", (String)"listClearedSingleArgument", (String)"listChangedSingleArgument");
    }

    public void testItemAddedZeroArgumentNamedList() {
        TestModel testModel = new TestModel();
        String string = "foo";
        Target target = new Target(testModel, "strings", string, 0);
        testModel.addListChangeListener("strings", this.buildZeroArgumentListener(target));
        testModel.addString(string);
        ReflectiveListChangeListenerTests.assertTrue((boolean)target.itemAddedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemAddedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemRemovedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemRemovedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemReplacedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemReplacedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemMovedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemMovedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.listClearedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.listClearedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.listChangedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.listChangedSingleArgumentFlag);
    }

    public void testItemAddedSingleArgumentNamedList() {
        TestModel testModel = new TestModel();
        String string = "foo";
        Target target = new Target(testModel, "strings", string, 0);
        testModel.addListChangeListener("strings", this.buildSingleArgumentListener(target));
        testModel.addString(string);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemAddedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertTrue((boolean)target.itemAddedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemRemovedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemRemovedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemReplacedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemReplacedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemMovedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemMovedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.listClearedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.listClearedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.listChangedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.listChangedSingleArgumentFlag);
    }

    public void testItemRemovedZeroArgumentNamedList() {
        TestModel testModel = new TestModel();
        String string = "foo";
        testModel.addString(string);
        Target target = new Target(testModel, "strings", string, 0);
        testModel.addListChangeListener("strings", this.buildZeroArgumentListener(target));
        testModel.removeString(string);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemAddedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemAddedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertTrue((boolean)target.itemRemovedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemRemovedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemReplacedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemReplacedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemMovedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemMovedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.listClearedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.listClearedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.listChangedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.listChangedSingleArgumentFlag);
    }

    public void testItemRemovedSingleArgumentNamedList() {
        TestModel testModel = new TestModel();
        String string = "foo";
        testModel.addString(string);
        Target target = new Target(testModel, "strings", string, 0);
        testModel.addListChangeListener("strings", this.buildSingleArgumentListener(target));
        testModel.removeString(string);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemAddedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemAddedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemRemovedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertTrue((boolean)target.itemRemovedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemReplacedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemReplacedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemMovedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemMovedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.listClearedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.listClearedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.listChangedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.listChangedSingleArgumentFlag);
    }

    public void testItemReplacedZeroArgumentNamedList() {
        TestModel testModel = new TestModel();
        String oldString = "foo";
        String newString = "bar";
        testModel.addString(oldString);
        Target target = new Target(testModel, "strings", newString, 0, oldString);
        testModel.addListChangeListener("strings", this.buildZeroArgumentListener(target));
        testModel.replaceString(oldString, newString);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemAddedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemAddedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemRemovedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemRemovedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertTrue((boolean)target.itemReplacedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemReplacedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemMovedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemMovedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.listClearedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.listClearedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.listChangedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.listChangedSingleArgumentFlag);
    }

    public void testItemReplacedSingleArgumentNamedList() {
        TestModel testModel = new TestModel();
        String oldString = "foo";
        String newString = "bar";
        testModel.addString(oldString);
        Target target = new Target(testModel, "strings", newString, 0, oldString);
        testModel.addListChangeListener("strings", this.buildSingleArgumentListener(target));
        testModel.replaceString(oldString, newString);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemAddedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemAddedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemRemovedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemRemovedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemReplacedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertTrue((boolean)target.itemReplacedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemMovedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemMovedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.listClearedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.listClearedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.listChangedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.listChangedSingleArgumentFlag);
    }

    public void testItemMovedZeroArgumentNamedList() {
        TestModel testModel = new TestModel();
        testModel.addString("zero");
        testModel.addString("one");
        testModel.addString("two");
        testModel.addString("three");
        Target target = new Target(testModel, "strings", 0, 2);
        testModel.addListChangeListener("strings", this.buildZeroArgumentListener(target));
        testModel.moveString(0, 2);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemAddedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemAddedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemRemovedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemRemovedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemReplacedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemReplacedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertTrue((boolean)target.itemMovedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemMovedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.listClearedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.listClearedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.listChangedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.listChangedSingleArgumentFlag);
    }

    public void testItemMovedSingleArgumentNamedList() {
        TestModel testModel = new TestModel();
        testModel.addString("zero");
        testModel.addString("one");
        testModel.addString("two");
        testModel.addString("three");
        Target target = new Target(testModel, "strings", 0, 2);
        testModel.addListChangeListener("strings", this.buildSingleArgumentListener(target));
        testModel.moveString(0, 2);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemAddedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemAddedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemRemovedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemRemovedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemReplacedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemReplacedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemMovedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertTrue((boolean)target.itemMovedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.listClearedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.listClearedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.listChangedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.listChangedSingleArgumentFlag);
    }

    public void testListClearedZeroArgumentNamedList() {
        TestModel testModel = new TestModel();
        String string = "foo";
        testModel.addString(string);
        Target target = new Target(testModel, "strings", null, -1);
        testModel.addListChangeListener("strings", this.buildZeroArgumentListener(target));
        testModel.clearStrings();
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemAddedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemAddedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemRemovedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemRemovedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemReplacedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemReplacedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemMovedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemMovedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertTrue((boolean)target.listClearedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.listClearedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.listChangedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.listChangedSingleArgumentFlag);
    }

    public void testListClearedSingleArgumentNamedList() {
        TestModel testModel = new TestModel();
        String string = "foo";
        testModel.addString(string);
        Target target = new Target(testModel, "strings", null, -1);
        testModel.addListChangeListener("strings", this.buildSingleArgumentListener(target));
        testModel.clearStrings();
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemAddedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemAddedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemRemovedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemRemovedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemReplacedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemReplacedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemMovedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemMovedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.listClearedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertTrue((boolean)target.listClearedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.listChangedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.listChangedSingleArgumentFlag);
    }

    public void testListChangedZeroArgumentNamedList() {
        TestModel testModel = new TestModel();
        String string = "foo";
        testModel.addString(string);
        Target target = new Target(testModel, "strings", null, -1);
        testModel.addListChangeListener("strings", this.buildZeroArgumentListener(target));
        testModel.replaceAllStrings(new String[]{"bar", "baz"});
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemAddedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemAddedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemRemovedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemRemovedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemReplacedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemReplacedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemMovedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemMovedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.listClearedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.listClearedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertTrue((boolean)target.listChangedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.listChangedSingleArgumentFlag);
    }

    public void testListChangedSingleArgumentNamedList() {
        TestModel testModel = new TestModel();
        String string = "foo";
        testModel.addString(string);
        Target target = new Target(testModel, "strings", null, -1);
        testModel.addListChangeListener("strings", this.buildSingleArgumentListener(target));
        testModel.replaceAllStrings(new String[]{"bar", "baz"});
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemAddedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemAddedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemRemovedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemRemovedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemReplacedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemReplacedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemMovedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.itemMovedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.listClearedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.listClearedSingleArgumentFlag);
        ReflectiveListChangeListenerTests.assertFalse((boolean)target.listChangedZeroArgumentFlag);
        ReflectiveListChangeListenerTests.assertTrue((boolean)target.listChangedSingleArgumentFlag);
    }

    public void testBogusDoubleArgument1() {
        boolean exCaught;
        block2: {
            TestModel testModel = new TestModel();
            String string = "foo";
            Target target = new Target(testModel, "strings", string, 0);
            exCaught = false;
            try {
                ListChangeListener listener = ReflectiveChangeListener.buildListChangeListener((Object)target, (String)"listChangedDoubleArgument");
                ReflectiveListChangeListenerTests.fail((String)("bogus listener: " + listener));
            }
            catch (RuntimeException ex) {
                if (ex.getCause().getClass() != NoSuchMethodException.class) break block2;
                exCaught = true;
            }
        }
        ReflectiveListChangeListenerTests.assertTrue((boolean)exCaught);
    }

    public void testBogusDoubleArgument2() throws Exception {
        boolean exCaught;
        block2: {
            TestModel testModel = new TestModel();
            String string = "foo";
            Target target = new Target(testModel, "strings", string, 0);
            Method method = ObjectTools.method((Object)target, (String)"listChangedDoubleArgument", (Class[])new Class[]{ListChangeEvent.class, Object.class});
            exCaught = false;
            try {
                ListChangeListener listener = ReflectiveChangeListener.buildListChangeListener((Object)target, (Method)method);
                ReflectiveListChangeListenerTests.fail((String)("bogus listener: " + listener));
            }
            catch (RuntimeException ex) {
                if (!ex.getMessage().equals(method.toString())) break block2;
                exCaught = true;
            }
        }
        ReflectiveListChangeListenerTests.assertTrue((boolean)exCaught);
    }

    public void testListenerMismatch() {
        TestModel testModel = new TestModel();
        String string = "foo";
        Target target = new Target(testModel, "strings", string, 0);
        ListChangeListener listener = ReflectiveChangeListener.buildListChangeListener((Object)target, (String)"listEventSingleArgument");
        testModel.addCollectionChangeListener("bogus collection", (CollectionChangeListener)listener);
        boolean exCaught = false;
        try {
            testModel.changeCollection();
            ReflectiveListChangeListenerTests.fail((String)("listener mismatch: " + listener));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ReflectiveListChangeListenerTests.assertTrue((boolean)exCaught);
    }

    class Target {
        TestModel testModel;
        String listName;
        String string;
        int index;
        String replacedString;
        int sourceIndex;
        boolean itemAddedZeroArgumentFlag = false;
        boolean itemAddedSingleArgumentFlag = false;
        boolean itemRemovedZeroArgumentFlag = false;
        boolean itemRemovedSingleArgumentFlag = false;
        boolean itemReplacedZeroArgumentFlag = false;
        boolean itemReplacedSingleArgumentFlag = false;
        boolean itemMovedZeroArgumentFlag = false;
        boolean itemMovedSingleArgumentFlag = false;
        boolean listClearedZeroArgumentFlag = false;
        boolean listClearedSingleArgumentFlag = false;
        boolean listChangedZeroArgumentFlag = false;
        boolean listChangedSingleArgumentFlag = false;
        boolean listEventSingleArgumentFlag = false;

        Target(TestModel testModel, String listName, String string, int index) {
            this.testModel = testModel;
            this.listName = listName;
            this.string = string;
            this.index = index;
        }

        Target(TestModel testModel, String listName, String string, int index, String replacedString) {
            this(testModel, listName, string, index);
            this.replacedString = replacedString;
        }

        Target(TestModel testModel, String listName, int targetIndex, int sourceIndex) {
            this.testModel = testModel;
            this.listName = listName;
            this.index = targetIndex;
            this.sourceIndex = sourceIndex;
        }

        void itemAddedZeroArgument() {
            this.itemAddedZeroArgumentFlag = true;
        }

        void itemAddedSingleArgument(ListAddEvent e) {
            this.itemAddedSingleArgumentFlag = true;
            ReflectiveListChangeListenerTests.assertSame((Object)((Object)this.testModel), (Object)e.getSource());
            ReflectiveListChangeListenerTests.assertEquals((String)this.listName, (String)e.getListName());
            ReflectiveListChangeListenerTests.assertEquals((Object)this.string, e.getItems().iterator().next());
            ReflectiveListChangeListenerTests.assertEquals((int)this.index, (int)e.getIndex());
        }

        void itemRemovedZeroArgument() {
            this.itemRemovedZeroArgumentFlag = true;
        }

        void itemRemovedSingleArgument(ListRemoveEvent e) {
            this.itemRemovedSingleArgumentFlag = true;
            ReflectiveListChangeListenerTests.assertSame((Object)((Object)this.testModel), (Object)e.getSource());
            ReflectiveListChangeListenerTests.assertEquals((String)this.listName, (String)e.getListName());
            ReflectiveListChangeListenerTests.assertEquals((Object)this.string, e.getItems().iterator().next());
            ReflectiveListChangeListenerTests.assertEquals((int)this.index, (int)e.getIndex());
        }

        void itemReplacedZeroArgument() {
            this.itemReplacedZeroArgumentFlag = true;
        }

        void itemReplacedSingleArgument(ListReplaceEvent e) {
            this.itemReplacedSingleArgumentFlag = true;
            ReflectiveListChangeListenerTests.assertSame((Object)((Object)this.testModel), (Object)e.getSource());
            ReflectiveListChangeListenerTests.assertEquals((String)this.listName, (String)e.getListName());
            ReflectiveListChangeListenerTests.assertEquals((Object)this.string, e.getNewItems().iterator().next());
            ReflectiveListChangeListenerTests.assertEquals((Object)this.replacedString, e.getOldItems().iterator().next());
            ReflectiveListChangeListenerTests.assertEquals((int)this.index, (int)e.getIndex());
        }

        void itemMovedZeroArgument() {
            this.itemMovedZeroArgumentFlag = true;
        }

        void itemMovedSingleArgument(ListMoveEvent e) {
            this.itemMovedSingleArgumentFlag = true;
            ReflectiveListChangeListenerTests.assertSame((Object)((Object)this.testModel), (Object)e.getSource());
            ReflectiveListChangeListenerTests.assertEquals((String)this.listName, (String)e.getListName());
            ReflectiveListChangeListenerTests.assertEquals((int)this.index, (int)e.getTargetIndex());
            ReflectiveListChangeListenerTests.assertEquals((int)this.sourceIndex, (int)e.getSourceIndex());
        }

        void listChangedZeroArgument() {
            this.listChangedZeroArgumentFlag = true;
        }

        void listClearedSingleArgument(ListClearEvent e) {
            this.listClearedSingleArgumentFlag = true;
            ReflectiveListChangeListenerTests.assertSame((Object)((Object)this.testModel), (Object)e.getSource());
            ReflectiveListChangeListenerTests.assertEquals((String)this.listName, (String)e.getListName());
        }

        void listClearedZeroArgument() {
            this.listClearedZeroArgumentFlag = true;
        }

        void listChangedSingleArgument(ListChangeEvent e) {
            this.listChangedSingleArgumentFlag = true;
            ReflectiveListChangeListenerTests.assertSame((Object)((Object)this.testModel), (Object)e.getSource());
            ReflectiveListChangeListenerTests.assertEquals((String)this.listName, (String)e.getListName());
        }

        void listChangedDoubleArgument(ListChangeEvent e, Object o) {
            ReflectiveListChangeListenerTests.fail((String)("bogus event: " + e + " - object: " + o));
        }

        void listEventSingleArgument(ListEvent e) {
            this.listEventSingleArgumentFlag = true;
            ReflectiveListChangeListenerTests.assertSame((Object)((Object)this.testModel), (Object)e.getSource());
            ReflectiveListChangeListenerTests.assertEquals((String)this.listName, (String)e.getListName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TestModel
    extends AbstractModel {
        private List<String> strings = new ArrayList<String>();
        public static final String STRINGS_LIST = "strings";

        TestModel() {
        }

        ListIterator<String> strings() {
            return IteratorTools.clone(this.strings);
        }

        void addString(String string) {
            this.addItemToList(string, this.strings, STRINGS_LIST);
        }

        void removeString(String string) {
            this.removeItemFromList(this.strings.indexOf(string), this.strings, STRINGS_LIST);
        }

        void replaceString(String oldString, String newString) {
            this.setItemInList(this.strings.indexOf(oldString), newString, this.strings, STRINGS_LIST);
        }

        void moveString(int targetIndex, int sourceIndex) {
            this.moveItemInList(targetIndex, sourceIndex, this.strings, STRINGS_LIST);
        }

        void clearStrings() {
            this.clearList(this.strings, STRINGS_LIST);
        }

        void replaceAllStrings(String[] newStrings) {
            this.strings.clear();
            CollectionTools.addAll(this.strings, (Object[])newStrings);
            this.fireListChanged(STRINGS_LIST, this.strings);
        }

        void changeCollection() {
            this.fireCollectionChanged("bogus collection", Collections.emptySet());
        }
    }
}

