/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.context.AssociationOverrideContainer;
import org.eclipse.jpt.jpa.core.context.AttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.InheritanceType;
import org.eclipse.jpt.jpa.core.context.MappedSuperclass;
import org.eclipse.jpt.jpa.core.context.SpecifiedAssociationOverride;
import org.eclipse.jpt.jpa.core.context.SpecifiedAttributeOverride;
import org.eclipse.jpt.jpa.core.context.VirtualAssociationOverride;
import org.eclipse.jpt.jpa.core.context.VirtualAttributeOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaAssociationOverrideContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaEntity;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedAssociationOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedAttributeOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaVirtualAssociationOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaVirtualAttributeOverride;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.jpa2.context.Cacheable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.CacheableReference2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.persistence.options.SharedCacheMode2_0;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.CacheableAnnotation2_0;
import org.eclipse.jpt.jpa.core.resource.java.AssociationOverrideAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.AttributeOverrideAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLink2_0ContextModelTestCase;

public class EclipseLink2_0JavaEntityTests
extends EclipseLink2_0ContextModelTestCase {
    protected static final String SUB_TYPE_NAME = "AnnotationTestTypeChild";
    protected static final String FULLY_QUALIFIED_SUB_TYPE_NAME = "test.AnnotationTestTypeChild";

    public EclipseLink2_0JavaEntityTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }
        });
    }

    private ICompilationUnit createTestMappedSuperclass() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.MappedSuperclass", "javax.persistence.OneToOne", "javax.persistence.ManyToOne", "javax.persistence.OneToMany", "javax.persistence.ManyToMany"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@MappedSuperclass");
            }

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("private String foo;").append(CR);
                sb.append(CR);
                sb.append("    @OneToOne");
                sb.append(CR);
                sb.append("    private int address;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToOne");
                sb.append(CR);
                sb.append("    private int address2;").append(CR);
                sb.append(CR);
                sb.append("    @OneToMany");
                sb.append(CR);
                sb.append("    private int address3;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToMany");
                sb.append(CR);
                sb.append("    private int address4;").append(CR);
                sb.append(CR);
                sb.append("    ");
            }
        });
    }

    private ICompilationUnit createTestAbstractEntityTablePerClass() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Inheritance", "javax.persistence.InheritanceType", "javax.persistence.OneToOne", "javax.persistence.ManyToOne", "javax.persistence.OneToMany", "javax.persistence.ManyToMany"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)");
                sb.append("abstract");
            }

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("private String foo;").append(CR);
                sb.append(CR);
                sb.append("    @OneToOne");
                sb.append(CR);
                sb.append("    private int address;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToOne");
                sb.append(CR);
                sb.append("    private int address2;").append(CR);
                sb.append(CR);
                sb.append("    @OneToMany");
                sb.append(CR);
                sb.append("    private int address3;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToMany");
                sb.append(CR);
                sb.append("    private int address4;").append(CR);
                sb.append(CR);
                sb.append("    ");
            }
        });
    }

    private void createTestSubType() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append(EclipseLink2_0JavaEntityTests.SUB_TYPE_NAME).append(" ");
                sb.append("extends AnnotationTestType ");
                sb.append("{}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "AnnotationTestTypeChild.java", sourceWriter);
    }

    private void createTestMappedSuperclassCustomer() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append("import ");
                sb.append("javax.persistence.MappedSuperclass");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@MappedSuperclass");
                sb.append(CR);
                sb.append("public class ").append("Customer ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private String id;").append(CR);
                sb.append(CR);
                sb.append("    private String name;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Customer.java", sourceWriter);
    }

    private void createTestMappedSuperclassCustomerWithElementCollection() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append("import ");
                sb.append("javax.persistence.MappedSuperclass");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ElementCollection");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@MappedSuperclass");
                sb.append(CR);
                sb.append("public class ").append("Customer ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private String id;").append(CR);
                sb.append(CR);
                sb.append("    private String name;").append(CR);
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Collection<Address> address;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Customer.java", sourceWriter);
    }

    private void createTestEntityLongTimeCustomer() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("LongTimeCustomer extends Customer ");
                sb.append("{}");
            }
        };
        this.javaProject.createCompilationUnit("test", "LongTimeCustomer.java", sourceWriter);
    }

    private void createTestEmbeddableAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.OneToOne");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String street;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @OneToOne").append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private ZipCode zipCode;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEmbeddableZipCode() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("ZipCode").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String zip;").append(CR);
                sb.append(CR);
                sb.append("    private String plusfour;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "ZipCode.java", sourceWriter);
    }

    public void testAttributeMappingKeyAllowed() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Entity entity = (Entity)this.getJavaPersistentType().getMapping();
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("basic"));
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("id"));
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("embedded"));
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("embeddedId"));
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("version"));
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("transient"));
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("oneToOne"));
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("manyToOne"));
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("oneToMany"));
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("manyToMany"));
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("elementCollection"));
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("basicCollection"));
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("basicMap"));
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("transformation"));
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("variableOneToOne"));
    }

    public void testOverridableAttributes() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAttributes = this.getJavaEntity().getOverridableAttributeNames().iterator();
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)overridableAttributes.hasNext());
        this.getJavaEntity().setSpecifiedInheritanceStrategy(InheritanceType.TABLE_PER_CLASS);
        overridableAttributes = this.getJavaEntity().getOverridableAttributeNames().iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)((String)overridableAttributes.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"name", (String)((String)overridableAttributes.next()));
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)overridableAttributes.hasNext());
    }

    public void testOverridableAttributeNames() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAttributeNames = this.getJavaEntity().getOverridableAttributeNames().iterator();
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)overridableAttributeNames.hasNext());
        this.getJavaEntity().setSpecifiedInheritanceStrategy(InheritanceType.TABLE_PER_CLASS);
        overridableAttributeNames = this.getJavaEntity().getOverridableAttributeNames().iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)((String)overridableAttributeNames.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"name", (String)((String)overridableAttributeNames.next()));
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)overridableAttributeNames.hasNext());
    }

    public void testAllOverridableAttributes() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAttributes = this.getJavaEntity().getAllOverridableAttributeNames().iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)((String)overridableAttributes.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"name", (String)((String)overridableAttributes.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"foo", (String)((String)overridableAttributes.next()));
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)overridableAttributes.hasNext());
    }

    public void testAllOverridableAttributesTablePerClass() throws Exception {
        this.createTestAbstractEntityTablePerClass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAttributes = this.getJavaEntity().getAllOverridableAttributeNames().iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)((String)overridableAttributes.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"name", (String)((String)overridableAttributes.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"foo", (String)((String)overridableAttributes.next()));
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)overridableAttributes.hasNext());
        ListIterator classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        classRefs.next();
        JavaEntity abstractEntity = (JavaEntity)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        overridableAttributes = abstractEntity.getAllOverridableAttributeNames().iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)((String)overridableAttributes.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"name", (String)((String)overridableAttributes.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"foo", (String)((String)overridableAttributes.next()));
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)overridableAttributes.hasNext());
    }

    public void testAllOverridableAssociationsTablePerClass() throws Exception {
        this.createTestAbstractEntityTablePerClass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAssociations = this.getJavaEntity().getAllOverridableAssociationNames().iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address", (String)((String)overridableAssociations.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address2", (String)((String)overridableAssociations.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address3", (String)((String)overridableAssociations.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address4", (String)((String)overridableAssociations.next()));
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)overridableAssociations.hasNext());
        ListIterator classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        classRefs.next();
        JavaEntity abstractEntity = (JavaEntity)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        overridableAssociations = abstractEntity.getAllOverridableAssociationNames().iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address", (String)((String)overridableAssociations.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address2", (String)((String)overridableAssociations.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address3", (String)((String)overridableAssociations.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address4", (String)((String)overridableAssociations.next()));
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)overridableAssociations.hasNext());
    }

    public void testAllOverridableAttributesMappedSuperclassInOrmXml() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        Iterator overridableAttributes = this.getJavaEntity().getAllOverridableAttributeNames().iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)((String)overridableAttributes.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"name", (String)((String)overridableAttributes.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"foo", (String)((String)overridableAttributes.next()));
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)overridableAttributes.hasNext());
    }

    public void testAllOverridableAttributeNames() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAttributeNames = this.getJavaEntity().getAllOverridableAttributeNames().iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)((String)overridableAttributeNames.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"name", (String)((String)overridableAttributeNames.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"foo", (String)((String)overridableAttributeNames.next()));
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)overridableAttributeNames.hasNext());
    }

    public void testSpecifiedAttributeOverrides() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        ListIterator specifiedAttributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceType.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)resourceType.addAnnotation(1, "javax.persistence.AttributeOverride");
        attributeOverride.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)resourceType.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        resourceType.moveAnnotation(1, 0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        resourceType.removeAnnotation(0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        resourceType.removeAnnotation(0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        resourceType.removeAnnotation(0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
    }

    public void testDefaultAttributeOverrides() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        ListIterator classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        classRefs.next();
        JavaEntity javaEntity = (JavaEntity)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        JavaAttributeOverrideContainer overrideContainer = javaEntity.getAttributeOverrideContainer();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType(FULLY_QUALIFIED_SUB_TYPE_NAME, JavaResourceAnnotatedElement.AstNodeType.TYPE);
        EclipseLink2_0JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)resourceType.getName());
        EclipseLink2_0JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.AttributeOverride"));
        EclipseLink2_0JavaEntityTests.assertEquals((int)3, (int)overrideContainer.getVirtualOverridesSize());
        VirtualAttributeOverride virtualAttributeOverride = (VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)virtualAttributeOverride.getColumn().getTableName());
        MappedSuperclass mappedSuperclass = (MappedSuperclass)this.getJavaPersistentType().getMapping();
        BasicMapping idMapping = (BasicMapping)mappedSuperclass.getPersistentType().getAttributeNamed("id").getMapping();
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.getColumn().setSpecifiedTableName("BAR");
        EclipseLink2_0JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)resourceType.getName());
        EclipseLink2_0JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.AttributeOverride"));
        EclipseLink2_0JavaEntityTests.assertEquals((int)3, (int)overrideContainer.getVirtualOverridesSize());
        virtualAttributeOverride = (VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"FOO", (String)virtualAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAR", (String)virtualAttributeOverride.getColumn().getTableName());
        idMapping.getColumn().setSpecifiedName(null);
        idMapping.getColumn().setSpecifiedTableName(null);
        EclipseLink2_0JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)resourceType.getName());
        EclipseLink2_0JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.AttributeOverride"));
        virtualAttributeOverride = (VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)virtualAttributeOverride.getColumn().getTableName());
        virtualAttributeOverride.convertToSpecified();
        EclipseLink2_0JavaEntityTests.assertEquals((int)2, (int)overrideContainer.getVirtualOverridesSize());
    }

    public void testDefaultAttributeOverridesEntityHierachy() throws Exception {
        this.createTestAbstractEntityTablePerClass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        ListIterator classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        classRefs.next();
        JavaEntity javaEntity = (JavaEntity)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        JavaAttributeOverrideContainer overrideContainer = javaEntity.getAttributeOverrideContainer();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType(FULLY_QUALIFIED_SUB_TYPE_NAME, JavaResourceAnnotatedElement.AstNodeType.TYPE);
        EclipseLink2_0JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)resourceType.getName());
        EclipseLink2_0JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.AttributeOverride"));
        EclipseLink2_0JavaEntityTests.assertEquals((int)3, (int)overrideContainer.getVirtualOverridesSize());
        VirtualAttributeOverride virtualAttributeOverride = (VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)virtualAttributeOverride.getColumn().getTableName());
        JavaEntity superclass = (JavaEntity)this.getJavaPersistentType().getMapping();
        BasicMapping idMapping = (BasicMapping)superclass.getPersistentType().getAttributeNamed("id").getMapping();
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.getColumn().setSpecifiedTableName("BAR");
        EclipseLink2_0JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)resourceType.getName());
        EclipseLink2_0JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.AttributeOverride"));
        EclipseLink2_0JavaEntityTests.assertEquals((int)3, (int)overrideContainer.getVirtualOverridesSize());
        virtualAttributeOverride = (VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"FOO", (String)virtualAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAR", (String)virtualAttributeOverride.getColumn().getTableName());
        idMapping.getColumn().setSpecifiedName(null);
        idMapping.getColumn().setSpecifiedTableName(null);
        EclipseLink2_0JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)resourceType.getName());
        EclipseLink2_0JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.AttributeOverride"));
        virtualAttributeOverride = (VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)virtualAttributeOverride.getColumn().getTableName());
        virtualAttributeOverride.convertToSpecified();
        EclipseLink2_0JavaEntityTests.assertEquals((int)2, (int)overrideContainer.getVirtualOverridesSize());
    }

    public void testSpecifiedAttributeOverridesSize() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        EclipseLink2_0JavaEntityTests.assertEquals((int)0, (int)overrideContainer.getSpecifiedOverridesSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceType.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)resourceType.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaEntityTests.assertEquals((int)2, (int)overrideContainer.getSpecifiedOverridesSize());
    }

    public void testDefaultAttributeOverridesSize() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        EclipseLink2_0JavaEntityTests.assertEquals((int)3, (int)overrideContainer.getVirtualOverridesSize());
        ((VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        EclipseLink2_0JavaEntityTests.assertEquals((int)2, (int)overrideContainer.getVirtualOverridesSize());
        ((VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        EclipseLink2_0JavaEntityTests.assertEquals((int)1, (int)overrideContainer.getVirtualOverridesSize());
        ((VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        EclipseLink2_0JavaEntityTests.assertEquals((int)0, (int)overrideContainer.getVirtualOverridesSize());
    }

    public void testAttributeOverridesSize() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        EclipseLink2_0JavaEntityTests.assertEquals((int)3, (int)overrideContainer.getOverridesSize());
        ((VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        EclipseLink2_0JavaEntityTests.assertEquals((int)3, (int)overrideContainer.getOverridesSize());
        ((VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        EclipseLink2_0JavaEntityTests.assertEquals((int)3, (int)overrideContainer.getOverridesSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType(FULLY_QUALIFIED_SUB_TYPE_NAME, JavaResourceAnnotatedElement.AstNodeType.TYPE);
        AttributeOverrideAnnotation annotation = (AttributeOverrideAnnotation)resourceType.addAnnotation(0, "javax.persistence.AttributeOverride");
        annotation.setName("bar");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaEntityTests.assertEquals((int)4, (int)overrideContainer.getOverridesSize());
    }

    public void testAttributeOverrideSetVirtual() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        ((VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType(FULLY_QUALIFIED_SUB_TYPE_NAME, JavaResourceAnnotatedElement.AstNodeType.TYPE);
        ListIterator attributeOverrides = resourceType.getAnnotations("javax.persistence.AttributeOverride").iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"name", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
    }

    public void testAttributeOverrideSetVirtual2() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        ListIterator virtualAttributeOverrides = overrideContainer.getVirtualOverrides().iterator();
        virtualAttributeOverrides.next();
        ((JavaVirtualAttributeOverride)virtualAttributeOverrides.next()).convertToSpecified();
        ((JavaVirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType(FULLY_QUALIFIED_SUB_TYPE_NAME, JavaResourceAnnotatedElement.AstNodeType.TYPE);
        ListIterator attributeOverrides = resourceType.getAnnotations("javax.persistence.AttributeOverride").iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"name", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
    }

    public void testAttributeOverrideSetVirtualTrue() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        ((JavaVirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((JavaVirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((JavaVirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType(FULLY_QUALIFIED_SUB_TYPE_NAME, JavaResourceAnnotatedElement.AstNodeType.TYPE);
        EclipseLink2_0JavaEntityTests.assertEquals((int)3, (int)resourceType.getAnnotationsSize("javax.persistence.AttributeOverride"));
        ((JavaSpecifiedAttributeOverride)overrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        ListIterator attributeOverrideResources = resourceType.getAnnotations("javax.persistence.AttributeOverride").iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"name", (String)((AttributeOverrideAnnotation)attributeOverrideResources.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"foo", (String)((AttributeOverrideAnnotation)attributeOverrideResources.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)attributeOverrideResources.hasNext());
        ListIterator attributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"name", (String)((JavaSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"foo", (String)((JavaSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        ((JavaSpecifiedAttributeOverride)overrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        attributeOverrideResources = resourceType.getAnnotations("javax.persistence.AttributeOverride").iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"foo", (String)((AttributeOverrideAnnotation)attributeOverrideResources.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)attributeOverrideResources.hasNext());
        attributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"foo", (String)((JavaSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        ((JavaSpecifiedAttributeOverride)overrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        attributeOverrideResources = resourceType.getAnnotations("javax.persistence.AttributeOverride").iterator();
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)attributeOverrideResources.hasNext());
        attributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        EclipseLink2_0JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.AttributeOverride"));
    }

    public void testMoveSpecifiedAttributeOverride() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        ((VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType(FULLY_QUALIFIED_SUB_TYPE_NAME, JavaResourceAnnotatedElement.AstNodeType.TYPE);
        ListIterator javaAttributeOverrides = resourceType.getAnnotations("javax.persistence.AttributeOverride").iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((int)3, (int)IteratorTools.size((Iterator)javaAttributeOverrides));
        overrideContainer.moveSpecifiedOverride(2, 0);
        ListIterator attributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"name", (String)((SpecifiedAttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"foo", (String)((SpecifiedAttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)((SpecifiedAttributeOverride)attributeOverrides.next()).getName());
        javaAttributeOverrides = resourceType.getAnnotations("javax.persistence.AttributeOverride").iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"name", (String)((AttributeOverrideAnnotation)javaAttributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"foo", (String)((AttributeOverrideAnnotation)javaAttributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)((AttributeOverrideAnnotation)javaAttributeOverrides.next()).getName());
        overrideContainer.moveSpecifiedOverride(0, 1);
        attributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"foo", (String)((SpecifiedAttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"name", (String)((SpecifiedAttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)((SpecifiedAttributeOverride)attributeOverrides.next()).getName());
        javaAttributeOverrides = resourceType.getAnnotations("javax.persistence.AttributeOverride").iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"foo", (String)((AttributeOverrideAnnotation)javaAttributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"name", (String)((AttributeOverrideAnnotation)javaAttributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)((AttributeOverrideAnnotation)javaAttributeOverrides.next()).getName());
    }

    public void testUpdateSpecifiedAttributeOverrides() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        ((AttributeOverrideAnnotation)resourceType.addAnnotation(0, "javax.persistence.AttributeOverride")).setName("FOO");
        ((AttributeOverrideAnnotation)resourceType.addAnnotation(1, "javax.persistence.AttributeOverride")).setName("BAR");
        ((AttributeOverrideAnnotation)resourceType.addAnnotation(2, "javax.persistence.AttributeOverride")).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator attributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"FOO", (String)((SpecifiedAttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAR", (String)((SpecifiedAttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAZ", (String)((SpecifiedAttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        resourceType.moveAnnotation(2, 0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        attributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAR", (String)((SpecifiedAttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAZ", (String)((SpecifiedAttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"FOO", (String)((SpecifiedAttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        resourceType.moveAnnotation(0, 1, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        attributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAZ", (String)((SpecifiedAttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAR", (String)((SpecifiedAttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"FOO", (String)((SpecifiedAttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        resourceType.removeAnnotation(1, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        attributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAZ", (String)((SpecifiedAttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"FOO", (String)((SpecifiedAttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        resourceType.removeAnnotation(1, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        attributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAZ", (String)((SpecifiedAttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        resourceType.removeAnnotation(0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        attributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
    }

    public void testAttributeOverrideIsVirtual() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        ListIterator virtualAttributeOverrides = overrideContainer.getVirtualOverrides().iterator();
        JavaVirtualAttributeOverride virtualAttributeOverride = (JavaVirtualAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)virtualAttributeOverride.isVirtual());
        virtualAttributeOverride = (JavaVirtualAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"name", (String)virtualAttributeOverride.getName());
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)virtualAttributeOverride.isVirtual());
        virtualAttributeOverride = (JavaVirtualAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"foo", (String)virtualAttributeOverride.getName());
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)virtualAttributeOverride.isVirtual());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)virtualAttributeOverrides.hasNext());
        ((JavaVirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        SpecifiedAttributeOverride specifiedAttributeOverride = (SpecifiedAttributeOverride)overrideContainer.getSpecifiedOverrides().iterator().next();
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)specifiedAttributeOverride.isVirtual());
        virtualAttributeOverrides = overrideContainer.getVirtualOverrides().iterator();
        virtualAttributeOverride = (JavaVirtualAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"name", (String)virtualAttributeOverride.getName());
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)virtualAttributeOverride.isVirtual());
        virtualAttributeOverride = (JavaVirtualAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"foo", (String)virtualAttributeOverride.getName());
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)virtualAttributeOverride.isVirtual());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)virtualAttributeOverrides.hasNext());
    }

    public void testOverridableAssociations() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAssociations = this.getJavaEntity().getOverridableAssociationNames().iterator();
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)overridableAssociations.hasNext());
    }

    public void testOverridableAssociationNames() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAssociationNames = this.getJavaEntity().getOverridableAssociationNames().iterator();
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)overridableAssociationNames.hasNext());
    }

    public void testAllOverridableAssociationNames() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAssociationNames = this.getJavaEntity().getAllOverridableAssociationNames().iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address", (String)((String)overridableAssociationNames.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address2", (String)((String)overridableAssociationNames.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address3", (String)((String)overridableAssociationNames.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address4", (String)((String)overridableAssociationNames.next()));
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)overridableAssociationNames.hasNext());
    }

    public void testAllOverridableAssociationsMappedSuperclassInOrmXml() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        Iterator overridableAssociations = this.getJavaEntity().getAllOverridableAssociationNames().iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address", (String)((String)overridableAssociations.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address2", (String)((String)overridableAssociations.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address3", (String)((String)overridableAssociations.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address4", (String)((String)overridableAssociations.next()));
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)overridableAssociations.hasNext());
    }

    public void testSpecifiedAssociationOverrides() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        ListIterator specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)resourceType.addAnnotation(0, "javax.persistence.AssociationOverride");
        associationOverride.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        associationOverride = (AssociationOverrideAnnotation)resourceType.addAnnotation(1, "javax.persistence.AssociationOverride");
        associationOverride.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        associationOverride = (AssociationOverrideAnnotation)resourceType.addAnnotation(0, "javax.persistence.AssociationOverride");
        associationOverride.setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        resourceType.moveAnnotation(1, 0, "javax.persistence.AssociationOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        resourceType.removeAnnotation(0, "javax.persistence.AssociationOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        resourceType.removeAnnotation(0, "javax.persistence.AssociationOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        resourceType.removeAnnotation(0, "javax.persistence.AssociationOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
    }

    public void testVirtualAssociationOverrides() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        ListIterator classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        classRefs.next();
        JavaEntity javaEntity = (JavaEntity)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        JavaAssociationOverrideContainer overrideContainer = javaEntity.getAssociationOverrideContainer();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType(FULLY_QUALIFIED_SUB_TYPE_NAME, JavaResourceAnnotatedElement.AstNodeType.TYPE);
        EclipseLink2_0JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)resourceType.getName());
        EclipseLink2_0JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.AssociationOverride"));
        EclipseLink2_0JavaEntityTests.assertEquals((int)4, (int)overrideContainer.getVirtualOverridesSize());
        VirtualAssociationOverride virtualAssociationOverride = (VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address", (String)virtualAssociationOverride.getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)resourceType.getName());
        EclipseLink2_0JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.AssociationOverride"));
        EclipseLink2_0JavaEntityTests.assertEquals((int)4, (int)overrideContainer.getVirtualOverridesSize());
        virtualAssociationOverride = (VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address", (String)virtualAssociationOverride.getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)resourceType.getName());
        EclipseLink2_0JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.AssociationOverride"));
        virtualAssociationOverride = (VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address", (String)virtualAssociationOverride.getName());
        virtualAssociationOverride.convertToSpecified();
        EclipseLink2_0JavaEntityTests.assertEquals((int)3, (int)overrideContainer.getVirtualOverridesSize());
    }

    public void testSpecifiedAssociationOverridesSize() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        EclipseLink2_0JavaEntityTests.assertEquals((int)0, (int)overrideContainer.getSpecifiedOverridesSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)resourceType.addAnnotation(0, "javax.persistence.AssociationOverride");
        associationOverride.setName("FOO");
        associationOverride = (AssociationOverrideAnnotation)resourceType.addAnnotation(0, "javax.persistence.AssociationOverride");
        associationOverride.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaEntityTests.assertEquals((int)2, (int)overrideContainer.getSpecifiedOverridesSize());
    }

    public void testVirtualAssociationOverridesSize() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        EclipseLink2_0JavaEntityTests.assertEquals((int)4, (int)overrideContainer.getVirtualOverridesSize());
        ((VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        EclipseLink2_0JavaEntityTests.assertEquals((int)3, (int)overrideContainer.getVirtualOverridesSize());
        ((VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        EclipseLink2_0JavaEntityTests.assertEquals((int)2, (int)overrideContainer.getVirtualOverridesSize());
        ((VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        EclipseLink2_0JavaEntityTests.assertEquals((int)1, (int)overrideContainer.getVirtualOverridesSize());
        ((VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        EclipseLink2_0JavaEntityTests.assertEquals((int)0, (int)overrideContainer.getVirtualOverridesSize());
    }

    public void testAssociationOverridesSize() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        EclipseLink2_0JavaEntityTests.assertEquals((int)4, (int)overrideContainer.getOverridesSize());
        ((VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        EclipseLink2_0JavaEntityTests.assertEquals((int)4, (int)overrideContainer.getOverridesSize());
        ((VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        EclipseLink2_0JavaEntityTests.assertEquals((int)4, (int)overrideContainer.getOverridesSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType(FULLY_QUALIFIED_SUB_TYPE_NAME, JavaResourceAnnotatedElement.AstNodeType.TYPE);
        AssociationOverrideAnnotation annotation = (AssociationOverrideAnnotation)resourceType.addAnnotation(0, "javax.persistence.AssociationOverride");
        annotation.setName("bar");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaEntityTests.assertEquals((int)5, (int)overrideContainer.getOverridesSize());
    }

    public void testAssociationOverrideSetVirtual() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        ((VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType(FULLY_QUALIFIED_SUB_TYPE_NAME, JavaResourceAnnotatedElement.AstNodeType.TYPE);
        ListIterator associationOverrides = resourceType.getAnnotations("javax.persistence.AssociationOverride").iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address", (String)((AssociationOverrideAnnotation)associationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address2", (String)((AssociationOverrideAnnotation)associationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
    }

    public void testAssociationOverrideSetVirtual2() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        ListIterator virtualAssociationOverrides = overrideContainer.getVirtualOverrides().iterator();
        virtualAssociationOverrides.next();
        ((JavaVirtualAssociationOverride)virtualAssociationOverrides.next()).convertToSpecified();
        ((JavaVirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType(FULLY_QUALIFIED_SUB_TYPE_NAME, JavaResourceAnnotatedElement.AstNodeType.TYPE);
        ListIterator associationOverrides = resourceType.getAnnotations("javax.persistence.AssociationOverride").iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address2", (String)((AssociationOverrideAnnotation)associationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address", (String)((AssociationOverrideAnnotation)associationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
    }

    public void testAssociationOverrideSetVirtualTrue() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        ((JavaVirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((JavaVirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType(FULLY_QUALIFIED_SUB_TYPE_NAME, JavaResourceAnnotatedElement.AstNodeType.TYPE);
        EclipseLink2_0JavaEntityTests.assertEquals((int)2, (int)resourceType.getAnnotationsSize("javax.persistence.AssociationOverride"));
        ((JavaSpecifiedAssociationOverride)overrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        ListIterator associationOverrideResources = resourceType.getAnnotations("javax.persistence.AssociationOverride").iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address2", (String)((AssociationOverrideAnnotation)associationOverrideResources.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)associationOverrideResources.hasNext());
        ListIterator associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address2", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
        ((JavaSpecifiedAssociationOverride)overrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        associationOverrideResources = resourceType.getAnnotations("javax.persistence.AssociationOverride").iterator();
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)associationOverrideResources.hasNext());
        associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
        EclipseLink2_0JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.AssociationOverride"));
    }

    public void testMoveSpecifiedAssociationOverride() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        ((JavaVirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((JavaVirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType(FULLY_QUALIFIED_SUB_TYPE_NAME, JavaResourceAnnotatedElement.AstNodeType.TYPE);
        ListIterator javaAssociationOverrides = resourceType.getAnnotations("javax.persistence.AssociationOverride").iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((int)2, (int)IteratorTools.size((Iterator)javaAssociationOverrides));
        overrideContainer.moveSpecifiedOverride(1, 0);
        ListIterator associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address2", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        javaAssociationOverrides = resourceType.getAnnotations("javax.persistence.AssociationOverride").iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address2", (String)((AssociationOverrideAnnotation)javaAssociationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address", (String)((AssociationOverrideAnnotation)javaAssociationOverrides.next()).getName());
        overrideContainer.moveSpecifiedOverride(0, 1);
        associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address2", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        javaAssociationOverrides = resourceType.getAnnotations("javax.persistence.AssociationOverride").iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address", (String)((AssociationOverrideAnnotation)javaAssociationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address2", (String)((AssociationOverrideAnnotation)javaAssociationOverrides.next()).getName());
    }

    public void testUpdateSpecifiedAssociationOverrides() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        ((AssociationOverrideAnnotation)resourceType.addAnnotation(0, "javax.persistence.AssociationOverride")).setName("FOO");
        ((AssociationOverrideAnnotation)resourceType.addAnnotation(1, "javax.persistence.AssociationOverride")).setName("BAR");
        ((AssociationOverrideAnnotation)resourceType.addAnnotation(2, "javax.persistence.AssociationOverride")).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
        resourceType.moveAnnotation(2, 0, "javax.persistence.AssociationOverride");
        this.getJpaProject().synchronizeContextModel();
        associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
        resourceType.moveAnnotation(0, 1, "javax.persistence.AssociationOverride");
        this.getJpaProject().synchronizeContextModel();
        associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
        resourceType.removeAnnotation(1, "javax.persistence.AssociationOverride");
        this.getJpaProject().synchronizeContextModel();
        associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
        resourceType.removeAnnotation(1, "javax.persistence.AssociationOverride");
        this.getJpaProject().synchronizeContextModel();
        associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
        resourceType.removeAnnotation(0, "javax.persistence.AssociationOverride");
        this.getJpaProject().synchronizeContextModel();
        associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
    }

    public void testAssociationOverrideIsVirtual() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        ListIterator virtualAssociationOverrides = overrideContainer.getVirtualOverrides().iterator();
        VirtualAssociationOverride virtualAssociationOverride = (VirtualAssociationOverride)virtualAssociationOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address", (String)virtualAssociationOverride.getName());
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        virtualAssociationOverride = (VirtualAssociationOverride)virtualAssociationOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address2", (String)virtualAssociationOverride.getName());
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        virtualAssociationOverride = (VirtualAssociationOverride)virtualAssociationOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address3", (String)virtualAssociationOverride.getName());
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        virtualAssociationOverride = (VirtualAssociationOverride)virtualAssociationOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address4", (String)virtualAssociationOverride.getName());
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)virtualAssociationOverrides.hasNext());
        ((JavaVirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        SpecifiedAssociationOverride specifiedAssociationOverride = (SpecifiedAssociationOverride)overrideContainer.getSpecifiedOverrides().iterator().next();
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)specifiedAssociationOverride.isVirtual());
        virtualAssociationOverrides = overrideContainer.getVirtualOverrides().iterator();
        virtualAssociationOverride = (VirtualAssociationOverride)virtualAssociationOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address2", (String)virtualAssociationOverride.getName());
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        virtualAssociationOverride = (VirtualAssociationOverride)virtualAssociationOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address3", (String)virtualAssociationOverride.getName());
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        virtualAssociationOverride = (VirtualAssociationOverride)virtualAssociationOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address4", (String)virtualAssociationOverride.getName());
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)virtualAssociationOverrides.hasNext());
    }

    public void testNestedVirtualAttributeOverrides() throws Exception {
        this.createTestMappedSuperclassCustomer();
        this.createTestEntityLongTimeCustomer();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableZipCode();
        this.addXmlClassRef("test.Customer");
        this.addXmlClassRef("test.LongTimeCustomer");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.ZipCode");
        ListIterator specifiedClassRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        JavaPersistentType longTimeCustomerPersistentType = ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        JavaPersistentType addressPersistentType = ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        JavaPersistentType zipCodePersistentType = ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        AttributeOverrideContainer attributeOverrideContainer = ((Entity)longTimeCustomerPersistentType.getMapping()).getAttributeOverrideContainer();
        EclipseLink2_0JavaEntityTests.assertEquals((int)6, (int)attributeOverrideContainer.getVirtualOverridesSize());
        ListIterator virtualAttributeOverrides = attributeOverrideContainer.getVirtualOverrides().iterator();
        VirtualAttributeOverride virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"name", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address.street", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address.city", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address.zipCode.zip", (String)virtualAttributeOverride.getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"zip", (String)virtualAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"LongTimeCustomer", (String)virtualAttributeOverride.getColumn().getTableName());
        virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address.zipCode.plusfour", (String)virtualAttributeOverride.getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"plusfour", (String)virtualAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"LongTimeCustomer", (String)virtualAttributeOverride.getColumn().getTableName());
        EclipseLink2_0JavaEntityTests.assertEquals(null, (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUnique());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isNullable());
        EclipseLink2_0JavaEntityTests.assertEquals((int)255, (int)virtualAttributeOverride.getColumn().getLength());
        EclipseLink2_0JavaEntityTests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getPrecision());
        EclipseLink2_0JavaEntityTests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getScale());
        BasicMapping plusFourMapping = (BasicMapping)zipCodePersistentType.getAttributeNamed("plusfour").getMapping();
        plusFourMapping.getColumn().setSpecifiedName("BLAH");
        plusFourMapping.getColumn().setSpecifiedTableName("BLAH_TABLE");
        plusFourMapping.getColumn().setColumnDefinition("COLUMN_DEFINITION");
        plusFourMapping.getColumn().setSpecifiedInsertable(Boolean.FALSE);
        plusFourMapping.getColumn().setSpecifiedUpdatable(Boolean.FALSE);
        plusFourMapping.getColumn().setSpecifiedUnique(Boolean.TRUE);
        plusFourMapping.getColumn().setSpecifiedNullable(Boolean.FALSE);
        plusFourMapping.getColumn().setSpecifiedLength(Integer.valueOf(5));
        plusFourMapping.getColumn().setSpecifiedPrecision(Integer.valueOf(6));
        plusFourMapping.getColumn().setSpecifiedScale(Integer.valueOf(7));
        attributeOverrideContainer = ((Entity)longTimeCustomerPersistentType.getMapping()).getAttributeOverrideContainer();
        virtualAttributeOverride = (VirtualAttributeOverride)attributeOverrideContainer.getOverrideNamed("address.zipCode.plusfour");
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address.zipCode.plusfour", (String)virtualAttributeOverride.getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BLAH", (String)virtualAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BLAH_TABLE", (String)virtualAttributeOverride.getColumn().getTableName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"COLUMN_DEFINITION", (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUnique());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isNullable());
        EclipseLink2_0JavaEntityTests.assertEquals((int)5, (int)virtualAttributeOverride.getColumn().getLength());
        EclipseLink2_0JavaEntityTests.assertEquals((int)6, (int)virtualAttributeOverride.getColumn().getPrecision());
        EclipseLink2_0JavaEntityTests.assertEquals((int)7, (int)virtualAttributeOverride.getColumn().getScale());
        SpecifiedAttributeOverride specifiedAttributeOverride = ((VirtualAttributeOverride)((EmbeddedMapping)addressPersistentType.getAttributeNamed("zipCode").getMapping()).getAttributeOverrideContainer().getOverrideNamed("plusfour")).convertToSpecified();
        specifiedAttributeOverride.getColumn().setSpecifiedName("BLAH_OVERRIDE");
        specifiedAttributeOverride.getColumn().setSpecifiedTableName("BLAH_TABLE_OVERRIDE");
        specifiedAttributeOverride.getColumn().setColumnDefinition("COLUMN_DEFINITION_OVERRIDE");
        attributeOverrideContainer = ((Entity)longTimeCustomerPersistentType.getMapping()).getAttributeOverrideContainer();
        virtualAttributeOverride = (VirtualAttributeOverride)attributeOverrideContainer.getOverrideNamed("address.zipCode.plusfour");
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address.zipCode.plusfour", (String)virtualAttributeOverride.getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BLAH_OVERRIDE", (String)virtualAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BLAH_TABLE_OVERRIDE", (String)virtualAttributeOverride.getColumn().getTableName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"COLUMN_DEFINITION_OVERRIDE", (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUnique());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isNullable());
        EclipseLink2_0JavaEntityTests.assertEquals((int)255, (int)virtualAttributeOverride.getColumn().getLength());
        EclipseLink2_0JavaEntityTests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getPrecision());
        EclipseLink2_0JavaEntityTests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getScale());
        specifiedAttributeOverride = virtualAttributeOverride.convertToSpecified();
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)specifiedAttributeOverride.isVirtual());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address.zipCode.plusfour", (String)specifiedAttributeOverride.getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BLAH_OVERRIDE", (String)specifiedAttributeOverride.getColumn().getSpecifiedName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BLAH_TABLE_OVERRIDE", (String)specifiedAttributeOverride.getColumn().getSpecifiedTableName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"COLUMN_DEFINITION_OVERRIDE", (String)specifiedAttributeOverride.getColumn().getColumnDefinition());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)specifiedAttributeOverride.getColumn().isInsertable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)specifiedAttributeOverride.getColumn().isUpdatable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)specifiedAttributeOverride.getColumn().isUnique());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)specifiedAttributeOverride.getColumn().isNullable());
        EclipseLink2_0JavaEntityTests.assertEquals((int)255, (int)specifiedAttributeOverride.getColumn().getLength());
        EclipseLink2_0JavaEntityTests.assertEquals((int)0, (int)specifiedAttributeOverride.getColumn().getPrecision());
        EclipseLink2_0JavaEntityTests.assertEquals((int)0, (int)specifiedAttributeOverride.getColumn().getScale());
    }

    public void testNestedVirtualAttributeOverridesElementCollection() throws Exception {
        this.createTestMappedSuperclassCustomerWithElementCollection();
        this.createTestEntityLongTimeCustomer();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableZipCode();
        this.addXmlClassRef("test.Customer");
        this.addXmlClassRef("test.LongTimeCustomer");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.ZipCode");
        ListIterator specifiedClassRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        JavaPersistentType longTimeCustomerPersistentType = ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        JavaPersistentType addressPersistentType = ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        JavaPersistentType zipCodePersistentType = ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        AttributeOverrideContainer attributeOverrideContainer = ((Entity)longTimeCustomerPersistentType.getMapping()).getAttributeOverrideContainer();
        EclipseLink2_0JavaEntityTests.assertEquals((int)6, (int)attributeOverrideContainer.getVirtualOverridesSize());
        ListIterator virtualAttributeOverrides = attributeOverrideContainer.getVirtualOverrides().iterator();
        VirtualAttributeOverride virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"name", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address.street", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address.city", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address.zipCode.zip", (String)virtualAttributeOverride.getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"zip", (String)virtualAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"LongTimeCustomer", (String)virtualAttributeOverride.getColumn().getTableName());
        virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address.zipCode.plusfour", (String)virtualAttributeOverride.getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"plusfour", (String)virtualAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"LongTimeCustomer", (String)virtualAttributeOverride.getColumn().getTableName());
        EclipseLink2_0JavaEntityTests.assertEquals(null, (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUnique());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isNullable());
        EclipseLink2_0JavaEntityTests.assertEquals((int)255, (int)virtualAttributeOverride.getColumn().getLength());
        EclipseLink2_0JavaEntityTests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getPrecision());
        EclipseLink2_0JavaEntityTests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getScale());
        BasicMapping plusFourMapping = (BasicMapping)zipCodePersistentType.getAttributeNamed("plusfour").getMapping();
        plusFourMapping.getColumn().setSpecifiedName("BLAH");
        plusFourMapping.getColumn().setSpecifiedTableName("BLAH_TABLE");
        plusFourMapping.getColumn().setColumnDefinition("COLUMN_DEFINITION");
        plusFourMapping.getColumn().setSpecifiedInsertable(Boolean.FALSE);
        plusFourMapping.getColumn().setSpecifiedUpdatable(Boolean.FALSE);
        plusFourMapping.getColumn().setSpecifiedUnique(Boolean.TRUE);
        plusFourMapping.getColumn().setSpecifiedNullable(Boolean.FALSE);
        plusFourMapping.getColumn().setSpecifiedLength(Integer.valueOf(5));
        plusFourMapping.getColumn().setSpecifiedPrecision(Integer.valueOf(6));
        plusFourMapping.getColumn().setSpecifiedScale(Integer.valueOf(7));
        attributeOverrideContainer = ((Entity)longTimeCustomerPersistentType.getMapping()).getAttributeOverrideContainer();
        virtualAttributeOverride = (VirtualAttributeOverride)attributeOverrideContainer.getOverrideNamed("address.zipCode.plusfour");
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address.zipCode.plusfour", (String)virtualAttributeOverride.getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BLAH", (String)virtualAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BLAH_TABLE", (String)virtualAttributeOverride.getColumn().getTableName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"COLUMN_DEFINITION", (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUnique());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isNullable());
        EclipseLink2_0JavaEntityTests.assertEquals((int)5, (int)virtualAttributeOverride.getColumn().getLength());
        EclipseLink2_0JavaEntityTests.assertEquals((int)6, (int)virtualAttributeOverride.getColumn().getPrecision());
        EclipseLink2_0JavaEntityTests.assertEquals((int)7, (int)virtualAttributeOverride.getColumn().getScale());
        SpecifiedAttributeOverride specifiedAttributeOverride = ((VirtualAttributeOverride)((EmbeddedMapping)addressPersistentType.getAttributeNamed("zipCode").getMapping()).getAttributeOverrideContainer().getOverrideNamed("plusfour")).convertToSpecified();
        specifiedAttributeOverride.getColumn().setSpecifiedName("BLAH_OVERRIDE");
        specifiedAttributeOverride.getColumn().setSpecifiedTableName("BLAH_TABLE_OVERRIDE");
        specifiedAttributeOverride.getColumn().setColumnDefinition("COLUMN_DEFINITION_OVERRIDE");
        attributeOverrideContainer = ((Entity)longTimeCustomerPersistentType.getMapping()).getAttributeOverrideContainer();
        virtualAttributeOverride = (VirtualAttributeOverride)attributeOverrideContainer.getOverrideNamed("address.zipCode.plusfour");
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address.zipCode.plusfour", (String)virtualAttributeOverride.getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BLAH_OVERRIDE", (String)virtualAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BLAH_TABLE_OVERRIDE", (String)virtualAttributeOverride.getColumn().getTableName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"COLUMN_DEFINITION_OVERRIDE", (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUnique());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isNullable());
        EclipseLink2_0JavaEntityTests.assertEquals((int)255, (int)virtualAttributeOverride.getColumn().getLength());
        EclipseLink2_0JavaEntityTests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getPrecision());
        EclipseLink2_0JavaEntityTests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getScale());
        specifiedAttributeOverride = virtualAttributeOverride.convertToSpecified();
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)specifiedAttributeOverride.isVirtual());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address.zipCode.plusfour", (String)specifiedAttributeOverride.getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BLAH_OVERRIDE", (String)specifiedAttributeOverride.getColumn().getSpecifiedName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BLAH_TABLE_OVERRIDE", (String)specifiedAttributeOverride.getColumn().getSpecifiedTableName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"COLUMN_DEFINITION_OVERRIDE", (String)specifiedAttributeOverride.getColumn().getColumnDefinition());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)specifiedAttributeOverride.getColumn().isInsertable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)specifiedAttributeOverride.getColumn().isUpdatable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)specifiedAttributeOverride.getColumn().isUnique());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)specifiedAttributeOverride.getColumn().isNullable());
        EclipseLink2_0JavaEntityTests.assertEquals((int)255, (int)specifiedAttributeOverride.getColumn().getLength());
        EclipseLink2_0JavaEntityTests.assertEquals((int)0, (int)specifiedAttributeOverride.getColumn().getPrecision());
        EclipseLink2_0JavaEntityTests.assertEquals((int)0, (int)specifiedAttributeOverride.getColumn().getScale());
    }

    public void testNestedVirtualAssociationOverrides() throws Exception {
        this.createTestMappedSuperclassCustomer();
        this.createTestEntityLongTimeCustomer();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableZipCode();
        this.addXmlClassRef("test.Customer");
        this.addXmlClassRef("test.LongTimeCustomer");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.ZipCode");
        ListIterator specifiedClassRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        specifiedClassRefs.next();
        JavaPersistentType longTimeCustomerPersistentType = ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        AssociationOverrideContainer attributeOverrideContainer = ((Entity)longTimeCustomerPersistentType.getMapping()).getAssociationOverrideContainer();
        EclipseLink2_0JavaEntityTests.assertEquals((int)1, (int)attributeOverrideContainer.getVirtualOverridesSize());
        ListIterator virtualAssociationOverrides = attributeOverrideContainer.getVirtualOverrides().iterator();
        VirtualAssociationOverride virtualAssociationOverride = (VirtualAssociationOverride)virtualAssociationOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address.state", (String)virtualAssociationOverride.getName());
    }

    public void testNestedVirtualAssociationOverridesElementCollection() throws Exception {
        this.createTestMappedSuperclassCustomerWithElementCollection();
        this.createTestEntityLongTimeCustomer();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableZipCode();
        this.addXmlClassRef("test.Customer");
        this.addXmlClassRef("test.LongTimeCustomer");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.ZipCode");
        ListIterator specifiedClassRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        specifiedClassRefs.next();
        JavaPersistentType longTimeCustomerPersistentType = ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        AssociationOverrideContainer attributeOverrideContainer = ((Entity)longTimeCustomerPersistentType.getMapping()).getAssociationOverrideContainer();
        EclipseLink2_0JavaEntityTests.assertEquals((int)1, (int)attributeOverrideContainer.getVirtualOverridesSize());
        ListIterator virtualAssociationOverrides = attributeOverrideContainer.getVirtualOverrides().iterator();
        VirtualAssociationOverride virtualAssociationOverride = (VirtualAssociationOverride)virtualAssociationOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address.state", (String)virtualAssociationOverride.getName());
    }

    public void testSetSpecifiedCacheable() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Cacheable2_0 cacheable = ((CacheableReference2_0)this.getJavaEntity()).getCacheable();
        CacheableAnnotation2_0 cacheableAnnotation = (CacheableAnnotation2_0)this.getJavaPersistentType().getJavaResourceType().getAnnotation("javax.persistence.Cacheable");
        EclipseLink2_0JavaEntityTests.assertEquals(null, (Object)cacheable.getSpecifiedCacheable());
        EclipseLink2_0JavaEntityTests.assertEquals(null, (Object)cacheableAnnotation);
        cacheable.setSpecifiedCacheable(Boolean.FALSE);
        cacheableAnnotation = (CacheableAnnotation2_0)this.getJavaPersistentType().getJavaResourceType().getAnnotation("javax.persistence.Cacheable");
        EclipseLink2_0JavaEntityTests.assertEquals((Object)Boolean.FALSE, (Object)cacheable.getSpecifiedCacheable());
        EclipseLink2_0JavaEntityTests.assertEquals((Object)Boolean.FALSE, (Object)cacheableAnnotation.getValue());
        this.assertSourceContains("@Cacheable(false)", cu);
        cacheable.setSpecifiedCacheable(Boolean.TRUE);
        cacheableAnnotation = (CacheableAnnotation2_0)this.getJavaPersistentType().getJavaResourceType().getAnnotation("javax.persistence.Cacheable");
        EclipseLink2_0JavaEntityTests.assertEquals((Object)Boolean.TRUE, (Object)cacheable.getSpecifiedCacheable());
        EclipseLink2_0JavaEntityTests.assertEquals(null, (Object)cacheableAnnotation.getValue());
        this.assertSourceContains("@Cacheable", cu);
        cacheable.setSpecifiedCacheable(null);
        cacheableAnnotation = (CacheableAnnotation2_0)this.getJavaPersistentType().getJavaResourceType().getAnnotation("javax.persistence.Cacheable");
        EclipseLink2_0JavaEntityTests.assertEquals(null, (Object)cacheable.getSpecifiedCacheable());
        EclipseLink2_0JavaEntityTests.assertEquals(null, (Object)cacheableAnnotation);
        this.assertSourceDoesNotContain("@Cacheable", cu);
    }

    public void testGetSpecifiedCacheable() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Cacheable2_0 cacheable = ((CacheableReference2_0)this.getJavaEntity()).getCacheable();
        CacheableAnnotation2_0 cacheableAnnotation = (CacheableAnnotation2_0)this.getJavaPersistentType().getJavaResourceType().getAnnotation("javax.persistence.Cacheable");
        EclipseLink2_0JavaEntityTests.assertEquals(null, (Object)cacheable.getSpecifiedCacheable());
        EclipseLink2_0JavaEntityTests.assertEquals(null, (Object)cacheableAnnotation);
        this.getJavaPersistentType().getJavaResourceType().addAnnotation("javax.persistence.Cacheable");
        this.getJpaProject().synchronizeContextModel();
        cacheableAnnotation = (CacheableAnnotation2_0)this.getJavaPersistentType().getJavaResourceType().getAnnotation("javax.persistence.Cacheable");
        EclipseLink2_0JavaEntityTests.assertEquals((Object)Boolean.TRUE, (Object)cacheable.getSpecifiedCacheable());
        EclipseLink2_0JavaEntityTests.assertEquals(null, (Object)cacheableAnnotation.getValue());
        this.assertSourceContains("@Cacheable", cu);
        cacheableAnnotation.setValue(Boolean.FALSE);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaEntityTests.assertEquals((Object)Boolean.FALSE, (Object)cacheable.getSpecifiedCacheable());
        EclipseLink2_0JavaEntityTests.assertEquals((Object)Boolean.FALSE, (Object)cacheableAnnotation.getValue());
        this.assertSourceContains("@Cacheable(false)", cu);
        cacheableAnnotation.setValue(Boolean.TRUE);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaEntityTests.assertEquals((Object)Boolean.TRUE, (Object)cacheable.getSpecifiedCacheable());
        EclipseLink2_0JavaEntityTests.assertEquals((Object)Boolean.TRUE, (Object)cacheableAnnotation.getValue());
        this.assertSourceContains("@Cacheable(true)", cu);
        cacheableAnnotation.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaEntityTests.assertEquals((Object)Boolean.TRUE, (Object)cacheable.getSpecifiedCacheable());
        EclipseLink2_0JavaEntityTests.assertEquals(null, (Object)cacheableAnnotation.getValue());
        this.assertSourceContains("@Cacheable", cu);
        this.getJavaPersistentType().getJavaResourceType().removeAnnotation("javax.persistence.Cacheable");
        cacheableAnnotation = (CacheableAnnotation2_0)this.getJavaPersistentType().getJavaResourceType().getAnnotation("javax.persistence.Cacheable");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaEntityTests.assertEquals(null, (Object)cacheable.getSpecifiedCacheable());
        EclipseLink2_0JavaEntityTests.assertEquals(null, (Object)cacheableAnnotation);
        this.assertSourceDoesNotContain("@Cacheable", cu);
    }

    public void testIsDefaultCacheable() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Cacheable2_0 cacheable = ((CacheableReference2_0)this.getJavaEntity()).getCacheable();
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        EclipseLink2_0JavaEntityTests.assertEquals((Object)SharedCacheMode2_0.DISABLE_SELECTIVE, (Object)persistenceUnit.getSharedCacheMode());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)cacheable.isDefaultCacheable());
        persistenceUnit.setSpecifiedSharedCacheMode(SharedCacheMode2_0.ALL);
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)cacheable.isDefaultCacheable());
        persistenceUnit.setSpecifiedSharedCacheMode(SharedCacheMode2_0.NONE);
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)cacheable.isDefaultCacheable());
        persistenceUnit.setSpecifiedSharedCacheMode(SharedCacheMode2_0.ENABLE_SELECTIVE);
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)cacheable.isDefaultCacheable());
        persistenceUnit.setSpecifiedSharedCacheMode(SharedCacheMode2_0.DISABLE_SELECTIVE);
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)cacheable.isDefaultCacheable());
        persistenceUnit.setSpecifiedSharedCacheMode(SharedCacheMode2_0.UNSPECIFIED);
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)cacheable.isDefaultCacheable());
    }

    public void testInheritedIsDefaultCacheable() throws Exception {
        this.createTestEntity();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        Cacheable2_0 subCacheable = ((CacheableReference2_0)this.getJavaEntity()).getCacheable();
        Cacheable2_0 cacheable = ((CacheableReference2_0)this.getJavaEntity().getParentEntity()).getCacheable();
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)subCacheable.isDefaultCacheable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)cacheable.isDefaultCacheable());
        EclipseLinkPersistenceUnit persistenceUnit2_0 = this.getPersistenceUnit();
        persistenceUnit2_0.setSpecifiedSharedCacheMode(SharedCacheMode2_0.NONE);
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)subCacheable.isDefaultCacheable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)cacheable.isDefaultCacheable());
        persistenceUnit2_0.setSpecifiedSharedCacheMode(null);
        cacheable.setSpecifiedCacheable(Boolean.FALSE);
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)subCacheable.isDefaultCacheable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)cacheable.isDefaultCacheable());
        persistenceUnit2_0.setSpecifiedSharedCacheMode(SharedCacheMode2_0.DISABLE_SELECTIVE);
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)subCacheable.isDefaultCacheable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)cacheable.isDefaultCacheable());
        cacheable.setSpecifiedCacheable(Boolean.FALSE);
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)subCacheable.isDefaultCacheable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)cacheable.isDefaultCacheable());
        persistenceUnit2_0.setSpecifiedSharedCacheMode(SharedCacheMode2_0.ENABLE_SELECTIVE);
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)subCacheable.isDefaultCacheable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)cacheable.isDefaultCacheable());
        cacheable.setSpecifiedCacheable(Boolean.TRUE);
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)subCacheable.isDefaultCacheable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)cacheable.isDefaultCacheable());
        persistenceUnit2_0.setSpecifiedSharedCacheMode(SharedCacheMode2_0.NONE);
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)subCacheable.isDefaultCacheable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)cacheable.isDefaultCacheable());
    }
}

