/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.context.BaseTemporalConverter;
import org.eclipse.jpt.jpa.core.context.SpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.TemporalType;
import org.eclipse.jpt.jpa.core.context.VersionMapping;
import org.eclipse.jpt.jpa.core.resource.java.TemporalAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConvert;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkMutable;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkVersionMapping;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.ConvertAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.MutableAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLinkContextModelTestCase;

public class EclipseLinkJavaVersionMappingTests
extends EclipseLinkContextModelTestCase {
    private ICompilationUnit createTestEntityWithVersionMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Version"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Version").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithConvert() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Version", "org.eclipse.persistence.annotations.Convert"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Version").append(CR);
                sb.append("@Convert(\"class-instance\")").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithMutableVersion() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Version", "org.eclipse.persistence.annotations.Mutable"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Version").append(CR);
                sb.append("@Mutable").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithMutableVersionDate() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Version", "org.eclipse.persistence.annotations.Mutable", "java.util.Date"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Version").append(CR);
                sb.append("    @Mutable").append(CR);
                sb.append("    private Date myDate;").append(CR);
                sb.append(CR);
                sb.append("    ");
            }
        });
    }

    public EclipseLinkJavaVersionMappingTests(String name) {
        super(name);
    }

    public void testGetConvert() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation("org.eclipse.persistence.annotations.Convert");
        this.getJpaProject().synchronizeContextModel();
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getMapping();
        EclipseLinkJavaVersionMappingTests.assertEquals(EclipseLinkConvert.class, (Object)versionMapping.getConverter().getType());
    }

    public void testGetConvert2() throws Exception {
        this.createTestEntityWithConvert();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getMapping();
        EclipseLinkJavaVersionMappingTests.assertEquals(EclipseLinkConvert.class, (Object)versionMapping.getConverter().getType());
        EclipseLinkJavaVersionMappingTests.assertEquals((String)"class-instance", (String)((EclipseLinkConvert)versionMapping.getConverter()).getConverterName());
    }

    public void testSetConvert() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getMapping();
        EclipseLinkJavaVersionMappingTests.assertNull((Object)versionMapping.getConverter().getType());
        versionMapping.setConverter(BaseTemporalConverter.class);
        ((BaseTemporalConverter)versionMapping.getConverter()).setTemporalType(TemporalType.TIME);
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        TemporalAnnotation temporal = (TemporalAnnotation)resourceField.getAnnotation("javax.persistence.Temporal");
        EclipseLinkJavaVersionMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.java.TemporalType.TIME, (Object)temporal.getValue());
        versionMapping.setConverter(null);
        EclipseLinkJavaVersionMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
    }

    public void testGetConvertUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getMapping();
        EclipseLinkJavaVersionMappingTests.assertNull((Object)versionMapping.getConverter().getType());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ConvertAnnotation convert = (ConvertAnnotation)resourceField.addAnnotation("org.eclipse.persistence.annotations.Convert");
        convert.setValue("foo");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaVersionMappingTests.assertEquals(EclipseLinkConvert.class, (Object)versionMapping.getConverter().getType());
        EclipseLinkJavaVersionMappingTests.assertEquals((String)"foo", (String)((EclipseLinkConvert)versionMapping.getConverter()).getConverterName());
        resourceField.removeAnnotation("org.eclipse.persistence.annotations.Convert");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaVersionMappingTests.assertNull((Object)versionMapping.getConverter().getType());
        EclipseLinkJavaVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        EclipseLinkJavaVersionMappingTests.assertSame((Object)versionMapping, (Object)persistentAttribute.getMapping());
    }

    public void testGetSpecifiedMutable() throws Exception {
        this.createTestEntityWithMutableVersion();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EclipseLinkVersionMapping versionMapping = (EclipseLinkVersionMapping)persistentAttribute.getMapping();
        EclipseLinkMutable mutable = versionMapping.getMutable();
        EclipseLinkJavaVersionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mutable.getSpecifiedMutable());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        MutableAnnotation mutableAnnotation = (MutableAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.Mutable");
        mutableAnnotation.setValue(Boolean.TRUE);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaVersionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mutable.getSpecifiedMutable());
        mutableAnnotation.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaVersionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mutable.getSpecifiedMutable());
        mutableAnnotation.setValue(Boolean.FALSE);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaVersionMappingTests.assertEquals((Object)Boolean.FALSE, (Object)mutable.getSpecifiedMutable());
        resourceField.removeAnnotation("org.eclipse.persistence.annotations.Mutable");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaVersionMappingTests.assertEquals(null, (Object)mutable.getSpecifiedMutable());
        resourceField.addAnnotation("org.eclipse.persistence.annotations.Mutable");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaVersionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mutable.getSpecifiedMutable());
    }

    public void testSetSpecifiedMutable() throws Exception {
        this.createTestEntityWithMutableVersion();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EclipseLinkVersionMapping versionMapping = (EclipseLinkVersionMapping)persistentAttribute.getMapping();
        EclipseLinkMutable mutable = versionMapping.getMutable();
        EclipseLinkJavaVersionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mutable.getSpecifiedMutable());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        MutableAnnotation mutableAnnotation = (MutableAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaVersionMappingTests.assertEquals(null, (Object)mutableAnnotation.getValue());
        mutable.setSpecifiedMutable(Boolean.TRUE);
        EclipseLinkJavaVersionMappingTests.assertEquals(null, (Object)mutableAnnotation.getValue());
        mutable.setSpecifiedMutable(null);
        mutableAnnotation = (MutableAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaVersionMappingTests.assertEquals(null, (Object)mutableAnnotation);
        mutable.setSpecifiedMutable(Boolean.FALSE);
        mutableAnnotation = (MutableAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaVersionMappingTests.assertEquals((Object)Boolean.FALSE, (Object)mutableAnnotation.getValue());
        mutable.setSpecifiedMutable(Boolean.TRUE);
        EclipseLinkJavaVersionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mutableAnnotation.getValue());
    }

    public void testIsDefaultMutable() throws Exception {
        this.createTestEntityWithMutableVersion();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EclipseLinkVersionMapping versionMapping = (EclipseLinkVersionMapping)persistentAttribute.getMapping();
        EclipseLinkMutable mutable = versionMapping.getMutable();
        EclipseLinkJavaVersionMappingTests.assertTrue((boolean)mutable.isDefaultMutable());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.removeAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaVersionMappingTests.assertTrue((boolean)mutable.isDefaultMutable());
        mutable.setSpecifiedMutable(Boolean.FALSE);
        EclipseLinkJavaVersionMappingTests.assertTrue((boolean)mutable.isDefaultMutable());
        this.getPersistenceUnit().getEclipseLinkOptions().setTemporalMutable(Boolean.FALSE);
        EclipseLinkJavaVersionMappingTests.assertTrue((boolean)mutable.isDefaultMutable());
    }

    public void testIsDefaultMutableForDate() throws Exception {
        this.createTestEntityWithMutableVersionDate();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EclipseLinkVersionMapping versionMapping = (EclipseLinkVersionMapping)persistentAttribute.getMapping();
        EclipseLinkMutable mutable = versionMapping.getMutable();
        EclipseLinkJavaVersionMappingTests.assertFalse((boolean)mutable.isDefaultMutable());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.removeAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaVersionMappingTests.assertFalse((boolean)mutable.isDefaultMutable());
        mutable.setSpecifiedMutable(Boolean.TRUE);
        EclipseLinkJavaVersionMappingTests.assertFalse((boolean)mutable.isDefaultMutable());
        this.getPersistenceUnit().getEclipseLinkOptions().setTemporalMutable(Boolean.TRUE);
        EclipseLinkJavaVersionMappingTests.assertTrue((boolean)mutable.isDefaultMutable());
        this.getPersistenceUnit().getEclipseLinkOptions().setTemporalMutable(Boolean.FALSE);
        EclipseLinkJavaVersionMappingTests.assertFalse((boolean)mutable.isDefaultMutable());
        this.getPersistenceUnit().getEclipseLinkOptions().setTemporalMutable(null);
        EclipseLinkJavaVersionMappingTests.assertFalse((boolean)mutable.isDefaultMutable());
    }

    public void testIsMutable() throws Exception {
        this.createTestEntityWithMutableVersion();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EclipseLinkVersionMapping versionMapping = (EclipseLinkVersionMapping)persistentAttribute.getMapping();
        EclipseLinkMutable mutable = versionMapping.getMutable();
        EclipseLinkJavaVersionMappingTests.assertTrue((boolean)mutable.isMutable());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.removeAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaVersionMappingTests.assertTrue((boolean)mutable.isMutable());
        mutable.setSpecifiedMutable(Boolean.TRUE);
        EclipseLinkJavaVersionMappingTests.assertTrue((boolean)mutable.isMutable());
    }
}

