/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.java.GenericJavaNullAttributeMapping;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.EclipseLinkOrmIdMapping;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.EclipseLinkOrmOneToOneMapping;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLinkContextModelTestCase;

public class EclipseLinkOrmPersistentAttributeTests
extends EclipseLinkContextModelTestCase {
    public EclipseLinkOrmPersistentAttributeTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    private ICompilationUnit createTestTypeNullAttributeMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityIdMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.Column"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
                sb.append("@Column(name=\"FOO\")");
            }
        });
    }

    private ICompilationUnit createTestEntityOneToOneMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne");
                sb.append("    private Address address;");
            }
        });
    }

    public void testMakeSpecified() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLinkOrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.getDefaultAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next();
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        EclipseLinkOrmPersistentAttributeTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        ormPersistentAttribute.addToXml();
        EclipseLinkOrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.getDefaultAttributesSize());
        EclipseLinkOrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmSpecifiedPersistentAttribute specifiedOrmPersistentAttribute = (OrmSpecifiedPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next();
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"id", (String)specifiedOrmPersistentAttribute.getName());
        EclipseLinkOrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next();
        ormPersistentAttribute.addToXml();
        EclipseLinkOrmPersistentAttributeTests.assertEquals((int)0, (int)ormPersistentType.getDefaultAttributesSize());
        EclipseLinkOrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.getSpecifiedAttributesSize());
        ListIterator specifiedAttributes = ormPersistentType.getSpecifiedAttributes().iterator();
        specifiedOrmPersistentAttribute = (OrmSpecifiedPersistentAttribute)specifiedAttributes.next();
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"id", (String)specifiedOrmPersistentAttribute.getName());
        EclipseLinkOrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        specifiedOrmPersistentAttribute = (OrmSpecifiedPersistentAttribute)specifiedAttributes.next();
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"name", (String)specifiedOrmPersistentAttribute.getName());
        EclipseLinkOrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
    }

    public void testMakeSpecifiedMappingKey() throws Exception {
        this.createTestTypeNullAttributeMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLinkOrmPersistentAttributeTests.assertEquals((int)3, (int)ormPersistentType.getDefaultAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next();
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"address", (String)ormPersistentAttribute.getName());
        EclipseLinkOrmPersistentAttributeTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        EclipseLinkOrmPersistentAttributeTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof GenericJavaNullAttributeMapping));
        ormPersistentAttribute.addToXml("oneToOne");
        EclipseLinkOrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.getDefaultAttributesSize());
        EclipseLinkOrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmSpecifiedPersistentAttribute specifiedOrmPersistentAttribute = (OrmSpecifiedPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next();
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"address", (String)specifiedOrmPersistentAttribute.getName());
        EclipseLinkOrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)specifiedOrmPersistentAttribute.getMappingKey(), (String)"oneToOne");
        EclipseLinkOrmPersistentAttributeTests.assertTrue((boolean)(specifiedOrmPersistentAttribute.getMapping() instanceof EclipseLinkOrmOneToOneMapping));
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next();
        ormPersistentAttribute.addToXml("id");
        EclipseLinkOrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.getDefaultAttributesSize());
        EclipseLinkOrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.getSpecifiedAttributesSize());
        ListIterator specifiedAttributes = ormPersistentType.getSpecifiedAttributes().iterator();
        specifiedOrmPersistentAttribute = (OrmSpecifiedPersistentAttribute)specifiedAttributes.next();
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"id", (String)specifiedOrmPersistentAttribute.getName());
        EclipseLinkOrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        EclipseLinkOrmPersistentAttributeTests.assertTrue((boolean)(specifiedOrmPersistentAttribute.getMapping() instanceof EclipseLinkOrmIdMapping));
        specifiedOrmPersistentAttribute = (OrmSpecifiedPersistentAttribute)specifiedAttributes.next();
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"address", (String)specifiedOrmPersistentAttribute.getName());
        EclipseLinkOrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
    }

    public void testMakeVirtual() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLinkOrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.getDefaultAttributesSize());
        ((OrmPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next()).addToXml();
        ((OrmPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next()).addToXml();
        EclipseLinkOrmPersistentAttributeTests.assertEquals((int)0, (int)ormPersistentType.getDefaultAttributesSize());
        EclipseLinkOrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmSpecifiedPersistentAttribute specifiedOrmPersistentAttribute = (OrmSpecifiedPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next();
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"id", (String)specifiedOrmPersistentAttribute.getName());
        EclipseLinkOrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        specifiedOrmPersistentAttribute.removeFromXml();
        EclipseLinkOrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.getDefaultAttributesSize());
        EclipseLinkOrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        specifiedOrmPersistentAttribute = (OrmSpecifiedPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next();
        specifiedOrmPersistentAttribute.removeFromXml();
        EclipseLinkOrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.getDefaultAttributesSize());
        EclipseLinkOrmPersistentAttributeTests.assertEquals((int)0, (int)ormPersistentType.getSpecifiedAttributesSize());
        ListIterator virtualAttributes = ormPersistentType.getDefaultAttributes().iterator();
        OrmPersistentAttribute virtualAttribute = (OrmPersistentAttribute)virtualAttributes.next();
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"id", (String)virtualAttribute.getName());
        virtualAttribute = (OrmPersistentAttribute)virtualAttributes.next();
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"name", (String)virtualAttribute.getName());
    }

    public void testMakeVirtualNoUnderlyingJavaAttribute() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLinkOrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.getDefaultAttributesSize());
        ((OrmPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next()).addToXml();
        ((OrmPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next()).addToXml();
        ((OrmSpecifiedPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next()).getMapping().setName("noJavaAttribute");
        EclipseLinkOrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.getDefaultAttributesSize());
        EclipseLinkOrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmSpecifiedPersistentAttribute specifiedOrmPersistentAttribute = (OrmSpecifiedPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next();
        specifiedOrmPersistentAttribute.removeFromXml();
        EclipseLinkOrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.getDefaultAttributesSize());
        EclipseLinkOrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"id", (String)((OrmPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next()).getName());
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"name", (String)((OrmSpecifiedPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next()).getName());
    }

    public void testVirtualMappingTypeWhenMetadataComplete() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next();
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMappingKey());
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"FOO", (String)((IdMapping)ormPersistentAttribute.getMapping()).getColumn().getName());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMappingKey());
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"id", (String)((BasicMapping)ormPersistentAttribute.getMapping()).getColumn().getName());
    }

    public void testVirtualMappingTypeWhenMetadataComplete2() throws Exception {
        this.createTestEntityOneToOneMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next();
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"address", (String)ormPersistentAttribute.getName());
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"oneToOne", (String)ormPersistentAttribute.getMappingKey());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"address", (String)ormPersistentAttribute.getName());
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY, (String)ormPersistentAttribute.getMappingKey());
    }

    public void testGetJavaPersistentAttribute() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        JavaSpecifiedPersistentAttribute javaPersistentAttribute = javaPersistentType.getAttributeNamed("id");
        EclipseLinkOrmPersistentAttributeTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        EclipseLinkOrmPersistentAttributeTests.assertNotSame((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        JavaResourceAttribute javaResourceAttribute = ormPersistentAttribute.getJavaPersistentAttribute().getResourceAttribute();
        EclipseLinkOrmPersistentAttributeTests.assertTrue((javaResourceAttribute.getAstNodeType() == JavaResourceAnnotatedElement.AstNodeType.FIELD ? 1 : 0) != 0);
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"id", (String)javaResourceAttribute.getName());
        EclipseLinkOrmPersistentAttributeTests.assertEquals(javaPersistentType.getJavaResourceType().getFields().iterator().next(), (Object)javaResourceAttribute);
        ormPersistentAttribute.addToXml();
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        EclipseLinkOrmPersistentAttributeTests.assertFalse((boolean)ormPersistentAttribute.isVirtual());
        EclipseLinkOrmPersistentAttributeTests.assertEquals((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        ((OrmSpecifiedPersistentAttribute)ormPersistentAttribute).removeFromXml();
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        ormPersistentType.setSpecifiedAccess(AccessType.PROPERTY);
        ListIterator attributes = ormPersistentType.getAttributes().iterator();
        OrmPersistentAttribute idFieldAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentAttribute idPropertyAttribute = (OrmPersistentAttribute)attributes.next();
        EclipseLinkOrmPersistentAttributeTests.assertEquals((Object)ormPersistentAttribute, (Object)idFieldAttribute);
        EclipseLinkOrmPersistentAttributeTests.assertNotSame((Object)ormPersistentAttribute, (Object)idPropertyAttribute);
        ormPersistentAttribute = idPropertyAttribute;
        EclipseLinkOrmPersistentAttributeTests.assertNotSame((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        EclipseLinkOrmPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentAttribute.getAccess());
        EclipseLinkOrmPersistentAttributeTests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentAttribute.getJavaPersistentAttribute().getAccess());
        EclipseLinkOrmPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)idFieldAttribute.getJavaPersistentAttribute().getAccess());
        javaResourceAttribute = ormPersistentAttribute.getJavaPersistentAttribute().getResourceAttribute();
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"id", (String)javaResourceAttribute.getName());
        EclipseLinkOrmPersistentAttributeTests.assertEquals(javaPersistentType.getJavaResourceType().getMethods().iterator().next(), (Object)javaResourceAttribute);
        ormPersistentType.setSpecifiedAccess(null);
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute2 = ormPersistentAttribute.addToXml();
        ormPersistentAttribute2.getMapping().setName("id2");
        EclipseLinkOrmPersistentAttributeTests.assertEquals(null, (Object)ormPersistentAttribute2.getJavaPersistentAttribute());
        ormPersistentAttribute2.getMapping().setName(null);
        EclipseLinkOrmPersistentAttributeTests.assertEquals(null, (Object)ormPersistentAttribute2.getJavaPersistentAttribute());
        ormPersistentAttribute2.getMapping().setName("id");
        EclipseLinkOrmPersistentAttributeTests.assertEquals((Object)javaPersistentAttribute, (Object)ormPersistentAttribute2.getJavaPersistentAttribute());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        EclipseLinkOrmPersistentAttributeTests.assertEquals((Object)javaPersistentAttribute, (Object)ormPersistentAttribute2.getJavaPersistentAttribute());
    }
}

