/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxb.core.tests;

import javax.xml.bind.annotation.XmlSchema;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jst.ws.annotations.core.AnnotationsCore;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.jaxb.core.tests.AbstractAnnotationTest;
import org.eclipse.ltk.core.refactoring.Change;

public class RemoveAnnotationFromPackageTest
extends AbstractAnnotationTest {
    public String getPackageName() {
        return "com.example";
    }

    public String getClassName() {
        return "package-info.java";
    }

    public String getClassContents() {
        StringBuilder classContents = new StringBuilder("@XmlSchema\n\n");
        classContents.append("package com.example;\n\n");
        classContents.append("import javax.xml.bind.annotation.XmlSchema;\n\n");
        return classContents.toString();
    }

    public Annotation getAnnotation() {
        return AnnotationsCore.createNormalAnnotation((AST)this.ast, (String)XmlSchema.class.getSimpleName(), null);
    }

    public void testRemoveAnnotationFromPackage() {
        try {
            RemoveAnnotationFromPackageTest.assertNotNull((Object)this.annotation);
            RemoveAnnotationFromPackageTest.assertEquals((String)XmlSchema.class.getSimpleName(), (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation));
            IPackageDeclaration myPackage = this.source.getPackageDeclaration(this.getPackageName());
            RemoveAnnotationFromPackageTest.assertNotNull((Object)myPackage);
            RemoveAnnotationFromPackageTest.assertTrue((boolean)AnnotationUtils.isAnnotationPresent((IJavaElement)myPackage, (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation)));
            this.textFileChange.addEdit(AnnotationUtils.createRemoveAnnotationTextEdit((IJavaElement)myPackage, (Annotation)this.annotation));
            this.textFileChange.addEdit(AnnotationUtils.createRemoveImportTextEdit((IJavaElement)myPackage, (String)XmlSchema.class.getCanonicalName()));
            RemoveAnnotationFromPackageTest.assertTrue((boolean)this.executeChange((IProgressMonitor)new NullProgressMonitor(), (Change)this.textFileChange));
            RemoveAnnotationFromPackageTest.assertFalse((boolean)AnnotationUtils.isAnnotationPresent((IJavaElement)myPackage, (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation)));
            RemoveAnnotationFromPackageTest.assertFalse((boolean)this.source.getImport(XmlSchema.class.getCanonicalName()).exists());
        }
        catch (CoreException ce) {
            RemoveAnnotationFromPackageTest.fail((String)ce.getLocalizedMessage());
        }
    }
}

