/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.regression;

import org.eclipse.wst.jsdt.core.tests.compiler.regression.ASTBinaryExpressionCollector;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.ASTCollector;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.wst.jsdt.core.tests.util.Util;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.CompilationResult;
import org.eclipse.wst.jsdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.wst.jsdt.internal.compiler.IProblemFactory;
import org.eclipse.wst.jsdt.internal.compiler.ast.BinaryExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.CombinedBinaryExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.StringLiteral;
import org.eclipse.wst.jsdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.parser.Parser;
import org.eclipse.wst.jsdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.wst.jsdt.internal.compiler.problem.ProblemReporter;

public class ASTImplTests
extends AbstractRegressionTest {
    static Parser defaultParser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(), (IProblemFactory)new DefaultProblemFactory()), false);
    static /* synthetic */ Class class$0;

    public ASTImplTests(String name) {
        super(name);
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.compiler.regression.ASTImplTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void runConformTest(String fileName, String fileContents, Parser parser, ASTCollector visitor, String expected) {
        CompilationUnit source = new CompilationUnit(fileContents.toCharArray(), fileName, null);
        CompilationResult compilationResult = new CompilationResult((ICompilationUnit)source, 1, 1, 10);
        CompilationUnitDeclaration unit = parser.parse((ICompilationUnit)source, compilationResult);
        ASTImplTests.assertEquals((int)0, (int)compilationResult.problemCount);
        unit.traverse((ASTVisitor)visitor, unit.scope);
        String result = visitor.result();
        if (!expected.equals(result)) {
            System.out.println(String.valueOf(this.getClass().getName()) + '#' + this.getName());
            System.out.println("Expected:");
            System.out.println(expected);
            System.out.println("But was:");
            System.out.println(result);
            System.out.println("Cut and paste:");
            System.out.println(Util.displayString(result, INDENT, SHIFT));
        }
        ASTImplTests.assertEquals(expected, result);
    }

    public void test0001_regular_binary_expression() {
        this.runConformTest("X.js", "  function foo() {\n    var s1 = \"s1\";\n    var s2 = \"s2\";\n    var s3 = \"s3\";\n    var s4 = \"s4\";\n    println(s1 + \"l1\" + s2 + \"l2\" +\n      s3 + \"l3\" + s4);\n  }\n\n", defaultParser, new ASTBinaryExpressionCollector(), "[v SL \"s1\"]\n[ev SL \"s1\"]\n[v SL \"s2\"]\n[ev SL \"s2\"]\n[v SL \"s3\"]\n[ev SL \"s3\"]\n[v SL \"s4\"]\n[ev SL \"s4\"]\n[v BE ((((((s1 + \"l1\") + s...) + s4)]\n[v BE (((((s1 + \"l1\") + s2...+ \"l3\")]\n[v BE ((((s1 + \"l1\") + s2)...) + s3)]\n[v BE (((s1 + \"l1\") + s2) + \"l2\")]\n[v BE ((s1 + \"l1\") + s2)]\n[v BE (s1 + \"l1\")]\n[v SNR s1]\n[ev SNR s1]\n[v SL \"l1\"]\n[ev SL \"l1\"]\n[ev BE (s1 + \"l1\")]\n[v SNR s2]\n[ev SNR s2]\n[ev BE ((s1 + \"l1\") + s2)]\n[v SL \"l2\"]\n[ev SL \"l2\"]\n[ev BE (((s1 + \"l1\") + s2) + \"l2\")]\n[v SNR s3]\n[ev SNR s3]\n[ev BE ((((s1 + \"l1\") + s2)...) + s3)]\n[v SL \"l3\"]\n[ev SL \"l3\"]\n[ev BE (((((s1 + \"l1\") + s2...+ \"l3\")]\n[v SNR s4]\n[ev SNR s4]\n[ev BE ((((((s1 + \"l1\") + s...) + s4)]\n");
    }

    public void test0002_combined_binary_expression() {
        CombinedBinaryExpression.defaultArityMaxStartingValue = 3;
        this.runConformTest("X.js", "  function foo() {\n    var s1 = \"s1\";\n    var s2 = \"s2\";\n    var s3 = \"s3\";\n    var s4 = \"s4\";\n    println(s1 + \"l1\" + s2 + \"l2\" +\n      s3 + \"l3\" + s4);\n  }\n\n", defaultParser, new ASTBinaryExpressionCollector(){

            public void endVisit(BinaryExpression binaryExpression, BlockScope scope) {
                if (binaryExpression instanceof CombinedBinaryExpression && ((CombinedBinaryExpression)binaryExpression).referencesTable != null) {
                    this.collector.append("[ev CBE " + this.cut(binaryExpression.toString()) + "]\n");
                } else {
                    super.endVisit(binaryExpression, scope);
                }
            }
        }, "[v SL \"s1\"]\n[ev SL \"s1\"]\n[v SL \"s2\"]\n[ev SL \"s2\"]\n[v SL \"s3\"]\n[ev SL \"s3\"]\n[v SL \"s4\"]\n[ev SL \"s4\"]\n[v BE ((((((s1 + \"l1\") + s...) + s4)]\n[v BE (((((s1 + \"l1\") + s2...+ \"l3\")]\n[v BE ((((s1 + \"l1\") + s2)...) + s3)]\n[v BE (((s1 + \"l1\") + s2) + \"l2\")]\n[v BE ((s1 + \"l1\") + s2)]\n[v BE (s1 + \"l1\")]\n[v SNR s1]\n[ev SNR s1]\n[v SL \"l1\"]\n[ev SL \"l1\"]\n[ev BE (s1 + \"l1\")]\n[v SNR s2]\n[ev SNR s2]\n[ev BE ((s1 + \"l1\") + s2)]\n[v SL \"l2\"]\n[ev SL \"l2\"]\n[ev BE (((s1 + \"l1\") + s2) + \"l2\")]\n[v SNR s3]\n[ev SNR s3]\n[ev CBE ((((s1 + \"l1\") + s2)...) + s3)]\n[v SL \"l3\"]\n[ev SL \"l3\"]\n[ev BE (((((s1 + \"l1\") + s2...+ \"l3\")]\n[v SNR s4]\n[ev SNR s4]\n[ev BE ((((((s1 + \"l1\") + s...) + s4)]\n");
        CombinedBinaryExpression.defaultArityMaxStartingValue = 20;
    }

    public void test0003_combined_binary_expression() {
        Parser parser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(), (IProblemFactory)new DefaultProblemFactory()), true);
        CombinedBinaryExpression.defaultArityMaxStartingValue = 2;
        this.runConformTest("X.js", "  function foo() {\n    var s1 = \"s1\";\n    var s2 = \"s2\";\n    var s3 = \"s3\";\n    var s4 = \"s4\";\n    println(s1 + \"l1\" + s2 + \"l2\" +\n      s3 + \"l3\" + s4);\n  }\n\n", parser, new ASTBinaryExpressionCollector(){

            public void endVisit(BinaryExpression binaryExpression, BlockScope scope) {
                if (binaryExpression instanceof CombinedBinaryExpression && ((CombinedBinaryExpression)binaryExpression).referencesTable != null) {
                    this.collector.append("[ev CBE " + this.cut(binaryExpression.toString()) + "]\n");
                } else {
                    super.endVisit(binaryExpression, scope);
                }
            }
        }, "[v SL \"s1\"]\n[ev SL \"s1\"]\n[v SL \"s2\"]\n[ev SL \"s2\"]\n[v SL \"s3\"]\n[ev SL \"s3\"]\n[v SL \"s4\"]\n[ev SL \"s4\"]\n[v BE ((((((s1 + \"l1\") + s...) + s4)]\n[v BE (((((s1 + \"l1\") + s2...+ \"l3\")]\n[v BE ((((s1 + \"l1\") + s2)...) + s3)]\n[v BE (((s1 + \"l1\") + s2) + \"l2\")]\n[v BE ((s1 + \"l1\") + s2)]\n[v BE (s1 + \"l1\")]\n[v SNR s1]\n[ev SNR s1]\n[v SL \"l1\"]\n[ev SL \"l1\"]\n[ev BE (s1 + \"l1\")]\n[v SNR s2]\n[ev SNR s2]\n[ev BE ((s1 + \"l1\") + s2)]\n[v SL \"l2\"]\n[ev SL \"l2\"]\n[ev CBE (((s1 + \"l1\") + s2) + \"l2\")]\n[v SNR s3]\n[ev SNR s3]\n[ev BE ((((s1 + \"l1\") + s2)...) + s3)]\n[v SL \"l3\"]\n[ev SL \"l3\"]\n[ev BE (((((s1 + \"l1\") + s2...+ \"l3\")]\n[v SNR s4]\n[ev SNR s4]\n[ev BE ((((((s1 + \"l1\") + s...) + s4)]\n");
        CombinedBinaryExpression.defaultArityMaxStartingValue = 20;
    }

    public void test0004_combined_binary_expression() {
        Parser parser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(), (IProblemFactory)new DefaultProblemFactory()), true);
        this.runConformTest("X.js", "  function foo() {\n    var s1 = \"s1\";\n    println(\"l\" + \"1\" + s1);\n  }\n\n", parser, new ASTBinaryExpressionCollector(), "[v SL \"s1\"]\n[ev SL \"s1\"]\n[v BE (ExtendedStringLiter...} + s1)]\n[v ESL ExtendedStringLiteral{l1}]\n[ev ESL ExtendedStringLiteral{l1}]\n[v SNR s1]\n[ev SNR s1]\n[ev BE (ExtendedStringLiter...} + s1)]\n");
    }

    public void test0005_combined_binary_expression() {
        this.runConformTest("X.js", "  function foo() {\n    var s1 = \"s1\";\n    println(\"l\" + \"1\" + s1);\n  }\n\n", defaultParser, new ASTBinaryExpressionCollector(), "[v SL \"s1\"]\n[ev SL \"s1\"]\n[v BE (StringLiteralConcat...} + s1)]\n[v SLC StringLiteralConcate...\n\"1\"+\n}]\n[v SL \"l\"]\n[ev SL \"l\"]\n[v SL \"1\"]\n[ev SL \"1\"]\n[ev SLC StringLiteralConcate...\n\"1\"+\n}]\n[v SNR s1]\n[ev SNR s1]\n[ev BE (StringLiteralConcat...} + s1)]\n");
    }

    public void test0006_combined_binary_expression() {
        CombinedBinaryExpression.defaultArityMaxStartingValue = 1;
        this.runConformTest("X.js", "  function foo() {\n    var s1 = \"s1\";\n    var s2 = \"s2\";\n    var s3 = \"s3\";\n    var s4 = \"s4\";\n    println(s1 + \"l1\" + s2 + \"l2\" +\n      s3 + s1 + s4);\n  }\n\n", defaultParser, new ASTBinaryExpressionCollector(){

            public boolean visit(BinaryExpression binaryExpression, BlockScope scope) {
                super.visit(binaryExpression, scope);
                return !(binaryExpression.right instanceof StringLiteral);
            }
        }, "[v SL \"s1\"]\n[ev SL \"s1\"]\n[v SL \"s2\"]\n[ev SL \"s2\"]\n[v SL \"s3\"]\n[ev SL \"s3\"]\n[v SL \"s4\"]\n[ev SL \"s4\"]\n[v BE ((((((s1 + \"l1\") + s...) + s4)]\n[v BE (((((s1 + \"l1\") + s2...) + s1)]\n[v BE ((((s1 + \"l1\") + s2)...) + s3)]\n[v BE (((s1 + \"l1\") + s2) + \"l2\")]\n[ev BE (((s1 + \"l1\") + s2) + \"l2\")]\n[v SNR s3]\n[ev SNR s3]\n[ev BE ((((s1 + \"l1\") + s2)...) + s3)]\n[v SNR s1]\n[ev SNR s1]\n[ev BE (((((s1 + \"l1\") + s2...) + s1)]\n[v SNR s4]\n[ev SNR s4]\n[ev BE ((((((s1 + \"l1\") + s...) + s4)]\n");
        CombinedBinaryExpression.defaultArityMaxStartingValue = 20;
    }

    public void test0007_combined_binary_expression() {
        CombinedBinaryExpression.defaultArityMaxStartingValue = 4;
        this.runConformTest("X.js", "  function foo() {\n    var s1 = \"s1\";\n    var s2 = \"s2\";\n    var s3 = \"s3\";\n    var s4 = \"s4\";\n    println(s1 + \"l1\" + s2 + \"l2\" +\n      s3 + \"l3\" + s4);\n  }\n\n", defaultParser, new ASTBinaryExpressionCollector(){

            public boolean visit(BinaryExpression binaryExpression, BlockScope scope) {
                super.visit(binaryExpression, scope);
                return false;
            }
        }, "[v SL \"s1\"]\n[ev SL \"s1\"]\n[v SL \"s2\"]\n[ev SL \"s2\"]\n[v SL \"s3\"]\n[ev SL \"s3\"]\n[v SL \"s4\"]\n[ev SL \"s4\"]\n[v BE ((((((s1 + \"l1\") + s...) + s4)]\n[ev BE ((((((s1 + \"l1\") + s...) + s4)]\n");
        CombinedBinaryExpression.defaultArityMaxStartingValue = 20;
    }

    public void test0008_combined_binary_expression() {
        this.runConformTest("X.js", "  function foo() {\n    var s1 = \"s1\";\n    var s2 = \"s2\";\n    println(s1 + \"l1\" + s2 + \"l2\");\n    println(s1 + s2);\n  }\n\n", defaultParser, new ASTBinaryExpressionCollector(){

            public void endVisit(BinaryExpression binaryExpression, BlockScope scope) {
                if (binaryExpression instanceof CombinedBinaryExpression) {
                    this.collector.append("[ev CBE " + this.cut(binaryExpression.toString()) + "]\n");
                } else {
                    super.endVisit(binaryExpression, scope);
                }
            }
        }, "[v SL \"s1\"]\n[ev SL \"s1\"]\n[v SL \"s2\"]\n[ev SL \"s2\"]\n[v BE (((s1 + \"l1\") + s2) + \"l2\")]\n[v BE ((s1 + \"l1\") + s2)]\n[v BE (s1 + \"l1\")]\n[v SNR s1]\n[ev SNR s1]\n[v SL \"l1\"]\n[ev SL \"l1\"]\n[ev BE (s1 + \"l1\")]\n[v SNR s2]\n[ev SNR s2]\n[ev BE ((s1 + \"l1\") + s2)]\n[v SL \"l2\"]\n[ev SL \"l2\"]\n[ev CBE (((s1 + \"l1\") + s2) + \"l2\")]\n[v BE (s1 + s2)]\n[v SNR s1]\n[ev SNR s1]\n[v SNR s2]\n[ev SNR s2]\n[ev BE (s1 + s2)]\n");
    }

    public void test0009_combined_binary_expression() {
        ASTImplTests.assertEquals((int)20, (int)20);
        this.runConformTest(new String[]{"X.js", "  function main(args) {\n    var max = 30; \n    var s = new Array();\n    for (var i = 0; i < max; i++) {\n        s[i] = \"a\";\n    }\n    foo(s);\n}\n function foo (s) {\n    println(\n        s[0] + s[1] + s[2] + s[3] + s[4] + s[5] + s[6] + \n        s[7] + s[8] + s[9] + s[10] + s[11] + s[12] + s[13] +\n        s[14] + s[15] + s[16] + s[17] + s[18] + s[19] + \n        s[20] + s[21] + s[22] + s[23] + s[24] + s[25] + \n        s[26] + s[27] + s[28] + s[29]\n        );\n}\n"}, "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaa");
    }

    public void test0012_combined_binary_expression() {
        CombinedBinaryExpression.defaultArityMaxStartingValue = 2;
        this.runConformTest("X.js", "  function foo() {\n    var s1 = \"s1\";\n    var s2 = \"s2\";\n    var s3 = \"s3\";\n    var s4 = \"s4\";\n    println(s1 + \"l1\" + s2 + \"l2\" +\n      s3 + s1 + s4);\n  }\n\n", defaultParser, new ASTCollector(){

            public boolean visit(BinaryExpression binaryExpression, BlockScope scope) {
                super.visit(binaryExpression, scope);
                this.collector.append(binaryExpression);
                return true;
            }
        }, "((((((s1 + \"l1\") + s2) + \"l2\") + s3) + s1) + s4)(((((s1 + \"l1\") + s2) + \"l2\") + s3) + s1)((((s1 + \"l1\") + s2) + \"l2\") + s3)(((s1 + \"l1\") + s2) + \"l2\")((s1 + \"l1\") + s2)(s1 + \"l1\")");
        CombinedBinaryExpression.defaultArityMaxStartingValue = 20;
    }

    public void test0016_combined_binary_expression() {
        CombinedBinaryExpression.defaultArityMaxStartingValue = 2;
        this.runConformTest("X.js", "function foo( i1,  i2,  i3,  i4) {\n  println(i1 - i2 + 0 + i3 + 0 + i4);\n}\n\n", defaultParser, new ASTCollector(){

            public boolean visit(BinaryExpression binaryExpression, BlockScope scope) {
                super.visit(binaryExpression, scope);
                this.collector.append(binaryExpression);
                return true;
            }
        }, "(((((i1 - i2) + 0) + i3) + 0) + i4)((((i1 - i2) + 0) + i3) + 0)(((i1 - i2) + 0) + i3)((i1 - i2) + 0)(i1 - i2)");
        CombinedBinaryExpression.defaultArityMaxStartingValue = 20;
    }
}

