/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.test;

import java.util.Comparator;
import org.eclipse.wst.xml.xpath2.api.CollationProvider;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.StaticError;
import org.eclipse.wst.xml.xpath2.processor.XPathParserException;
import org.eclipse.wst.xml.xpath2.processor.test.AbstractPsychoPathTest;

public class TestMinMax
extends AbstractPsychoPathTest {
    private static final String URN_X_ECLIPSE_XPATH20_FUNKY_COLLATOR = "urn:x-eclipse:xpath20:funky-collator";

    public void testEmpty() throws Exception {
        this.assertXPathEvalation("max( () )", "");
        this.assertXPathEvalation("min( () )", "");
    }

    public void testYMDMinMax() throws Exception {
        this.assertXPathEvalation("max( (xs:yearMonthDuration('P0Y1M'), xs:yearMonthDuration('P1Y1M'), xs:yearMonthDuration('P1Y0M')) )", "P1Y1M");
        this.assertXPathEvalation("min( (xs:yearMonthDuration('P0Y1M'), xs:yearMonthDuration('P1Y1M'), xs:yearMonthDuration('P1Y0M')) )", "P1M");
    }

    public void testDTDMax() throws Exception {
        this.assertXPathEvalation("max( (xs:dayTimeDuration('P1DT2H'), xs:dayTimeDuration('P1D'), xs:dayTimeDuration('PT22H')) )", "P1DT2H");
        this.assertXPathEvalation("min( (xs:dayTimeDuration('P1DT2H'), xs:dayTimeDuration('P1D'), xs:dayTimeDuration('PT22H')) )", "PT22H");
    }

    public void testAtomic() throws Exception {
        this.assertXPathEvalation("max( (xs:untypedAtomic('1'), 0.9, xs:untypedAtomic('2.1')) )", "2.1");
        this.assertXPathEvalation("min( (xs:untypedAtomic('1'), 0.9, xs:untypedAtomic('2.1')) )", "0.9");
    }

    public void testMixed() throws Exception {
        this.assertDynamicError("max( ('a', 1.2, 1) )", "FORG0006");
        this.assertDynamicError("min( ('a', 1.2, 1) )", "FORG0006");
        this.assertDynamicError("max( (xs:dayTimeDuration('P1DT2H'), 123) )", "FORG0006");
        this.assertDynamicError("min( (xs:dayTimeDuration('P1DT2H'), 123) )", "FORG0006");
        this.assertDynamicError("max( (xs:untypedAtomic('1'), 1.2, '2.1') )", "FORG0006");
        this.assertDynamicError("min( (xs:untypedAtomic('1'), 1.2, '2.1') )", "FORG0006");
    }

    private void assertXPathEvalation(String xpath, String expectedResult) throws XPathParserException, StaticError, DynamicError {
        this.setupDynamicContext(null);
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        String resultValue = this.buildResultString(rs);
        TestMinMax.assertEquals((String)expectedResult, (String)resultValue);
    }

    private void assertDynamicError(String xpath, String errorCode) throws XPathParserException, StaticError {
        this.setupDynamicContext(null);
        this.compileXPath(xpath);
        try {
            this.evaluate(this.domDoc);
            TestMinMax.fail((String)("Error " + errorCode + " expected here"));
        }
        catch (DynamicError de) {
            TestMinMax.assertEquals((String)"Wrong error code", (String)errorCode, (String)de.code());
        }
        catch (Throwable t) {
            TestMinMax.fail((String)("Unexpected error: " + t.getMessage()));
        }
    }

    public void testStringMax() throws Exception {
        this.setupDynamicContext(null);
        this.setCollationProvider(this.createLengthCollatorProvider());
        String xpath = "max( ('1000', '200', '30', '4') )";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        String resultValue = rs.first().getStringValue();
        TestMinMax.assertEquals((String)"4", (String)resultValue);
        this.setDefaultCollation(URN_X_ECLIPSE_XPATH20_FUNKY_COLLATOR);
        rs = this.evaluate(null);
        resultValue = rs.first().getStringValue();
        TestMinMax.assertEquals((String)"1000", (String)resultValue);
    }

    private CollationProvider createLengthCollatorProvider() {
        final CollationProvider oldProvider = this.getStaticContext().getCollationProvider();
        return new CollationProvider(){

            public Comparator getCollation(String name) {
                if (name.equals(TestMinMax.URN_X_ECLIPSE_XPATH20_FUNKY_COLLATOR)) {
                    return new Comparator(){

                        public int compare(Object o1, Object o2) {
                            return ((String)o1).length() - ((String)o2).length();
                        }
                    };
                }
                return oldProvider.getCollation(name);
            }

            public String getDefaultCollation() {
                return oldProvider.getDefaultCollation();
            }
        };
    }
}

