/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.dom;

import java.lang.reflect.Method;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTMatcher;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ArrayAccess;
import org.eclipse.wst.jsdt.core.dom.ArrayCreation;
import org.eclipse.wst.jsdt.core.dom.ArrayInitializer;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BlockComment;
import org.eclipse.wst.jsdt.core.dom.BooleanLiteral;
import org.eclipse.wst.jsdt.core.dom.BreakStatement;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.CharacterLiteral;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.ConditionalExpression;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.ContinueStatement;
import org.eclipse.wst.jsdt.core.dom.DoStatement;
import org.eclipse.wst.jsdt.core.dom.EmptyStatement;
import org.eclipse.wst.jsdt.core.dom.EnhancedForStatement;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.FunctionRef;
import org.eclipse.wst.jsdt.core.dom.FunctionRefParameter;
import org.eclipse.wst.jsdt.core.dom.IfStatement;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.InfixExpression;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.JSdoc;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.LabeledStatement;
import org.eclipse.wst.jsdt.core.dom.LineComment;
import org.eclipse.wst.jsdt.core.dom.MemberRef;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.NullLiteral;
import org.eclipse.wst.jsdt.core.dom.NumberLiteral;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.core.dom.ParenthesizedExpression;
import org.eclipse.wst.jsdt.core.dom.PostfixExpression;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.QualifiedType;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SuperFieldAccess;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.SwitchCase;
import org.eclipse.wst.jsdt.core.dom.SwitchStatement;
import org.eclipse.wst.jsdt.core.dom.TagElement;
import org.eclipse.wst.jsdt.core.dom.TextElement;
import org.eclipse.wst.jsdt.core.dom.ThisExpression;
import org.eclipse.wst.jsdt.core.dom.ThrowStatement;
import org.eclipse.wst.jsdt.core.dom.TryStatement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.TypeLiteral;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.WhileStatement;
import org.eclipse.wst.jsdt.core.tests.junit.extension.TestCase;

public class ASTMatcherTest
extends TestCase {
    AST ast;
    SimpleName N1;
    SimpleName N2;
    SimpleName N3;
    SimpleName N4;
    Expression E1;
    Expression E2;
    Type T1;
    String T1S;
    Type T2;
    String T2S;
    String PT1S;
    Statement S1;
    Statement S2;
    Block B1;
    SingleVariableDeclaration V1;
    SingleVariableDeclaration V2;
    VariableDeclarationFragment W1;
    VariableDeclarationFragment W2;
    FieldDeclaration FD1;
    FieldDeclaration FD2;
    PackageDeclaration PD1;
    ImportDeclaration ID1;
    ImportDeclaration ID2;
    TypeDeclaration TD1;
    TypeDeclaration TD2;
    AnonymousClassDeclaration ACD1;
    JSdoc JD1;
    JSdoc JD2;
    String JD2S;
    String TP1S;
    String TP2S;
    TagElement TAG1;
    TagElement TAG2;
    TextElement TEXT1;
    MemberRef MBREF1;
    FunctionRef MTHREF1;
    FunctionRefParameter MPARM1;
    LineComment LC1;
    BlockComment BC1;
    Modifier MOD1;
    Modifier MOD2;
    final StringBuffer b = new StringBuffer();
    int API_LEVEL;
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.dom.ASTMatcherTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite suite = new TestSuite(clazz.getName());
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.dom.ASTMatcherTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> c = clazz2;
        Method[] methods = c.getMethods();
        int i = 0;
        int max = methods.length;
        while (i < max) {
            if (methods[i].getName().startsWith("test")) {
                suite.addTest((Test)new ASTMatcherTest(methods[i].getName(), 3));
            }
            ++i;
        }
        return suite;
    }

    public ASTMatcherTest(String name, int apiLevel) {
        super(name);
        this.API_LEVEL = apiLevel;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.ast = AST.newAST((int)this.API_LEVEL);
        this.N1 = this.ast.newSimpleName("N");
        this.N2 = this.ast.newSimpleName("M");
        this.N3 = this.ast.newSimpleName("O");
        this.N4 = this.ast.newSimpleName("P");
        this.E1 = this.ast.newSimpleName("X");
        this.E2 = this.ast.newSimpleName("Y");
        this.T1 = this.ast.newSimpleType((Name)this.ast.newSimpleName("Z"));
        this.T1S = "(tS(nSZZnS)tS)";
        this.T2 = this.ast.newSimpleType((Name)this.ast.newSimpleName("Y"));
        this.T2S = "(tS(nSYYnS)tS)";
        this.S1 = this.ast.newContinueStatement();
        this.S2 = this.ast.newBreakStatement();
        this.B1 = this.ast.newBlock();
        this.V1 = this.ast.newSingleVariableDeclaration();
        this.V1.setType((Type)this.ast.newPrimitiveType(PrimitiveType.INT));
        this.V1.setName(this.ast.newSimpleName("a"));
        this.V2 = this.ast.newSingleVariableDeclaration();
        this.V2.setType((Type)this.ast.newPrimitiveType(PrimitiveType.BYTE));
        this.V2.setName(this.ast.newSimpleName("b"));
        this.W1 = this.ast.newVariableDeclarationFragment();
        this.W1.setName(this.ast.newSimpleName("a"));
        this.W2 = this.ast.newVariableDeclarationFragment();
        this.W2.setName(this.ast.newSimpleName("b"));
        VariableDeclarationFragment temp = this.ast.newVariableDeclarationFragment();
        temp.setName(this.ast.newSimpleName("f"));
        this.FD1 = this.ast.newFieldDeclaration(temp);
        this.FD1.setType((Type)this.ast.newPrimitiveType(PrimitiveType.INT));
        temp = this.ast.newVariableDeclarationFragment();
        temp.setName(this.ast.newSimpleName("g"));
        this.FD2 = this.ast.newFieldDeclaration(temp);
        this.FD2.setType((Type)this.ast.newPrimitiveType(PrimitiveType.CHAR));
        this.PD1 = this.ast.newPackageDeclaration();
        this.PD1.setName((Name)this.ast.newSimpleName("p"));
        this.ID1 = this.ast.newImportDeclaration();
        this.ID1.setName((Name)this.ast.newSimpleName("i"));
        this.ID2 = this.ast.newImportDeclaration();
        this.ID2.setName((Name)this.ast.newSimpleName("j"));
        this.TD1 = this.ast.newTypeDeclaration();
        this.TD1.setName(this.ast.newSimpleName("c"));
        this.TD2 = this.ast.newTypeDeclaration();
        this.TD2.setName(this.ast.newSimpleName("d"));
        this.ACD1 = this.ast.newAnonymousClassDeclaration();
        this.JD1 = this.ast.newJSdoc();
        this.JD2 = this.ast.newJSdoc();
        if (this.ast.apiLevel() == 2) {
            this.JD1.setComment("/**X*/");
            this.JD2.setComment("/**Y*/");
        }
        this.BC1 = this.ast.newBlockComment();
        this.TAG1 = this.ast.newTagElement();
        this.TAG1.setTagName("@foo");
        this.TAG2 = this.ast.newTagElement();
        this.TAG2.setTagName("@bar");
        this.TEXT1 = this.ast.newTextElement();
        this.TEXT1.setText("foo");
        this.MBREF1 = this.ast.newMemberRef();
        this.MBREF1.setName(this.ast.newSimpleName("p"));
        this.MTHREF1 = this.ast.newFunctionRef();
        this.MTHREF1.setName(this.ast.newSimpleName("p"));
        this.MPARM1 = this.ast.newFunctionRefParameter();
        this.MPARM1.setType((Type)this.ast.newPrimitiveType(PrimitiveType.CHAR));
        if (this.ast.apiLevel() >= 3) {
            this.PT1S = "[(tM[(tS[(nSZZnS)]tS)]tM)]";
            this.TP1S = "[(tTP[(nSxxnS)]tTP)]";
            this.TP2S = "[(tTP[(nSyynS)]tTP)]";
            this.LC1 = this.ast.newLineComment();
            this.MOD1 = this.ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD);
            this.MOD2 = this.ast.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD);
        }
    }

    protected void tearDown() throws Exception {
        this.ast = null;
        super.tearDown();
    }

    public String getName() {
        String name = super.getName();
        switch (this.API_LEVEL) {
            case 2: {
                name = "JLS2 - " + name;
                break;
            }
            case 3: {
                name = "JLS3 - " + name;
            }
        }
        return name;
    }

    static int nodeCount(ASTNode node, boolean visitDocTags) {
        NodeCounter c = new NodeCounter(visitDocTags);
        node.accept((ASTVisitor)c);
        return c.count;
    }

    void basicMatch(ASTNode node) {
        boolean result;
        Object o1;
        TestMatcher m1;
        TestMatcher[] m = new TestMatcher[]{new TestMatcher(), new TestMatcher(true), new TestMatcher(false)};
        int i = 0;
        while (i < m.length) {
            m1 = m[i];
            o1 = new Object();
            m1.result = true;
            result = node.subtreeMatch((ASTMatcher)m1, o1);
            ASTMatcherTest.assertTrue((m1.matchCalls == 1 ? 1 : 0) != 0);
            ASTMatcherTest.assertTrue((m1.receiverNode == node ? 1 : 0) != 0);
            ASTMatcherTest.assertTrue((m1.otherNode == o1 ? 1 : 0) != 0);
            ASTMatcherTest.assertTrue((boolean)result);
            ++i;
        }
        m = new TestMatcher[]{new TestMatcher(), new TestMatcher(true), new TestMatcher(false)};
        i = 0;
        while (i < m.length) {
            m1 = m[i];
            o1 = new Object();
            m1.result = false;
            result = node.subtreeMatch((ASTMatcher)m1, o1);
            ASTMatcherTest.assertTrue((m1.matchCalls == 1 ? 1 : 0) != 0);
            ASTMatcherTest.assertTrue((m1.receiverNode == node ? 1 : 0) != 0);
            ASTMatcherTest.assertTrue((m1.otherNode == o1 ? 1 : 0) != 0);
            ASTMatcherTest.assertTrue((!result ? 1 : 0) != 0);
            ++i;
        }
        int count = ASTMatcherTest.nodeCount(node, false);
        m1 = new TestMatcher();
        m1.superMatch = true;
        boolean result2 = node.subtreeMatch((ASTMatcher)m1, (Object)node);
        ASTMatcherTest.assertTrue((m1.matchCalls == count ? 1 : 0) != 0);
        ASTMatcherTest.assertTrue((boolean)result2);
        count = ASTMatcherTest.nodeCount(node, false);
        m1 = new TestMatcher(false);
        m1.superMatch = true;
        result2 = node.subtreeMatch((ASTMatcher)m1, (Object)node);
        ASTMatcherTest.assertTrue((m1.matchCalls == count ? 1 : 0) != 0);
        ASTMatcherTest.assertTrue((boolean)result2);
        count = ASTMatcherTest.nodeCount(node, true);
        m1 = new TestMatcher(true);
        m1.superMatch = true;
        result2 = node.subtreeMatch((ASTMatcher)m1, (Object)node);
        ASTMatcherTest.assertTrue((m1.matchCalls == count ? 1 : 0) != 0);
        ASTMatcherTest.assertTrue((boolean)result2);
    }

    public void testSimpleName() {
        Name x1 = this.ast.newName(new String[]{"Z"});
        this.basicMatch((ASTNode)x1);
    }

    public void testQualifiedName() {
        Name x1 = this.ast.newName(new String[]{"X", "Y"});
        this.basicMatch((ASTNode)x1);
    }

    public void testPrimitiveType() {
        PrimitiveType x1 = this.ast.newPrimitiveType(PrimitiveType.CHAR);
        this.basicMatch((ASTNode)x1);
    }

    public void testSimpleType() {
        SimpleType x1 = this.ast.newSimpleType((Name)this.N1);
        this.basicMatch((ASTNode)x1);
    }

    public void testArrayType() {
        PrimitiveType x0 = this.ast.newPrimitiveType(PrimitiveType.CHAR);
        ArrayType x1 = this.ast.newArrayType((Type)x0);
        this.basicMatch((ASTNode)x1);
    }

    public void testQualifiedType() {
        if (this.ast.apiLevel() == 2) {
            return;
        }
        QualifiedType x1 = this.ast.newQualifiedType(this.T1, this.N1);
        this.basicMatch((ASTNode)x1);
    }

    public void testAnonymousClassDeclaration() {
        AnonymousClassDeclaration x1 = this.ast.newAnonymousClassDeclaration();
        x1.bodyDeclarations().add(this.FD1);
        x1.bodyDeclarations().add(this.FD2);
        this.basicMatch((ASTNode)x1);
    }

    public void testArrayAccess() {
        ArrayAccess x1 = this.ast.newArrayAccess();
        x1.setArray(this.E1);
        x1.setIndex(this.E2);
        this.basicMatch((ASTNode)x1);
    }

    public void testArrayCreation() {
        ArrayCreation x1 = this.ast.newArrayCreation();
        x1.setType(this.ast.newArrayType(this.T1));
        x1.dimensions().add(this.E1);
        x1.dimensions().add(this.E2);
        x1.setInitializer(this.ast.newArrayInitializer());
        this.basicMatch((ASTNode)x1);
    }

    public void testArrayInitializer() {
        ArrayInitializer x1 = this.ast.newArrayInitializer();
        x1.expressions().add(this.E1);
        x1.expressions().add(this.E2);
        this.basicMatch((ASTNode)x1);
    }

    public void testAssignment() {
        Assignment x1 = this.ast.newAssignment();
        x1.setLeftHandSide(this.E1);
        x1.setRightHandSide(this.E2);
        this.basicMatch((ASTNode)x1);
    }

    public void testBlock() {
        Block x1 = this.ast.newBlock();
        x1.statements().add(this.S1);
        x1.statements().add(this.S2);
        this.basicMatch((ASTNode)x1);
    }

    public void testBlockComment() {
        BlockComment x1 = this.ast.newBlockComment();
        this.basicMatch((ASTNode)x1);
    }

    public void testBooleanLiteral() {
        BooleanLiteral x1 = this.ast.newBooleanLiteral(true);
        this.basicMatch((ASTNode)x1);
    }

    public void testBreakStatement() {
        BreakStatement x1 = this.ast.newBreakStatement();
        x1.setLabel(this.N1);
        this.basicMatch((ASTNode)x1);
    }

    public void testCatchClause() {
        CatchClause x1 = this.ast.newCatchClause();
        x1.setException(this.V1);
        x1.setBody(this.B1);
        this.basicMatch((ASTNode)x1);
    }

    public void testCharacterLiteral() {
        CharacterLiteral x1 = this.ast.newCharacterLiteral();
        x1.setCharValue('q');
        this.basicMatch((ASTNode)x1);
    }

    public void testClassInstanceCreation() {
        ClassInstanceCreation x1 = this.ast.newClassInstanceCreation();
        x1.setExpression(this.E1);
        if (this.ast.apiLevel() == 2) {
            x1.setName((Name)this.N1);
        } else {
            x1.setType(this.T1);
        }
        x1.setAnonymousClassDeclaration(this.ACD1);
        this.basicMatch((ASTNode)x1);
    }

    public void testConditionalExpression() {
        ConditionalExpression x1 = this.ast.newConditionalExpression();
        x1.setExpression(this.E1);
        x1.setThenExpression(this.E2);
        x1.setElseExpression((Expression)this.N1);
        this.basicMatch((ASTNode)x1);
    }

    public void testConstructorInvocation() {
        ConstructorInvocation x1 = this.ast.newConstructorInvocation();
        x1.arguments().add(this.E1);
        x1.arguments().add(this.E2);
        this.basicMatch((ASTNode)x1);
    }

    public void testContinueStatement() {
        ContinueStatement x1 = this.ast.newContinueStatement();
        x1.setLabel(this.N1);
        this.basicMatch((ASTNode)x1);
    }

    public void testDoStatement() {
        DoStatement x1 = this.ast.newDoStatement();
        x1.setExpression(this.E1);
        x1.setBody(this.S1);
        this.basicMatch((ASTNode)x1);
    }

    public void testEmptyStatement() {
        EmptyStatement x1 = this.ast.newEmptyStatement();
        this.basicMatch((ASTNode)x1);
    }

    public void testEnhancedForStatement() {
        if (this.ast.apiLevel() == 2) {
            return;
        }
        EnhancedForStatement x1 = this.ast.newEnhancedForStatement();
        x1.setParameter(this.V1);
        x1.setExpression(this.E1);
        x1.setBody(this.S1);
        this.basicMatch((ASTNode)x1);
    }

    public void testExpressionStatement() {
        ExpressionStatement x1 = this.ast.newExpressionStatement(this.E1);
        this.basicMatch((ASTNode)x1);
    }

    public void testFieldAccess() {
        FieldAccess x1 = this.ast.newFieldAccess();
        x1.setExpression(this.E1);
        x1.setName(this.N1);
        this.basicMatch((ASTNode)x1);
    }

    public void testFieldDeclaration() {
        FieldDeclaration x1 = this.ast.newFieldDeclaration(this.W1);
        x1.setJavadoc(this.JD1);
        if (this.ast.apiLevel() >= 3) {
            x1.modifiers().add(this.MOD1);
            x1.modifiers().add(this.MOD2);
        }
        x1.setType(this.T1);
        x1.fragments().add(this.W2);
        this.basicMatch((ASTNode)x1);
    }

    public void testForStatement() {
        ForStatement x1 = this.ast.newForStatement();
        x1.initializers().add(this.E1);
        x1.initializers().add(this.E2);
        x1.setExpression((Expression)this.N1);
        x1.updaters().add(this.N2);
        x1.updaters().add(this.N3);
        x1.setBody(this.S1);
        this.basicMatch((ASTNode)x1);
    }

    public void testIfStatement() {
        IfStatement x1 = this.ast.newIfStatement();
        x1.setExpression(this.E1);
        x1.setThenStatement(this.S1);
        x1.setElseStatement(this.S2);
        this.basicMatch((ASTNode)x1);
    }

    public void testImportDeclaration() {
        ImportDeclaration x1 = this.ast.newImportDeclaration();
        x1.setName((Name)this.N1);
        this.basicMatch((ASTNode)x1);
    }

    public void testInfixExpression() {
        InfixExpression x1 = this.ast.newInfixExpression();
        x1.setOperator(InfixExpression.Operator.PLUS);
        x1.setLeftOperand(this.E1);
        x1.setRightOperand(this.E2);
        x1.extendedOperands().add(this.N1);
        x1.extendedOperands().add(this.N2);
        this.basicMatch((ASTNode)x1);
    }

    public void testInitializer() {
        Initializer x1 = this.ast.newInitializer();
        x1.setJavadoc(this.JD1);
        if (this.ast.apiLevel() >= 3) {
            x1.modifiers().add(this.MOD1);
            x1.modifiers().add(this.MOD2);
        }
        x1.setBody(this.B1);
        this.basicMatch((ASTNode)x1);
    }

    public void testJavadoc() {
        JSdoc x1 = this.ast.newJSdoc();
        if (this.ast.apiLevel() == 2) {
            x1.setComment("/**?*/");
        }
        x1.tags().add(this.TAG1);
        x1.tags().add(this.TAG2);
        this.basicMatch((ASTNode)x1);
    }

    public void testLabeledStatement() {
        LabeledStatement x1 = this.ast.newLabeledStatement();
        x1.setLabel(this.N1);
        x1.setBody(this.S1);
        this.basicMatch((ASTNode)x1);
    }

    public void testLineComment() {
        LineComment x1 = this.ast.newLineComment();
        this.basicMatch((ASTNode)x1);
    }

    public void testMemberRef() {
        MemberRef x1 = this.ast.newMemberRef();
        x1.setQualifier((Name)this.N1);
        x1.setName(this.N2);
        this.basicMatch((ASTNode)x1);
    }

    public void testMethodDeclaration() {
        FunctionDeclaration x1 = this.ast.newFunctionDeclaration();
        x1.setJavadoc(this.JD1);
        if (this.ast.apiLevel() == 2) {
            x1.setReturnType(this.T1);
        } else {
            x1.modifiers().add(this.MOD1);
            x1.modifiers().add(this.MOD2);
            x1.setReturnType2(this.T1);
        }
        x1.setName(this.N1);
        x1.parameters().add(this.V1);
        x1.parameters().add(this.V2);
        x1.thrownExceptions().add(this.N2);
        x1.thrownExceptions().add(this.N3);
        x1.setBody(this.B1);
        this.basicMatch((ASTNode)x1);
    }

    public void testMethodInvocation() {
        FunctionInvocation x1 = this.ast.newFunctionInvocation();
        x1.setExpression((Expression)this.N1);
        x1.setName(this.N2);
        x1.arguments().add(this.E1);
        x1.arguments().add(this.E2);
        this.basicMatch((ASTNode)x1);
    }

    public void testMethodRef() {
        FunctionRef x1 = this.ast.newFunctionRef();
        this.basicMatch((ASTNode)x1);
        x1.setQualifier((Name)this.N1);
        x1.setName(this.N2);
        x1.parameters().add(this.MPARM1);
    }

    public void testMethodRefParameter() {
        FunctionRefParameter x1 = this.ast.newFunctionRefParameter();
        x1.setType(this.T1);
        x1.setName(this.N1);
        this.basicMatch((ASTNode)x1);
    }

    public void testNullLiteral() {
        NullLiteral x1 = this.ast.newNullLiteral();
        this.basicMatch((ASTNode)x1);
    }

    public void testNumberLiteral() {
        NumberLiteral x1 = this.ast.newNumberLiteral("1.0");
        this.basicMatch((ASTNode)x1);
    }

    public void testParenthesizedExpression() {
        ParenthesizedExpression x1 = this.ast.newParenthesizedExpression();
        this.basicMatch((ASTNode)x1);
    }

    public void testPostfixExpression() {
        PostfixExpression x1 = this.ast.newPostfixExpression();
        x1.setOperand(this.E1);
        x1.setOperator(PostfixExpression.Operator.INCREMENT);
        this.basicMatch((ASTNode)x1);
    }

    public void testPrefixExpression() {
        PrefixExpression x1 = this.ast.newPrefixExpression();
        x1.setOperand(this.E1);
        x1.setOperator(PrefixExpression.Operator.INCREMENT);
        this.basicMatch((ASTNode)x1);
    }

    public void testReturnStatement() {
        ReturnStatement x1 = this.ast.newReturnStatement();
        x1.setExpression(this.E1);
        this.basicMatch((ASTNode)x1);
    }

    public void testSingleVariableDeclaration() {
        SingleVariableDeclaration x1 = this.ast.newSingleVariableDeclaration();
        if (this.ast.apiLevel() >= 3) {
            x1.modifiers().add(this.MOD1);
            x1.modifiers().add(this.MOD2);
        }
        x1.setType(this.T1);
        x1.setName(this.N1);
        x1.setInitializer(this.E1);
        this.basicMatch((ASTNode)x1);
    }

    public void testStringLiteral() {
        StringLiteral x1 = this.ast.newStringLiteral();
        x1.setLiteralValue("H");
        this.basicMatch((ASTNode)x1);
    }

    public void testSuperConstructorInvocation() {
        SuperConstructorInvocation x1 = this.ast.newSuperConstructorInvocation();
        x1.setExpression((Expression)this.N1);
        x1.arguments().add(this.E1);
        x1.arguments().add(this.E2);
        this.basicMatch((ASTNode)x1);
    }

    public void testSuperFieldAccess() {
        SuperFieldAccess x1 = this.ast.newSuperFieldAccess();
        x1.setQualifier((Name)this.N1);
        x1.setName(this.N2);
        this.basicMatch((ASTNode)x1);
    }

    public void testSuperMethodInvocation() {
        SuperMethodInvocation x1 = this.ast.newSuperMethodInvocation();
        x1.setQualifier((Name)this.N1);
        x1.setName(this.N2);
        x1.arguments().add(this.E1);
        x1.arguments().add(this.E2);
        this.basicMatch((ASTNode)x1);
    }

    public void testSwitchCase() {
        SwitchCase x1 = this.ast.newSwitchCase();
        x1.setExpression(this.E1);
        this.basicMatch((ASTNode)x1);
    }

    public void testSwitchStatement() {
        SwitchStatement x1 = this.ast.newSwitchStatement();
        x1.setExpression(this.E1);
        x1.statements().add(this.S1);
        x1.statements().add(this.S2);
        this.basicMatch((ASTNode)x1);
    }

    public void testTagElement() {
        TagElement x1 = this.ast.newTagElement();
        x1.setTagName("@foo");
        x1.fragments().add(this.TAG1);
        x1.fragments().add(this.TEXT1);
        x1.fragments().add(this.N1);
        x1.fragments().add(this.MTHREF1);
        this.basicMatch((ASTNode)x1);
    }

    public void testTextElement() {
        TextElement x1 = this.ast.newTextElement();
        x1.setText("foo");
        this.basicMatch((ASTNode)x1);
    }

    public void testThisExpression() {
        ThisExpression x1 = this.ast.newThisExpression();
        x1.setQualifier((Name)this.N1);
        this.basicMatch((ASTNode)x1);
    }

    public void testThrowStatement() {
        ThrowStatement x1 = this.ast.newThrowStatement();
        x1.setExpression(this.E1);
        this.basicMatch((ASTNode)x1);
    }

    public void testTryStatement() {
        TryStatement x1 = this.ast.newTryStatement();
        x1.setBody(this.B1);
        CatchClause c1 = this.ast.newCatchClause();
        c1.setException(this.V1);
        c1.setBody(this.ast.newBlock());
        x1.catchClauses().add(c1);
        CatchClause c2 = this.ast.newCatchClause();
        c2.setException(this.V2);
        c2.setBody(this.ast.newBlock());
        x1.catchClauses().add(c2);
        x1.setFinally(this.ast.newBlock());
        this.basicMatch((ASTNode)x1);
    }

    public void testTypeDeclaration() {
        TypeDeclaration x1 = this.ast.newTypeDeclaration();
        x1.setJavadoc(this.JD1);
        x1.setName(this.N1);
        if (this.ast.apiLevel() == 2) {
            x1.setSuperclass((Name)this.N2);
        } else {
            x1.modifiers().add(this.MOD1);
            x1.modifiers().add(this.MOD2);
        }
        x1.bodyDeclarations().add(this.FD1);
        x1.bodyDeclarations().add(this.FD2);
        this.basicMatch((ASTNode)x1);
    }

    public void testTypeDeclarationStatement() {
        TypeDeclarationStatement x1 = this.ast.newTypeDeclarationStatement(this.TD1);
        this.basicMatch((ASTNode)x1);
    }

    public void testTypeLiteral() {
        TypeLiteral x1 = this.ast.newTypeLiteral();
        x1.setType(this.T1);
        this.basicMatch((ASTNode)x1);
    }

    public void testVariableDeclarationFragment() {
        VariableDeclarationFragment x1 = this.ast.newVariableDeclarationFragment();
        x1.setName(this.N1);
        x1.setInitializer(this.E1);
        this.basicMatch((ASTNode)x1);
    }

    public void testVariableDeclarationExpression() {
        VariableDeclarationExpression x1 = this.ast.newVariableDeclarationExpression(this.W1);
        if (this.ast.apiLevel() >= 3) {
            x1.modifiers().add(this.MOD1);
            x1.modifiers().add(this.MOD2);
        }
        x1.setType(this.T1);
        x1.fragments().add(this.W2);
        this.basicMatch((ASTNode)x1);
    }

    public void testVariableDeclarationStatement() {
        VariableDeclarationStatement x1 = this.ast.newVariableDeclarationStatement(this.W1);
        if (this.ast.apiLevel() >= 3) {
            x1.modifiers().add(this.MOD1);
            x1.modifiers().add(this.MOD2);
        }
        x1.setType(this.T1);
        x1.fragments().add(this.W2);
        this.basicMatch((ASTNode)x1);
    }

    public void testWhileStatement() {
        WhileStatement x1 = this.ast.newWhileStatement();
        x1.setExpression(this.E1);
        x1.setBody(this.S1);
        this.basicMatch((ASTNode)x1);
    }

    static class NodeCounter
    extends ASTVisitor {
        public int count = 0;

        public NodeCounter(boolean visitDocTags) {
            super(visitDocTags);
        }

        public void preVisit(ASTNode node) {
            ++this.count;
        }
    }

    class TestMatcher
    extends ASTMatcher {
        public Object receiverNode;
        public Object otherNode;
        public boolean result;
        public boolean superMatch;
        public boolean superMatchResult;
        public int matchCalls = 0;

        TestMatcher() {
            this(false);
        }

        TestMatcher(boolean visitDocTags) {
            super(visitDocTags);
        }

        boolean standardBody(ASTNode receiver, Object other, boolean matchResult) {
            ++this.matchCalls;
            this.receiverNode = receiver;
            this.otherNode = other;
            this.superMatchResult = matchResult;
            if (this.superMatch) {
                return this.superMatchResult;
            }
            return this.result;
        }

        public boolean match(AnonymousClassDeclaration node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(ArrayAccess node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(ArrayCreation node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(ArrayInitializer node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(ArrayType node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(Assignment node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(Block node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(BlockComment node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(BooleanLiteral node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(BreakStatement node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(CatchClause node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(CharacterLiteral node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(ClassInstanceCreation node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(JavaScriptUnit node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(ConditionalExpression node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(ConstructorInvocation node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(ContinueStatement node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(DoStatement node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(EmptyStatement node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(EnhancedForStatement node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(ExpressionStatement node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(FieldAccess node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(FieldDeclaration node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(ForStatement node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(IfStatement node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(ImportDeclaration node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(InfixExpression node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(Initializer node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(JSdoc node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(LabeledStatement node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(LineComment node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(MemberRef node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(FunctionDeclaration node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(FunctionInvocation node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(FunctionRef node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(FunctionRefParameter node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(Modifier node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(NullLiteral node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(NumberLiteral node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(PackageDeclaration node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(ParenthesizedExpression node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(PostfixExpression node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(PrefixExpression node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(PrimitiveType node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(QualifiedName node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(QualifiedType node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(ReturnStatement node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(SimpleName node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(SimpleType node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(SingleVariableDeclaration node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(StringLiteral node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(SuperConstructorInvocation node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(SuperFieldAccess node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(SuperMethodInvocation node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(SwitchCase node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(SwitchStatement node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(TagElement node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(TextElement node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(ThisExpression node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(ThrowStatement node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(TryStatement node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(TypeDeclaration node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(TypeDeclarationStatement node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(TypeLiteral node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(VariableDeclarationExpression node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(VariableDeclarationFragment node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(VariableDeclarationStatement node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }

        public boolean match(WhileStatement node, Object other) {
            return this.standardBody((ASTNode)node, other, this.superMatch ? super.match(node, other) : false);
        }
    }
}

