/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavaSearchTests;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;

public class InclusionPatternsTests
extends ModifyingResourceTests {
    IJavaScriptProject project;
    static /* synthetic */ Class class$0;

    public InclusionPatternsTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.model.InclusionPatternsTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return InclusionPatternsTests.buildModelTestSuite(clazz);
    }

    protected void setClasspath(String[] sourceFoldersAndInclusionPatterns) throws JavaScriptModelException {
        this.project.setRawIncludepath(this.createClasspath(sourceFoldersAndInclusionPatterns, true, false), null);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.project = this.createJavaProject("P", new String[]{"src"}, new String[0], new String[0], new boolean[0], "bin", new String[]{"bin"}, new String[][]{new String[0]}, new String[][]{{"**"}}, "1.4");
        this.startDeltas();
    }

    protected void tearDown() throws Exception {
        this.stopDeltas();
        this.deleteProject("P");
        super.tearDown();
    }

    public void testAddInclusionOnCompilationUnit() throws CoreException {
        this.createFolder("/P/src/p");
        this.createFile("/P/src/p/A.js", "package p;\npublic class A {\n}");
        this.clearDeltas();
        this.setClasspath(new String[]{"/P/src", "**/A.js"});
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\tsrc[*]: {ADDED TO CLASSPATH | REMOVED FROM CLASSPATH}\n\tResourceDelta(/P/.classpath)[*]");
        IPackageFragment pkg = this.getPackage("/P/src/p");
        this.assertSortedElementsEqual("Unexpected children", "A.java [in p [in src [in P]]]", pkg.getChildren());
        this.assertResourceNamesEqual("Unexpected non-java resources", "", pkg.getNonJavaScriptResources());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddInclusionOnFolderUnderProject() throws CoreException {
        try {
            IJavaScriptProject javaProject = this.createJavaProject("P1", new String[]{""});
            this.createFolder("/P1/doc");
            this.clearDeltas();
            javaProject.setRawIncludepath(this.createClasspath(new String[]{"/P1", "doc/"}, true, false), null);
            this.assertDeltas("Unexpected deltas", "P1[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\t<project root>[*]: {ADDED TO CLASSPATH | REMOVED FROM CLASSPATH}\n\tResourceDelta(/P1/.classpath)[*]");
            IPackageFragmentRoot root = this.getPackageFragmentRoot("/P1");
            this.assertSortedElementsEqual("Unexpected children", "doc [in <project root> [in P1]]", root.getChildren());
            this.assertResourceNamesEqual("Unexpected non-java resources of project", ".classpath\n.project", javaProject.getNonJavaScriptResources());
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P1");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P1");
    }

    public void testAddInclusionOnPackage() throws CoreException {
        this.createFolder("/P/src/p");
        this.clearDeltas();
        this.setClasspath(new String[]{"/P/src", "p/"});
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\tsrc[*]: {ADDED TO CLASSPATH | REMOVED FROM CLASSPATH}\n\tResourceDelta(/P/.classpath)[*]");
        IPackageFragmentRoot root = this.getPackageFragmentRoot("/P/src");
        this.assertSortedElementsEqual("Unexpected children", "p [in src [in P]]", root.getChildren());
        this.assertResourceNamesEqual("Unexpected non-java resources", "", root.getNonJavaScriptResources());
    }

    public void testAddToIncludedFolder() throws CoreException {
        this.createFolder("/P/src/p");
        this.setClasspath(new String[]{"/P/src", "p/"});
        this.clearDeltas();
        this.createFile("/P/src/p/my.txt", "");
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\tp[*]: {CONTENT}\n\t\t\tResourceDelta(/P/src/p/my.txt)[+]");
        this.clearDeltas();
        this.deleteFile("/P/src/p/my.txt");
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\tp[*]: {CONTENT}\n\t\t\tResourceDelta(/P/src/p/my.txt)[-]");
    }

    public void testCreateIncludedCompilationUnit() throws CoreException {
        this.setClasspath(new String[]{"/P/src", "**/A.js"});
        this.createFolder("/P/src/p");
        IPackageFragment pkg = this.getPackage("/P/src/p");
        this.clearDeltas();
        pkg.createCompilationUnit("A.js", "package p;\npublic class A {\n}", false, null);
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\tp[*]: {CHILDREN}\n\t\t\tA.java[+]: {}");
        this.assertSortedElementsEqual("Unexpected children", "A.java [in p [in src [in P]]]", pkg.getChildren());
        this.assertResourceNamesEqual("Unexpected non-java resources", "", pkg.getNonJavaScriptResources());
    }

    public void testCreateIncludedPackage() throws CoreException {
        this.setClasspath(new String[]{"/P/src", "p/"});
        IPackageFragmentRoot root = this.getPackageFragmentRoot("/P/src");
        this.clearDeltas();
        root.createPackageFragment("p", false, null);
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\tp[+]: {}");
        this.assertSortedElementsEqual("Unexpected children", "p [in src [in P]]", root.getChildren());
        this.assertResourceNamesEqual("Unexpected non-java resources", "", root.getNonJavaScriptResources());
    }

    public void testCreateResourceIncludedCompilationUnit() throws CoreException {
        this.setClasspath(new String[]{"/P/src", "**/A.js"});
        this.createFolder("/P/src/p");
        this.clearDeltas();
        this.createFile("/P/src/p/A.js", "package p;\npublic class A {\n}");
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\tp[*]: {CHILDREN}\n\t\t\tA.java[+]: {}");
        IPackageFragment pkg = this.getPackage("/P/src/p");
        this.assertSortedElementsEqual("Unexpected children", "A.java [in p [in src [in P]]]", pkg.getChildren());
        this.assertResourceNamesEqual("Unexpected non-java resources", "", pkg.getNonJavaScriptResources());
    }

    public void testCreateResourceIncludedCompilationUnit2() throws CoreException {
        this.setClasspath(new String[]{"/P/src", "p1/p2/p3/A.js"});
        this.createFolder("/P/src/p1/p2/p3");
        this.clearDeltas();
        this.createFile("/P/src/p1/p2/p3/A.js", "package p1.p2.p3;\npublic class A {\n}");
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN | CONTENT}\n\t\tp1.p2.p3[*]: {CHILDREN}\n\t\t\tA.java[+]: {}\n\t\tResourceDelta(/P/src/p1)[*]");
        IPackageFragment pkg = this.getPackage("/P/src/p1/p2/p3");
        this.assertSortedElementsEqual("Unexpected children", "A.java [in p1.p2.p3 [in src [in P]]]", pkg.getChildren());
        this.assertResourceNamesEqual("Unexpected non-java resources", "", pkg.getNonJavaScriptResources());
    }

    public void testCreateResourceIncludedPackage() throws CoreException {
        this.setClasspath(new String[]{"/P/src", "p/"});
        this.clearDeltas();
        this.createFolder("/P/src/p");
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\tp[+]: {}");
        IPackageFragmentRoot root = this.getPackageFragmentRoot("/P/src");
        this.assertSortedElementsEqual("Unexpected children", "p [in src [in P]]", root.getChildren());
        this.assertResourceNamesEqual("Unexpected non-java resources", "", root.getNonJavaScriptResources());
    }

    public void testCreateResourceIncludedPackage2() throws CoreException {
        this.setClasspath(new String[]{"/P/src", "p1/p2/p3/"});
        this.createFolder("/P/src/p1/p2");
        this.clearDeltas();
        this.createFolder("/P/src/p1/p2/p3");
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN | CONTENT}\n\t\tp1.p2.p3[+]: {}\n\t\tResourceDelta(/P/src/p1)[*]");
        IPackageFragmentRoot root = this.getPackageFragmentRoot("/P/src");
        this.assertSortedElementsEqual("Unexpected children", "p1.p2.p3 [in src [in P]]", root.getChildren());
        this.assertResourceNamesEqual("Unexpected non-java resources", "p1", root.getNonJavaScriptResources());
    }

    public void testDefaultPackageProjectIsSource() throws CoreException {
        this.setClasspath(new String[]{"/P", "**/*.js"});
        this.deleteFolder("/P/src");
        this.createFile("/P/A.js", "public class A {}");
        IPackageFragmentRoot root = this.getPackageFragmentRoot("/P");
        this.assertElementDescendants("Unexpected descendants of root", "<project root>\n  <default> (...)\n    A.java\n      class A", (IJavaScriptElement)root);
    }

    /*
     * Exception decompiling
     */
    public void testIncludeCUOnly01() throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 110->114)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testIncludeCUOnly02() throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 110->114)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void testIsOnClasspath1() throws CoreException {
        this.setClasspath(new String[]{"/P/src", "**/B.js"});
        this.createFolder("/P/src/p");
        IFile file = this.createFile("/P/src/p/A.js", "package p;\npublic class A {\n}");
        InclusionPatternsTests.assertTrue((String)"Resource should not be on classpath", (!this.project.isOnIncludepath((IResource)file) ? 1 : 0) != 0);
        IJavaScriptUnit cu = this.getCompilationUnit("/P/src/p/A.js");
        InclusionPatternsTests.assertTrue((String)"CU should not be on classpath", (!this.project.isOnIncludepath((IJavaScriptElement)cu) ? 1 : 0) != 0);
    }

    public void testIsOnClasspath2() throws CoreException {
        this.setClasspath(new String[]{"/P/src", "**/A.js"});
        this.createFolder("/P/src/p");
        IFile file = this.createFile("/P/src/p/A.js", "package p;\npublic class A {\n}");
        InclusionPatternsTests.assertTrue((String)"Resource should be on classpath", (boolean)this.project.isOnIncludepath((IResource)file));
        IJavaScriptUnit cu = this.getCompilationUnit("/P/src/p/A.js");
        InclusionPatternsTests.assertTrue((String)"CU should be on classpath", (boolean)this.project.isOnIncludepath((IJavaScriptElement)cu));
    }

    public void testIsOnClasspath3() throws CoreException {
        this.setClasspath(new String[]{"/P/src", "**/X.js"});
        this.createFolder("/P/src/p");
        IFile file = this.createFile("/P/src/p/readme.txt", "");
        InclusionPatternsTests.assertTrue((String)"Resource should not be on classpath", (!this.project.isOnIncludepath((IResource)file) ? 1 : 0) != 0);
    }

    public void testIsOnClasspath4() throws CoreException {
        this.setClasspath(new String[]{"/P/src", "p/**"});
        this.createFolder("/P/src/p");
        IFile file = this.createFile("/P/src/p/readme.txt", "");
        InclusionPatternsTests.assertTrue((String)"Resource should be on classpath", (boolean)this.project.isOnIncludepath((IResource)file));
    }

    public void testMoveFolderContainingPackage1() throws CoreException {
        this.setClasspath(new String[]{"/P/src", "p1/p2/"});
        this.createFolder("/P/src/p1/p2");
        this.clearDeltas();
        this.getFolder("/P/src/p1").move((IPath)new Path("/P/p1"), false, null);
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN | CONTENT}\n\tsrc[*]: {CHILDREN | CONTENT}\n\t\tp1.p2[-]: {}\n\t\tResourceDelta(/P/src/p1)[-]\n\tResourceDelta(/P/p1)[+]");
    }

    public void testMoveFolderContainingPackage2() throws CoreException {
        this.setClasspath(new String[]{"/P/src", "p1/p2/"});
        this.createFolder("/P/p1/p2");
        this.clearDeltas();
        this.getFolder("/P//p1").move((IPath)new Path("/P/src/p1"), false, null);
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN | CONTENT}\n\tsrc[*]: {CHILDREN | CONTENT}\n\t\tp1.p2[+]: {}\n\t\tResourceDelta(/P/src/p1)[+]\n\tResourceDelta(/P/p1)[-]");
    }

    public void testNestedSourceFolder1() throws CoreException {
        this.setClasspath(new String[]{"/P/src1", "**/A.js", "/P/src1/src2", ""});
        this.createFolder("/P/src1/src2");
        IPackageFragmentRoot root1 = this.getPackageFragmentRoot("/P/src1");
        this.assertResourceNamesEqual("Unexpected non-java resources for /P/src1", "", root1.getNonJavaScriptResources());
    }

    public void testNestedSourceFolder2() throws CoreException {
        this.setClasspath(new String[]{"/P/src1", "**/X.js", "/P/src1/src2", ""});
        this.createFolder("/P/src1/src2");
        this.clearDeltas();
        this.createFile("/P/src1/src2/A.js", "public class A {\n}");
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc1/src2[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tA.java[+]: {}");
    }

    public void testNestedSourceFolder3() throws CoreException {
        this.setClasspath(new String[]{"/P/src1", "**/X.js", "/P/src1/src2", ""});
        this.createFolder("/P/src1/src2");
        this.clearDeltas();
        this.createFile("/P/src1/src2/readme.txt", "");
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc1/src2[*]: {CONTENT}\n\t\tResourceDelta(/P/src1/src2/readme.txt)[+]");
    }

    public void testNestedSourceFolder4() throws CoreException {
        this.setClasspath(new String[]{"/P/src1", "**/X.js", "/P/src1/src2", "**/X.js"});
        this.createFolder("/P/src1/src2");
        this.clearDeltas();
        this.createFolder("/P/src1/src2/p");
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc1/src2[*]: {CHILDREN}\n\t\tp[+]: {}");
    }

    public void testNestedSourceFolder5() throws CoreException {
        this.setClasspath(new String[]{"/P/src1", "**/X.js", "/P/src1/src2", ""});
        this.createFolder("/P/src1/src2");
        this.clearDeltas();
        this.createFolder("/P/src1/p");
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc1[*]: {CHILDREN}\n\t\tp[+]: {}");
    }

    public void testNestedSourceFolder6() throws CoreException {
        this.setClasspath(new String[]{"/P/src1", "**/X.js", "/P/src1/src2", "**/X.js"});
        this.createFolder("/P/src1/src2");
        this.createFolder("/P/src1/p");
        this.clearDeltas();
        this.moveFolder("/P/src1/p", "/P/src1/src2/p");
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc1[*]: {CHILDREN}\n\t\tp[-]: {MOVED_TO(p [in src1/src2 [in P]])}\n\tsrc1/src2[*]: {CHILDREN}\n\t\tp[+]: {MOVED_FROM(p [in src1 [in P]])}");
    }

    public void testRemoveInclusionOnCompilationUnit() throws CoreException {
        this.setClasspath(new String[]{"/P/src", "**/A.js"});
        this.createFolder("/P/src/p");
        this.createFile("/P/src/p/A.js", "package p;\npublic class A {\n}");
        this.clearDeltas();
        this.setClasspath(new String[]{"/P/src", "**/B.js"});
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\tsrc[*]: {ADDED TO CLASSPATH | REMOVED FROM CLASSPATH}\n\tResourceDelta(/P/.classpath)[*]");
        IPackageFragment pkg = this.getPackage("/P/src/p");
        this.assertSortedElementsEqual("Unexpected children", "", pkg.getChildren());
        this.assertResourceNamesEqual("Unexpected non-java resources", "A.js", pkg.getNonJavaScriptResources());
    }

    public void testRemoveInclusionOnPackage() throws CoreException {
        this.setClasspath(new String[]{"/P/src", "p"});
        this.createFolder("/P/src/p");
        this.clearDeltas();
        this.setClasspath(new String[]{"/P/src", "q"});
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\tsrc[*]: {ADDED TO CLASSPATH | REMOVED FROM CLASSPATH}\n\tResourceDelta(/P/.classpath)[*]");
        IPackageFragmentRoot root = this.getPackageFragmentRoot("/P/src");
        this.assertSortedElementsEqual("Unexpected children", "<default> [in src [in P]]", root.getChildren());
        this.assertResourceNamesEqual("Unexpected non-java resources", "p", root.getNonJavaScriptResources());
    }

    public void testRenameIncludedCompilationUnit() throws CoreException {
        this.setClasspath(new String[]{"/P/src", "**/A.js"});
        this.createFolder("/P/src/p");
        IFile file = this.createFile("/P/src/p/A.js", "package p;\npublic class A {\n}");
        this.clearDeltas();
        file.move((IPath)new Path("/P/src/p/B.js"), false, null);
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\tp[*]: {CHILDREN | CONTENT}\n\t\t\tA.java[-]: {}\n\t\t\tResourceDelta(/P/src/p/B.java)[+]");
        IPackageFragment pkg = this.getPackage("/P/src/p");
        this.assertSortedElementsEqual("Unexpected children", "", pkg.getChildren());
        this.assertResourceNamesEqual("Unexpected non-java resources", "B.js", pkg.getNonJavaScriptResources());
    }

    public void testRenameIncludedPackage1() throws CoreException {
        this.setClasspath(new String[]{"/P/src", "p/"});
        IPackageFragmentRoot root = this.getPackageFragmentRoot("/P/src");
        IPackageFragment pkg = root.createPackageFragment("p", false, null);
        this.clearDeltas();
        pkg.rename("q", false, null);
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN | CONTENT}\n\t\tp[-]: {}\n\t\tResourceDelta(/P/src/q)[+]");
        this.assertSortedElementsEqual("Unexpected children", "", root.getChildren());
        this.assertResourceNamesEqual("Unexpected non-java resources", "q", root.getNonJavaScriptResources());
    }

    public void testRenameIncludedPackage2() throws CoreException {
        this.setClasspath(new String[]{"/P/src", "p/"});
        IPackageFragmentRoot root = this.getPackageFragmentRoot("/P/src");
        IPackageFragment pkg = root.createPackageFragment("p", false, null);
        this.createFile("/P/src/p/X.js", "package p;\npublic class X {\n}");
        this.clearDeltas();
        pkg.rename("q", false, null);
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN | CONTENT}\n\t\tp[-]: {}\n\t\tResourceDelta(/P/src/q)[+]");
        this.assertSortedElementsEqual("Unexpected children", "", root.getChildren());
        this.assertResourceNamesEqual("Unexpected non-java resources", "q", root.getNonJavaScriptResources());
    }

    public void testRenameResourceIncludedCompilationUnit() throws CoreException {
        this.setClasspath(new String[]{"/P/src", "**/A.js"});
        this.createFolder("/P/src/p");
        IFile file = this.createFile("/P/src/p/A.js", "package p;\npublic class A {\n}");
        this.clearDeltas();
        file.move((IPath)new Path("/P/src/p/B.js"), false, null);
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\tp[*]: {CHILDREN | CONTENT}\n\t\t\tA.java[-]: {}\n\t\t\tResourceDelta(/P/src/p/B.java)[+]");
        IPackageFragment pkg = this.getPackage("/P/src/p");
        this.assertSortedElementsEqual("Unexpected children", "", pkg.getChildren());
        this.assertResourceNamesEqual("Unexpected non-java resources", "B.js", pkg.getNonJavaScriptResources());
    }

    public void testRenameResourceIncludedPackage() throws CoreException {
        this.setClasspath(new String[]{"/P/src", "p/"});
        IFolder folder = this.createFolder("/P/src/p");
        this.clearDeltas();
        folder.move((IPath)new Path("/P/src/q"), false, null);
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN | CONTENT}\n\t\tp[-]: {}\n\t\tResourceDelta(/P/src/q)[+]");
        IPackageFragmentRoot root = this.getPackageFragmentRoot("/P/src");
        this.assertSortedElementsEqual("Unexpected children", "", root.getChildren());
        this.assertResourceNamesEqual("Unexpected non-java resources", "q", root.getNonJavaScriptResources());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testSearchPotentialMatchInOutput() throws CoreException {
        try {
            JavaScriptCore.run((IWorkspaceRunnable)new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IJavaScriptProject javaProject = InclusionPatternsTests.this.createJavaProject("P2", new String[0]);
                    javaProject.setRawIncludepath(InclusionPatternsTests.this.createClasspath(new String[]{"/P2", "**/X.js", "/P2/src", ""}, true, false), null);
                    InclusionPatternsTests.this.createFile("/P2/bin/X.js", "public class X {\n}");
                }
            }, null);
            AbstractJavaSearchTests.JavaSearchResultCollector resultCollector = new AbstractJavaSearchTests.JavaSearchResultCollector();
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{this.getJavaProject("P")});
            this.search("X", 0, 0, scope, (SearchRequestor)resultCollector);
            InclusionPatternsTests.assertEquals((String)"", (String)resultCollector.toString());
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P2");
    }

    public void testSearchWithIncludedCompilationUnit1() throws CoreException {
        this.setClasspath(new String[]{"/P/src", "**/A.js"});
        this.createFolder("/P/src/p");
        this.createFile("/P/src/p/A.js", "package p;\npublic class A {\n}");
        AbstractJavaSearchTests.JavaSearchResultCollector resultCollector = new AbstractJavaSearchTests.JavaSearchResultCollector();
        this.search("A", 0, 0, SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptProject[]{this.getJavaProject("P")}), (SearchRequestor)resultCollector);
        InclusionPatternsTests.assertEquals((String)"Unexpected matches found", (String)"src/p/A.java p.A [A]", (String)resultCollector.toString());
    }

    public void testSearchWithIncludedCompilationUnit2() throws CoreException {
        this.setClasspath(new String[]{"/P/src", "**/A.js"});
        this.createFolder("/P/src/p");
        this.createFile("/P/src/p/A.js", "package p;\npublic class A {\n}");
        this.setClasspath(new String[]{"/P/src", "**/B.js"});
        AbstractJavaSearchTests.JavaSearchResultCollector resultCollector = new AbstractJavaSearchTests.JavaSearchResultCollector();
        this.search("A", 0, 0, SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptProject[]{this.getJavaProject("P")}), (SearchRequestor)resultCollector);
        InclusionPatternsTests.assertEquals((String)"Unexpected matches found", (String)"", (String)resultCollector.toString());
    }

    public void testSearchWithIncludedPackage1() throws CoreException {
        this.createFolder("/P/src/p");
        this.createFile("/P/src/p/A.js", "package p;\npublic class A {\n}");
        this.setClasspath(new String[]{"/P/src", "p/"});
        AbstractJavaSearchTests.JavaSearchResultCollector resultCollector = new AbstractJavaSearchTests.JavaSearchResultCollector();
        this.search("A", 0, 0, SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptProject[]{this.getJavaProject("P")}), (SearchRequestor)resultCollector);
        InclusionPatternsTests.assertEquals((String)"Unexpected matches found", (String)"src/p/A.java p.A [A]", (String)resultCollector.toString());
    }

    public void testSearchWithIncludedPackage2() throws CoreException {
        this.setClasspath(new String[]{"/P/src", "p/"});
        this.createFolder("/P/src/p");
        this.createFile("/P/src/p/A.js", "package p;\npublic class A {\n}");
        IProject p = this.project.getProject();
        p.close(null);
        p.open(null);
        AbstractJavaSearchTests.JavaSearchResultCollector resultCollector = new AbstractJavaSearchTests.JavaSearchResultCollector();
        this.search("A", 0, 0, SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptProject[]{this.getJavaProject("P")}), (SearchRequestor)resultCollector);
        InclusionPatternsTests.assertEquals((String)"Unexpected matches found", (String)"src/p/A.java p.A [A]", (String)resultCollector.toString());
    }

    public void testTrailingSlash() throws CoreException {
        this.setClasspath(new String[]{"/P/src", "a/"});
        this.createFolder("/P/src/a/b/c");
        IPackageFragmentRoot root = this.getPackageFragmentRoot("/P/src");
        this.assertSortedElementsEqual("Unexpected children of root", "a [in src [in P]]\na.b [in src [in P]]\na.b.c [in src [in P]]", root.getChildren());
    }
}

