/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.rewrite.describing;

import java.util.HashSet;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.IfStatement;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.core.tests.model.SuiteOfTestCases;
import org.eclipse.wst.jsdt.core.tests.rewrite.describing.ASTRewritingTest;
import org.eclipse.wst.jsdt.internal.core.dom.rewrite.LineCommentEndOffsets;

public class LineCommentOffsetsTest
extends ASTRewritingTest {
    private static final Class THIS;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.rewrite.describing.LineCommentOffsetsTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        THIS = clazz;
    }

    public LineCommentOffsetsTest(String name) {
        super(name);
    }

    public static Test allTests() {
        return new SuiteOfTestCases.Suite(THIS);
    }

    public static Test setUpTest(Test someTest) {
        SuiteOfTestCases.Suite suite = new SuiteOfTestCases.Suite("one test");
        suite.addTest(someTest);
        return suite;
    }

    public static Test suite() {
        return LineCommentOffsetsTest.allTests();
    }

    public void testEmptyLineComments() throws Exception {
        StringBuffer buf = new StringBuffer();
        buf.append("\n");
        LineCommentEndOffsets offsets = new LineCommentEndOffsets(null);
        boolean res = offsets.isEndOfLineComment(0);
        LineCommentOffsetsTest.assertFalse((boolean)res);
        res = offsets.remove(0);
        LineCommentOffsetsTest.assertFalse((boolean)res);
    }

    public void testRemove() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;//comment Y\n");
        buf.append("public class E//comment Y\n");
        buf.append("{//comment Y\n");
        buf.append("}//comment Y");
        String contents = buf.toString();
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", contents, false, null);
        JavaScriptUnit astRoot = this.createAST3(cu);
        LineCommentEndOffsets offsets = new LineCommentEndOffsets(astRoot.getCommentList());
        int p1 = contents.indexOf(89) + 1;
        int p2 = contents.indexOf(89, p1) + 1;
        int p3 = contents.indexOf(89, p2) + 1;
        int p4 = contents.indexOf(89, p3) + 1;
        LineCommentOffsetsTest.assertFalse((boolean)offsets.isEndOfLineComment(0));
        LineCommentOffsetsTest.assertTrue((boolean)offsets.isEndOfLineComment(p1));
        LineCommentOffsetsTest.assertTrue((boolean)offsets.isEndOfLineComment(p2));
        LineCommentOffsetsTest.assertTrue((boolean)offsets.isEndOfLineComment(p3));
        LineCommentOffsetsTest.assertTrue((boolean)offsets.isEndOfLineComment(p4));
        boolean res = offsets.remove(p2);
        LineCommentOffsetsTest.assertTrue((boolean)res);
        res = offsets.remove(p2);
        LineCommentOffsetsTest.assertFalse((boolean)res);
        LineCommentOffsetsTest.assertFalse((boolean)offsets.isEndOfLineComment(0));
        LineCommentOffsetsTest.assertTrue((boolean)offsets.isEndOfLineComment(p1));
        LineCommentOffsetsTest.assertFalse((boolean)offsets.isEndOfLineComment(p2));
        LineCommentOffsetsTest.assertTrue((boolean)offsets.isEndOfLineComment(p3));
        LineCommentOffsetsTest.assertTrue((boolean)offsets.isEndOfLineComment(p4));
        res = offsets.remove(p4);
        LineCommentOffsetsTest.assertTrue((boolean)res);
        LineCommentOffsetsTest.assertFalse((boolean)offsets.isEndOfLineComment(0));
        LineCommentOffsetsTest.assertTrue((boolean)offsets.isEndOfLineComment(p1));
        LineCommentOffsetsTest.assertFalse((boolean)offsets.isEndOfLineComment(p2));
        LineCommentOffsetsTest.assertTrue((boolean)offsets.isEndOfLineComment(p3));
        LineCommentOffsetsTest.assertFalse((boolean)offsets.isEndOfLineComment(p4));
        res = offsets.remove(p1);
        LineCommentOffsetsTest.assertTrue((boolean)res);
        LineCommentOffsetsTest.assertFalse((boolean)offsets.isEndOfLineComment(0));
        LineCommentOffsetsTest.assertFalse((boolean)offsets.isEndOfLineComment(p1));
        LineCommentOffsetsTest.assertFalse((boolean)offsets.isEndOfLineComment(p2));
        LineCommentOffsetsTest.assertTrue((boolean)offsets.isEndOfLineComment(p3));
        LineCommentOffsetsTest.assertFalse((boolean)offsets.isEndOfLineComment(p4));
    }

    public void testLineCommentEndOffsets() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("/* comment */\n");
        buf.append("// comment Y\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        while (i == 0) {\n");
        buf.append("            foo();\n");
        buf.append("            i++; // comment Y\n");
        buf.append("            i++;\n");
        buf.append("        }// comment// comment Y\n");
        buf.append("        return;\n");
        buf.append("    }\n");
        buf.append("} // comment Y");
        String content = buf.toString();
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", content, false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        LineCommentEndOffsets offsets = new LineCommentEndOffsets(astRoot.getCommentList());
        HashSet<Integer> expectedOffsets = new HashSet<Integer>();
        int i = 0;
        while (i < content.length()) {
            char ch = content.charAt(i);
            if (ch == 'Y') {
                expectedOffsets.add(new Integer(i + 1));
            }
            ++i;
        }
        int count = 0;
        char[] charContent = content.toCharArray();
        int i2 = 0;
        while (i2 <= content.length() + 5) {
            boolean expected = i2 > 0 && i2 <= content.length() && charContent[i2 - 1] == 'Y';
            boolean actual = offsets.isEndOfLineComment(i2, charContent);
            LineCommentOffsetsTest.assertEquals((boolean)expected, (boolean)actual);
            actual = offsets.isEndOfLineComment(i2);
            LineCommentOffsetsTest.assertEquals((boolean)expected, (boolean)actual);
            if (expected) {
                ++count;
            }
            ++i2;
        }
        LineCommentOffsetsTest.assertEquals((int)4, (int)count);
    }

    public void testLineCommentEndOffsetsMixedLineDelimiter() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("/* comment */\r\n");
        buf.append("// comment Y\n");
        buf.append("public class E {\r\n");
        buf.append("    public void foo() {\n");
        buf.append("        while (i == 0) {\n");
        buf.append("            foo();\n");
        buf.append("            i++; // comment Y\r\n");
        buf.append("            i++;\n");
        buf.append("        }// comment// comment Y\r");
        buf.append("        return;\n");
        buf.append("    }\r\n");
        buf.append("} // comment Y");
        String content = buf.toString();
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", content, false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        LineCommentEndOffsets offsets = new LineCommentEndOffsets(astRoot.getCommentList());
        HashSet<Integer> expectedOffsets = new HashSet<Integer>();
        int i = 0;
        while (i < content.length()) {
            char ch = content.charAt(i);
            if (ch == 'Y') {
                expectedOffsets.add(new Integer(i + 1));
            }
            ++i;
        }
        int count = 0;
        char[] charContent = content.toCharArray();
        int i2 = 0;
        while (i2 <= content.length() + 5) {
            boolean expected = i2 > 0 && i2 <= content.length() && charContent[i2 - 1] == 'Y';
            boolean actual = offsets.isEndOfLineComment(i2, charContent);
            LineCommentOffsetsTest.assertEquals((boolean)expected, (boolean)actual);
            if (expected) {
                ++count;
            }
            ++i2;
        }
        LineCommentOffsetsTest.assertEquals((int)4, (int)count);
    }

    public void testBug95839() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("function foo() {\n");
        buf.append("  object.method(\n");
        buf.append("    param1, // text about param1\n");
        buf.append("    param2  // text about param2\n");
        buf.append("  );\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST3(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        LineCommentOffsetsTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        FunctionDeclaration function = LineCommentOffsetsTest.findMethodDeclaration(astRoot, "foo");
        ExpressionStatement statement = (ExpressionStatement)function.getBody().statements().get(0);
        FunctionInvocation inv = (FunctionInvocation)statement.getExpression();
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)inv, FunctionInvocation.ARGUMENTS_PROPERTY);
        listRewrite.insertLast((ASTNode)ast.newSimpleName("param3"), null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("function foo() {\n");
        buf.append("  object.method(\n");
        buf.append("    param1, // text about param1\n");
        buf.append("    param2  // text about param2\n");
        buf.append(", param3\n");
        buf.append("  );\n");
        buf.append("}\n");
        LineCommentOffsetsTest.assertEqualString(preview, buf.toString());
    }

    public void testBug128818() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("function foo() {\n");
        buf.append("  if (true) {\n");
        buf.append("  } // comment\n");
        buf.append("  else\n");
        buf.append("    return;\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST3(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        LineCommentOffsetsTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        FunctionDeclaration function = LineCommentOffsetsTest.findMethodDeclaration(astRoot, "foo");
        IfStatement statement = (IfStatement)function.getBody().statements().get(0);
        rewrite.set((ASTNode)statement, (StructuralPropertyDescriptor)IfStatement.ELSE_STATEMENT_PROPERTY, (Object)ast.newBlock(), null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("function foo() {\n");
        buf.append("  if (true) {\n");
        buf.append("  } // comment\n");
        buf.append(" else {\n");
        buf.append("}\n");
        buf.append("}\n");
        LineCommentOffsetsTest.assertEqualString(preview, buf.toString());
    }

    public void testCommentAtEnd() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("function E() \n");
        buf.append("{\n");
        buf.append("}//comment");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST3(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        LineCommentOffsetsTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)astRoot, JavaScriptUnit.STATEMENTS_PROPERTY);
        FunctionDeclaration newFunction = ast.newFunctionDeclaration();
        newFunction.setName(ast.newSimpleName("B"));
        listRewrite.insertLast((ASTNode)newFunction, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("function E() \n");
        buf.append("{\n");
        buf.append("}//comment\n");
        buf.append("\n");
        buf.append("function B() {\n");
        buf.append("}");
        LineCommentOffsetsTest.assertEqualString(preview, buf.toString());
    }
}

