/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.rewrite.modifying;

import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import junit.framework.ComparisonFailure;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavaModelTests;
import org.eclipse.wst.jsdt.core.tests.rewrite.describing.StringAsserts;
import org.eclipse.wst.jsdt.core.tests.rewrite.modifying.ASTRewritingModifyingInsertTest;
import org.eclipse.wst.jsdt.core.tests.rewrite.modifying.ASTRewritingModifyingOtherTest;
import org.eclipse.wst.jsdt.core.tests.rewrite.modifying.ASTRewritingModifyingRemoveTest;
import org.eclipse.wst.jsdt.core.tests.rewrite.modifying.ASTRewritingModifyingReplaceTest;

public abstract class ASTRewritingModifyingTest
extends AbstractJavaModelTests {
    private static final int AST_INTERNAL_JLS2 = 2;
    protected IJavaScriptProject fJProject1;
    protected IPackageFragmentRoot fSourceFolder;
    private Hashtable oldOptions;
    static /* synthetic */ Class class$0;

    public ASTRewritingModifyingTest(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.rewrite.modifying.ASTRewritingModifyingTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite suite = new TestSuite(clazz.getName());
        suite.addTest(ASTRewritingModifyingOtherTest.suite());
        suite.addTest(ASTRewritingModifyingInsertTest.suite());
        suite.addTest(ASTRewritingModifyingReplaceTest.suite());
        suite.addTest(ASTRewritingModifyingRemoveTest.suite());
        return suite;
    }

    public void setUpSuite() throws Exception {
        super.setUpSuite();
        this.fJProject1 = this.createJavaProject("P", new String[]{"src"});
        this.fSourceFolder = this.getPackageFragmentRoot("P", "src");
        Hashtable options = JavaScriptCore.getOptions();
        this.oldOptions = (Hashtable)options.clone();
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "space");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.size", "4");
        JavaScriptCore.setOptions((Hashtable)options);
        ASTRewritingModifyingTest.waitUntilIndexesReady();
    }

    public void tearDownSuite() throws Exception {
        this.deleteProject("P");
        JavaScriptCore.setOptions((Hashtable)this.oldOptions);
        super.tearDownSuite();
    }

    public JavaScriptUnit createCU(IJavaScriptUnit unit, boolean resolveBindings) {
        try {
            ASTParser c = ASTParser.newParser((int)2);
            c.setSource(unit);
            c.setResolveBindings(resolveBindings);
            ASTNode result = c.createAST(null);
            return (JavaScriptUnit)result;
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalArgumentException();
        }
    }

    public JavaScriptUnit createCU(char[] source) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        ASTParser c = ASTParser.newParser((int)2);
        c.setSource(source);
        ASTNode result = c.createAST(null);
        return (JavaScriptUnit)result;
    }

    public String evaluateRewrite(IJavaScriptUnit cu, JavaScriptUnit astRoot) throws CoreException, MalformedTreeException, BadLocationException {
        return this.evaluateRewrite(cu.getSource(), astRoot, cu.getJavaScriptProject().getOptions(true));
    }

    public String evaluateRewrite(String source, JavaScriptUnit astRoot) throws MalformedTreeException, BadLocationException {
        return this.evaluateRewrite(source, astRoot, this.getJavaProject("Rewrite").getOptions(true));
    }

    public String evaluateRewrite(String source, JavaScriptUnit astRoot, Map options) throws MalformedTreeException, BadLocationException {
        Document doc = new Document(source);
        TextEdit changes = astRoot.rewrite((IDocument)doc, options);
        changes.apply((IDocument)doc);
        return doc.get();
    }

    public static void assertEqualString(String actual, String expected) {
        try {
            StringAsserts.assertEqualString(actual, expected);
        }
        catch (ComparisonFailure e) {
            System.out.println(ASTRewritingModifyingTest.displayActual(actual, 2));
            throw e;
        }
    }

    public static String displayActual(String inputString, int indent) {
        int length = inputString.length();
        StringBuffer buffer = new StringBuffer(length);
        StringTokenizer tokenizer = new StringTokenizer(inputString, "\n\r", true);
        int i = 0;
        while (i < indent) {
            buffer.append("\t");
            ++i;
        }
        buffer.append("buf.append(\"");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("\r")) {
                buffer.append("\\r");
                if (!tokenizer.hasMoreTokens()) continue;
                token = tokenizer.nextToken();
                if (token.equals("\n")) {
                    buffer.append("\\n");
                    if (!tokenizer.hasMoreTokens()) continue;
                    buffer.append("\");\n");
                    int i2 = 0;
                    while (i2 < indent) {
                        buffer.append("\t");
                        ++i2;
                    }
                    buffer.append("buf.append(\"");
                    continue;
                }
                buffer.append("\");\n");
                int i3 = 0;
                while (i3 < indent) {
                    buffer.append("\t");
                    ++i3;
                }
                buffer.append("buf.append(\"");
            } else if (token.equals("\n")) {
                buffer.append("\\n");
                if (!tokenizer.hasMoreTokens()) continue;
                buffer.append("\");\n");
                int i4 = 0;
                while (i4 < indent) {
                    buffer.append("\t");
                    ++i4;
                }
                buffer.append("buf.append(\"");
                continue;
            }
            StringBuffer tokenBuffer = new StringBuffer();
            int i5 = 0;
            while (i5 < token.length()) {
                char c = token.charAt(i5);
                switch (c) {
                    case '\r': {
                        tokenBuffer.append("\\r");
                        break;
                    }
                    case '\n': {
                        tokenBuffer.append("\\n");
                        break;
                    }
                    case '\b': {
                        tokenBuffer.append("\\b");
                        break;
                    }
                    case '\t': {
                        tokenBuffer.append("\t");
                        break;
                    }
                    case '\f': {
                        tokenBuffer.append("\\f");
                        break;
                    }
                    case '\"': {
                        tokenBuffer.append("\\\"");
                        break;
                    }
                    case '\'': {
                        tokenBuffer.append("\\'");
                        break;
                    }
                    case '\\': {
                        tokenBuffer.append("\\\\");
                        break;
                    }
                    default: {
                        tokenBuffer.append(c);
                    }
                }
                ++i5;
            }
            buffer.append(tokenBuffer.toString());
        }
        buffer.append("\");");
        return buffer.toString();
    }
}

