/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.test.util.mock;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeSettings;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jst.jsf.test.util.mock.FileSpec;

public class MockContentType
implements IContentType {
    static final int SPEC_PRE_DEFINED = 1;
    static final int SPEC_USER_DEFINED = 2;
    static final byte ASSOCIATED_BY_EXTENSION = 2;
    static final byte ASSOCIATED_BY_NAME = 1;
    static final byte NOT_ASSOCIATED = 0;
    private CopyOnWriteArrayList<FileSpec> fileSpecs = new CopyOnWriteArrayList();
    private final IScopeContext _context = new InstanceScope();
    private final String _id;
    private boolean _builtInAssociations;

    public MockContentType(String id) {
        this._id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileSpec(String fileSpec, int type) throws CoreException {
        Assert.isLegal((type == 8 || type == 4 ? 1 : 0) != 0, (String)("Unknown type: " + type));
        MockContentType mockContentType = this;
        synchronized (mockContentType) {
            if (!this.internalAddFileSpec(fileSpec, type | 2)) {
                return;
            }
        }
    }

    boolean internalAddFileSpec(String fileSpec, int typeMask) {
        if (this.hasFileSpec(fileSpec, typeMask, false)) {
            return false;
        }
        FileSpec newFileSpec = MockContentType.createFileSpec(fileSpec, typeMask);
        if ((typeMask & 2) == 0) {
            if (this.fileSpecs.isEmpty()) {
                this.fileSpecs = new CopyOnWriteArrayList();
            }
            this.fileSpecs.add(newFileSpec);
            return true;
        }
        return true;
    }

    public void removeFileSpec(String fileSpec, int type) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void setDefaultCharset(String userCharset) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public IContentType getBaseType() {
        throw new UnsupportedOperationException();
    }

    public IContentDescription getDefaultDescription() {
        throw new UnsupportedOperationException();
    }

    public IContentDescription getDescriptionFor(InputStream contents, QualifiedName[] options) throws IOException {
        throw new UnsupportedOperationException();
    }

    public IContentDescription getDescriptionFor(Reader contents, QualifiedName[] options) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getDefaultCharset() {
        return "UTF-8";
    }

    public String[] getFileSpecs(int type) {
        throw new UnsupportedOperationException();
    }

    public String getId() {
        return this._id;
    }

    public String getName() {
        throw new UnsupportedOperationException();
    }

    public boolean isAssociatedWith(String fileName) {
        return this.internalIsAssociatedWith(fileName, this._context) != 0;
    }

    private byte internalIsAssociatedWith(String fileName, IScopeContext context) {
        if (this.hasFileSpec(context, fileName, 4)) {
            return 1;
        }
        String fileExtension = MockContentType.getFileExtension(fileName);
        if (this.hasFileSpec(context, fileExtension, 8)) {
            return 2;
        }
        this.hasBuiltInAssociations();
        return 0;
    }

    private boolean hasBuiltInAssociations() {
        return this._builtInAssociations;
    }

    static String getFileExtension(String fileName) {
        int dotPosition = fileName.lastIndexOf(46);
        return dotPosition == -1 || dotPosition == fileName.length() - 1 ? "" : fileName.substring(dotPosition + 1);
    }

    private boolean hasFileSpec(IScopeContext context, String text, int typeMask) {
        if (context.equals(this._context) || (typeMask & 2) != 0) {
            return this.hasFileSpec(text, typeMask, false);
        }
        return this.hasFileSpec(text, typeMask | 1, false);
    }

    private boolean hasFileSpec(String text, int typeMask, boolean strict) {
        if (this.fileSpecs.isEmpty()) {
            return false;
        }
        for (FileSpec spec : this.fileSpecs) {
            if (!spec.equals(text, typeMask, strict)) continue;
            return true;
        }
        return false;
    }

    public boolean isAssociatedWith(String fileName, IScopeContext context) {
        return this.isAssociatedWith(fileName);
    }

    public boolean isKindOf(IContentType another) {
        throw new UnsupportedOperationException();
    }

    public IContentTypeSettings getSettings(IScopeContext context) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public static IContentType createContentType(String uniqueId, String[] fileExtensions, String[] fileNames) {
        MockContentType contentType = new MockContentType(uniqueId);
        if (fileExtensions != null && fileExtensions.length > 0 || fileNames != null && fileNames.length > 0) {
            contentType._builtInAssociations = true;
            contentType.fileSpecs = new CopyOnWriteArrayList();
            int i = 0;
            while (i < fileNames.length) {
                contentType.internalAddFileSpec(fileNames[i], 5);
                ++i;
            }
            i = 0;
            while (i < fileExtensions.length) {
                contentType.internalAddFileSpec(fileExtensions[i], 9);
                ++i;
            }
        }
        return contentType;
    }

    static FileSpec createFileSpec(String fileSpec, int type) {
        return new FileSpec(fileSpec, type);
    }
}

