/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.jaxb.core.JaxbProject;
import org.eclipse.jpt.jaxb.core.JaxbWorkspace;
import org.eclipse.jpt.jaxb.core.internal.facet.JaxbFacetDataModelProperties;
import org.eclipse.jpt.jaxb.core.internal.facet.JaxbFacetInstallDataModelProvider;
import org.eclipse.jpt.jaxb.core.internal.libval.JaxbLibraryValidatorTools;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformConfig;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformManager;
import org.eclipse.jpt.jaxb.core.tests.internal.projects.TestJaxbProject;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class JaxbTestCase
extends AnnotationTestCase {
    protected static final String BASE_PROJECT_NAME = "JaxbTestProject";

    protected JaxbTestCase(String name) {
        super(name);
    }

    protected TestJavaProject buildJavaProject(boolean autoBuild) throws Exception {
        return this.buildJaxbProject(BASE_PROJECT_NAME, autoBuild, this.buildJaxbFacetInstallConfig());
    }

    protected TestJaxbProject buildJaxbProject(String projectName, boolean autoBuild, IDataModel jaxbConfig) throws Exception {
        return TestJaxbProject.buildJaxbProject(projectName, autoBuild, jaxbConfig);
    }

    protected IDataModel buildJaxbFacetInstallConfig() {
        IDataModel config = DataModelFactory.createDataModel((IDataModelProvider)new JaxbFacetInstallDataModelProvider());
        config.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)this.getProjectFacetVersion());
        config.setProperty(JaxbFacetDataModelProperties.PLATFORM, (Object)this.getPlatformConfig());
        return config;
    }

    protected final JaxbPlatformConfig getPlatformConfig() {
        return this.getJaxbPlatformManager().getJaxbPlatformConfig(this.getPlatformID());
    }

    protected String getPlatformID() {
        return this.getJaxbPlatformManager().getDefaultJaxbPlatformConfig(this.getProjectFacetVersion()).getId();
    }

    protected JaxbPlatformManager getJaxbPlatformManager() {
        return this.getJaxbWorkspace().getJaxbPlatformManager();
    }

    protected JaxbWorkspace getJaxbWorkspace() {
        return (JaxbWorkspace)ResourcesPlugin.getWorkspace().getAdapter(JaxbWorkspace.class);
    }

    protected IProjectFacetVersion getProjectFacetVersion() {
        return JaxbLibraryValidatorTools.FACET_VERSION_2_2;
    }

    protected TestJaxbProject getJavaProject() {
        return (TestJaxbProject)super.getJavaProject();
    }

    protected JaxbProject getJaxbProject() {
        return this.getJavaProject().getJaxbProject();
    }

    protected JavaResourceAttribute getFieldNamed(JavaResourceType resourceType, String attributeName) {
        for (JavaResourceAttribute attribute : resourceType.getFields()) {
            if (!attribute.getName().equals(attributeName)) continue;
            return attribute;
        }
        return null;
    }
}

