/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.XmlAttributeMapping;
import org.eclipse.jpt.jaxb.core.context.XmlElementMapping;
import org.eclipse.jpt.jaxb.core.context.XmlElementRef;
import org.eclipse.jpt.jaxb.core.context.java.JavaClass;
import org.eclipse.jpt.jaxb.core.context.java.JavaClassMapping;
import org.eclipse.jpt.jaxb.core.context.java.JavaXmlAnyElementMapping;
import org.eclipse.jpt.jaxb.core.resource.java.XmlAnyElementAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementRefAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementRefsAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlMixedAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.context.JaxbContextModelTestCase;

public class GenericJavaXmlAnyElementMappingTests
extends JaxbContextModelTestCase {
    public GenericJavaXmlAnyElementMappingTests(String name) {
        super(name);
    }

    private ICompilationUnit createTypeWithXmlAnyElement() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType", "javax.xml.bind.annotation.XmlAnyElement"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlAnyElement");
            }
        });
    }

    public void testChangeMappingType() throws Exception {
        this.createTypeWithXmlAnyElement();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        JavaXmlAnyElementMapping attributeMapping = (JavaXmlAnyElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = attributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlAnyElementMappingTests.assertNotNull((Object)attributeMapping);
        GenericJavaXmlAnyElementMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAnyElement"));
        persistentAttribute.setMappingKey("xml-attribute");
        XmlAttributeMapping xmlAttributeMapping = (XmlAttributeMapping)persistentAttribute.getMapping();
        GenericJavaXmlAnyElementMappingTests.assertNotNull((Object)xmlAttributeMapping);
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAnyElement"));
        GenericJavaXmlAnyElementMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttribute"));
        persistentAttribute.setMappingKey("xml-any-element");
        attributeMapping = (JavaXmlAnyElementMapping)persistentAttribute.getMapping();
        GenericJavaXmlAnyElementMappingTests.assertNotNull((Object)attributeMapping);
        GenericJavaXmlAnyElementMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAnyElement"));
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttribute"));
        persistentAttribute.setMappingKey("xml-element");
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        GenericJavaXmlAnyElementMappingTests.assertNotNull((Object)xmlElementMapping);
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAnyElement"));
        GenericJavaXmlAnyElementMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement"));
        persistentAttribute.setMappingKey("xml-any-element");
        attributeMapping = (JavaXmlAnyElementMapping)persistentAttribute.getMapping();
        GenericJavaXmlAnyElementMappingTests.assertNotNull((Object)attributeMapping);
        GenericJavaXmlAnyElementMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAnyElement"));
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement"));
    }

    public void testModifyXmlJavaTypeAdapter() throws Exception {
        this.createTypeWithXmlAnyElement();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        JavaXmlAnyElementMapping attributeMapping = (JavaXmlAnyElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = attributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)attributeMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlAnyElementMappingTests.assertEquals((int)0, (int)resourceAttribute.getAnnotationsSize("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"));
        attributeMapping.addXmlJavaTypeAdapter();
        GenericJavaXmlAnyElementMappingTests.assertNotNull((Object)attributeMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlAnyElementMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"));
        attributeMapping.removeXmlJavaTypeAdapter();
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)attributeMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlAnyElementMappingTests.assertEquals((int)0, (int)resourceAttribute.getAnnotationsSize("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"));
    }

    public void testUpdateXmlJavaTypeAdapter() throws Exception {
        this.createTypeWithXmlAnyElement();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        JavaXmlAnyElementMapping attributeMapping = (JavaXmlAnyElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = attributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)attributeMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlAnyElementMappingTests.assertEquals((int)0, (int)resourceAttribute.getAnnotationsSize("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"));
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAnyElementMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
            }
        });
        GenericJavaXmlAnyElementMappingTests.assertNotNull((Object)attributeMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlAnyElementMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"));
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAnyElementMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
            }
        });
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)attributeMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlAnyElementMappingTests.assertEquals((int)0, (int)resourceAttribute.getAnnotationsSize("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"));
    }

    public void testModifyLax() throws Exception {
        this.createTypeWithXmlAnyElement();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        JavaXmlAnyElementMapping attributeMapping = (JavaXmlAnyElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = attributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)attributeMapping.getSpecifiedLax());
        GenericJavaXmlAnyElementMappingTests.assertEquals((boolean)false, (boolean)attributeMapping.isDefaultLax());
        GenericJavaXmlAnyElementMappingTests.assertEquals((boolean)false, (boolean)attributeMapping.isLax());
        attributeMapping.setSpecifiedLax(Boolean.TRUE);
        XmlAnyElementAnnotation xmlAnyElementAnnotation = (XmlAnyElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAnyElement");
        GenericJavaXmlAnyElementMappingTests.assertEquals((Object)Boolean.TRUE, (Object)xmlAnyElementAnnotation.getLax());
        GenericJavaXmlAnyElementMappingTests.assertEquals((Object)Boolean.TRUE, (Object)attributeMapping.getSpecifiedLax());
        GenericJavaXmlAnyElementMappingTests.assertEquals((boolean)false, (boolean)attributeMapping.isDefaultLax());
        GenericJavaXmlAnyElementMappingTests.assertEquals((boolean)true, (boolean)attributeMapping.isLax());
        attributeMapping.setSpecifiedLax(null);
        xmlAnyElementAnnotation = (XmlAnyElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAnyElement");
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)attributeMapping.getSpecifiedLax());
        GenericJavaXmlAnyElementMappingTests.assertEquals((boolean)false, (boolean)attributeMapping.isDefaultLax());
        GenericJavaXmlAnyElementMappingTests.assertEquals((boolean)false, (boolean)attributeMapping.isLax());
    }

    public void testUpdateLax() throws Exception {
        this.createTypeWithXmlAnyElement();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        JavaXmlAnyElementMapping attributeMapping = (JavaXmlAnyElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = attributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)attributeMapping.getSpecifiedLax());
        GenericJavaXmlAnyElementMappingTests.assertEquals((boolean)false, (boolean)attributeMapping.isDefaultLax());
        GenericJavaXmlAnyElementMappingTests.assertEquals((boolean)false, (boolean)attributeMapping.isLax());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAnyElementMappingTests.this.addXmlAnyElementMemberValuePair(declaration, "lax", true);
            }
        });
        GenericJavaXmlAnyElementMappingTests.assertEquals((Object)Boolean.TRUE, (Object)attributeMapping.getSpecifiedLax());
        GenericJavaXmlAnyElementMappingTests.assertEquals((boolean)false, (boolean)attributeMapping.isDefaultLax());
        GenericJavaXmlAnyElementMappingTests.assertEquals((boolean)true, (boolean)attributeMapping.isLax());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation xmlElementAnnotation = (NormalAnnotation)GenericJavaXmlAnyElementMappingTests.this.getXmlAnyElementAnnotation(declaration);
                GenericJavaXmlAnyElementMappingTests.this.values(xmlElementAnnotation).remove(0);
            }
        });
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)attributeMapping.getSpecifiedLax());
        GenericJavaXmlAnyElementMappingTests.assertEquals((boolean)false, (boolean)attributeMapping.isDefaultLax());
        GenericJavaXmlAnyElementMappingTests.assertEquals((boolean)false, (boolean)attributeMapping.isLax());
    }

    public void testModifyValue() throws Exception {
        this.createTypeWithXmlAnyElement();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        JavaXmlAnyElementMapping attributeMapping = (JavaXmlAnyElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = attributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)attributeMapping.getSpecifiedValue());
        attributeMapping.setSpecifiedValue("Foo");
        XmlAnyElementAnnotation xmlElementAnnotation = (XmlAnyElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAnyElement");
        GenericJavaXmlAnyElementMappingTests.assertEquals((String)"Foo", (String)attributeMapping.getSpecifiedValue());
        GenericJavaXmlAnyElementMappingTests.assertEquals((String)"Foo", (String)attributeMapping.getValue());
        attributeMapping.setSpecifiedValue(null);
        xmlElementAnnotation = (XmlAnyElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAnyElement");
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)xmlElementAnnotation.getValue());
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)attributeMapping.getSpecifiedValue());
    }

    public void testUpdateValue() throws Exception {
        this.createTypeWithXmlAnyElement();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        JavaXmlAnyElementMapping attributeMapping = (JavaXmlAnyElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = attributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)attributeMapping.getSpecifiedValue());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAnyElementMappingTests.this.addXmlAnyElementTypeMemberValuePair(declaration, "value", "Foo");
            }
        });
        GenericJavaXmlAnyElementMappingTests.assertEquals((String)"Foo", (String)attributeMapping.getValue());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation xmlElementAnnotation = (NormalAnnotation)GenericJavaXmlAnyElementMappingTests.this.getXmlAnyElementAnnotation(declaration);
                GenericJavaXmlAnyElementMappingTests.this.values(xmlElementAnnotation).remove(0);
            }
        });
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)attributeMapping.getSpecifiedValue());
    }

    protected Annotation getXmlAnyElementAnnotation(ModifiedDeclaration declaration) {
        return declaration.getAnnotationNamed("javax.xml.bind.annotation.XmlAnyElement");
    }

    protected void addXmlAnyElementMemberValuePair(ModifiedDeclaration declaration, String name, boolean value) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlAnyElementAnnotation(declaration), name, value);
    }

    protected void addXmlAnyElementTypeMemberValuePair(ModifiedDeclaration declaration, String name, String typeName) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlAnyElementAnnotation(declaration), name, (Expression)this.newTypeLiteral(declaration.getAst(), typeName));
    }

    public void testSyncXmlElementRefs() throws Exception {
        this.createTypeWithXmlAnyElement();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        JavaXmlAnyElementMapping attributeMapping = (JavaXmlAnyElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = attributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        ListIterable xmlElementRefs = attributeMapping.getXmlElementRefs().getXmlElementRefs();
        GenericJavaXmlAnyElementMappingTests.assertTrue((boolean)IterableTools.isEmpty((Iterable)xmlElementRefs));
        GenericJavaXmlAnyElementMappingTests.assertEquals((int)0, (int)attributeMapping.getXmlElementRefs().getXmlElementRefsSize());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAnyElementMappingTests.this.addMemberValuePair(GenericJavaXmlAnyElementMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlElementRef"), "name", "foo");
            }
        });
        xmlElementRefs = attributeMapping.getXmlElementRefs().getXmlElementRefs();
        GenericJavaXmlAnyElementMappingTests.assertFalse((boolean)IterableTools.isEmpty((Iterable)attributeMapping.getXmlElementRefs().getXmlElementRefs()));
        GenericJavaXmlAnyElementMappingTests.assertEquals((int)1, (int)attributeMapping.getXmlElementRefs().getXmlElementRefsSize());
        GenericJavaXmlAnyElementMappingTests.assertEquals((String)"foo", (String)((XmlElementRef)IterableTools.get((Iterable)xmlElementRefs, (int)0)).getQName().getName());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAnyElementMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlElementRefs");
                NormalAnnotation annotation = GenericJavaXmlAnyElementMappingTests.this.newNormalAnnotation(declaration.getAst(), "javax.xml.bind.annotation.XmlElementRef");
                GenericJavaXmlAnyElementMappingTests.this.addMemberValuePair(annotation, "name", "bar");
                GenericJavaXmlAnyElementMappingTests.this.addArrayElement(declaration, "javax.xml.bind.annotation.XmlElementRefs", 0, "value", (Expression)annotation);
            }
        });
        xmlElementRefs = attributeMapping.getXmlElementRefs().getXmlElementRefs();
        GenericJavaXmlAnyElementMappingTests.assertFalse((boolean)IterableTools.isEmpty((Iterable)attributeMapping.getXmlElementRefs().getXmlElementRefs()));
        GenericJavaXmlAnyElementMappingTests.assertEquals((int)1, (int)attributeMapping.getXmlElementRefs().getXmlElementRefsSize());
        GenericJavaXmlAnyElementMappingTests.assertEquals((String)"bar", (String)((XmlElementRef)IterableTools.get((Iterable)xmlElementRefs, (int)0)).getQName().getName());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation annotation = GenericJavaXmlAnyElementMappingTests.this.newNormalAnnotation(declaration.getAst(), "javax.xml.bind.annotation.XmlElementRef");
                GenericJavaXmlAnyElementMappingTests.this.addMemberValuePair(annotation, "name", "baz");
                GenericJavaXmlAnyElementMappingTests.this.addArrayElement(declaration, "javax.xml.bind.annotation.XmlElementRefs", 1, "value", (Expression)annotation);
            }
        });
        xmlElementRefs = attributeMapping.getXmlElementRefs().getXmlElementRefs();
        GenericJavaXmlAnyElementMappingTests.assertFalse((boolean)IterableTools.isEmpty((Iterable)attributeMapping.getXmlElementRefs().getXmlElementRefs()));
        GenericJavaXmlAnyElementMappingTests.assertEquals((int)2, (int)attributeMapping.getXmlElementRefs().getXmlElementRefsSize());
        GenericJavaXmlAnyElementMappingTests.assertEquals((String)"bar", (String)((XmlElementRef)IterableTools.get((Iterable)xmlElementRefs, (int)0)).getQName().getName());
        GenericJavaXmlAnyElementMappingTests.assertEquals((String)"baz", (String)((XmlElementRef)IterableTools.get((Iterable)xmlElementRefs, (int)1)).getQName().getName());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAnyElementMappingTests.this.moveArrayElement((NormalAnnotation)declaration.getAnnotationNamed("javax.xml.bind.annotation.XmlElementRefs"), "value", 0, 1);
            }
        });
        xmlElementRefs = attributeMapping.getXmlElementRefs().getXmlElementRefs();
        GenericJavaXmlAnyElementMappingTests.assertFalse((boolean)IterableTools.isEmpty((Iterable)attributeMapping.getXmlElementRefs().getXmlElementRefs()));
        GenericJavaXmlAnyElementMappingTests.assertEquals((int)2, (int)attributeMapping.getXmlElementRefs().getXmlElementRefsSize());
        GenericJavaXmlAnyElementMappingTests.assertEquals((String)"baz", (String)((XmlElementRef)IterableTools.get((Iterable)xmlElementRefs, (int)0)).getQName().getName());
        GenericJavaXmlAnyElementMappingTests.assertEquals((String)"bar", (String)((XmlElementRef)IterableTools.get((Iterable)xmlElementRefs, (int)1)).getQName().getName());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAnyElementMappingTests.this.removeArrayElement((NormalAnnotation)declaration.getAnnotationNamed("javax.xml.bind.annotation.XmlElementRefs"), "value", 1);
                GenericJavaXmlAnyElementMappingTests.this.removeArrayElement((NormalAnnotation)declaration.getAnnotationNamed("javax.xml.bind.annotation.XmlElementRefs"), "value", 0);
                GenericJavaXmlAnyElementMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlElementRefs");
            }
        });
        xmlElementRefs = attributeMapping.getXmlElementRefs().getXmlElementRefs();
        GenericJavaXmlAnyElementMappingTests.assertFalse((boolean)IterableTools.isEmpty((Iterable)attributeMapping.getXmlElementRefs().getXmlElementRefs()));
        GenericJavaXmlAnyElementMappingTests.assertEquals((int)1, (int)attributeMapping.getXmlElementRefs().getXmlElementRefsSize());
        GenericJavaXmlAnyElementMappingTests.assertEquals((String)"foo", (String)((XmlElementRef)IterableTools.get((Iterable)xmlElementRefs, (int)0)).getQName().getName());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAnyElementMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlElementRef");
            }
        });
        xmlElementRefs = attributeMapping.getXmlElementRefs().getXmlElementRefs();
        GenericJavaXmlAnyElementMappingTests.assertTrue((boolean)IterableTools.isEmpty((Iterable)attributeMapping.getXmlElementRefs().getXmlElementRefs()));
        GenericJavaXmlAnyElementMappingTests.assertEquals((int)0, (int)attributeMapping.getXmlElementRefs().getXmlElementRefsSize());
    }

    public void testModifyXmlElementRefs() throws Exception {
        this.createTypeWithXmlAnyElement();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        JavaXmlAnyElementMapping attributeMapping = (JavaXmlAnyElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = attributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementRefs"));
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementRef"));
        GenericJavaXmlAnyElementMappingTests.assertEquals((int)0, (int)attributeMapping.getXmlElementRefs().getXmlElementRefsSize());
        attributeMapping.getXmlElementRefs().addXmlElementRef(0).getQName().setSpecifiedName("foo");
        XmlElementRefsAnnotation xmlElementRefsAnnotation = (XmlElementRefsAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementRefs");
        XmlElementRefAnnotation xmlElementRefAnnotation = (XmlElementRefAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementRef");
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)xmlElementRefsAnnotation);
        GenericJavaXmlAnyElementMappingTests.assertNotNull((Object)xmlElementRefAnnotation);
        GenericJavaXmlAnyElementMappingTests.assertEquals((String)"foo", (String)xmlElementRefAnnotation.getName());
        attributeMapping.getXmlElementRefs().addXmlElementRef(1).getQName().setSpecifiedName("bar");
        xmlElementRefsAnnotation = (XmlElementRefsAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementRefs");
        xmlElementRefAnnotation = (XmlElementRefAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementRef");
        GenericJavaXmlAnyElementMappingTests.assertNotNull((Object)xmlElementRefsAnnotation);
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)xmlElementRefAnnotation);
        GenericJavaXmlAnyElementMappingTests.assertEquals((int)2, (int)attributeMapping.getXmlElementRefs().getXmlElementRefsSize());
        GenericJavaXmlAnyElementMappingTests.assertEquals((String)"foo", (String)((XmlElementRefAnnotation)IterableTools.get((Iterable)xmlElementRefsAnnotation.getXmlElementRefs(), (int)0)).getName());
        GenericJavaXmlAnyElementMappingTests.assertEquals((String)"bar", (String)((XmlElementRefAnnotation)IterableTools.get((Iterable)xmlElementRefsAnnotation.getXmlElementRefs(), (int)1)).getName());
        attributeMapping.getXmlElementRefs().moveXmlElementRef(0, 1);
        xmlElementRefsAnnotation = (XmlElementRefsAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementRefs");
        xmlElementRefAnnotation = (XmlElementRefAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementRef");
        GenericJavaXmlAnyElementMappingTests.assertNotNull((Object)xmlElementRefsAnnotation);
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)xmlElementRefAnnotation);
        GenericJavaXmlAnyElementMappingTests.assertEquals((int)2, (int)attributeMapping.getXmlElementRefs().getXmlElementRefsSize());
        GenericJavaXmlAnyElementMappingTests.assertEquals((String)"bar", (String)((XmlElementRefAnnotation)IterableTools.get((Iterable)xmlElementRefsAnnotation.getXmlElementRefs(), (int)0)).getName());
        GenericJavaXmlAnyElementMappingTests.assertEquals((String)"foo", (String)((XmlElementRefAnnotation)IterableTools.get((Iterable)xmlElementRefsAnnotation.getXmlElementRefs(), (int)1)).getName());
        attributeMapping.getXmlElementRefs().removeXmlElementRef(0);
        xmlElementRefsAnnotation = (XmlElementRefsAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementRefs");
        xmlElementRefAnnotation = (XmlElementRefAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementRef");
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)xmlElementRefsAnnotation);
        GenericJavaXmlAnyElementMappingTests.assertNotNull((Object)xmlElementRefAnnotation);
        GenericJavaXmlAnyElementMappingTests.assertEquals((int)1, (int)attributeMapping.getXmlElementRefs().getXmlElementRefsSize());
        GenericJavaXmlAnyElementMappingTests.assertEquals((String)"foo", (String)xmlElementRefAnnotation.getName());
        attributeMapping.getXmlElementRefs().removeXmlElementRef(0);
        xmlElementRefsAnnotation = (XmlElementRefsAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementRefs");
        xmlElementRefAnnotation = (XmlElementRefAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementRef");
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementRefs"));
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementRef"));
        GenericJavaXmlAnyElementMappingTests.assertEquals((int)0, (int)attributeMapping.getXmlElementRefs().getXmlElementRefsSize());
    }

    public void testModifyXmlMixed() throws Exception {
        this.createTypeWithXmlAnyElement();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        JavaXmlAnyElementMapping attributeMapping = (JavaXmlAnyElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = attributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlMixedAnnotation xmlListAnnotation = (XmlMixedAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlMixed");
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)attributeMapping.getXmlMixed());
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)xmlListAnnotation);
        attributeMapping.addXmlMixed();
        xmlListAnnotation = (XmlMixedAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlMixed");
        GenericJavaXmlAnyElementMappingTests.assertNotNull((Object)attributeMapping.getXmlMixed());
        GenericJavaXmlAnyElementMappingTests.assertNotNull((Object)xmlListAnnotation);
        attributeMapping.removeXmlMixed();
        xmlListAnnotation = (XmlMixedAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlMixed");
    }

    public void testUpdateXmlMixed() throws Exception {
        this.createTypeWithXmlAnyElement();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        JavaXmlAnyElementMapping attributeMapping = (JavaXmlAnyElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = attributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlMixedAnnotation xmlListAnnotation = (XmlMixedAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlMixed");
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)attributeMapping.getXmlMixed());
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)xmlListAnnotation);
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAnyElementMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlMixed");
            }
        });
        xmlListAnnotation = (XmlMixedAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlMixed");
        GenericJavaXmlAnyElementMappingTests.assertNotNull((Object)attributeMapping.getXmlMixed());
        GenericJavaXmlAnyElementMappingTests.assertNotNull((Object)xmlListAnnotation);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAnyElementMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlMixed");
            }
        });
        xmlListAnnotation = (XmlMixedAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlMixed");
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)attributeMapping.getXmlMixed());
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)xmlListAnnotation);
    }
}

