/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.listeners;

import org.eclipse.jpt.common.ui.internal.plugin.JptCommonUiPlugin;
import org.eclipse.jpt.common.ui.internal.swt.widgets.DisplayTools;
import org.eclipse.jpt.common.utility.internal.RunnableAdapter;
import org.eclipse.jpt.common.utility.internal.collection.SynchronizedQueue;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;

public class SWTPropertyChangeListenerWrapper
implements PropertyChangeListener {
    private final PropertyChangeListener listener;
    private final SynchronizedQueue<PropertyChangeEvent> events = new SynchronizedQueue();

    public SWTPropertyChangeListenerWrapper(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listener = listener;
    }

    public void propertyChanged(PropertyChangeEvent event) {
        this.events.enqueue((Object)event);
        this.execute((Runnable)((Object)new ForwardEventsRunnable()));
    }

    void forwardEvents() {
        for (PropertyChangeEvent event : this.events.drain()) {
            try {
                this.listener.propertyChanged(event);
            }
            catch (RuntimeException ex) {
                JptCommonUiPlugin.instance().logError(ex);
            }
        }
    }

    private void execute(Runnable r) {
        DisplayTools.execute(r);
    }

    public String toString() {
        return "SWT(" + this.listener + ')';
    }

    class ForwardEventsRunnable
    extends RunnableAdapter {
        ForwardEventsRunnable() {
        }

        public void run() {
            SWTPropertyChangeListenerWrapper.this.forwardEvents();
        }
    }
}

