/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards.gen;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jpt.common.core.internal.utility.JavaProjectTools;
import org.eclipse.jpt.common.core.internal.utility.PackageFragmentRootTools;
import org.eclipse.jpt.common.ui.internal.WorkbenchTools;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.gen.internal.ORMGenCustomizer;
import org.eclipse.jpt.jpa.gen.internal.ORMGenTable;
import org.eclipse.jpt.jpa.ui.internal.JpaHelpContextIds;
import org.eclipse.jpt.jpa.ui.internal.plugin.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.GenerateEntitiesFromSchemaWizard;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.TableGenPanel;
import org.eclipse.jpt.jpa.ui.wizards.gen.JptJpaUiWizardsEntityGenMessages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTableGenerationWizardPage
extends NewTypeWizardPage {
    protected JpaProject jpaProject;
    protected ORMGenTable defaultsTable;
    protected ORMGenCustomizer customizer;
    protected TableGenPanel defaultTableGenPanel;
    protected static String SERIALIZABLE_INTERFACE = ORMGenTable.SERIALIZABLE_INTERFACE;

    public DefaultTableGenerationWizardPage(JpaProject jpaProject) {
        super(true, "DefaultTableGenerationWizardPage");
        this.jpaProject = jpaProject;
        this.setTitle(JptJpaUiWizardsEntityGenMessages.GenerateEntitiesWizard_defaultTablePage_title);
        this.setDescription(JptJpaUiWizardsEntityGenMessages.GenerateEntitiesWizard_defaultTablePage_desc);
    }

    public void init(IStructuredSelection selection) {
        Object jelem = null;
        jelem = selection != null && selection.getFirstElement() instanceof IJavaElement ? (IJavaElement)selection.getFirstElement() : this.jpaProject.getJavaProject();
        if (jelem != null) {
            this.initContainerPage((IJavaElement)jelem);
            this.initTypePage((IJavaElement)jelem);
        }
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        WorkbenchTools.setHelp((Control)composite, (String)JpaHelpContextIds.GENERATE_ENTITIES_WIZARD_CUSTOMIZE_DEFAULT_ENTITY_GENERATION);
        this.defaultTableGenPanel = new TableGenPanel(composite, 4, true, (WizardPage)this);
        this.createDomainJavaClassesPropertiesGroup(composite, 4);
        this.setControl((Control)composite);
        this.setPageComplete(true);
    }

    public void setVisible(boolean visible) {
        ORMGenCustomizer customizer;
        super.setVisible(visible);
        if (visible && this.customizer != (customizer = this.getCustomizer())) {
            this.customizer = customizer;
            this.defaultsTable = customizer.createGenTable(null);
            this.defaultTableGenPanel.setORMGenTable(this.defaultsTable);
            this.defaultTableGenPanel.updateControls();
            this.setTableSuperClass(this.defaultsTable);
            this.setTableSuperInterfaces(this.defaultsTable);
            IPackageFragmentRoot root = this.getSourceFolder(this.defaultsTable.getSourceFolder());
            String initPackageName = this.getPackageText();
            if (initPackageName.length() == 0) {
                this.setPackageName(root, this.defaultsTable.getPackage());
            }
            this.setPackageFragmentRoot(root, true);
        }
    }

    private void setTableSuperClass(ORMGenTable genTable) {
        String baseClass = genTable.getExtends() == null ? "" : genTable.getExtends();
        this.setSuperClass(baseClass, true);
    }

    private void setTableSuperInterfaces(ORMGenTable genTable) {
        ArrayList<String> superInterfaces = new ArrayList<String>(genTable.getImplements());
        if (!this.interfacesHasSerializable(superInterfaces)) {
            superInterfaces.add(SERIALIZABLE_INTERFACE);
        }
        this.setSuperInterfaces(superInterfaces, true);
    }

    private boolean interfacesHasSerializable(List<String> interfaces) {
        for (String interf : interfaces) {
            if (!interf.equals(SERIALIZABLE_INTERFACE)) continue;
            return true;
        }
        return false;
    }

    private IPackageFragmentRoot getSourceFolder(String srcFolder) {
        IPackageFragmentRoot packageFragmentRoot = null;
        srcFolder = String.valueOf('/') + srcFolder;
        IJavaProject javaProject = this.jpaProject.getJavaProject();
        for (IPackageFragmentRoot root : JavaProjectTools.getSourceFolders((IJavaProject)javaProject)) {
            if (packageFragmentRoot == null) {
                packageFragmentRoot = root;
            }
            if (!root.getPath().toString().equals(srcFolder)) continue;
            packageFragmentRoot = root;
            break;
        }
        return packageFragmentRoot;
    }

    private void setPackageName(IPackageFragmentRoot packageFragmentRoot, String packageName) {
        if (packageName == null || packageName.length() == 0 || packageFragmentRoot == null) {
            return;
        }
        IPackageFragment packageFragment = packageFragmentRoot.getPackageFragment(packageName);
        this.setPackageFragment(packageFragment, true);
    }

    protected void createDomainJavaClassesPropertiesGroup(Composite composite, int columns) {
        Group parent = new Group(composite, 0);
        parent.setText(JptJpaUiWizardsEntityGenMessages.GenerateEntitiesWizard_defaultTablePage_domainJavaClass);
        parent.setLayout((Layout)new GridLayout(columns, false));
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = columns;
        layoutData.verticalAlignment = 4;
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        parent.setLayoutData((Object)layoutData);
        this.createContainerControls((Composite)parent, columns);
        this.createPackageControls((Composite)parent, columns);
        this.createSuperClassControls((Composite)parent, columns);
        this.createSuperInterfacesControls((Composite)parent, columns);
    }

    protected IStatus packageChanged() {
        IStatus status = super.packageChanged();
        IPackageFragment packageFragment = this.getPackageFragment();
        if (this.defaultsTable != null && !status.matches(4)) {
            this.defaultsTable.setPackage(packageFragment.getElementName());
        }
        return status;
    }

    protected IStatus superClassChanged() {
        String oldBaseClass;
        IStatus status = super.superClassChanged();
        String baseClass = this.getSuperClass();
        if (baseClass != null && this.defaultsTable != null && !status.matches(4) && !baseClass.equals(oldBaseClass = this.defaultsTable.getExtends())) {
            this.defaultsTable.setExtends(baseClass);
        }
        return status;
    }

    protected IStatus containerChanged() {
        IStatus status = super.containerChanged();
        String srcFolder = this.getPackageFragmentRootText();
        if (!status.matches(4) && this.defaultsTable != null) {
            this.defaultsTable.setSourceFolder(srcFolder);
        }
        return status;
    }

    protected IPackageFragmentRoot chooseContainer() {
        Class[] acceptedClasses = new Class[]{IPackageFragmentRoot.class, IJavaProject.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false){

            public boolean isSelectedValid(Object element) {
                try {
                    if (element instanceof IJavaProject) {
                        IJavaProject jproject = (IJavaProject)element;
                        IPath path = jproject.getProject().getFullPath();
                        return jproject.findPackageFragmentRoot(path) != null;
                    }
                    if (element instanceof IPackageFragmentRoot) {
                        return PackageFragmentRootTools.isSourceFolder((IPackageFragmentRoot)((IPackageFragmentRoot)element));
                    }
                    return true;
                }
                catch (JavaModelException e) {
                    JptJpaUiPlugin.instance().logError(e);
                    return false;
                }
            }
        };
        acceptedClasses = new Class[]{IJavaModel.class, IPackageFragmentRoot.class, IJavaProject.class};
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses){

            public boolean select(Viewer viewer, Object parent, Object element) {
                if (element instanceof IPackageFragmentRoot) {
                    return PackageFragmentRootTools.isSourceFolder((IPackageFragmentRoot)((IPackageFragmentRoot)element));
                }
                return super.select(viewer, parent, element);
            }
        };
        StandardJavaElementContentProvider provider = new StandardJavaElementContentProvider();
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)provider);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setComparator((ViewerComparator)new JavaElementComparator());
        dialog.setTitle(NewWizardMessages.NewContainerWizardPage_ChooseSourceContainerDialog_title);
        dialog.setMessage(NewWizardMessages.NewContainerWizardPage_ChooseSourceContainerDialog_description);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)this.jpaProject.getJavaProject());
        dialog.setInitialSelection((Object)this.getPackageFragmentRoot());
        dialog.setHelpAvailable(false);
        if (dialog.open() == 0) {
            Object element = dialog.getFirstResult();
            if (element instanceof IJavaProject) {
                IJavaProject jproject = (IJavaProject)element;
                return jproject.getPackageFragmentRoot((IResource)jproject.getProject());
            }
            if (element instanceof IPackageFragmentRoot) {
                return (IPackageFragmentRoot)element;
            }
            return null;
        }
        return null;
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if (this.fContainerStatus.matches(4)) {
            this.updateStatus(this.fContainerStatus);
        } else if (!this.fPackageStatus.matches(0)) {
            this.updateStatus(this.fPackageStatus);
        } else if (this.fSuperClassStatus.matches(4)) {
            this.updateStatus(this.fSuperClassStatus);
        } else {
            this.updateStatus(Status.OK_STATUS);
        }
    }

    protected IStatus superInterfacesChanged() {
        IStatus status = super.superInterfacesChanged();
        if (status.isOK()) {
            List interfaces = this.getSuperInterfaces();
            if (this.defaultsTable != null) {
                this.defaultsTable.setImplements(interfaces);
            }
            if (this.serializableInterfaceRemoved(interfaces)) {
                this.removeAllSerializableFromTables(this.customizer.getTableNames());
            }
        }
        return status;
    }

    private void removeAllSerializableFromTables(List<String> tableNames) {
        for (String tableName : tableNames) {
            ORMGenTable table = this.customizer.getTable(tableName);
            List tableInterfaces = table.getImplements();
            tableInterfaces.remove(SERIALIZABLE_INTERFACE);
            table.setImplements(tableInterfaces);
        }
    }

    private boolean serializableInterfaceRemoved(List<String> interfaces) {
        return !this.interfacesHasSerializable(interfaces) && this.customizer != null;
    }

    protected ORMGenCustomizer getCustomizer() {
        return this.getWizard().getCustomizer();
    }

    public GenerateEntitiesFromSchemaWizard getWizard() {
        return (GenerateEntitiesFromSchemaWizard)super.getWizard();
    }

    public final void performHelp() {
        WorkbenchTools.displayHelp((String)this.getWizard().getHelpContextID());
    }
}

