/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools.model.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.parser.FunctionExpression;
import org.eclipse.persistence.jpa.jpql.tools.model.IListChangeListener;
import org.eclipse.persistence.jpa.jpql.tools.model.query.AbstractStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.ListHolderStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StateObjectVisitor;
import org.eclipse.persistence.jpa.jpql.utility.iterable.ListIterable;
import org.eclipse.persistence.jpa.jpql.utility.iterable.SnapshotCloneListIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionExpressionStateObject
extends AbstractStateObject
implements ListHolderStateObject<StateObject> {
    private String functionName;
    private String identifier;
    private List<StateObject> items;
    public static final String ARGUMENTS_LIST = "arguments";
    public static final String FUNCTION_NAME_PROPERTY = "functionName";

    public FunctionExpressionStateObject(StateObject parent) {
        super(parent);
    }

    public FunctionExpressionStateObject(StateObject parent, String identifier, String functionName, List<? extends StateObject> arguments) {
        super(parent);
        this.identifier = identifier;
        this.functionName = ExpressionTools.unquote(functionName);
        this.items.addAll(this.parent(arguments));
    }

    @Override
    public void accept(StateObjectVisitor visitor) {
        this.acceptUnknownVisitor(visitor);
    }

    @Override
    protected void addChildren(List<StateObject> children) {
        super.addChildren(children);
        children.addAll(this.items);
    }

    @Override
    public <S extends StateObject> S addItem(S item) {
        this.getChangeSupport().addItem(this, this.items, ARGUMENTS_LIST, this.parent(item));
        return item;
    }

    @Override
    public void addItems(List<? extends StateObject> items) {
        this.getChangeSupport().addItems(this, this.items, ARGUMENTS_LIST, this.parent(items));
    }

    @Override
    public void addListChangeListener(String listName, IListChangeListener<StateObject> listener) {
        this.getChangeSupport().addListChangeListener(listName, listener);
    }

    protected boolean areChildrenEquivalent(FunctionExpressionStateObject stateObject) {
        int size = this.itemsSize();
        if (size != stateObject.itemsSize()) {
            return false;
        }
        int index = size;
        while (--index >= 0) {
            StateObject child2;
            StateObject child1 = this.getItem(index);
            if (child1.isEquivalent(child2 = stateObject.getItem(index))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canMoveDown(StateObject item) {
        return this.getChangeSupport().canMoveDown(this.items, item);
    }

    @Override
    public boolean canMoveUp(StateObject item) {
        return this.getChangeSupport().canMoveUp(this.items, item);
    }

    @Override
    public FunctionExpression getExpression() {
        return (FunctionExpression)super.getExpression();
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public StateObject getItem(int index) {
        return this.items.get(index);
    }

    public String getQuotedFunctionName() {
        return ExpressionTools.quote(this.functionName);
    }

    public boolean hasFunctionName() {
        return this.functionName != null;
    }

    @Override
    public boolean hasItems() {
        return !this.items.isEmpty();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.items = new ArrayList<StateObject>();
    }

    @Override
    public boolean isEquivalent(StateObject stateObject) {
        if (super.isEquivalent(stateObject)) {
            FunctionExpressionStateObject function = (FunctionExpressionStateObject)stateObject;
            return ExpressionTools.valuesAreEqual(this.functionName, function.functionName) && this.areChildrenEquivalent(function);
        }
        return false;
    }

    @Override
    public ListIterable<StateObject> items() {
        return new SnapshotCloneListIterable<StateObject>(this.items);
    }

    @Override
    public int itemsSize() {
        return this.items.size();
    }

    @Override
    public StateObject moveDown(StateObject item) {
        this.getChangeSupport().moveDown(this, this.items, ARGUMENTS_LIST, item);
        return item;
    }

    @Override
    public StateObject moveUp(StateObject item) {
        this.getChangeSupport().moveUp(this, this.items, ARGUMENTS_LIST, item);
        return item;
    }

    @Override
    public void removeItem(StateObject item) {
        this.getChangeSupport().removeItem(this, this.items, ARGUMENTS_LIST, item);
    }

    @Override
    public void removeItems(Collection<StateObject> items) {
        this.getChangeSupport().removeItems(this, this.items, ARGUMENTS_LIST, items);
    }

    @Override
    public void removeListChangeListener(String listName, IListChangeListener<StateObject> listener) {
        this.getChangeSupport().removeListChangeListener(listName, listener);
    }

    public void setExpression(FunctionExpression expression) {
        super.setExpression(expression);
    }

    public void setFunctionName(String functionName) {
        String oldFunctionName = this.functionName;
        this.functionName = functionName;
        this.firePropertyChanged(FUNCTION_NAME_PROPERTY, oldFunctionName, functionName);
    }

    @Override
    protected void toTextInternal(Appendable writer) throws IOException {
        if (this.functionName != null) {
            writer.append('\'');
            writer.append(this.functionName);
            writer.append('\'');
        }
        if (this.hasItems()) {
            writer.append(',');
            writer.append(' ');
            this.toStringItems(writer, this.items, true);
        }
    }
}

