/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal;

import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.MultiThreadExceptionHandler;
import org.eclipse.jpt.common.utility.internal.CompositeMultiThreadedExceptionHandler;
import org.eclipse.jpt.common.utility.tests.internal.CompositeExceptionHandlerTests;

public class CompositeMultiThreadedExceptionHandlerTests
extends TestCase {
    public CompositeMultiThreadedExceptionHandlerTests(String name) {
        super(name);
    }

    public void testHandleException() {
        TestMultiThreadedExceptionHandler handler1 = new TestMultiThreadedExceptionHandler();
        TestMultiThreadedExceptionHandler handler2 = new TestMultiThreadedExceptionHandler();
        CompositeMultiThreadedExceptionHandler exceptionHandler = new CompositeMultiThreadedExceptionHandler(new MultiThreadExceptionHandler[]{handler1, handler2});
        NullPointerException npe = new NullPointerException();
        Thread thread = Thread.currentThread();
        exceptionHandler.handleException(thread, (Throwable)npe);
        CompositeMultiThreadedExceptionHandlerTests.assertEquals((Object)npe, (Object)handler1.throwable);
        CompositeMultiThreadedExceptionHandlerTests.assertEquals((Object)thread, (Object)handler1.thread);
        CompositeMultiThreadedExceptionHandlerTests.assertEquals((Object)npe, (Object)handler2.throwable);
        CompositeMultiThreadedExceptionHandlerTests.assertEquals((Object)thread, (Object)handler2.thread);
    }

    public static class TestMultiThreadedExceptionHandler
    extends CompositeExceptionHandlerTests.TestExceptionHandler
    implements MultiThreadExceptionHandler {
        public volatile Thread thread = null;

        public void handleException(Thread t, Throwable ex) {
            this.thread = t;
            this.throwable = ex;
        }
    }
}

