/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal;

import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.Association;
import org.eclipse.jpt.common.utility.internal.MapEntryAssociation;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapKeyAssociationTests
extends TestCase {
    private MapEntryAssociation<String, String> assoc;

    public MapKeyAssociationTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.assoc = this.buildMapEntryAssociation("foo", "bar");
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testGetKey() {
        MapKeyAssociationTests.assertEquals((String)"foo", (String)((String)this.assoc.getKey()));
    }

    public void testGetValue() {
        MapKeyAssociationTests.assertEquals((String)"bar", (String)((String)this.assoc.getValue()));
    }

    public void testSetValue() {
        MapKeyAssociationTests.assertEquals((String)"bar", (String)((String)this.assoc.getValue()));
        this.assoc.setValue((Object)"baz");
        MapKeyAssociationTests.assertEquals((String)"baz", (String)((String)this.assoc.getValue()));
    }

    public void testEquals() {
        MapKeyAssociationTests.assertFalse((boolean)this.assoc.equals((Object)"foo"));
        MapKeyAssociationTests.assertEquals(this.assoc, this.copy(this.assoc));
        MapEntryAssociation<String, String> assoc2 = this.buildMapEntryAssociation("foo", "baz");
        MapKeyAssociationTests.assertFalse((boolean)this.assoc.equals(assoc2));
        assoc2 = this.buildMapEntryAssociation("fop", "bar");
        MapKeyAssociationTests.assertFalse((boolean)this.assoc.equals(assoc2));
        MapEntryAssociation<Object, Object> assoc3 = this.buildMapEntryAssociation(null, null);
        MapEntryAssociation<Object, Object> assoc4 = this.buildMapEntryAssociation(null, null);
        MapKeyAssociationTests.assertEquals(assoc3, assoc4);
    }

    public void testHashCode() {
        MapKeyAssociationTests.assertEquals((int)this.assoc.hashCode(), (int)this.copy(this.assoc).hashCode());
        MapEntryAssociation<Object, Object> assoc2 = this.buildMapEntryAssociation(null, null);
        MapKeyAssociationTests.assertEquals((int)assoc2.hashCode(), (int)this.copy(assoc2).hashCode());
    }

    public void testToString() {
        MapKeyAssociationTests.assertNotNull((Object)this.assoc.toString());
    }

    public void testClone() {
        this.verifyClone((Association<String, String>)this.assoc, (Association<String, String>)this.assoc.clone());
    }

    private void verifyClone(Association<String, String> expected, Association<String, String> actual) {
        MapKeyAssociationTests.assertEquals(expected, actual);
        MapKeyAssociationTests.assertNotSame(expected, actual);
        MapKeyAssociationTests.assertEquals((String)((String)expected.getKey()), (String)((String)actual.getKey()));
        MapKeyAssociationTests.assertSame((Object)expected.getKey(), (Object)actual.getKey());
        MapKeyAssociationTests.assertEquals((String)((String)expected.getValue()), (String)((String)actual.getValue()));
        MapKeyAssociationTests.assertSame((Object)expected.getValue(), (Object)actual.getValue());
    }

    private MapEntryAssociation<String, String> copy(MapEntryAssociation<String, String> mea) {
        return this.buildMapEntryAssociation((String)mea.getKey(), (String)mea.getValue());
    }

    private <K, V> MapEntryAssociation<K, V> buildMapEntryAssociation(K key, V value) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(key, value);
        Map.Entry entry = map.entrySet().iterator().next();
        return new MapEntryAssociation(entry);
    }
}

