/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.test.util.mock.smodel;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.IllegalCharsetNameException;
import org.eclipse.core.internal.runtime.PlatformActivator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jst.jsf.test.util.mock.osgi.BundleHacker;
import org.eclipse.wst.sse.core.internal.document.IDocumentLoader;
import org.eclipse.wst.sse.core.internal.encoding.EncodingMemento;
import org.eclipse.wst.sse.core.internal.encoding.util.Logger;
import org.eclipse.wst.sse.core.internal.encoding.util.NullInputStream;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.IModelHandler;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.document.IEncodedDocument;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceInUse;
import org.eclipse.wst.sse.core.internal.util.ProjectResolver;
import org.eclipse.wst.sse.core.internal.util.URIResolver;
import org.eclipse.wst.xml.core.internal.encoding.XMLDocumentLoader;
import org.eclipse.wst.xml.core.internal.modelhandler.ModelHandlerForXML;
import org.eclipse.wst.xml.core.internal.modelhandler.XMLModelLoader;
import org.osgi.framework.BundleException;

public class TestableStructuredModelFactory {
    public static final String NO_SPEC_DEFAULT = "NoSpecDefault";

    public static void hackStatics() throws SecurityException, NoSuchFieldException, BundleException, IllegalArgumentException, IllegalAccessException {
        new BundleHacker().mockBundleContext(PlatformActivator.class, null);
    }

    public IStructuredModel createUnManagedModelFor(IFile file) throws CoreException, ResourceInUse, IOException {
        IStructuredModel model = this.createUnManagedEmptyModelFor(file);
        IDocumentLoader loader = model.getModelHandler().getDocumentLoader();
        IEncodedDocument document = loader.createNewStructuredDocument(file);
        model.getStructuredDocument().setText((Object)this, document.get());
        return model;
    }

    protected IStructuredModel createUnManagedEmptyModelFor(IFile iFile) throws CoreException, ResourceInUse {
        ModelHandlerForXML handler = new ModelHandlerForXML(){

            public IDocumentLoader getDocumentLoader() {
                return new TestableXMLModelLoader();
            }
        };
        String id = iFile.getFullPath().toString();
        URIResolver resolver = this.calculateURIResolver(iFile);
        return this._commonCreateModel(id, handler, resolver);
    }

    private URIResolver calculateURIResolver(IFile file) {
        IProject project = file.getProject();
        ProjectResolver resolver = new ProjectResolver(project);
        Object location = file.getLocation();
        if (location == null) {
            location = file.getLocationURI();
        }
        if (location != null) {
            resolver.setFileBaseLocation(location.toString());
        }
        return resolver;
    }

    private IStructuredModel _commonCreateModel(String id, ModelHandlerForXML handler, URIResolver resolver) throws ResourceInUse {
        XMLModelLoader loader = new XMLModelLoader(){

            public IDocumentLoader getDocumentLoader() {
                return new TestableXMLModelLoader();
            }
        };
        IStructuredModel result = loader.createModel();
        result.setModelHandler((IModelHandler)handler);
        result.setResolver(resolver);
        result.setBaseLocation(id);
        if (resolver != null) {
            resolver.setFileBaseLocation(id);
        }
        return result;
    }

    public static EncodingMemento createEncodingMemento(String detectedCharsetName, String reason, String specDefaultEncoding) {
        EncodingMemento result = new EncodingMemento();
        result = new EncodingMemento();
        result.setJavaCharsetName("UTF-8");
        result.setDetectedCharsetName(detectedCharsetName);
        if (specDefaultEncoding == null) {
            result.setAppropriateDefault(NO_SPEC_DEFAULT);
        } else {
            result.setAppropriateDefault(specDefaultEncoding);
        }
        try {
            Charset.isSupported("UTF-8");
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            result.setInvalidEncoding("UTF-8");
        }
        return result;
    }

    private static final class TestableXMLModelLoader
    extends XMLDocumentLoader {
        private TestableXMLModelLoader() {
        }

        public IEncodedDocument createNewStructuredDocument() {
            IEncodedDocument structuredDocument = this.newEncodedDocument();
            String specDefaultCharset = this.getDocumentEncodingDetector().getSpecDefaultEncoding();
            structuredDocument.setEncodingMemento(TestableStructuredModelFactory.createEncodingMemento("UTF-8", "DefaultsAssumedForEmptyInput", specDefaultCharset));
            IDocumentPartitioner defaultPartitioner = this.getDefaultDocumentPartitioner();
            if (structuredDocument instanceof IDocumentExtension3) {
                ((IDocumentExtension3)structuredDocument).setDocumentPartitioner("org.eclipse.wst.sse.core.default_structured_text_partitioning", defaultPartitioner);
            } else {
                structuredDocument.setDocumentPartitioner(defaultPartitioner);
            }
            defaultPartitioner.connect((IDocument)structuredDocument);
            return structuredDocument;
        }

        public IEncodedDocument createNewStructuredDocument(IFile iFile) throws IOException, CoreException {
            IEncodedDocument structuredDocument = this.createNewStructuredDocument();
            try {
                InputStream streamToReturn = this.getResettableStream(iFile);
                streamToReturn.reset();
                Charset charset = Charset.forName("UTF-8");
                CharsetDecoder charsetDecoder = charset.newDecoder();
                this.fFullPreparedReader = new BufferedReader(new InputStreamReader(streamToReturn, charsetDecoder), 8192);
                this.fFullPreparedReader.mark(8192);
                this.setDocumentContentsFromReader(structuredDocument, this.fFullPreparedReader);
            }
            finally {
                if (this.fFullPreparedReader != null) {
                    this.fFullPreparedReader.close();
                }
            }
            return structuredDocument;
        }

        private InputStream getResettableStream(IFile fIFile) throws CoreException, IOException {
            InputStream resettableStream = null;
            if (fIFile != null) {
                InputStream inputStream = null;
                try {
                    inputStream = fIFile.getContents(true);
                }
                catch (CoreException e) {
                    Logger.logException((Throwable)e);
                    inputStream = new NullInputStream();
                }
                resettableStream = new BufferedInputStream(inputStream, 8192);
            }
            if (resettableStream == null) {
                resettableStream = new NullInputStream();
            }
            resettableStream.mark(8192);
            return resettableStream;
        }
    }
}

