/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.tests.contentassist;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.wst.jsdt.ui.tests.contentassist.ContentAssistTestUtilities;
import org.eclipse.wst.jsdt.ui.tests.utils.TestProjectSetup;

public class DoublyNestedFunctionTests
extends TestCase {
    private static final String TEST_NAME = "Test Doubly Nested Functions JavaScript Content Assist";
    private static TestProjectSetup fTestProjectSetup;
    static /* synthetic */ Class class$0;

    public DoublyNestedFunctionTests() {
        super(TEST_NAME);
    }

    public DoublyNestedFunctionTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.ui.tests.contentassist.DoublyNestedFunctionTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite ts = new TestSuite((Class)clazz, TEST_NAME);
        fTestProjectSetup = new TestProjectSetup((Test)ts, "ContentAssist", "root", false);
        return fTestProjectSetup;
    }

    public void testFindInnerFunctions2_OtherFile_BeforeOpen_ExpressionNotStarted() throws Exception {
        String[][] expectedProposals = new String[][]{{"outerFunc() - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "test13_1.js", 0, 0, expectedProposals);
    }

    public void test_FindInnerFunctions2_OtherFile_BeforeOpen_NegativeTest_ExpressionStarted_1() throws Exception {
        String[][] unexpectedProposals = new String[][]{{"innerFunc()", "insideInnerFunc()", "localInnerFunc : Function", "localInnerFunc(param1)"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "test13_1.js", 4, 1, unexpectedProposals, true, false);
    }

    public void testFindInnerFunctions2_ThisFile_Expression1() throws Exception {
        String[][] expectedProposals = new String[][]{{"outerFunc() - Global", "innerFunc()"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "test13_0.js", 3, 0, expectedProposals);
    }

    public void test_InnerFunctions2_ThisFile_NegativeTest_Expression1() throws Exception {
        String[][] unexpectedProposals = new String[][]{{"insideInnerFunc()", "localInnerFunc", "localInnerFunc(param1)"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "test13_0.js", 2, 0, unexpectedProposals, true, false);
    }

    public void testFindInnerFunctions2_ThisFile_Expression2() throws Exception {
        String[][] expectedProposals = new String[][]{{"outerFunc() - Global", "innerFunc()", "insideInnerFunc()"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "test13_0.js", 7, 0, expectedProposals);
    }

    public void test_FindInnerFunctions2_ThisFile_NegativeTest_Expression2() throws Exception {
        String[][] unexpectedProposals = new String[][]{{"localInnerFunc : Function", "localInnerFunc(param1)"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "test13_0.js", 5, 0, unexpectedProposals, true, false);
    }

    public void testFindInnerFunctions2_ThisFile_Expression3() throws Exception {
        String[][] expectedProposals = new String[][]{{"outerFunc() - Global", "innerFunc()", "insideInnerFunc()", "localInnerFunc : Function", "localInnerFunc(param1)"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "test13_0.js", 12, 0, expectedProposals);
    }

    public void testFindInnerFunctions2_ThisFile_Expression4() throws Exception {
        String[][] expectedProposals = new String[][]{{"outerFunc() - Global", "innerFunc()", "insideInnerFunc()"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "test13_0.js", 15, 0, expectedProposals);
    }

    public void test_FindInnerFunctions2_ThisFile_NegativeTest_Expression4() throws Exception {
        String[][] unexpectedProposals = new String[][]{{"localInnerFunc : Function", "localInnerFunc(param1)"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "test13_0.js", 15, 0, unexpectedProposals, true, false);
    }

    public void testFindInnerFunctions2_ThisFile_Expression5() throws Exception {
        String[][] expectedProposals = new String[][]{{"outerFunc() - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "test13_0.js", 21, 0, expectedProposals);
    }

    public void test_FindInnerFunctions2_ThisFile_NegativeTest_Expression5() throws Exception {
        String[][] unexpectedProposals = new String[][]{{"innerFunc()", "insideInnerFunc()", "localInnerFunc : Function", "localInnerFunc(param1)"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "test13_0.js", 21, 0, unexpectedProposals, true, false);
    }

    public void testFindInnerFunctions2_OtherFile_AfterOpen_ExpressionNotStarted() throws Exception {
        String[][] expectedProposals = new String[][]{{"outerFunc() - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "test13_1.js", 0, 0, expectedProposals);
    }

    public void test_FindInnerFunctions2_OtherFile_NegativeTest_AfterOpen_ExpressionStarted_1() throws Exception {
        String[][] unexpectedProposals = new String[][]{{"innerFunc()", "insideInnerFunc()", "localInnerFunc : Function", "localInnerFunc(param1)"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "test13_1.js", 4, 1, unexpectedProposals, true, false);
    }
}

