/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.tests.hyperlink;

import java.util.ArrayList;
import junit.framework.Assert;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaElementHyperlink;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaElementHyperlinkDetector;
import org.eclipse.wst.jsdt.ui.tests.hyperlink.HyperLinkTestUtilities;
import org.eclipse.wst.jsdt.ui.tests.utils.TestProjectSetup;

public class HyperLinkTestUtilities {
    public static void checkHyperlink(TestProjectSetup testProject, int lineNum, int lineRelativeCharOffset, String filePath, ArrayList filesExpected) throws Exception {
        ArrayList expectedFilesNotOpened = new ArrayList(filesExpected);
        EditorListener listener = null;
        class EditorListener
        implements IPartListener2 {
            private final /* synthetic */ ArrayList val$expectedFilesNotOpened;

            EditorListener(ArrayList arrayList) {
                this.val$expectedFilesNotOpened = arrayList;
            }

            public void partActivated(IWorkbenchPartReference partRef) {
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
                IWorkbenchPart part = partRef.getPart(false);
                if (part instanceof JavaEditor) {
                    String fileOpened = part.getTitle();
                    int index = 0;
                    boolean found = false;
                    String item = new String();
                    while (index < this.val$expectedFilesNotOpened.size() && !found) {
                        item = (String)this.val$expectedFilesNotOpened.get(index);
                        if (item.equals(fileOpened)) {
                            found = true;
                            this.val$expectedFilesNotOpened.remove(index);
                            continue;
                        }
                        ++index;
                    }
                }
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partVisible(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }
        }
        listener = new EditorListener(expectedFilesNotOpened);
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        page.addPartListener((IPartListener2)listener);
        IHyperlink[] hyperLinks = HyperLinkTestUtilities.getHyperlinks(testProject, lineNum, lineRelativeCharOffset, filePath);
        Assert.assertTrue((String)"No hyperlinks found", (hyperLinks != null && hyperLinks.length > 0 ? 1 : 0) != 0);
        int i = 0;
        while (i < hyperLinks.length) {
            if (hyperLinks[i] instanceof JavaElementHyperlink) {
                hyperLinks[i].open();
            }
            ++i;
        }
        Assert.assertTrue((String)"Not all expected pages were opened.", (boolean)expectedFilesNotOpened.isEmpty());
        page.removePartListener((IPartListener2)listener);
    }

    public static IHyperlink[] getHyperlinks(TestProjectSetup testProject, int lineNum, int lineRelativeCharOffset, String filePath) throws Exception {
        IFile file = testProject.getFile(filePath);
        JavaEditor editor = testProject.getEditor(file);
        IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        int offset = doc.getLineOffset(lineNum) + lineRelativeCharOffset;
        ISourceViewer viewer = editor.getViewer();
        editor.setHighlightRange(offset, 0, true);
        Region region = new Region(offset, 0);
        JavaElementHyperlinkDetector hyperlinkDetector = new JavaElementHyperlinkDetector();
        hyperlinkDetector.setContext((IAdaptable)editor);
        Thread.sleep(1000L);
        IHyperlink[] hyperlinks = hyperlinkDetector.detectHyperlinks((ITextViewer)viewer, (IRegion)region, true);
        return hyperlinks;
    }
}

