/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.resource.oxm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum EXmlAccessType implements Enumerator
{
    FIELD(0, "FIELD", "FIELD"),
    NONE(1, "NONE", "NONE"),
    PROPERTY(2, "PROPERTY", "PROPERTY"),
    PUBLIC_MEMBER(3, "PUBLIC_MEMBER", "PUBLIC_MEMBER");

    public static final int FIELD_VALUE = 0;
    public static final int NONE_VALUE = 1;
    public static final int PROPERTY_VALUE = 2;
    public static final int PUBLIC_MEMBER_VALUE = 3;
    private static final EXmlAccessType[] VALUES_ARRAY;
    public static final List<EXmlAccessType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EXmlAccessType[]{FIELD, NONE, PROPERTY, PUBLIC_MEMBER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EXmlAccessType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EXmlAccessType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EXmlAccessType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EXmlAccessType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EXmlAccessType get(int value) {
        switch (value) {
            case 0: {
                return FIELD;
            }
            case 1: {
                return NONE;
            }
            case 2: {
                return PROPERTY;
            }
            case 3: {
                return PUBLIC_MEMBER;
            }
        }
        return null;
    }

    private EXmlAccessType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

