/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.core.resources.IResource;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.core.internal.utility.ValidationMessageTools;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.ValidationMessage;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jpa.core.JpaModel;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.MappingFile;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.internal.AbstractJpaModel;
import org.eclipse.jpt.jpa.db.Catalog;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.SchemaContainer;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationCancelledException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJpaContextModel<P extends JpaContextModel>
extends AbstractJpaModel<P>
implements JpaContextModel {
    protected AbstractJpaContextModel(P parent) {
        super(parent);
    }

    @Override
    public void synchronizeWithResourceModel() {
    }

    protected void synchronizeModelsWithResourceModel(Iterable<? extends JpaContextModel> models) {
        for (JpaContextModel jpaContextModel : models) {
            jpaContextModel.synchronizeWithResourceModel();
        }
    }

    @Override
    public void update() {
    }

    protected void updateModels(Iterable<? extends JpaContextModel> models) {
        for (JpaContextModel jpaContextModel : models) {
            jpaContextModel.update();
        }
    }

    public JptResourceType getResourceType() {
        return ((JpaContextModel)this.parent).getResourceType();
    }

    @Override
    public PersistenceUnit getPersistenceUnit() {
        return ((JpaContextModel)this.parent).getPersistenceUnit();
    }

    @Override
    public MappingFile.Root getMappingFileRoot() {
        return ((JpaContextModel)this.parent).getMappingFileRoot();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        if (reporter.isCancelled()) {
            throw new ValidationCancelledException();
        }
    }

    protected TextRange getValidationTextRange(TextRange textRange) {
        return textRange != null ? textRange : this.getValidationTextRange();
    }

    protected void validateModel(JpaContextModel model, List<IMessage> messages, IReporter reporter) {
        if (model != null) {
            model.validate(messages, reporter);
        }
    }

    protected void validateModels(Iterable<? extends JpaContextModel> models, List<IMessage> messages, IReporter reporter) {
        for (JpaContextModel jpaContextModel : models) {
            jpaContextModel.validate(messages, reporter);
        }
    }

    protected IMessage buildValidationMessage(ValidationMessage message) {
        return this.buildValidationMessage(this, message);
    }

    protected IMessage buildValidationMessage(JpaModel target, ValidationMessage message) {
        return ValidationMessageTools.buildValidationMessage((IResource)target.getResource(), (ValidationMessage)message);
    }

    protected IMessage buildValidationMessage(ValidationMessage message, Object ... args) {
        return this.buildValidationMessage((JpaModel)this, message, args);
    }

    protected IMessage buildValidationMessage(JpaModel target, ValidationMessage message, Object ... args) {
        return ValidationMessageTools.buildValidationMessage((IResource)target.getResource(), (ValidationMessage)message, (Object[])args);
    }

    protected IMessage buildValidationMessage(TextRange textRange, ValidationMessage message) {
        return this.buildValidationMessage((JpaModel)this, textRange, message);
    }

    protected IMessage buildValidationMessage(JpaModel target, TextRange textRange, ValidationMessage message) {
        return ValidationMessageTools.buildValidationMessage((IResource)target.getResource(), (TextRange)textRange, (ValidationMessage)message);
    }

    protected IMessage buildValidationMessage(TextRange textRange, ValidationMessage message, Object ... args) {
        return this.buildValidationMessage((JpaModel)this, textRange, message, args);
    }

    protected IMessage buildValidationMessage(JpaModel target, TextRange textRange, ValidationMessage message, Object ... args) {
        return ValidationMessageTools.buildValidationMessage((IResource)target.getResource(), (TextRange)textRange, (ValidationMessage)message, (Object[])args);
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result;
        if (this.connectionProfileIsActive() && (result = this.getConnectedCompletionProposals(pos)) != null) {
            return result;
        }
        return null;
    }

    protected Iterable<String> getConnectedCompletionProposals(int pos) {
        return null;
    }

    @Override
    public Schema getContextDefaultDbSchema() {
        SchemaContainer dbSchemaContainer = this.getContextDefaultDbSchemaContainer();
        return dbSchemaContainer == null ? null : dbSchemaContainer.getSchemaForIdentifier(this.getContextDefaultSchema());
    }

    protected String getContextDefaultSchema() {
        MappingFile.Root mfr = this.getMappingFileRoot();
        return mfr != null ? mfr.getSchema() : this.getPersistenceUnit().getDefaultSchema();
    }

    @Override
    public SchemaContainer getContextDefaultDbSchemaContainer() {
        String catalog = this.getContextDefaultCatalog();
        return catalog != null ? this.resolveDbCatalog(catalog) : this.getDatabase();
    }

    @Override
    public Catalog getContextDefaultDbCatalog() {
        String catalog = this.getContextDefaultCatalog();
        return catalog == null ? null : this.resolveDbCatalog(catalog);
    }

    protected String getContextDefaultCatalog() {
        MappingFile.Root mfr = this.getMappingFileRoot();
        return mfr != null ? mfr.getCatalog() : this.getPersistenceUnit().getDefaultCatalog();
    }

    protected <E> boolean addItemToCollection(E item, Collection<E> collection, String collectionName) {
        return super.addItemToCollection(item, collection, collectionName);
    }

    protected <E> boolean addItemsToCollection(Iterable<? extends E> items, Collection<E> collection, String collectionName) {
        return super.addItemsToCollection(items, collection, collectionName);
    }

    protected boolean removeItemFromCollection(Object item, Collection<?> collection, String collectionName) {
        return super.removeItemFromCollection(item, collection, collectionName);
    }

    protected boolean removeItemsFromCollection(Iterable<?> items, Collection<?> collection, String collectionName) {
        return super.removeItemsFromCollection(items, collection, collectionName);
    }

    protected <C extends JpaContextModel, R> SpecifiedContextCollectionContainer<C, R> buildSpecifiedContextCollectionContainer(String aspectName, Container.Adapter<C, R> adapter) {
        return new SpecifiedContextCollectionContainer<C, R>(aspectName, adapter);
    }

    protected <C extends JpaContextModel, R> VirtualContextCollectionContainer<C, R> buildVirtualContextCollectionContainer(String aspectName, Container.Adapter<C, R> adapter) {
        return new VirtualContextCollectionContainer<C, R>(aspectName, adapter);
    }

    protected <E> void addItemToList(int index, E item, List<E> list, String listName) {
        super.addItemToList(index, item, list, listName);
    }

    protected <E> boolean addItemsToList(int index, Iterable<? extends E> items, List<E> list, String listName) {
        return super.addItemsToList(index, items, list, listName);
    }

    protected <E> void moveItemInList(int targetIndex, int sourceIndex, List<E> list, String listName) {
        super.moveItemInList(targetIndex, sourceIndex, list, listName);
    }

    protected <E> void moveItemInList(int targetIndex, E item, List<E> list, String listName) {
        super.moveItemInList(targetIndex, item, list, listName);
    }

    protected boolean clearList(List<?> list, String listName) {
        return super.clearList(list, listName);
    }

    protected <E> E removeItemFromList(int index, List<E> list, String listName) {
        return (E)super.removeItemFromList(index, list, listName);
    }

    protected boolean removeItemFromList(Object item, List<?> list, String listName) {
        return super.removeItemFromList(item, list, listName);
    }

    protected boolean removeItemsFromList(Iterable<?> items, List<?> list, String listName) {
        return super.removeItemsFromList(items, list, listName);
    }

    protected <C extends JpaContextModel, R> SpecifiedContextListContainer<C, R> buildSpecifiedContextListContainer(String aspectName, Container.Adapter<C, R> adapter) {
        return new SpecifiedContextListContainer<C, R>(aspectName, adapter);
    }

    protected <C extends JpaContextModel, R> VirtualContextListContainer<C, R> buildVirtualContextListContainer(String aspectName, Container.Adapter<C, R> adapter) {
        return new VirtualContextListContainer<C, R>(aspectName, adapter);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class AbstractContainerAdapter<C, R>
    implements Container.Adapter<C, R> {
        public String toString() {
            return ObjectTools.toString((Object)this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Container<C, R>
    implements ListIterable<C> {
        protected final Vector<C> elements = new Vector();
        protected final String aspectName;
        protected final Adapter<C, R> adapter;

        protected Container(String aspectName, Adapter<C, R> adapter) {
            this.aspectName = aspectName;
            this.adapter = adapter;
        }

        protected void initialize() {
            for (R resourceElement : this.adapter.getResourceElements()) {
                this.elements.add(this.adapter.buildContextElement(resourceElement));
            }
        }

        public C get(int index) {
            return this.elements.get(index);
        }

        public ListIterator<C> iterator() {
            return IteratorTools.clone(this.elements);
        }

        public int size() {
            return this.elements.size();
        }

        public C addContextElement(int index, R resourceElement) {
            return this.add(index, this.adapter.buildContextElement(resourceElement));
        }

        protected abstract C add(int var1, C var2);

        public Iterable<C> addContextElements(int index, Iterable<R> resourceElements) {
            ArrayList<C> contextElements = new ArrayList<C>();
            for (R resourceElement : resourceElements) {
                contextElements.add(this.adapter.buildContextElement(resourceElement));
            }
            return this.addAll(index, contextElements);
        }

        protected abstract Iterable<C> addAll(int var1, Iterable<C> var2);

        public abstract void remove(C var1);

        public abstract void removeAll(Iterable<C> var1);

        protected abstract void move(int var1, C var2);

        public String toString() {
            return this.elements.toString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface Adapter<C, R> {
            public Iterable<R> getResourceElements();

            public R extractResourceElement(C var1);

            public C buildContextElement(R var1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class ContextCollectionContainer<C extends JpaContextModel, R>
    extends ContextContainer<C, R> {
        protected ContextCollectionContainer(String aspectName, Container.Adapter<C, R> adapter) {
            super(aspectName, adapter);
        }

        @Override
        protected C add(int index, C element) {
            AbstractJpaContextModel.this.addItemToCollection(element, this.elements, this.aspectName);
            return element;
        }

        @Override
        protected Iterable<C> addAll(int index, Iterable<C> contextElements) {
            AbstractJpaContextModel.this.addItemsToCollection(contextElements, this.elements, this.aspectName);
            return contextElements;
        }

        @Override
        public void remove(C element) {
            AbstractJpaContextModel.this.removeItemFromCollection(element, this.elements, this.aspectName);
        }

        @Override
        public void removeAll(Iterable<C> contextElements) {
            AbstractJpaContextModel.this.removeItemsFromCollection(contextElements, this.elements, this.aspectName);
        }

        @Override
        protected void move(int index, C element) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class ContextContainer<C extends JpaContextModel, R>
    extends Container<C, R> {
        protected ContextContainer(String aspectName, Container.Adapter<C, R> adapter) {
            super(aspectName, adapter);
        }

        public void synchronizeWithResourceModel() {
            this.sync(true);
        }

        public void update() {
            this.sync(false);
        }

        protected void sync(boolean sync) {
            HashSet contextElements = CollectionTools.set((Object[])this.elements.toArray());
            ArrayList<JpaContextModel> contextElementsToSync = new ArrayList<JpaContextModel>(contextElements.size());
            int resourceIndex = 0;
            for (Object resourceElement : this.adapter.getResourceElements()) {
                boolean match = false;
                Iterator stream = contextElements.iterator();
                while (stream.hasNext()) {
                    JpaContextModel contextElement = (JpaContextModel)stream.next();
                    if (!ObjectTools.equals(this.adapter.extractResourceElement(contextElement), resourceElement)) continue;
                    this.move(resourceIndex, contextElement);
                    stream.remove();
                    contextElementsToSync.add(contextElement);
                    match = true;
                    break;
                }
                if (!match) {
                    this.addContextElement(resourceIndex, resourceElement);
                }
                ++resourceIndex;
            }
            for (JpaContextModel contextElement : contextElements) {
                this.remove(contextElement);
            }
            for (JpaContextModel contextElement : contextElementsToSync) {
                if (sync) {
                    contextElement.synchronizeWithResourceModel();
                    continue;
                }
                contextElement.update();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class ContextListContainer<C extends JpaContextModel, R>
    extends ContextContainer<C, R> {
        protected ContextListContainer(String aspectName, Container.Adapter<C, R> adapter) {
            super(aspectName, adapter);
        }

        public int indexOf(C element) {
            return this.elements.indexOf(element);
        }

        @Override
        protected C add(int index, C element) {
            AbstractJpaContextModel.this.addItemToList(index, element, this.elements, this.aspectName);
            return element;
        }

        @Override
        public Iterable<C> addAll(int index, Iterable<C> contextElements) {
            AbstractJpaContextModel.this.addItemsToList(index, contextElements, this.elements, this.aspectName);
            return contextElements;
        }

        @Override
        public void move(int targetIndex, int sourceIndex) {
            AbstractJpaContextModel.this.moveItemInList(targetIndex, sourceIndex, this.elements, this.aspectName);
        }

        @Override
        public void move(int index, C element) {
            AbstractJpaContextModel.this.moveItemInList(index, element, this.elements, this.aspectName);
        }

        public void clear() {
            AbstractJpaContextModel.this.clearList(this.elements, this.aspectName);
        }

        public C remove(int index) {
            return (C)((JpaContextModel)AbstractJpaContextModel.this.removeItemFromList(index, this.elements, this.aspectName));
        }

        @Override
        public void remove(C element) {
            AbstractJpaContextModel.this.removeItemFromList(element, this.elements, this.aspectName);
        }

        @Override
        public void removeAll(Iterable<C> contextElements) {
            AbstractJpaContextModel.this.removeItemsFromList(contextElements, this.elements, this.aspectName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SpecifiedContextCollectionContainer<C extends JpaContextModel, R>
    extends ContextCollectionContainer<C, R> {
        public SpecifiedContextCollectionContainer(String aspectName, Container.Adapter<C, R> adapter) {
            super(aspectName, adapter);
            this.initialize();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SpecifiedContextListContainer<C extends JpaContextModel, R>
    extends ContextListContainer<C, R> {
        public SpecifiedContextListContainer(String aspectName, Container.Adapter<C, R> adapter) {
            super(aspectName, adapter);
            this.initialize();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class ValueListContainer<E>
    extends Container<E, E> {
        protected ValueListContainer(String aspectName, Container.Adapter<E, E> adapter) {
            super(aspectName, adapter);
        }

        public int indexOf(E element) {
            return this.elements.indexOf(element);
        }

        @Override
        protected E add(int index, E element) {
            AbstractJpaContextModel.this.addItemToList(index, element, this.elements, this.aspectName);
            return element;
        }

        @Override
        protected Iterable<E> addAll(int index, Iterable<E> contextElements) {
            AbstractJpaContextModel.this.addItemsToList(index, contextElements, this.elements, this.aspectName);
            return contextElements;
        }

        @Override
        public void move(int targetIndex, int sourceIndex) {
            AbstractJpaContextModel.this.moveItemInList(targetIndex, sourceIndex, this.elements, this.aspectName);
        }

        @Override
        public void move(int index, E element) {
            AbstractJpaContextModel.this.moveItemInList(index, element, this.elements, this.aspectName);
        }

        @Override
        public void remove(E element) {
            AbstractJpaContextModel.this.removeItemFromList(element, this.elements, this.aspectName);
        }

        public E remove(int index) {
            return AbstractJpaContextModel.this.removeItemFromList(index, this.elements, this.aspectName);
        }

        @Override
        public void removeAll(Iterable<E> contextElements) {
            AbstractJpaContextModel.this.removeItemsFromList(contextElements, this.elements, this.aspectName);
        }

        public void synchronizeWithResourceModel() {
            int resourceIndex = 0;
            for (Object resourceElement : this.adapter.getResourceElements()) {
                if (this.size() > resourceIndex) {
                    Object contextElement = this.get(resourceIndex);
                    if (ObjectTools.notEquals(this.adapter.extractResourceElement(contextElement), resourceElement)) {
                        this.addContextElement(resourceIndex, resourceElement);
                    }
                } else {
                    this.addContextElement(resourceIndex, resourceElement);
                }
                ++resourceIndex;
            }
            while (resourceIndex < this.size()) {
                this.remove(resourceIndex++);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class VirtualContextCollectionContainer<C extends JpaContextModel, R>
    extends ContextCollectionContainer<C, R> {
        public VirtualContextCollectionContainer(String aspectName, Container.Adapter<C, R> adapter) {
            super(aspectName, adapter);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class VirtualContextListContainer<C extends JpaContextModel, R>
    extends ContextListContainer<C, R> {
        public VirtualContextListContainer(String aspectName, Container.Adapter<C, R> adapter) {
            super(aspectName, adapter);
        }
    }
}

