/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.orm;

import java.util.List;
import java.util.Vector;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateAdapter;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.jpa.core.context.BaseColumn;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.Override_;
import org.eclipse.jpt.jpa.core.context.SpecifiedOverride;
import org.eclipse.jpt.jpa.core.context.TableColumn;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.VirtualOverride;
import org.eclipse.jpt.jpa.core.context.orm.OrmOverrideContainer;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedOverride;
import org.eclipse.jpt.jpa.core.context.orm.OrmVirtualOverride;
import org.eclipse.jpt.jpa.core.internal.context.ContextContainerTools;
import org.eclipse.jpt.jpa.core.internal.context.JpaValidator;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextModel;
import org.eclipse.jpt.jpa.core.resource.orm.XmlOverride;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmOverrideContainer<PA extends OrmOverrideContainer.ParentAdapter, R extends Override_, S extends OrmSpecifiedOverride, V extends OrmVirtualOverride, X extends XmlOverride>
extends AbstractOrmXmlContextModel<JpaContextModel>
implements OrmOverrideContainer {
    protected final PA parentAdapter;
    protected final Vector<S> specifiedOverrides = new Vector();
    protected final SpecifiedOverrideContainerAdapter specifiedOverrideContainerAdapter = new SpecifiedOverrideContainerAdapter();
    protected final Vector<V> virtualOverrides = new Vector();
    protected final VirtualOverrideContainerAdapter virtualOverrideContainerAdapter = new VirtualOverrideContainerAdapter();

    protected AbstractOrmOverrideContainer(JpaContextModel parent) {
        super(parent);
        this.parentAdapter = null;
    }

    protected AbstractOrmOverrideContainer(PA parentAdapter) {
        super(parentAdapter.getOverrideContainerParent());
        this.parentAdapter = parentAdapter;
        this.initializeSpecifiedOverrides();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncSpecifiedOverrides();
    }

    @Override
    public void update() {
        super.update();
        this.updateModels((Iterable<? extends JpaContextModel>)this.getSpecifiedOverrides());
        this.updateVirtualOverrides();
    }

    public ListIterable<R> getOverrides() {
        return IterableTools.concatenate((ListIterable[])new ListIterable[]{this.getReadOnlySpecifiedOverrides(), this.getReadOnlyVirtualOverrides()});
    }

    @Override
    public int getOverridesSize() {
        return this.specifiedOverrides.size() + this.virtualOverrides.size();
    }

    public R getOverrideNamed(String name) {
        return this.selectOverrideNamed((Iterable<R>)this.getOverrides(), name);
    }

    public V convertOverrideToVirtual(SpecifiedOverride override) {
        if (override.isVirtual()) {
            throw new IllegalArgumentException("Override is already virtual: " + override);
        }
        OrmSpecifiedOverride specifiedOverride = (OrmSpecifiedOverride)override;
        int virtualIndex = this.virtualOverrides.size();
        String overrideName = specifiedOverride.getName();
        Object virtualOverride = null;
        if (this.overrideWillBeVirtual(overrideName, specifiedOverride)) {
            virtualOverride = this.buildVirtualOverride(overrideName);
            this.virtualOverrides.add(virtualIndex, virtualOverride);
        }
        this.removeSpecifiedOverride(specifiedOverride);
        if (virtualOverride != null) {
            this.fireItemAdded("virtualOverrides", virtualIndex, virtualOverride);
        }
        return (V)virtualOverride;
    }

    protected boolean overrideWillBeVirtual(String overrideName, S specifiedOverrideToBeRemoved) {
        return IterableTools.contains(this.getPossibleVirtualOverrideNames(), (Object)overrideName) && this.getSpecifiedOverrideNamed(overrideName, specifiedOverrideToBeRemoved) == null;
    }

    public S convertOverrideToSpecified(VirtualOverride override) {
        if (!override.isVirtual()) {
            throw new IllegalArgumentException("Override is already specified: " + override);
        }
        OrmVirtualOverride virtualOverride = (OrmVirtualOverride)override;
        int virtualIndex = this.virtualOverrides.indexOf(virtualOverride);
        this.virtualOverrides.remove(virtualIndex);
        int specifiedIndex = this.specifiedOverrides.size();
        X xmlOverride = this.buildXmlOverride();
        S specifiedOverride = this.buildSpecifiedOverride(xmlOverride);
        this.specifiedOverrides.add(specifiedIndex, specifiedOverride);
        this.parentAdapter.getXmlOverrides().add(specifiedIndex, xmlOverride);
        this.initializeSpecifiedOverride(specifiedOverride, virtualOverride);
        this.fireItemRemoved("virtualOverrides", virtualIndex, virtualOverride);
        this.fireItemAdded("specifiedOverrides", specifiedIndex, specifiedOverride);
        return specifiedOverride;
    }

    protected abstract void initializeSpecifiedOverride(S var1, V var2);

    public ListIterable<S> getSpecifiedOverrides() {
        return IterableTools.cloneLive(this.specifiedOverrides);
    }

    protected ListIterable<R> getReadOnlySpecifiedOverrides() {
        return this.getSpecifiedOverrides();
    }

    @Override
    public int getSpecifiedOverridesSize() {
        return this.specifiedOverrides.size();
    }

    public S getSpecifiedOverride(int index) {
        return (S)((OrmSpecifiedOverride)this.specifiedOverrides.get(index));
    }

    public S getSpecifiedOverrideNamed(String name) {
        return this.getSpecifiedOverrideNamed(name, null);
    }

    protected S getSpecifiedOverrideNamed(String name, S exclude) {
        return (S)((OrmSpecifiedOverride)this.selectOverrideNamed((Iterable<R>)this.getReadOnlySpecifiedOverrides(), name, exclude));
    }

    protected S addSpecifiedOverride() {
        return this.addSpecifiedOverride(this.specifiedOverrides.size());
    }

    protected S addSpecifiedOverride(int index) {
        X xmlOverride = this.buildXmlOverride();
        S override = this.addSpecifiedOverride_(index, xmlOverride);
        this.parentAdapter.getXmlOverrides().add(index, xmlOverride);
        return override;
    }

    protected abstract X buildXmlOverride();

    protected void removeSpecifiedOverride(S override) {
        this.removeSpecifiedOverride(this.specifiedOverrides.indexOf(override));
    }

    protected void removeSpecifiedOverride(int index) {
        this.removeSpecifiedOverride_(index);
        this.parentAdapter.getXmlOverrides().remove(index);
    }

    protected void removeSpecifiedOverride_(int index) {
        this.removeItemFromList(index, this.specifiedOverrides, "specifiedOverrides");
    }

    @Override
    public void moveSpecifiedOverride(int targetIndex, int sourceIndex) {
        this.moveItemInList(targetIndex, sourceIndex, this.specifiedOverrides, "specifiedOverrides");
        this.parentAdapter.getXmlOverrides().move(targetIndex, sourceIndex);
    }

    protected void initializeSpecifiedOverrides() {
        for (XmlOverride xmlOverride : this.getXmlOverrides()) {
            this.specifiedOverrides.add(this.buildSpecifiedOverride(xmlOverride));
        }
    }

    protected abstract S buildSpecifiedOverride(X var1);

    protected void syncSpecifiedOverrides() {
        ContextContainerTools.synchronizeWithResourceModel(this.specifiedOverrideContainerAdapter);
    }

    protected Iterable<X> getXmlOverrides() {
        return this.parentAdapter == null ? EmptyIterable.instance() : this.getXmlOverrides_();
    }

    protected abstract Iterable<X> getXmlOverrides_();

    protected void moveSpecifiedOverride_(int index, S override) {
        this.moveItemInList(index, override, this.specifiedOverrides, "specifiedOverrides");
    }

    protected S addSpecifiedOverride_(int index, X xmlOverride) {
        S override = this.buildSpecifiedOverride(xmlOverride);
        this.addItemToList(index, override, this.specifiedOverrides, "specifiedOverrides");
        return override;
    }

    protected void removeSpecifiedOverride_(S override) {
        this.removeSpecifiedOverride_(this.specifiedOverrides.indexOf(override));
    }

    public ListIterable<V> getVirtualOverrides() {
        return IterableTools.cloneLive(this.virtualOverrides);
    }

    protected ListIterable<R> getReadOnlyVirtualOverrides() {
        return this.getVirtualOverrides();
    }

    @Override
    public int getVirtualOverridesSize() {
        return this.virtualOverrides.size();
    }

    protected void updateVirtualOverrides() {
        ContextContainerTools.update(this.virtualOverrideContainerAdapter);
    }

    protected Iterable<String> getVirtualOverrideNames() {
        return IterableTools.filter(this.getPossibleVirtualOverrideNames(), (Predicate)new OverrideIsVirtual());
    }

    protected boolean overrideIsVirtual(String name) {
        return this.getSpecifiedOverrideNamed(name) == null;
    }

    protected void moveVirtualOverride(int index, V override) {
        this.moveItemInList(index, override, this.virtualOverrides, "virtualOverrides");
    }

    protected V addVirtualOverride(int index, String name) {
        V override = this.buildVirtualOverride(name);
        this.addItemToList(index, override, this.virtualOverrides, "virtualOverrides");
        return override;
    }

    protected abstract V buildVirtualOverride(String var1);

    protected void removeVirtualOverride(V override) {
        this.removeItemFromList(override, this.virtualOverrides, "virtualOverrides");
    }

    @Override
    public TypeMapping getOverridableTypeMapping() {
        return this.parentAdapter.getOverridableTypeMapping();
    }

    @Override
    public TypeMapping getTypeMapping() {
        return this.parentAdapter.getTypeMapping();
    }

    protected Iterable<String> getPossibleVirtualOverrideNames() {
        if (this.parentAdapter == null) {
            return EmptyIterable.instance();
        }
        Iterable<String> javaNames = this.parentAdapter.getJavaOverrideNames();
        return javaNames != null ? javaNames : this.parentAdapter.getAllOverridableNames();
    }

    @Override
    public Iterable<String> getAllOverridableNames() {
        return this.parentAdapter != null ? this.parentAdapter.getAllOverridableNames() : EmptyIterable.instance();
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        return this.parentAdapter.tableNameIsInvalid(tableName);
    }

    @Override
    public Iterable<String> getCandidateTableNames() {
        return this.parentAdapter.getCandidateTableNames();
    }

    @Override
    public Table resolveDbTable(String tableName) {
        return this.parentAdapter.resolveDbTable(tableName);
    }

    @Override
    public String getDefaultTableName() {
        return this.parentAdapter.getDefaultTableName();
    }

    @Override
    public JpaValidator buildOverrideValidator(Override_ override) {
        return this.parentAdapter.buildOverrideValidator(override, this);
    }

    @Override
    public JpaValidator buildColumnValidator(Override_ override, BaseColumn column, TableColumn.ParentAdapter columnParentAdapter) {
        return this.parentAdapter.buildColumnValidator(override, column, columnParentAdapter);
    }

    protected R selectOverrideNamed(Iterable<R> overrides, String name) {
        return this.selectOverrideNamed(overrides, name, null);
    }

    protected R selectOverrideNamed(Iterable<R> overrides, String name, S exclude) {
        for (Override_ override : overrides) {
            if (override == exclude || !this.valuesAreEqual(override.getName(), name)) continue;
            return (R)override;
        }
        return null;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        for (Override_ override : this.getOverrides()) {
            override.validate(messages, reporter);
        }
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.specifiedOverrides.size() > 0 ? ((OrmSpecifiedOverride)this.specifiedOverrides.get(0)).getValidationTextRange() : this.parentAdapter.getValidationTextRange();
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        for (Override_ override : this.getOverrides()) {
            result = override.getCompletionProposals(pos);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class OverrideIsVirtual
    extends PredicateAdapter<String> {
        public boolean evaluate(String name) {
            return AbstractOrmOverrideContainer.this.overrideIsVirtual(name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SpecifiedOverrideContainerAdapter
    implements ContextContainerTools.Adapter<S, X> {
        protected SpecifiedOverrideContainerAdapter() {
        }

        @Override
        public Iterable<S> getContextElements() {
            return AbstractOrmOverrideContainer.this.getSpecifiedOverrides();
        }

        @Override
        public Iterable<X> getResourceElements() {
            return AbstractOrmOverrideContainer.this.getXmlOverrides();
        }

        @Override
        public X getResourceElement(S contextElement) {
            return contextElement.getXmlOverride();
        }

        @Override
        public void moveContextElement(int index, S element) {
            AbstractOrmOverrideContainer.this.moveSpecifiedOverride_(index, element);
        }

        @Override
        public void addContextElement(int index, X resourceElement) {
            AbstractOrmOverrideContainer.this.addSpecifiedOverride_(index, resourceElement);
        }

        @Override
        public void removeContextElement(S element) {
            AbstractOrmOverrideContainer.this.removeSpecifiedOverride_(element);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class VirtualOverrideContainerAdapter
    implements ContextContainerTools.Adapter<V, String> {
        protected VirtualOverrideContainerAdapter() {
        }

        @Override
        public Iterable<V> getContextElements() {
            return AbstractOrmOverrideContainer.this.getVirtualOverrides();
        }

        @Override
        public Iterable<String> getResourceElements() {
            return AbstractOrmOverrideContainer.this.getVirtualOverrideNames();
        }

        @Override
        public String getResourceElement(V contextElement) {
            return contextElement.getName();
        }

        @Override
        public void moveContextElement(int index, V element) {
            AbstractOrmOverrideContainer.this.moveVirtualOverride(index, element);
        }

        @Override
        public void addContextElement(int index, String resourceElement) {
            AbstractOrmOverrideContainer.this.addVirtualOverride(index, resourceElement);
        }

        @Override
        public void removeContextElement(V element) {
            AbstractOrmOverrideContainer.this.removeVirtualOverride(element);
        }
    }
}

