/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.persistence;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jpt.common.core.resource.ProjectResourceLocator;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.SingleElementIterable;
import org.eclipse.jpt.jpa.core.context.orm.OrmXml;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.internal.context.persistence.AbstractOrmXmlRef;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.ReplaceEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmXmlRef
extends AbstractOrmXmlRef {
    protected final XmlMappingFileRef xmlMappingFileRef;

    public GenericOrmXmlRef(PersistenceUnit parent, XmlMappingFileRef xmlMappingFileRef) {
        super(parent, xmlMappingFileRef.getFileName());
        this.xmlMappingFileRef = xmlMappingFileRef;
    }

    @Override
    public void synchronizeWithResourceModel() {
        this.setFileName_(this.xmlMappingFileRef.getFileName());
        super.synchronizeWithResourceModel();
    }

    @Override
    public void setFileName(String fileName) {
        this.setFileName_(fileName);
        this.xmlMappingFileRef.setFileName(fileName);
    }

    protected void setFileName_(String xmlFileName) {
        String old = this.fileName;
        this.fileName = xmlFileName;
        if (this.firePropertyChanged("fileName", old, xmlFileName) && this.mappingFile != null) {
            ((OrmXml)this.mappingFile).dispose();
            this.setMappingFile(null);
        }
    }

    @Override
    public XmlMappingFileRef getXmlMappingFileRef() {
        return this.xmlMappingFileRef;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public TextRange getFullTextRange() {
        return this.xmlMappingFileRef.getFullTextRange();
    }

    @Override
    public boolean containsOffset(int textOffset) {
        return this.xmlMappingFileRef.containsOffset(textOffset);
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.xmlMappingFileRef.getFileNameTextRange();
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.getXmlValidationTextRange();
        return textRange != null ? textRange : this.getPersistenceUnit().getValidationTextRange();
    }

    protected TextRange getXmlValidationTextRange() {
        return this.xmlMappingFileRef.getFileNameTextRange();
    }

    @Override
    public Iterable<DeleteEdit> createDeleteMappingFileEdits(IFile file) {
        return this.isFor(file) ? new SingleElementIterable((Object)this.createDeleteEdit()) : EmptyIterable.instance();
    }

    protected DeleteEdit createDeleteEdit() {
        return this.xmlMappingFileRef.createDeleteEdit();
    }

    @Override
    protected ReplaceEdit createRenameEdit(IFile originalFile, String newName) {
        return this.xmlMappingFileRef.createRenameEdit(originalFile, newName);
    }

    @Override
    public Iterable<ReplaceEdit> createRenameFolderEdits(IFolder originalFolder, String newName) {
        return this.isIn(originalFolder) ? new SingleElementIterable((Object)this.createRenameFolderEdit(originalFolder, newName)) : EmptyIterable.instance();
    }

    protected ReplaceEdit createRenameFolderEdit(IFolder originalFolder, String newName) {
        return this.xmlMappingFileRef.createRenameFolderEdit(originalFolder, newName);
    }

    @Override
    protected ReplaceEdit createMoveEdit(IFile originalFile, IPath runtineDestination) {
        return this.xmlMappingFileRef.createMoveEdit(originalFile, runtineDestination);
    }

    @Override
    public Iterable<ReplaceEdit> createMoveFolderEdits(IFolder originalFolder, IPath runtimeDestination) {
        return this.isIn(originalFolder) ? new SingleElementIterable((Object)this.createMoveEdit(originalFolder, runtimeDestination)) : EmptyIterable.instance();
    }

    protected ReplaceEdit createMoveEdit(IFolder originalFolder, IPath runtimeDestination) {
        IProject project = originalFolder.getProject();
        IPath fullPath = originalFolder.getFullPath();
        ProjectResourceLocator locator = (ProjectResourceLocator)project.getAdapter(ProjectResourceLocator.class);
        IPath originalLocation = locator.getRuntimePath(fullPath);
        return this.createMoveEdit(originalLocation, runtimeDestination);
    }

    protected ReplaceEdit createMoveEdit(IPath originalLocation, IPath runtineDestination) {
        return this.xmlMappingFileRef.createMoveEdit(originalLocation, runtineDestination);
    }
}

