/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.operations;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jpt.common.core.internal.utility.PathTools;
import org.eclipse.jpt.common.core.resource.ProjectResourceLocator;
import org.eclipse.jpt.common.core.resource.xml.JptXmlResourceProvider;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.jpa.core.internal.operations.AbstractJpaFileCreationOperation;
import org.eclipse.jpt.jpa.core.internal.operations.OrmFileCreationDataModelProperties;
import org.eclipse.jpt.jpa.core.internal.resource.orm.OrmXmlResourceProvider;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class OrmFileCreationOperation
extends AbstractJpaFileCreationOperation
implements OrmFileCreationDataModelProperties {
    public OrmFileCreationOperation(IDataModel dataModel) {
        super(dataModel);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)5);
        IStatus status = super.execute((IProgressMonitor)sm.newChild(4), info);
        if (status.isOK()) {
            this.addMappingFileToPersistenceXml();
            sm.worked(1);
        }
        return OK_STATUS;
    }

    protected PersistenceUnit getPersistenceUnit() throws ExecutionException {
        String pUnitName = this.getDataModel().getStringProperty("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT");
        JpaProject jpaProject = this.getJpaProject();
        PersistenceXml persistenceXml = jpaProject.getContextModelRoot().getPersistenceXml();
        if (persistenceXml == null) {
            throw new ExecutionException("Project does not have a persistence.xml file");
        }
        Persistence persistence = persistenceXml.getRoot();
        if (persistence == null) {
            throw new ExecutionException("persistence.xml does not have a persistence node.");
        }
        for (PersistenceUnit pUnit : persistence.getPersistenceUnits()) {
            if (!pUnitName.equals(pUnit.getName())) continue;
            return pUnit;
        }
        throw new ExecutionException("persistence.xml does not have persistence unit named '" + pUnitName + "'");
    }

    protected void addMappingFileToPersistenceXml() throws ExecutionException {
        if (this.getDataModel().getBooleanProperty("OrmFileCreationDataModelProperties.ADD_TO_PERSISTENCE_UNIT")) {
            this.addMappingFileToPersistenceXml_();
        }
    }

    protected void addMappingFileToPersistenceXml_() throws ExecutionException {
        PersistenceUnit pUnit = this.getPersistenceUnit();
        IPath containerPath = (IPath)this.getDataModel().getProperty("JptFileCreationDataModelProperties.CONTAINER_PATH");
        String fileName = this.getDataModel().getStringProperty("JptFileCreationDataModelProperties.FILE_NAME");
        IContainer container = PathTools.getContainer((IPath)containerPath);
        IPath filePath = container.getFullPath().append(fileName);
        IProject project = container.getProject();
        ProjectResourceLocator locator = (ProjectResourceLocator)project.getAdapter(ProjectResourceLocator.class);
        IPath runtimePath = locator.getRuntimePath(filePath);
        boolean found = false;
        for (MappingFileRef ref : pUnit.getSpecifiedMappingFileRefs()) {
            if (!runtimePath.equals((Object)ref.getFileName())) continue;
            found = true;
            break;
        }
        if (!found) {
            pUnit.addSpecifiedMappingFileRef(runtimePath.toString());
        }
        this.getJpaProject().getPersistenceXmlResource().save();
    }

    protected JptXmlResourceProvider getXmlResourceProvider(IFile file) {
        return OrmXmlResourceProvider.getXmlResourceProvider(file);
    }
}

