/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.bundleexclude;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jpt.common.core.internal.plugin.JptCommonCorePlugin;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;

public final class FacetedReferencingProjectsPropertyTester
extends PropertyTester {
    private static final String ANY_FACETED_REFERENCING_PROJECTS_PROPERTY = "anyFacetedReferencingProjects";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean test(Object receiver, String property, Object[] args, Object value) {
        String versionExpression;
        String facetId;
        if (!property.equals(ANY_FACETED_REFERENCING_PROJECTS_PROPERTY)) return false;
        String val = (String)value;
        int colonIndex = val.indexOf(58);
        if (colonIndex == -1 || colonIndex == val.length() - 1) {
            facetId = val;
            versionExpression = null;
        } else {
            facetId = val.substring(0, colonIndex);
            versionExpression = val.substring(colonIndex + 1);
        }
        if (!(receiver instanceof IResource)) return false;
        try {
            if (FacetedProjectFramework.hasProjectFacet((IProject)((IResource)receiver).getProject(), (String)facetId, versionExpression)) {
                return true;
            }
            IProject[] iProjectArray = ((IResource)receiver).getProject().getReferencingProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IProject project = iProjectArray[n2];
                if (FacetedProjectFramework.hasProjectFacet((IProject)project, (String)facetId, (String)versionExpression)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            JptCommonCorePlugin.instance().logError(e);
        }
        return false;
    }
}

