/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.orm;

import org.eclipse.jpt.jpa.core.context.orm.OrmPersistenceUnitMetadata;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlPersistenceUnitMetadata;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class PersistenceUnitMetadataTests
extends ContextModelTestCase {
    public PersistenceUnitMetadataTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    protected OrmPersistenceUnitMetadata persistenceUnitMetadata() {
        return this.getEntityMappings().getPersistenceUnitMetadata();
    }

    public void testIsAllFeaturesUnset() throws Exception {
        XmlPersistenceUnitMetadata persistenceUnitMetadata = OrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata();
        this.getXmlEntityMappings().setPersistenceUnitMetadata(persistenceUnitMetadata);
        PersistenceUnitMetadataTests.assertTrue((boolean)persistenceUnitMetadata.isUnset());
        persistenceUnitMetadata.setXmlMappingMetadataComplete(true);
        PersistenceUnitMetadataTests.assertFalse((boolean)persistenceUnitMetadata.isUnset());
        persistenceUnitMetadata.setXmlMappingMetadataComplete(false);
        PersistenceUnitMetadataTests.assertTrue((boolean)persistenceUnitMetadata.isUnset());
        persistenceUnitMetadata.setPersistenceUnitDefaults(OrmFactory.eINSTANCE.createXmlPersistenceUnitDefaults());
        PersistenceUnitMetadataTests.assertFalse((boolean)persistenceUnitMetadata.isUnset());
    }

    public void testUpdateXmlMappingMetadataComplete() throws Exception {
        OrmPersistenceUnitMetadata persistenceUnitMetadata = this.getEntityMappings().getPersistenceUnitMetadata();
        PersistenceUnitMetadataTests.assertFalse((boolean)persistenceUnitMetadata.isXmlMappingMetadataComplete());
        PersistenceUnitMetadataTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
        this.getXmlEntityMappings().setPersistenceUnitMetadata(OrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        PersistenceUnitMetadataTests.assertTrue((boolean)persistenceUnitMetadata.isXmlMappingMetadataComplete());
        PersistenceUnitMetadataTests.assertTrue((boolean)this.getXmlEntityMappings().getPersistenceUnitMetadata().isXmlMappingMetadataComplete());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(false);
        PersistenceUnitMetadataTests.assertFalse((boolean)persistenceUnitMetadata.isXmlMappingMetadataComplete());
        PersistenceUnitMetadataTests.assertFalse((boolean)this.getXmlEntityMappings().getPersistenceUnitMetadata().isXmlMappingMetadataComplete());
    }

    public void testModifyXmlMappingMetadataComplete() throws Exception {
        OrmPersistenceUnitMetadata persistenceUnitMetadata = this.getEntityMappings().getPersistenceUnitMetadata();
        PersistenceUnitMetadataTests.assertFalse((boolean)persistenceUnitMetadata.isXmlMappingMetadataComplete());
        PersistenceUnitMetadataTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
        persistenceUnitMetadata.setXmlMappingMetadataComplete(true);
        PersistenceUnitMetadataTests.assertTrue((boolean)persistenceUnitMetadata.isXmlMappingMetadataComplete());
        PersistenceUnitMetadataTests.assertTrue((boolean)this.getXmlEntityMappings().getPersistenceUnitMetadata().isXmlMappingMetadataComplete());
        persistenceUnitMetadata.setXmlMappingMetadataComplete(false);
        PersistenceUnitMetadataTests.assertFalse((boolean)persistenceUnitMetadata.isXmlMappingMetadataComplete());
        PersistenceUnitMetadataTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
    }

    public void testModifyXmlMappingMetadataComplete2() throws Exception {
        OrmPersistenceUnitMetadata persistenceUnitMetadata = this.getEntityMappings().getPersistenceUnitMetadata();
        PersistenceUnitMetadataTests.assertFalse((boolean)persistenceUnitMetadata.isXmlMappingMetadataComplete());
        PersistenceUnitMetadataTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
        persistenceUnitMetadata.setXmlMappingMetadataComplete(true);
        PersistenceUnitMetadataTests.assertTrue((boolean)persistenceUnitMetadata.isXmlMappingMetadataComplete());
        PersistenceUnitMetadataTests.assertTrue((boolean)this.getXmlEntityMappings().getPersistenceUnitMetadata().isXmlMappingMetadataComplete());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().setPersistenceUnitDefaults(OrmFactory.eINSTANCE.createXmlPersistenceUnitDefaults());
        persistenceUnitMetadata.setXmlMappingMetadataComplete(false);
        PersistenceUnitMetadataTests.assertFalse((boolean)persistenceUnitMetadata.isXmlMappingMetadataComplete());
        PersistenceUnitMetadataTests.assertFalse((boolean)this.getXmlEntityMappings().getPersistenceUnitMetadata().isXmlMappingMetadataComplete());
    }
}

