/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.BaseEnumeratedConverter;
import org.eclipse.jpt.jpa.core.context.BaseTemporalConverter;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.EnumType;
import org.eclipse.jpt.jpa.core.context.FetchType;
import org.eclipse.jpt.jpa.core.context.OneToManyMapping;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.SpecifiedColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaEntity;
import org.eclipse.jpt.jpa.core.context.java.JavaOneToManyMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmEntity;
import org.eclipse.jpt.jpa.core.context.orm.OrmOneToManyMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.orm.NullOrmConverter;
import org.eclipse.jpt.jpa.core.jpa2.context.Cascade2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.OneToManyMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.OneToManyRelationship2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.Orderable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.OrphanRemovable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.SpecifiedOrderColumn2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmOneToManyRelationship2_0;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapKeyColumnAnnotation2_0;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.TemporalType;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.core.resource.orm.XmlJoinColumn;
import org.eclipse.jpt.jpa.core.resource.orm.XmlOneToMany;
import org.eclipse.jpt.jpa.core.resource.orm.v2_0.XmlOneToMany_2_0;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.Generic2_0ContextModelTestCase;

public class GenericOrmOneToManyMapping2_0Tests
extends Generic2_0ContextModelTestCase {
    public GenericOrmOneToManyMapping2_0Tests(String name) {
        super(name);
    }

    private void createTestTargetEntityAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestTargetEntityAddressWithElementCollection() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ElementCollection");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Collection<State> state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEntityWithValidOneToManyMapping() throws Exception {
        this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private java.util.Collection<Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        for (OrmPersistentAttribute each : ormPersistentType.getAttributes()) {
            each.addToXml();
        }
    }

    private ICompilationUnit createTestEntityWithValidMapOneToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private java.util.Map<String, Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidNonGenericMapOneToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private java.util.Map addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestEmbeddableState() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("State").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String name;").append(CR);
                sb.append(CR);
                sb.append("    private String abbr;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "State.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityWithValidGenericMapOneToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private java.util.Map<String, Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityOneToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.FetchType", "javax.persistence.CascadeType", "javax.persistence.OrderBy", "javax.persistence.MapKeyEnumerated", "javax.persistence.EnumType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany(fetch=FetchType.EAGER, targetEntity=Address.class, orphanRemoval = true, cascade={CascadeType.ALL, CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE, CascadeType.REFRESH, CascadeType.DETACH})");
                sb.append(CR);
                sb.append("    @OrderBy(\"city\"");
                sb.append(CR);
                sb.append("    @MapKeyEnumerated(EnumType.STRING)").append(CR);
                sb.append("    private java.util.Collection<Address> address;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    public void testCandidateMappedByAttributeNames() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("addresses"), "oneToMany");
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)ormPersistentType.getAttributes().iterator().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        Iterator attributeNames = oneToManyMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"state.name", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"state.abbr", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        oneToManyMapping.setSpecifiedTargetEntity("foo");
        attributeNames = oneToManyMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        oneToManyMapping.setSpecifiedTargetEntity(null);
        attributeNames = oneToManyMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"state.name", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"state.abbr", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        AttributeMapping stateFooMapping = oneToManyMapping.getResolvedTargetEntity().resolveAttributeMapping("state.name");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"name", (String)stateFooMapping.getName());
    }

    public void testCandidateMappedByAttributeNamesElementCollection() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.createTestTargetEntityAddressWithElementCollection();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("addresses"), "oneToMany");
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)ormPersistentType.getAttributes().iterator().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        Iterator attributeNames = oneToManyMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"state.name", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"state.abbr", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        oneToManyMapping.setSpecifiedTargetEntity("foo");
        attributeNames = oneToManyMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        oneToManyMapping.setSpecifiedTargetEntity(null);
        attributeNames = oneToManyMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"state.name", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"state.abbr", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        AttributeMapping stateFooMapping = oneToManyMapping.getResolvedTargetEntity().resolveAttributeMapping("state.name");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"name", (String)stateFooMapping.getName());
    }

    private OrphanRemovable2_0 getOrphanRemovalOf(OneToManyMapping2_0 oneToManyMapping) {
        return oneToManyMapping.getOrphanRemoval();
    }

    public void testUpdateSpecifiedOrphanRemoval() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "oneToMany");
        OneToManyMapping2_0 ormOneToManyMapping = (OneToManyMapping2_0)ormPersistentAttribute.getMapping();
        OrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf(ormOneToManyMapping);
        XmlOneToMany oneToManyResource = (XmlOneToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        GenericOrmOneToManyMapping2_0Tests.assertEquals(null, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        GenericOrmOneToManyMapping2_0Tests.assertEquals(null, (Object)oneToManyResource.getOrphanRemoval());
        oneToManyResource.setOrphanRemoval(Boolean.TRUE);
        GenericOrmOneToManyMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)oneToManyResource.getOrphanRemoval());
        oneToManyResource.setOrphanRemoval(Boolean.FALSE);
        GenericOrmOneToManyMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)oneToManyResource.getOrphanRemoval());
    }

    public void testModifySpecifiedOrphanRemoval() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "oneToMany");
        OneToManyMapping2_0 ormOneToManyMapping = (OneToManyMapping2_0)ormPersistentAttribute.getMapping();
        OrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf(ormOneToManyMapping);
        XmlOneToMany oneToManyResource = (XmlOneToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        GenericOrmOneToManyMapping2_0Tests.assertEquals(null, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        GenericOrmOneToManyMapping2_0Tests.assertEquals(null, (Object)oneToManyResource.getOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(Boolean.TRUE);
        GenericOrmOneToManyMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)oneToManyResource.getOrphanRemoval());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(Boolean.FALSE);
        GenericOrmOneToManyMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)oneToManyResource.getOrphanRemoval());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
    }

    public void testUpdateMapKey() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "oneToMany");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        XmlOneToMany oneToMany = (XmlOneToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKey());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)oneToMany.getMapKey());
        oneToMany.setMapKey(OrmFactory.eINSTANCE.createMapKey());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKey());
        GenericOrmOneToManyMapping2_0Tests.assertNotNull((Object)oneToMany.getMapKey());
        oneToMany.getMapKey().setName("myMapKey");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"myMapKey", (String)ormOneToManyMapping.getSpecifiedMapKey());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"myMapKey", (String)oneToMany.getMapKey().getName());
        oneToMany.getMapKey().setName(null);
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKey());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)oneToMany.getMapKey().getName());
        oneToMany.getMapKey().setName("myMapKey");
        oneToMany.setMapKey(null);
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKey());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)oneToMany.getMapKey());
    }

    public void testUpdateVirtualMapKey() throws Exception {
        this.createTestEntityWithValidMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        OneToManyMapping oneToManyMapping = (OneToManyMapping)ormPersistentType.getAttributeNamed("addresses").getMapping();
        JavaOneToManyMapping javaOneToManyMapping = (JavaOneToManyMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)oneToManyMapping.getSpecifiedMapKey());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)oneToManyMapping.getMapKey());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)oneToManyMapping.isPkMapKey());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)oneToManyMapping.isCustomMapKey());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)oneToManyMapping.isNoMapKey());
        javaOneToManyMapping.setPkMapKey(true);
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"id", (String)oneToManyMapping.getMapKey());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)oneToManyMapping.isPkMapKey());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)oneToManyMapping.isCustomMapKey());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)oneToManyMapping.isNoMapKey());
        javaOneToManyMapping.setCustomMapKey(true);
        javaOneToManyMapping.setSpecifiedMapKey("city");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"city", (String)oneToManyMapping.getSpecifiedMapKey());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"city", (String)oneToManyMapping.getMapKey());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)oneToManyMapping.isPkMapKey());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)oneToManyMapping.isCustomMapKey());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)oneToManyMapping.isNoMapKey());
    }

    public void testModifyMapKey() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "oneToMany");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        XmlOneToMany oneToMany = (XmlOneToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKey());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)oneToMany.getMapKey());
        ormOneToManyMapping.setSpecifiedMapKey("myMapKey");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"myMapKey", (String)ormOneToManyMapping.getSpecifiedMapKey());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"myMapKey", (String)oneToMany.getMapKey().getName());
        ormOneToManyMapping.setSpecifiedMapKey(null);
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKey());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)oneToMany.getMapKey().getName());
    }

    public void testCandidateMapKeyNames() throws Exception {
        this.createTestEntityWithValidMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        OneToManyMapping oneToManyMapping = (OneToManyMapping)ormPersistentType.getAttributeNamed("addresses").getMapping();
        Iterator mapKeyNames = oneToManyMapping.getCandidateMapKeyNames().iterator();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"state.name", (String)((String)mapKeyNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"state.abbr", (String)((String)mapKeyNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)mapKeyNames.hasNext());
    }

    public void testCandidateMapKeyNames2() throws Exception {
        this.createTestEntityWithValidNonGenericMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        OneToManyMapping oneToManyMapping = (OneToManyMapping)ormPersistentType.getAttributeNamed("addresses").getMapping();
        JavaOneToManyMapping javaOneToManyMapping = (JavaOneToManyMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        Iterator mapKeyNames = oneToManyMapping.getCandidateMapKeyNames().iterator();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
        javaOneToManyMapping.setSpecifiedTargetEntity("test.Address");
        mapKeyNames = oneToManyMapping.getCandidateMapKeyNames().iterator();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"state.name", (String)((String)mapKeyNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"state.abbr", (String)((String)mapKeyNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)mapKeyNames.hasNext());
        ormPersistentType.getAttributeNamed("addresses").addToXml();
        oneToManyMapping = (OneToManyMapping)ormPersistentType.getAttributeNamed("addresses").getMapping();
        mapKeyNames = oneToManyMapping.getCandidateMapKeyNames().iterator();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
        oneToManyMapping.setSpecifiedTargetEntity("test.Address");
        mapKeyNames = oneToManyMapping.getCandidateMapKeyNames().iterator();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"state.name", (String)((String)mapKeyNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"state.abbr", (String)((String)mapKeyNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)mapKeyNames.hasNext());
        oneToManyMapping.setSpecifiedTargetEntity("String");
        mapKeyNames = oneToManyMapping.getCandidateMapKeyNames().iterator();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
    }

    public void testUpdateMapKeyClass() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "oneToMany");
        OneToManyMapping2_0 ormOneToManyMapping = (OneToManyMapping2_0)ormPersistentAttribute.getMapping();
        XmlOneToMany oneToMany = (XmlOneToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKeyClass());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)oneToMany.getMapKeyClass());
        oneToMany.setMapKeyClass(OrmFactory.eINSTANCE.createXmlClassReference());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKeyClass());
        GenericOrmOneToManyMapping2_0Tests.assertNotNull((Object)oneToMany.getMapKeyClass());
        oneToMany.getMapKeyClass().setClassName("String");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"String", (String)ormOneToManyMapping.getSpecifiedMapKeyClass());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"String", (String)oneToMany.getMapKeyClass().getClassName());
        oneToMany.getMapKeyClass().setClassName(null);
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKeyClass());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)oneToMany.getMapKeyClass().getClassName());
        oneToMany.getMapKeyClass().setClassName("String");
        oneToMany.setMapKeyClass(null);
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKeyClass());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)oneToMany.getMapKeyClass());
    }

    public void testUpdateVirtualMapKeyClass() throws Exception {
        this.createTestEntityWithValidMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)ormPersistentType.getAttributeNamed("addresses").getMapping();
        OneToManyMapping2_0 javaOneToManyMapping = (OneToManyMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"java.lang.String", (String)oneToManyMapping.getMapKeyClass());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)oneToManyMapping.getSpecifiedMapKeyClass());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"java.lang.String", (String)oneToManyMapping.getDefaultMapKeyClass());
        javaOneToManyMapping.setSpecifiedMapKeyClass("Integer");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"Integer", (String)oneToManyMapping.getMapKeyClass());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"Integer", (String)oneToManyMapping.getSpecifiedMapKeyClass());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"java.lang.String", (String)oneToManyMapping.getDefaultMapKeyClass());
    }

    public void testModifyMapKeyClass() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "oneToMany");
        OneToManyMapping2_0 ormOneToManyMapping = (OneToManyMapping2_0)ormPersistentAttribute.getMapping();
        XmlOneToMany oneToMany = (XmlOneToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKeyClass());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)oneToMany.getMapKeyClass());
        ormOneToManyMapping.setSpecifiedMapKeyClass("String");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"String", (String)ormOneToManyMapping.getSpecifiedMapKeyClass());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"String", (String)oneToMany.getMapKeyClass().getClassName());
        ormOneToManyMapping.setSpecifiedMapKeyClass(null);
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKeyClass());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)oneToMany.getMapKeyClass());
    }

    public void testOrderColumnDefaults() throws Exception {
        this.createTestEntityPrintQueue();
        this.createTestEntityPrintJob();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.PrintQueue");
        this.getEntityMappings().addPersistentType("entity", "test.PrintJob");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("jobs"), "oneToMany");
        OrmOneToManyMapping oneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        oneToManyMapping.getRelationship().setStrategyToMappedBy();
        oneToManyMapping.getRelationship().getMappedByStrategy().setMappedByAttribute("queue");
        Orderable2_0 orderable = (Orderable2_0)oneToManyMapping.getOrderable();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)orderable.isOrderColumnOrdering());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)orderable.isNoOrdering());
        orderable.setOrderColumnOrdering(true);
        SpecifiedOrderColumn2_0 orderColumn = orderable.getOrderColumn();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)orderable.isOrderColumnOrdering());
        GenericOrmOneToManyMapping2_0Tests.assertEquals(null, (String)orderColumn.getSpecifiedName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"jobs_ORDER", (String)orderColumn.getDefaultName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"PrintJob", (String)orderColumn.getTableName());
        orderColumn.setSpecifiedName("FOO");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)orderColumn.getSpecifiedName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"jobs_ORDER", (String)orderColumn.getDefaultName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"PrintJob", (String)orderColumn.getTableName());
        OrmPersistentType printJobPersistentType = (OrmPersistentType)this.getPersistenceUnit().getPersistentType("test.PrintJob");
        ((Entity)printJobPersistentType.getMapping()).getTable().setSpecifiedName("MY_TABLE");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"MY_TABLE", (String)orderColumn.getTableName());
    }

    public void testVirtualOrderColumn() throws Exception {
        this.createTestEntityPrintQueue();
        this.createTestEntityPrintJob();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.PrintQueue");
        this.getEntityMappings().addPersistentType("entity", "test.PrintJob");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("jobs"), "oneToMany");
        OneToManyMapping oneToManyMapping = (OneToManyMapping)ormPersistentAttribute.getMapping();
        Orderable2_0 orderable = (Orderable2_0)oneToManyMapping.getOrderable();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)orderable.isOrderColumnOrdering());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)orderable.isNoOrdering());
        JavaOneToManyMapping javaOneToManyMapping = (JavaOneToManyMapping)ormPersistentAttribute.getJavaPersistentAttribute().getMapping();
        ((Orderable2_0)javaOneToManyMapping.getOrderable()).setOrderColumnOrdering(true);
        GenericOrmOneToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)orderable.isOrderColumnOrdering());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)orderable.isNoOrdering());
        ormPersistentAttribute.removeFromXml();
        OrmPersistentAttribute ormPersistentAttribute2 = ormPersistentType.getAttributeNamed("jobs");
        oneToManyMapping = (OneToManyMapping)ormPersistentAttribute2.getMapping();
        orderable = (Orderable2_0)oneToManyMapping.getOrderable();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)orderable.isOrderColumnOrdering());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)orderable.isNoOrdering());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"PrintJob", (String)orderable.getOrderColumn().getTableName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"jobs_ORDER", (String)orderable.getOrderColumn().getName());
        ((Orderable2_0)javaOneToManyMapping.getOrderable()).getOrderColumn().setSpecifiedName("FOO");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"PrintJob", (String)orderable.getOrderColumn().getTableName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)orderable.getOrderColumn().getName());
    }

    private void createTestEntityPrintQueue() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.OneToMany");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.OrderColumn");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("PrintQueue").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private String name;").append(CR);
                sb.append(CR);
                sb.append("    @OneToMany(mappedBy=\"queue\")").append(CR);
                sb.append("    @OrderColumn").append(CR);
                sb.append("    private java.util.List<PrintJob> jobs;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "PrintQueue.java", sourceWriter);
    }

    private void createTestEntityPrintJob() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ManyToOne");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("PrintJob").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToOne").append(CR);
                sb.append("    private PrintQueue queue;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "PrintJob.java", sourceWriter);
    }

    public void testVirtualMapKeyColumnDefaults() throws Exception {
        this.createTestEntityWithValidMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        OrmPersistentAttribute addressesPersistentAttribute = ormPersistentType.getAttributeNamed("addresses");
        OneToManyMapping2_0 virtualAddressesMapping = (OneToManyMapping2_0)addressesPersistentAttribute.getMapping();
        SpecifiedColumn virtualColumn = virtualAddressesMapping.getMapKeyColumn();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"addresses_KEY", (String)virtualColumn.getName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)virtualColumn.getTableName());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)virtualColumn.getColumnDefinition());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)virtualColumn.isInsertable());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)virtualColumn.isUpdatable());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)virtualColumn.isNullable());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)virtualColumn.isUnique());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((int)255, (int)virtualColumn.getLength());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((int)0, (int)virtualColumn.getPrecision());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((int)0, (int)virtualColumn.getScale());
        OneToManyMapping2_0 javaOneToManyMapping = (OneToManyMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedName("FOO");
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedTableName("FOO_TABLE");
        javaOneToManyMapping.getMapKeyColumn().setColumnDefinition("COLUMN_DEFINITION");
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedInsertable(Boolean.FALSE);
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedUpdatable(Boolean.FALSE);
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedNullable(Boolean.FALSE);
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedUnique(Boolean.TRUE);
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedLength(Integer.valueOf(45));
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedPrecision(Integer.valueOf(46));
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedScale(Integer.valueOf(47));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)virtualColumn.getName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"FOO_TABLE", (String)virtualColumn.getTableName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"COLUMN_DEFINITION", (String)virtualColumn.getColumnDefinition());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)virtualColumn.isInsertable());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)virtualColumn.isUpdatable());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)virtualColumn.isNullable());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)virtualColumn.isUnique());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((int)45, (int)virtualColumn.getLength());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((int)46, (int)virtualColumn.getPrecision());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((int)47, (int)virtualColumn.getScale());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        addressesPersistentAttribute = ormPersistentType.getAttributeNamed("addresses");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY, (String)addressesPersistentAttribute.getMappingKey());
    }

    public void testNullMapKeyColumnDefaults() throws Exception {
        this.createTestEntityWithValidMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        OrmSpecifiedPersistentAttribute addressesPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("addresses"), "oneToMany");
        OneToManyMapping2_0 addressesVirtualMapping = (OneToManyMapping2_0)addressesPersistentAttribute.getMapping();
        SpecifiedColumn ormColumn = addressesVirtualMapping.getMapKeyColumn();
        OneToManyMapping2_0 javaOneToManyMapping = (OneToManyMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedName("FOO");
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedTableName("FOO_TABLE");
        javaOneToManyMapping.getMapKeyColumn().setColumnDefinition("COLUMN_DEFINITION");
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedInsertable(Boolean.FALSE);
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedUpdatable(Boolean.FALSE);
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedNullable(Boolean.FALSE);
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedUnique(Boolean.TRUE);
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedLength(Integer.valueOf(45));
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedPrecision(Integer.valueOf(46));
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedScale(Integer.valueOf(47));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"addresses_KEY", (String)ormColumn.getDefaultName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)ormColumn.getDefaultTableName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultInsertable());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultUpdatable());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultNullable());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)ormColumn.isDefaultUnique());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((int)255, (int)ormColumn.getDefaultLength());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((int)0, (int)ormColumn.getDefaultPrecision());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((int)0, (int)ormColumn.getDefaultScale());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormColumn.getSpecifiedName());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormColumn.getSpecifiedTableName());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormColumn.getColumnDefinition());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormColumn.getSpecifiedInsertable());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormColumn.getSpecifiedUpdatable());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormColumn.getSpecifiedNullable());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormColumn.getSpecifiedUnique());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormColumn.getSpecifiedLength());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormColumn.getSpecifiedPrecision());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormColumn.getSpecifiedScale());
    }

    public void testVirtualMapKeyColumnTable() throws Exception {
        this.createTestEntityWithValidMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        OrmPersistentAttribute addressesPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next();
        OneToManyMapping2_0 virtualAddressesMapping = (OneToManyMapping2_0)addressesPersistentAttribute.getMapping();
        SpecifiedColumn virtualColumn = virtualAddressesMapping.getMapKeyColumn();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)virtualColumn.getTableName());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)virtualColumn.getSpecifiedTableName());
        ((OrmEntity)ormPersistentType.getMapping()).getTable().setSpecifiedName("ORM_TABLE");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"ORM_TABLE_Address", (String)virtualColumn.getTableName());
        OneToManyMapping2_0 javaOneToManyMapping = (OneToManyMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        javaOneToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("JAVA_JOIN_TABLE");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"JAVA_JOIN_TABLE", (String)virtualColumn.getTableName());
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedTableName("JAVA_TABLE");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"JAVA_TABLE", (String)virtualColumn.getTableName());
        addressesPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("addresses"), "oneToMany");
        OneToManyMapping2_0 specifiedAddressesMapping = (OneToManyMapping2_0)addressesPersistentAttribute.getMapping();
        SpecifiedColumn specifiedColumn = specifiedAddressesMapping.getMapKeyColumn();
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)specifiedColumn.getSpecifiedTableName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"ORM_TABLE_Address", (String)specifiedColumn.getDefaultTableName());
    }

    public void testModifyPredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("addresses");
        OneToManyMapping2_0 contextMapping = (OneToManyMapping2_0)contextAttribute.getMapping();
        OrmOneToManyRelationship2_0 rel = (OrmOneToManyRelationship2_0)contextMapping.getRelationship();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlOneToMany resourceMapping = (XmlOneToMany)resourceEntity.getAttributes().getOneToManys().get(0);
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinTable());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
        rel.setStrategyToJoinColumn();
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinColumn());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
        rel.setStrategyToMappedBy();
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToManyMapping2_0Tests.assertNotNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)rel.strategyIsMappedBy());
        rel.setStrategyToJoinTable();
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinTable());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
    }

    public void testUpdatePredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("addresses");
        OneToManyMapping2_0 contextMapping = (OneToManyMapping2_0)contextAttribute.getMapping();
        OrmOneToManyRelationship2_0 rel = (OrmOneToManyRelationship2_0)contextMapping.getRelationship();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlOneToMany resourceMapping = (XmlOneToMany)resourceEntity.getAttributes().getOneToManys().get(0);
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinTable());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
        resourceMapping.setMappedBy("foo");
        this.getJpaProject().synchronizeContextModel();
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToManyMapping2_0Tests.assertNotNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)rel.strategyIsMappedBy());
        resourceMapping.setJoinTable(OrmFactory.eINSTANCE.createXmlJoinTable());
        this.getJpaProject().synchronizeContextModel();
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToManyMapping2_0Tests.assertNotNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToManyMapping2_0Tests.assertNotNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)rel.strategyIsMappedBy());
        resourceMapping.getJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumn());
        this.getJpaProject().synchronizeContextModel();
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToManyMapping2_0Tests.assertNotNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToManyMapping2_0Tests.assertNotNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)rel.strategyIsMappedBy());
        resourceMapping.setMappedBy(null);
        this.getJpaProject().synchronizeContextModel();
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToManyMapping2_0Tests.assertNotNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinColumn());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
        resourceMapping.setJoinTable(null);
        this.getJpaProject().synchronizeContextModel();
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinColumn());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
        resourceMapping.getJoinColumns().clear();
        this.getJpaProject().synchronizeContextModel();
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinTable());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
    }

    public void testTargetForeignKeyJoinColumnStrategy() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentType ormTargetPersistentType = this.getEntityMappings().addPersistentType("entity", "test.Address");
        OrmPersistentAttribute persistentAttribute = ormPersistentType.getAttributeNamed("addresses");
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        OneToManyMapping2_0 javaOneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getJavaPersistentAttribute().getMapping();
        OneToManyRelationship2_0 rr = (OneToManyRelationship2_0)javaOneToManyMapping.getRelationship();
        rr.setStrategyToJoinColumn();
        SpecifiedJoinColumn joinColumn = (SpecifiedJoinColumn)rr.getJoinColumnStrategy().getJoinColumns().iterator().next();
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)persistentAttribute.isVirtual());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"addresses_id", (String)joinColumn.getDefaultName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"Address", (String)joinColumn.getDefaultTableName());
        JavaEntity addressEntity = (JavaEntity)ormTargetPersistentType.getJavaPersistentType().getMapping();
        addressEntity.getTable().setSpecifiedName("ADDRESS_PRIMARY_TABLE");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"ADDRESS_PRIMARY_TABLE", (String)joinColumn.getDefaultTableName());
        persistentAttribute.addToXml();
        persistentAttribute = ormPersistentType.getAttributeNamed("addresses");
        oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)persistentAttribute.isVirtual());
        rr = (OneToManyRelationship2_0)oneToManyMapping.getRelationship();
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rr.strategyIsJoinColumn());
        rr.setStrategyToJoinColumn();
        joinColumn = (SpecifiedJoinColumn)rr.getJoinColumnStrategy().getSpecifiedJoinColumns().iterator().next();
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)persistentAttribute.isVirtual());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"addresses_id", (String)joinColumn.getDefaultName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"ADDRESS_PRIMARY_TABLE", (String)joinColumn.getDefaultTableName());
        OrmEntity ormAddressEntity = (OrmEntity)ormTargetPersistentType.getMapping();
        ormAddressEntity.getTable().setSpecifiedName("ORM_ADDRESS_PRIMARY_TABLE");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"ORM_ADDRESS_PRIMARY_TABLE", (String)joinColumn.getDefaultTableName());
        joinColumn.setSpecifiedName("FOO");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"addresses_id", (String)joinColumn.getDefaultName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)joinColumn.getSpecifiedName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"ORM_ADDRESS_PRIMARY_TABLE", (String)joinColumn.getDefaultTableName());
    }

    public void testGetMapKeyColumnJoinColumnStrategy() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentType ormTargetPersistentType = this.getEntityMappings().addPersistentType("entity", "test.Address");
        OrmPersistentAttribute persistentAttribute = ormPersistentType.getAttributeNamed("addresses");
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        OneToManyMapping2_0 javaOneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getJavaPersistentAttribute().getMapping();
        OneToManyRelationship2_0 rr = (OneToManyRelationship2_0)javaOneToManyMapping.getRelationship();
        rr.setStrategyToJoinColumn();
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)persistentAttribute.isVirtual());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"addresses_KEY", (String)oneToManyMapping.getMapKeyColumn().getName());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)oneToManyMapping.getMapKeyColumn().getSpecifiedName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"Address", (String)oneToManyMapping.getMapKeyColumn().getTableName());
        JavaEntity addressEntity = (JavaEntity)ormTargetPersistentType.getJavaPersistentType().getMapping();
        addressEntity.getTable().setSpecifiedName("ADDRESS_PRIMARY_TABLE");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"ADDRESS_PRIMARY_TABLE", (String)oneToManyMapping.getMapKeyColumn().getTableName());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        MapKeyColumnAnnotation2_0 column = (MapKeyColumnAnnotation2_0)resourceField.addAnnotation("javax.persistence.MapKeyColumn");
        column.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"foo", (String)oneToManyMapping.getMapKeyColumn().getSpecifiedName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"foo", (String)oneToManyMapping.getMapKeyColumn().getName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"addresses_KEY", (String)oneToManyMapping.getMapKeyColumn().getDefaultName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"ADDRESS_PRIMARY_TABLE", (String)oneToManyMapping.getMapKeyColumn().getDefaultTableName());
        persistentAttribute.addToXml();
        persistentAttribute = ormPersistentType.getAttributeNamed("addresses");
        oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)persistentAttribute.isVirtual());
        rr = (OneToManyRelationship2_0)oneToManyMapping.getRelationship();
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rr.strategyIsJoinColumn());
        rr.setStrategyToJoinColumn();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"addresses_KEY", (String)oneToManyMapping.getMapKeyColumn().getName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"ADDRESS_PRIMARY_TABLE", (String)oneToManyMapping.getMapKeyColumn().getTableName());
        OrmEntity ormAddressEntity = (OrmEntity)ormTargetPersistentType.getMapping();
        ormAddressEntity.getTable().setSpecifiedName("ORM_ADDRESS_PRIMARY_TABLE");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"addresses_KEY", (String)oneToManyMapping.getMapKeyColumn().getName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"ORM_ADDRESS_PRIMARY_TABLE", (String)oneToManyMapping.getMapKeyColumn().getTableName());
        oneToManyMapping.getMapKeyColumn().setSpecifiedName("FOO");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"addresses_KEY", (String)oneToManyMapping.getMapKeyColumn().getDefaultName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)oneToManyMapping.getMapKeyColumn().getSpecifiedName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"ORM_ADDRESS_PRIMARY_TABLE", (String)oneToManyMapping.getMapKeyColumn().getDefaultTableName());
    }

    public void testOrderColumnDefaultsJoinColumnStrategy() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentType ormTargetPersistentType = this.getEntityMappings().addPersistentType("entity", "test.Address");
        OrmPersistentAttribute persistentAttribute = ormPersistentType.getAttributeNamed("addresses");
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        OneToManyMapping2_0 javaOneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getJavaPersistentAttribute().getMapping();
        OneToManyRelationship2_0 rr = (OneToManyRelationship2_0)javaOneToManyMapping.getRelationship();
        rr.setStrategyToJoinColumn();
        ((Orderable2_0)javaOneToManyMapping.getOrderable()).setOrderColumnOrdering(true);
        SpecifiedOrderColumn2_0 orderColumn = ((Orderable2_0)oneToManyMapping.getOrderable()).getOrderColumn();
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)orderColumn.getSpecifiedName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"addresses_ORDER", (String)orderColumn.getDefaultName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"Address", (String)orderColumn.getTableName());
        JavaEntity addressEntity = (JavaEntity)ormTargetPersistentType.getJavaPersistentType().getMapping();
        addressEntity.getTable().setSpecifiedName("ADDRESS_PRIMARY_TABLE");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"ADDRESS_PRIMARY_TABLE", (String)orderColumn.getTableName());
        persistentAttribute.addToXml();
        persistentAttribute = ormPersistentType.getAttributeNamed("addresses");
        oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)persistentAttribute.isVirtual());
        rr = (OneToManyRelationship2_0)oneToManyMapping.getRelationship();
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rr.strategyIsJoinColumn());
        rr.setStrategyToJoinColumn();
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)((Orderable2_0)oneToManyMapping.getOrderable()).isOrderColumnOrdering());
        ((Orderable2_0)oneToManyMapping.getOrderable()).setOrderColumnOrdering(true);
        orderColumn = ((Orderable2_0)oneToManyMapping.getOrderable()).getOrderColumn();
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)orderColumn.getSpecifiedName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"addresses_ORDER", (String)orderColumn.getName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"ADDRESS_PRIMARY_TABLE", (String)orderColumn.getTableName());
        OrmEntity ormAddressEntity = (OrmEntity)ormTargetPersistentType.getMapping();
        ormAddressEntity.getTable().setSpecifiedName("ORM_ADDRESS_PRIMARY_TABLE");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"addresses_ORDER", (String)orderColumn.getName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"ORM_ADDRESS_PRIMARY_TABLE", (String)orderColumn.getTableName());
    }

    public void testVirtualMappingMetadataCompleteFalse() throws Exception {
        this.createTestEntityOneToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((int)3, (int)ormPersistentType.getDefaultAttributesSize());
        OrmPersistentAttribute virtualPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next();
        OneToManyMapping2_0 virtualOneToManyMapping = (OneToManyMapping2_0)virtualPersistentAttribute.getMapping();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"address", (String)virtualOneToManyMapping.getName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((Object)FetchType.EAGER, (Object)virtualOneToManyMapping.getSpecifiedFetch());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"Address", (String)virtualOneToManyMapping.getSpecifiedTargetEntity());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)virtualOneToManyMapping.getRelationship().getMappedByStrategy().getMappedByAttribute());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((Object)EnumType.STRING, (Object)((BaseEnumeratedConverter)virtualOneToManyMapping.getMapKeyConverter()).getEnumType());
        Cascade2_0 cascade = virtualOneToManyMapping.getCascade();
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)cascade.isAll());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)cascade.isMerge());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)cascade.isPersist());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)cascade.isRemove());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)cascade.isRefresh());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)cascade.isDetach());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)virtualOneToManyMapping.getOrderable().isCustomOrdering());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"city", (String)virtualOneToManyMapping.getOrderable().getSpecifiedOrderBy());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)virtualOneToManyMapping.getOrphanRemoval().isOrphanRemoval());
    }

    public void testVirtualMappingMetadataCompleteTrue() throws Exception {
        this.createTestEntityOneToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        GenericOrmOneToManyMapping2_0Tests.assertEquals((int)3, (int)ormPersistentType.getDefaultAttributesSize());
        OrmPersistentAttribute virtualPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY, (String)virtualPersistentAttribute.getMappingKey());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)virtualPersistentAttribute.isVirtual());
        virtualPersistentAttribute.addToXml("oneToMany");
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next();
        OneToManyMapping2_0 ormOneToManyMapping = (OneToManyMapping2_0)ormPersistentAttribute.getMapping();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"address", (String)ormOneToManyMapping.getName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((Object)FetchType.LAZY, (Object)ormOneToManyMapping.getFetch());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"test.Address", (String)ormOneToManyMapping.getTargetEntity());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormOneToManyMapping.getRelationship().getMappedByStrategy().getMappedByAttribute());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)(ormOneToManyMapping.getMapKeyConverter() instanceof NullOrmConverter));
        Cascade2_0 cascade = ormOneToManyMapping.getCascade();
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)cascade.isAll());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)cascade.isMerge());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)cascade.isPersist());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)cascade.isRemove());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)cascade.isRefresh());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)cascade.isDetach());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)ormOneToManyMapping.getOrderable().isNoOrdering());
        GenericOrmOneToManyMapping2_0Tests.assertEquals(null, (String)ormOneToManyMapping.getOrderable().getSpecifiedOrderBy());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)ormOneToManyMapping.getOrphanRemoval().isOrphanRemoval());
    }

    public void testUpdateSpecifiedEnumerated() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "oneToMany");
        OneToManyMapping2_0 ormOneToManyMapping = (OneToManyMapping2_0)ormPersistentAttribute.getMapping();
        XmlOneToMany_2_0 oneToManyResource = (XmlOneToMany_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormOneToManyMapping.getMapKeyConverter().getType());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)oneToManyResource.getMapKeyEnumerated());
        oneToManyResource.setMapKeyEnumerated(org.eclipse.jpt.jpa.core.resource.orm.EnumType.ORDINAL);
        GenericOrmOneToManyMapping2_0Tests.assertEquals((Object)EnumType.ORDINAL, (Object)((BaseEnumeratedConverter)ormOneToManyMapping.getMapKeyConverter()).getSpecifiedEnumType());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.orm.EnumType.ORDINAL, (Object)oneToManyResource.getMapKeyEnumerated());
        oneToManyResource.setMapKeyEnumerated(org.eclipse.jpt.jpa.core.resource.orm.EnumType.STRING);
        GenericOrmOneToManyMapping2_0Tests.assertEquals((Object)EnumType.STRING, (Object)((BaseEnumeratedConverter)ormOneToManyMapping.getMapKeyConverter()).getSpecifiedEnumType());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.orm.EnumType.STRING, (Object)oneToManyResource.getMapKeyEnumerated());
        oneToManyResource.setMapKeyEnumerated(null);
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormOneToManyMapping.getMapKeyConverter().getType());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)oneToManyResource.getMapKeyEnumerated());
    }

    public void testModifySpecifiedEnumerated() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "oneToMany");
        OneToManyMapping2_0 ormOneToManyMapping = (OneToManyMapping2_0)ormPersistentAttribute.getMapping();
        XmlOneToMany_2_0 oneToManyResource = (XmlOneToMany_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormOneToManyMapping.getMapKeyConverter().getType());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)oneToManyResource.getMapKeyEnumerated());
        ormOneToManyMapping.setMapKeyConverter(BaseEnumeratedConverter.class);
        ((BaseEnumeratedConverter)ormOneToManyMapping.getMapKeyConverter()).setSpecifiedEnumType(EnumType.ORDINAL);
        GenericOrmOneToManyMapping2_0Tests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.orm.EnumType.ORDINAL, (Object)oneToManyResource.getMapKeyEnumerated());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((Object)EnumType.ORDINAL, (Object)((BaseEnumeratedConverter)ormOneToManyMapping.getMapKeyConverter()).getSpecifiedEnumType());
        ((BaseEnumeratedConverter)ormOneToManyMapping.getMapKeyConverter()).setSpecifiedEnumType(EnumType.STRING);
        GenericOrmOneToManyMapping2_0Tests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.orm.EnumType.STRING, (Object)oneToManyResource.getMapKeyEnumerated());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((Object)EnumType.STRING, (Object)((BaseEnumeratedConverter)ormOneToManyMapping.getMapKeyConverter()).getSpecifiedEnumType());
        ormOneToManyMapping.setMapKeyConverter(null);
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)oneToManyResource.getMapKeyEnumerated());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormOneToManyMapping.getMapKeyConverter().getType());
    }

    public void testUpdateSpecifiedTemporal() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "oneToMany");
        OneToManyMapping2_0 ormOneToManyMapping = (OneToManyMapping2_0)ormPersistentAttribute.getMapping();
        XmlOneToMany_2_0 oneToManyResource = (XmlOneToMany_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormOneToManyMapping.getMapKeyConverter().getType());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)oneToManyResource.getMapKeyTemporal());
        oneToManyResource.setMapKeyTemporal(TemporalType.DATE);
        GenericOrmOneToManyMapping2_0Tests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.DATE, (Object)((BaseTemporalConverter)ormOneToManyMapping.getMapKeyConverter()).getTemporalType());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((Object)TemporalType.DATE, (Object)oneToManyResource.getMapKeyTemporal());
        oneToManyResource.setMapKeyTemporal(TemporalType.TIME);
        GenericOrmOneToManyMapping2_0Tests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.TIME, (Object)((BaseTemporalConverter)ormOneToManyMapping.getMapKeyConverter()).getTemporalType());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((Object)TemporalType.TIME, (Object)oneToManyResource.getMapKeyTemporal());
        oneToManyResource.setMapKeyTemporal(TemporalType.TIMESTAMP);
        GenericOrmOneToManyMapping2_0Tests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.TIMESTAMP, (Object)((BaseTemporalConverter)ormOneToManyMapping.getMapKeyConverter()).getTemporalType());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((Object)TemporalType.TIMESTAMP, (Object)oneToManyResource.getMapKeyTemporal());
        oneToManyResource.setMapKeyTemporal(null);
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormOneToManyMapping.getMapKeyConverter().getType());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)oneToManyResource.getMapKeyTemporal());
    }

    public void testModifySpecifiedTemporal() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "oneToMany");
        OneToManyMapping2_0 ormOneToManyMapping = (OneToManyMapping2_0)ormPersistentAttribute.getMapping();
        XmlOneToMany_2_0 oneToManyResource = (XmlOneToMany_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormOneToManyMapping.getMapKeyConverter().getType());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)oneToManyResource.getMapKeyTemporal());
        ormOneToManyMapping.setMapKeyConverter(BaseTemporalConverter.class);
        ((BaseTemporalConverter)ormOneToManyMapping.getMapKeyConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.DATE);
        GenericOrmOneToManyMapping2_0Tests.assertEquals((Object)TemporalType.DATE, (Object)oneToManyResource.getMapKeyTemporal());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.DATE, (Object)((BaseTemporalConverter)ormOneToManyMapping.getMapKeyConverter()).getTemporalType());
        ((BaseTemporalConverter)ormOneToManyMapping.getMapKeyConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        GenericOrmOneToManyMapping2_0Tests.assertEquals((Object)TemporalType.TIME, (Object)oneToManyResource.getMapKeyTemporal());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.TIME, (Object)((BaseTemporalConverter)ormOneToManyMapping.getMapKeyConverter()).getTemporalType());
        ormOneToManyMapping.setMapKeyConverter(null);
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)oneToManyResource.getMapKeyTemporal());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormOneToManyMapping.getMapKeyConverter().getType());
    }

    public void testAddSpecifiedMapKeyJoinColumn() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "oneToMany");
        OneToManyMapping2_0 ormOneToManyMapping = (OneToManyMapping2_0)ormPersistentAttribute.getMapping();
        XmlOneToMany_2_0 oneToManyResource = (XmlOneToMany_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        SpecifiedJoinColumn joinColumn = ormOneToManyMapping.addSpecifiedMapKeyJoinColumn(0);
        joinColumn.setSpecifiedName("FOO");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((XmlJoinColumn)oneToManyResource.getMapKeyJoinColumns().get(0)).getName());
        SpecifiedJoinColumn joinColumn2 = ormOneToManyMapping.addSpecifiedMapKeyJoinColumn(0);
        joinColumn2.setSpecifiedName("BAR");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((XmlJoinColumn)oneToManyResource.getMapKeyJoinColumns().get(0)).getName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((XmlJoinColumn)oneToManyResource.getMapKeyJoinColumns().get(1)).getName());
        SpecifiedJoinColumn joinColumn3 = ormOneToManyMapping.addSpecifiedMapKeyJoinColumn(1);
        joinColumn3.setSpecifiedName("BAZ");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((XmlJoinColumn)oneToManyResource.getMapKeyJoinColumns().get(0)).getName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)oneToManyResource.getMapKeyJoinColumns().get(1)).getName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((XmlJoinColumn)oneToManyResource.getMapKeyJoinColumns().get(2)).getName());
        ListIterator joinColumns = ormOneToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((Object)joinColumn2, joinColumns.next());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((Object)joinColumn3, joinColumns.next());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((Object)joinColumn, joinColumns.next());
        joinColumns = ormOneToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((SpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((SpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((SpecifiedJoinColumn)joinColumns.next()).getName());
    }

    public void testRemoveSpecifiedMapKeyJoinColumn() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "oneToMany");
        OneToManyMapping2_0 ormOneToManyMapping = (OneToManyMapping2_0)ormPersistentAttribute.getMapping();
        XmlOneToMany_2_0 oneToManyResource = (XmlOneToMany_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        ormOneToManyMapping.addSpecifiedMapKeyJoinColumn(0).setSpecifiedName("FOO");
        ormOneToManyMapping.addSpecifiedMapKeyJoinColumn(1).setSpecifiedName("BAR");
        ormOneToManyMapping.addSpecifiedMapKeyJoinColumn(2).setSpecifiedName("BAZ");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((int)3, (int)oneToManyResource.getMapKeyJoinColumns().size());
        ormOneToManyMapping.removeSpecifiedMapKeyJoinColumn(0);
        GenericOrmOneToManyMapping2_0Tests.assertEquals((int)2, (int)oneToManyResource.getMapKeyJoinColumns().size());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((XmlJoinColumn)oneToManyResource.getMapKeyJoinColumns().get(0)).getName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)oneToManyResource.getMapKeyJoinColumns().get(1)).getName());
        ormOneToManyMapping.removeSpecifiedMapKeyJoinColumn(0);
        GenericOrmOneToManyMapping2_0Tests.assertEquals((int)1, (int)oneToManyResource.getMapKeyJoinColumns().size());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)oneToManyResource.getMapKeyJoinColumns().get(0)).getName());
        ormOneToManyMapping.removeSpecifiedMapKeyJoinColumn(0);
        GenericOrmOneToManyMapping2_0Tests.assertEquals((int)0, (int)oneToManyResource.getMapKeyJoinColumns().size());
    }

    public void testMoveSpecifiedMapKeyJoinColumn() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "oneToMany");
        OneToManyMapping2_0 ormOneToManyMapping = (OneToManyMapping2_0)ormPersistentAttribute.getMapping();
        XmlOneToMany_2_0 oneToManyResource = (XmlOneToMany_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        ormOneToManyMapping.addSpecifiedMapKeyJoinColumn(0).setSpecifiedName("FOO");
        ormOneToManyMapping.addSpecifiedMapKeyJoinColumn(1).setSpecifiedName("BAR");
        ormOneToManyMapping.addSpecifiedMapKeyJoinColumn(2).setSpecifiedName("BAZ");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((int)3, (int)oneToManyResource.getMapKeyJoinColumns().size());
        ormOneToManyMapping.moveSpecifiedMapKeyJoinColumn(2, 0);
        ListIterator joinColumns = ormOneToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((SpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((SpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((SpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((XmlJoinColumn)oneToManyResource.getMapKeyJoinColumns().get(0)).getName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)oneToManyResource.getMapKeyJoinColumns().get(1)).getName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((XmlJoinColumn)oneToManyResource.getMapKeyJoinColumns().get(2)).getName());
        ormOneToManyMapping.moveSpecifiedMapKeyJoinColumn(0, 1);
        joinColumns = ormOneToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((SpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((SpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((SpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)oneToManyResource.getMapKeyJoinColumns().get(0)).getName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((XmlJoinColumn)oneToManyResource.getMapKeyJoinColumns().get(1)).getName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((XmlJoinColumn)oneToManyResource.getMapKeyJoinColumns().get(2)).getName());
    }

    public void testUpdateMapKeyJoinColumns() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "oneToMany");
        OneToManyMapping2_0 ormOneToManyMapping = (OneToManyMapping2_0)ormPersistentAttribute.getMapping();
        XmlOneToMany_2_0 oneToManyResource = (XmlOneToMany_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        oneToManyResource.getMapKeyJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumn());
        oneToManyResource.getMapKeyJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumn());
        oneToManyResource.getMapKeyJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumn());
        ((XmlJoinColumn)oneToManyResource.getMapKeyJoinColumns().get(0)).setName("FOO");
        ((XmlJoinColumn)oneToManyResource.getMapKeyJoinColumns().get(1)).setName("BAR");
        ((XmlJoinColumn)oneToManyResource.getMapKeyJoinColumns().get(2)).setName("BAZ");
        ListIterator joinColumns = ormOneToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((SpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((SpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((SpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)joinColumns.hasNext());
        oneToManyResource.getMapKeyJoinColumns().move(2, 0);
        joinColumns = ormOneToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((SpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((SpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((SpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)joinColumns.hasNext());
        oneToManyResource.getMapKeyJoinColumns().move(0, 1);
        joinColumns = ormOneToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((SpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((SpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((SpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)joinColumns.hasNext());
        oneToManyResource.getMapKeyJoinColumns().remove(1);
        joinColumns = ormOneToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((SpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((SpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)joinColumns.hasNext());
        oneToManyResource.getMapKeyJoinColumns().remove(1);
        joinColumns = ormOneToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((SpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)joinColumns.hasNext());
        oneToManyResource.getMapKeyJoinColumns().remove(0);
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)ormOneToManyMapping.getSpecifiedMapKeyJoinColumns().iterator().hasNext());
    }
}

