/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.persistence;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.collection.HashBag;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.context.JpaNamedContextModel;
import org.eclipse.jpt.jpa.core.context.java.JavaEntity;
import org.eclipse.jpt.jpa.core.context.java.JavaIdMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaMappedSuperclass;
import org.eclipse.jpt.jpa.core.context.orm.EntityMappings;
import org.eclipse.jpt.jpa.core.context.orm.OrmNamedNativeQuery;
import org.eclipse.jpt.jpa.core.context.orm.OrmNamedQuery;
import org.eclipse.jpt.jpa.core.context.orm.OrmQueryHint;
import org.eclipse.jpt.jpa.core.context.orm.OrmSequenceGenerator;
import org.eclipse.jpt.jpa.core.context.orm.OrmTableGenerator;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.internal.jpa2.context.orm.GenericOrmSequenceGenerator2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.LockModeType2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmNamedQuery2_0;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.Generic2_0ContextModelTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Generic2_0JpaMetadataConversionTests
extends Generic2_0ContextModelTestCase {
    private IProgressMonitor progressMonitor;

    public Generic2_0JpaMetadataConversionTests(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.progressMonitor = new IProgressMonitor(){

            public void worked(int work) {
            }

            public void subTask(String name) {
            }

            public void setTaskName(String name) {
            }

            public void setCanceled(boolean value) {
            }

            public boolean isCanceled() {
                return false;
            }

            public void internalWorked(double work) {
            }

            public void done() {
            }

            public void beginTask(String name, int totalWork) {
            }
        };
    }

    @Override
    protected void tearDown() throws Exception {
        this.progressMonitor = null;
        super.tearDown();
    }

    private ICompilationUnit createTestEntityWithNamedQueries() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.NamedQueries", "javax.persistence.NamedQuery", "javax.persistence.QueryHint", "javax.persistence.LockModeType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@NamedQueries({@NamedQuery(name=\"nq1\", query=\"abcd\", lockMode=LockModeType.OPTIMISTIC, hints={@QueryHint(name=\"nq1hint1\", value = \"aaa\"), @QueryHint(name=\"nq1hint2\", value=\"bbb\")}), @NamedQuery(name=\"nq2\", query=\"efgh\", lockMode=LockModeType.READ, hints=@QueryHint(name=\"nq2hint1\", value=\"ccc\"))})");
            }
        });
    }

    private ICompilationUnit createTestEntityWithNamedNativeQueries() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.NamedNativeQueries", "javax.persistence.NamedNativeQuery", "javax.persistence.QueryHint"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@NamedNativeQueries({@NamedNativeQuery(name=\"nnq1\", query=\"abcd\", resultClass=foo1.class, resultSetMapping=\"bar1\", hints={@QueryHint(name=\"nnq1hint1\", value = \"aaa\"), @QueryHint(name=\"nnq1hint2\", value=\"bbb\")}), @NamedNativeQuery(name=\"nnq2\", query=\"efgh\", resultClass=foo2.class, resultSetMapping=\"bar2\", hints=@QueryHint(name=\"nnq2hint1\", value=\"ccc\"))})");
            }
        });
    }

    private ICompilationUnit createTestEntityWithDuplicateQueries() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.NamedQuery", "javax.persistence.NamedNativeQueries", "javax.persistence.NamedNativeQuery"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@NamedQuery(name=\"query\")").append(CR);
                sb.append("@NamedNativeQueries({@NamedNativeQuery(name=\"query\"), @NamedNativeQuery(name=\"nnq\")})");
            }
        });
    }

    private ICompilationUnit createTestEntityWithQueries() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.NamedQueries", "javax.persistence.NamedQuery", "javax.persistence.NamedNativeQuery"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@NamedQueries({@NamedQuery(name=\"nq\"), @NamedQuery(name=\"query\")})").append(CR);
                sb.append("@NamedNativeQuery(name=\"nnq\")");
            }
        });
    }

    private ICompilationUnit createTestMappedSuperWithNamedQueries() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.MappedSuperclass", "javax.persistence.NamedQueries", "javax.persistence.NamedQuery", "javax.persistence.QueryHint", "javax.persistence.LockModeType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@MappedSuperclass").append(CR);
                sb.append("@NamedQueries({@NamedQuery(name=\"nq1\", query=\"abcd\", lockMode=LockModeType.OPTIMISTIC, hints={@QueryHint(name=\"nq1hint1\", value = \"aaa\"), @QueryHint(name=\"nq1hint2\", value=\"bbb\")}), @NamedQuery(name=\"nq2\", query=\"efgh\", lockMode=LockModeType.READ, hints=@QueryHint(name=\"nq2hint1\", value=\"ccc\"))})");
            }
        });
    }

    private ICompilationUnit createTestMappedSuperclassWithNamedNativeQueries() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.MappedSuperclass", "javax.persistence.NamedNativeQueries", "javax.persistence.NamedNativeQuery", "javax.persistence.QueryHint"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@MappedSuperclass").append(CR);
                sb.append("@NamedNativeQueries({@NamedNativeQuery(name=\"nnq1\", query=\"abcd\", resultClass=foo1.class, resultSetMapping=\"bar1\", hints={@QueryHint(name=\"nnq1hint1\", value = \"aaa\"), @QueryHint(name=\"nnq1hint2\", value=\"bbb\")}), @NamedNativeQuery(name=\"nnq2\", query=\"efgh\", resultClass=foo2.class, resultSetMapping=\"bar2\", hints=@QueryHint(name=\"nnq2hint1\", value=\"ccc\"))})");
            }
        });
    }

    public void testConvertNamedQueriesOnEntity() throws Exception {
        this.createTestEntityWithNamedQueries();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        this.addXmlMappingFileRef("META-INF/orm.xml");
        EntityMappings entityMappings = this.getEntityMappings();
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        persistenceUnit.convertJavaQueries(entityMappings, this.progressMonitor);
        Generic2_0JpaMetadataConversionTests.assertEquals((int)2, (int)entityMappings.getQueryContainer().getNamedQueriesSize());
        Generic2_0JpaMetadataConversionTests.assertEquals((int)0, (int)entity.getQueryContainer().getNamedQueriesSize());
        ListIterator namedQueries = entityMappings.getQueryContainer().getNamedQueries().iterator();
        OrmNamedQuery nq1 = (OrmNamedQuery)namedQueries.next();
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"nq1", (String)nq1.getName());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"abcd", (String)nq1.getQuery());
        Generic2_0JpaMetadataConversionTests.assertEquals((int)2, (int)nq1.getHintsSize());
        ListIterator nq1hints = nq1.getHints().iterator();
        OrmQueryHint nq1hint1 = (OrmQueryHint)nq1hints.next();
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"nq1hint1", (String)nq1hint1.getName());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"aaa", (String)nq1hint1.getValue());
        OrmQueryHint nq1hint2 = (OrmQueryHint)nq1hints.next();
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"nq1hint2", (String)nq1hint2.getName());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"bbb", (String)nq1hint2.getValue());
        OrmNamedQuery nq2 = (OrmNamedQuery)namedQueries.next();
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"nq2", (String)nq2.getName());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"efgh", (String)nq2.getQuery());
        Generic2_0JpaMetadataConversionTests.assertEquals((int)1, (int)nq2.getHintsSize());
        OrmQueryHint nq2hint1 = (OrmQueryHint)nq2.getHints().iterator().next();
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"nq2hint1", (String)nq2hint1.getName());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"ccc", (String)nq2hint1.getValue());
        Generic2_0JpaMetadataConversionTests.assertEquals((Object)LockModeType2_0.OPTIMISTIC, (Object)((OrmNamedQuery2_0)nq1).getLockMode());
        Generic2_0JpaMetadataConversionTests.assertEquals((Object)LockModeType2_0.READ, (Object)((OrmNamedQuery2_0)nq2).getLockMode());
    }

    public void testConvertNamedNativeQueriesOnEntity() throws Exception {
        this.createTestEntityWithNamedNativeQueries();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        this.addXmlMappingFileRef("META-INF/orm.xml");
        EntityMappings entityMappings = this.getEntityMappings();
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        persistenceUnit.convertJavaQueries(entityMappings, this.progressMonitor);
        Generic2_0JpaMetadataConversionTests.assertEquals((int)2, (int)entityMappings.getQueryContainer().getNamedNativeQueriesSize());
        Generic2_0JpaMetadataConversionTests.assertEquals((int)0, (int)entity.getQueryContainer().getNamedNativeQueriesSize());
        HashBag namedNativeQueries = CollectionTools.collection((Iterable)entityMappings.getQueryContainer().getNamedNativeQueries());
        OrmNamedNativeQuery nnq1 = (OrmNamedNativeQuery)Generic2_0JpaMetadataConversionTests.selectModelNamed(namedNativeQueries, "nnq1");
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"nnq1", (String)nnq1.getName());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"abcd", (String)nnq1.getQuery());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"foo1", (String)nnq1.getResultClass());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"bar1", (String)nnq1.getResultSetMapping());
        Generic2_0JpaMetadataConversionTests.assertEquals((int)2, (int)nnq1.getHintsSize());
        ListIterator nq1hints = nnq1.getHints().iterator();
        OrmQueryHint nnq1hint1 = (OrmQueryHint)nq1hints.next();
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"nnq1hint1", (String)nnq1hint1.getName());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"aaa", (String)nnq1hint1.getValue());
        OrmQueryHint nnq1hint2 = (OrmQueryHint)nq1hints.next();
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"nnq1hint2", (String)nnq1hint2.getName());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"bbb", (String)nnq1hint2.getValue());
        OrmNamedNativeQuery nnq2 = (OrmNamedNativeQuery)Generic2_0JpaMetadataConversionTests.selectModelNamed(namedNativeQueries, "nnq2");
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"nnq2", (String)nnq2.getName());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"efgh", (String)nnq2.getQuery());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"foo2", (String)nnq2.getResultClass());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"bar2", (String)nnq2.getResultSetMapping());
        Generic2_0JpaMetadataConversionTests.assertEquals((int)1, (int)nnq2.getHintsSize());
        OrmQueryHint nnq2hint1 = (OrmQueryHint)nnq2.getHints().iterator().next();
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"nnq2hint1", (String)nnq2hint1.getName());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"ccc", (String)nnq2hint1.getValue());
    }

    public static <M extends JpaNamedContextModel> M selectModelNamed(Iterable<M> models, String name) {
        for (JpaNamedContextModel node : models) {
            if (!node.getName().equals(name)) continue;
            return (M)node;
        }
        return null;
    }

    public void testConvertOverriddenQueries() throws Exception {
        this.createTestEntityWithQueries();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        this.addXmlMappingFileRef("META-INF/orm.xml");
        EntityMappings entityMappings = this.getEntityMappings();
        OrmNamedNativeQuery nnq = entityMappings.getQueryContainer().addNamedNativeQuery();
        nnq.setName("nq");
        OrmNamedQuery nq = entityMappings.getQueryContainer().addNamedQuery();
        nq.setName("nnq");
        JavaEntity entity = this.getJavaEntity();
        persistenceUnit.convertJavaQueries(entityMappings, this.progressMonitor);
        Generic2_0JpaMetadataConversionTests.assertEquals((int)1, (int)entity.getQueryContainer().getNamedQueriesSize());
        Generic2_0JpaMetadataConversionTests.assertEquals((int)1, (int)entity.getQueryContainer().getNamedNativeQueriesSize());
        Generic2_0JpaMetadataConversionTests.assertEquals((int)2, (int)entityMappings.getQueryContainer().getNamedQueriesSize());
        Generic2_0JpaMetadataConversionTests.assertEquals((int)1, (int)entityMappings.getQueryContainer().getNamedNativeQueriesSize());
    }

    public void testConvertDuplicateQueries() throws Exception {
        this.createTestEntityWithDuplicateQueries();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        this.addXmlMappingFileRef("META-INF/orm.xml");
        EntityMappings entityMappings = this.getEntityMappings();
        persistenceUnit.convertJavaQueries(entityMappings, this.progressMonitor);
        JavaEntity entity = this.getJavaEntity();
        Generic2_0JpaMetadataConversionTests.assertEquals((int)1, (int)entity.getQueryContainer().getNamedQueriesSize());
        Generic2_0JpaMetadataConversionTests.assertEquals((int)1, (int)entity.getQueryContainer().getNamedNativeQueriesSize());
        Generic2_0JpaMetadataConversionTests.assertEquals((int)0, (int)entityMappings.getQueryContainer().getNamedQueriesSize());
        Generic2_0JpaMetadataConversionTests.assertEquals((int)1, (int)entityMappings.getQueryContainer().getNamedNativeQueriesSize());
    }

    public void testConvertNamedQueriesOnMappedSuperclass() throws Exception {
        this.createTestMappedSuperWithNamedQueries();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaMappedSuperclass mappedSuperclass = (JavaMappedSuperclass)this.getJavaPersistentType().getMapping();
        this.addXmlMappingFileRef("META-INF/orm.xml");
        EntityMappings entityMappings = this.getEntityMappings();
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        persistenceUnit.convertJavaQueries(entityMappings, this.progressMonitor);
        Generic2_0JpaMetadataConversionTests.assertEquals((int)2, (int)entityMappings.getQueryContainer().getNamedQueriesSize());
        Generic2_0JpaMetadataConversionTests.assertEquals((int)0, (int)mappedSuperclass.getQueryContainer().getNamedQueriesSize());
        ListIterator namedQueries = entityMappings.getQueryContainer().getNamedQueries().iterator();
        OrmNamedQuery nq1 = (OrmNamedQuery)namedQueries.next();
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"nq1", (String)nq1.getName());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"abcd", (String)nq1.getQuery());
        Generic2_0JpaMetadataConversionTests.assertEquals((int)2, (int)nq1.getHintsSize());
        ListIterator nq1hints = nq1.getHints().iterator();
        OrmQueryHint nq1hint1 = (OrmQueryHint)nq1hints.next();
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"nq1hint1", (String)nq1hint1.getName());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"aaa", (String)nq1hint1.getValue());
        OrmQueryHint nq1hint2 = (OrmQueryHint)nq1hints.next();
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"nq1hint2", (String)nq1hint2.getName());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"bbb", (String)nq1hint2.getValue());
        OrmNamedQuery nq2 = (OrmNamedQuery)namedQueries.next();
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"nq2", (String)nq2.getName());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"efgh", (String)nq2.getQuery());
        Generic2_0JpaMetadataConversionTests.assertEquals((int)1, (int)nq2.getHintsSize());
        OrmQueryHint nq2hint1 = (OrmQueryHint)nq2.getHints().iterator().next();
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"nq2hint1", (String)nq2hint1.getName());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"ccc", (String)nq2hint1.getValue());
        Generic2_0JpaMetadataConversionTests.assertEquals((Object)LockModeType2_0.OPTIMISTIC, (Object)((OrmNamedQuery2_0)nq1).getLockMode());
        Generic2_0JpaMetadataConversionTests.assertEquals((Object)LockModeType2_0.READ, (Object)((OrmNamedQuery2_0)nq2).getLockMode());
    }

    public void testConvertNamedNativeQueriesOnMappedSuperclass() throws Exception {
        this.createTestMappedSuperclassWithNamedNativeQueries();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaMappedSuperclass mappedSuperclass = (JavaMappedSuperclass)this.getJavaPersistentType().getMapping();
        this.addXmlMappingFileRef("META-INF/orm.xml");
        EntityMappings entityMappings = this.getEntityMappings();
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        persistenceUnit.convertJavaQueries(entityMappings, this.progressMonitor);
        Generic2_0JpaMetadataConversionTests.assertEquals((int)2, (int)entityMappings.getQueryContainer().getNamedNativeQueriesSize());
        Generic2_0JpaMetadataConversionTests.assertEquals((int)0, (int)mappedSuperclass.getQueryContainer().getNamedNativeQueriesSize());
        HashBag namedNativeQueries = CollectionTools.collection((Iterable)entityMappings.getQueryContainer().getNamedNativeQueries());
        OrmNamedNativeQuery nnq1 = (OrmNamedNativeQuery)Generic2_0JpaMetadataConversionTests.selectModelNamed(namedNativeQueries, "nnq1");
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"nnq1", (String)nnq1.getName());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"abcd", (String)nnq1.getQuery());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"foo1", (String)nnq1.getResultClass());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"bar1", (String)nnq1.getResultSetMapping());
        Generic2_0JpaMetadataConversionTests.assertEquals((int)2, (int)nnq1.getHintsSize());
        ListIterator nq1hints = nnq1.getHints().iterator();
        OrmQueryHint nnq1hint1 = (OrmQueryHint)nq1hints.next();
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"nnq1hint1", (String)nnq1hint1.getName());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"aaa", (String)nnq1hint1.getValue());
        OrmQueryHint nnq1hint2 = (OrmQueryHint)nq1hints.next();
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"nnq1hint2", (String)nnq1hint2.getName());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"bbb", (String)nnq1hint2.getValue());
        OrmNamedNativeQuery nnq2 = (OrmNamedNativeQuery)Generic2_0JpaMetadataConversionTests.selectModelNamed(namedNativeQueries, "nnq2");
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"nnq2", (String)nnq2.getName());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"efgh", (String)nnq2.getQuery());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"foo2", (String)nnq2.getResultClass());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"bar2", (String)nnq2.getResultSetMapping());
        Generic2_0JpaMetadataConversionTests.assertEquals((int)1, (int)nnq2.getHintsSize());
        OrmQueryHint nnq2hint1 = (OrmQueryHint)nnq2.getHints().iterator().next();
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"nnq2hint1", (String)nnq2hint1.getName());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"ccc", (String)nnq2hint1.getValue());
    }

    private ICompilationUnit createTestEntityWithGenerators() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.TableGenerator", "javax.persistence.SequenceGenerator"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@TableGenerator(name=\"tgen\", table=\"ID_GEN\", schema=\"APP\", catalog=\"FOO\",pkColumnName=\"GEN_NAME\", valueColumnName=\"GEN_VALUE\", pkColumnValue=\"TGEN\",allocationSize=50, initialValue=100)").append(CR);
                sb.append("@SequenceGenerator(name=\"sgen\", sequenceName=\"Foo_Seq\", schema=\"SYS\", catalog=\"BAR\",allocationSize=5, initialValue=10)");
            }
        });
    }

    private ICompilationUnit createTestEntityWithGeneratorsOnIdMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.TableGenerator", "javax.persistence.SequenceGenerator"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id").append(CR);
                sb.append("@TableGenerator(name=\"tgen\", table=\"ID_GEN\", schema=\"APP\", catalog=\"FOO\",pkColumnName=\"GEN_NAME\", valueColumnName=\"GEN_VALUE\", pkColumnValue=\"TGEN\",allocationSize=50, initialValue=100)").append(CR);
                sb.append("@SequenceGenerator(name=\"sgen\", sequenceName=\"Foo_Seq\", schema=\"SYS\", catalog=\"BAR\",allocationSize=5, initialValue=10)");
            }
        });
    }

    private ICompilationUnit createTestEntityWithDuplicateGenerators() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.TableGenerator", "javax.persistence.SequenceGenerator"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@TableGenerator(name=\"gen\", table=\"ID_GEN\", schema=\"APP\", catalog=\"FOO\",pkColumnName=\"GEN_NAME\", valueColumnName=\"GEN_VALUE\", pkColumnValue=\"TGEN\",allocationSize=50, initialValue=100)").append(CR);
                sb.append("@SequenceGenerator(name=\"gen\", sequenceName=\"Foo_Seq\", schema=\"SYS\", catalog=\"BAR\",allocationSize=5, initialValue=10)");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id").append(CR);
                sb.append("@TableGenerator(name=\"tgen\", table=\"ID_GEN\", schema=\"APP\", catalog=\"FOO\",pkColumnName=\"GEN_NAME\", valueColumnName=\"GEN_VALUE\", pkColumnValue=\"TGEN\",allocationSize=50, initialValue=100)").append(CR);
                sb.append("@SequenceGenerator(name=\"gen\", sequenceName=\"Foo_Seq\", schema=\"SYS\", catalog=\"BAR\",allocationSize=5, initialValue=10)");
            }
        });
    }

    public void testTestConvertGenerators() throws Exception {
        this.createTestEntityWithGenerators();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        this.addXmlMappingFileRef("META-INF/orm.xml");
        EntityMappings entityMappings = this.getEntityMappings();
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        persistenceUnit.convertJavaGenerators(entityMappings, this.progressMonitor);
        Generic2_0JpaMetadataConversionTests.assertEquals((int)1, (int)entityMappings.getSequenceGeneratorsSize());
        Generic2_0JpaMetadataConversionTests.assertEquals((int)1, (int)entityMappings.getTableGeneratorsSize());
        Generic2_0JpaMetadataConversionTests.assertNull((Object)entity.getGeneratorContainer().getSequenceGenerator());
        Generic2_0JpaMetadataConversionTests.assertNull((Object)entity.getGeneratorContainer().getTableGenerator());
        OrmTableGenerator tableGen = (OrmTableGenerator)entityMappings.getTableGenerators().iterator().next();
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"tgen", (String)tableGen.getName());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"ID_GEN", (String)tableGen.getTableName());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"APP", (String)tableGen.getSchema());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"FOO", (String)tableGen.getCatalog());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"GEN_NAME", (String)tableGen.getPkColumnName());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"GEN_VALUE", (String)tableGen.getValueColumnName());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"TGEN", (String)tableGen.getPkColumnValue());
        Generic2_0JpaMetadataConversionTests.assertEquals((int)50, (int)tableGen.getAllocationSize());
        Generic2_0JpaMetadataConversionTests.assertEquals((int)100, (int)tableGen.getInitialValue());
        OrmSequenceGenerator seqGen = (OrmSequenceGenerator)entityMappings.getSequenceGenerators().iterator().next();
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"sgen", (String)seqGen.getName());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"Foo_Seq", (String)seqGen.getSequenceName());
        Generic2_0JpaMetadataConversionTests.assertEquals((int)5, (int)seqGen.getAllocationSize());
        Generic2_0JpaMetadataConversionTests.assertEquals((int)10, (int)seqGen.getInitialValue());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"SYS", (String)((GenericOrmSequenceGenerator2_0)seqGen).getSchema());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"BAR", (String)((GenericOrmSequenceGenerator2_0)seqGen).getCatalog());
    }

    public void testTestConvertGeneratorsOnIdMapping() throws Exception {
        this.createTestEntityWithGeneratorsOnIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        this.addXmlMappingFileRef("META-INF/orm.xml");
        EntityMappings entityMappings = this.getEntityMappings();
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        persistenceUnit.convertJavaGenerators(entityMappings, this.progressMonitor);
        Generic2_0JpaMetadataConversionTests.assertEquals((int)1, (int)entityMappings.getSequenceGeneratorsSize());
        Generic2_0JpaMetadataConversionTests.assertEquals((int)1, (int)entityMappings.getTableGeneratorsSize());
        JavaIdMapping mapping = (JavaIdMapping)entity.getIdAttribute().getMapping();
        Generic2_0JpaMetadataConversionTests.assertNull((Object)mapping.getGeneratorContainer().getSequenceGenerator());
        Generic2_0JpaMetadataConversionTests.assertNull((Object)mapping.getGeneratorContainer().getTableGenerator());
        OrmTableGenerator tableGen = (OrmTableGenerator)entityMappings.getTableGenerators().iterator().next();
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"tgen", (String)tableGen.getName());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"ID_GEN", (String)tableGen.getTableName());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"APP", (String)tableGen.getSchema());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"FOO", (String)tableGen.getCatalog());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"GEN_NAME", (String)tableGen.getPkColumnName());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"GEN_VALUE", (String)tableGen.getValueColumnName());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"TGEN", (String)tableGen.getPkColumnValue());
        Generic2_0JpaMetadataConversionTests.assertEquals((int)50, (int)tableGen.getAllocationSize());
        Generic2_0JpaMetadataConversionTests.assertEquals((int)100, (int)tableGen.getInitialValue());
        OrmSequenceGenerator seqGen = (OrmSequenceGenerator)entityMappings.getSequenceGenerators().iterator().next();
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"sgen", (String)seqGen.getName());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"Foo_Seq", (String)seqGen.getSequenceName());
        Generic2_0JpaMetadataConversionTests.assertEquals((int)5, (int)seqGen.getAllocationSize());
        Generic2_0JpaMetadataConversionTests.assertEquals((int)10, (int)seqGen.getInitialValue());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"SYS", (String)((GenericOrmSequenceGenerator2_0)seqGen).getSchema());
        Generic2_0JpaMetadataConversionTests.assertEquals((String)"BAR", (String)((GenericOrmSequenceGenerator2_0)seqGen).getCatalog());
    }

    public void testConvertOverridenGenerators() throws Exception {
        this.createTestEntityWithDuplicateGenerators();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        this.addXmlMappingFileRef("META-INF/orm.xml");
        EntityMappings entityMappings = this.getEntityMappings();
        OrmSequenceGenerator sequence = entityMappings.addSequenceGenerator();
        sequence.setName("gen");
        JavaEntity entity = this.getJavaEntity();
        JavaIdMapping mapping = (JavaIdMapping)entity.getIdAttribute().getMapping();
        persistenceUnit.convertJavaGenerators(entityMappings, this.progressMonitor);
        Generic2_0JpaMetadataConversionTests.assertNotNull((Object)entity.getGeneratorContainer().getSequenceGenerator());
        Generic2_0JpaMetadataConversionTests.assertNotNull((Object)entity.getGeneratorContainer().getTableGenerator());
        Generic2_0JpaMetadataConversionTests.assertEquals((int)1, (int)entityMappings.getSequenceGeneratorsSize());
        Generic2_0JpaMetadataConversionTests.assertEquals((int)1, (int)entityMappings.getTableGeneratorsSize());
        Generic2_0JpaMetadataConversionTests.assertNotNull((Object)mapping.getGeneratorContainer().getSequenceGenerator());
        Generic2_0JpaMetadataConversionTests.assertNull((Object)mapping.getGeneratorContainer().getTableGenerator());
    }

    public void testConvertDuplicateGenerators() throws Exception {
        this.createTestEntityWithDuplicateGenerators();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        JavaEntity entity = this.getJavaEntity();
        JavaIdMapping mapping = (JavaIdMapping)entity.getIdAttribute().getMapping();
        this.addXmlMappingFileRef("META-INF/orm.xml");
        EntityMappings entityMappings = this.getEntityMappings();
        persistenceUnit.convertJavaGenerators(entityMappings, this.progressMonitor);
        Generic2_0JpaMetadataConversionTests.assertNotNull((Object)entity.getGeneratorContainer().getSequenceGenerator());
        Generic2_0JpaMetadataConversionTests.assertNotNull((Object)entity.getGeneratorContainer().getTableGenerator());
        Generic2_0JpaMetadataConversionTests.assertEquals((int)0, (int)entityMappings.getSequenceGeneratorsSize());
        Generic2_0JpaMetadataConversionTests.assertEquals((int)1, (int)entityMappings.getTableGeneratorsSize());
        Generic2_0JpaMetadataConversionTests.assertNotNull((Object)mapping.getGeneratorContainer().getSequenceGenerator());
        Generic2_0JpaMetadataConversionTests.assertNull((Object)mapping.getGeneratorContainer().getTableGenerator());
    }
}

