/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2_1.context.persistence;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.context.java.JavaEntity;
import org.eclipse.jpt.jpa.core.context.java.JavaMappedSuperclass;
import org.eclipse.jpt.jpa.core.context.orm.EntityMappings;
import org.eclipse.jpt.jpa.core.context.orm.OrmNamedNativeQuery;
import org.eclipse.jpt.jpa.core.context.orm.OrmNamedQuery;
import org.eclipse.jpt.jpa.core.context.orm.OrmQueryHint;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.jpa2_1.ParameterMode2_1;
import org.eclipse.jpt.jpa.core.jpa2_1.context.QueryContainer2_1;
import org.eclipse.jpt.jpa.core.jpa2_1.context.orm.OrmNamedStoredProcedureQuery2_1;
import org.eclipse.jpt.jpa.core.jpa2_1.context.orm.OrmQueryContainer2_1;
import org.eclipse.jpt.jpa.core.jpa2_1.context.orm.OrmStoredProcedureParameter2_1;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2_1.context.Generic2_1ContextModelTestCase;

public class Generic2_1JpaMetadataConversionTests
extends Generic2_1ContextModelTestCase {
    private IProgressMonitor progressMonitor;

    public Generic2_1JpaMetadataConversionTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.progressMonitor = new IProgressMonitor(){

            public void worked(int work) {
            }

            public void subTask(String name) {
            }

            public void setTaskName(String name) {
            }

            public void setCanceled(boolean value) {
            }

            public boolean isCanceled() {
                return false;
            }

            public void internalWorked(double work) {
            }

            public void done() {
            }

            public void beginTask(String name, int totalWork) {
            }
        };
    }

    protected void tearDown() throws Exception {
        this.progressMonitor = null;
        super.tearDown();
    }

    private ICompilationUnit createTestEntityWithNamedStoredProcedureQueries() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.NamedStoredProcedureQueries", "javax.persistence.NamedStoredProcedureQuery", "javax.persistence.StoredProcedureParameter", "javax.persistence.ParameterMode", "javax.persistence.QueryHint"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@NamedStoredProcedureQueries({@NamedStoredProcedureQuery(name=\"nq1\", procedureName=\"abcd\", parameters={@StoredProcedureParameter(name=\"nq1parameter1\", mode=ParameterMode.INOUT, type=String.class), @StoredProcedureParameter(name=\"nq1parameter2\", mode=ParameterMode.OUT, type=Integer.class)}, resultClasses={Employee.class, Address.class}, resultSetMappings={\"EmployeeRSM\", \"AddressRSM\"}, hints={@QueryHint(name=\"nq1hint1\", value = \"aaa\"), @QueryHint(name=\"nq1hint2\", value=\"bbb\")}), @NamedStoredProcedureQuery(name=\"nq2\", procedureName=\"efgh\",parameters=@StoredProcedureParameter(name=\"nq2parameter1\", mode=ParameterMode.INOUT, type=Boolean.class),resultClasses=Project.class,resultSetMappings=\"ProjectRSM\",hints=@QueryHint(name=\"nq2hint1\", value=\"ccc\"))})");
            }
        });
    }

    private ICompilationUnit createTestEntityWithQueries() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.NamedStoredProcedureQueries", "javax.persistence.NamedStoredProcedureQuery", "javax.persistence.NamedNativeQuery"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@NamedStoredProcedureQueries({@NamedStoredProcedureQuery(name=\"nq\"), @NamedStoredProcedureQuery(name=\"query\")})").append(CR);
                sb.append("@NamedNativeQuery(name=\"nnq\")");
            }
        });
    }

    private ICompilationUnit createTestEntityWithDuplicateQueries() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.NamedStoredProcedureQueries", "javax.persistence.NamedStoredProcedureQuery", "javax.persistence.NamedNativeQueries", "javax.persistence.NamedNativeQuery"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@NamedStoredProcedureQueries({@NamedStoredProcedureQuery(name=\"query\"), @NamedStoredProcedureQuery(name=\"nspq\")})");
                sb.append("@NamedNativeQueries({@NamedNativeQuery(name=\"query\"), @NamedNativeQuery(name=\"nnq\")})");
            }
        });
    }

    private ICompilationUnit createTestMappedSuperWithNamedStoredProcedureQueries() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.MappedSuperclass", "javax.persistence.NamedStoredProcedureQueries", "javax.persistence.NamedStoredProcedureQuery", "javax.persistence.StoredProcedureParameter", "javax.persistence.ParameterMode", "javax.persistence.QueryHint"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@MappedSuperclass").append(CR);
                sb.append("@NamedStoredProcedureQueries({@NamedStoredProcedureQuery(name=\"nq1\", procedureName=\"abcd\", parameters={@StoredProcedureParameter(name=\"nq1parameter1\", mode=ParameterMode.INOUT, type=String.class), @StoredProcedureParameter(name=\"nq1parameter2\", mode=ParameterMode.OUT, type=Integer.class)}, resultClasses={Employee.class, Address.class}, resultSetMappings={\"EmployeeRSM\", \"AddressRSM\"}, hints={@QueryHint(name=\"nq1hint1\", value = \"aaa\"), @QueryHint(name=\"nq1hint2\", value=\"bbb\")}), @NamedStoredProcedureQuery(name=\"nq2\", procedureName=\"efgh\",parameters=@StoredProcedureParameter(name=\"nq2parameter1\", mode=ParameterMode.INOUT, type=Boolean.class),resultClasses=Project.class,resultSetMappings=\"ProjectRSM\",hints=@QueryHint(name=\"nq2hint1\", value=\"ccc\"))})");
            }
        });
    }

    public void testConvertNamedStoredProceduerQueriesOnEntity() throws Exception {
        this.createTestEntityWithNamedStoredProcedureQueries();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        this.addXmlMappingFileRef("META-INF/orm.xml");
        EntityMappings entityMappings = this.getEntityMappings();
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        persistenceUnit.convertJavaQueries(entityMappings, this.progressMonitor);
        Generic2_1JpaMetadataConversionTests.assertEquals((int)2, (int)((QueryContainer2_1)entityMappings.getQueryContainer()).getNamedStoredProcedureQueriesSize());
        Generic2_1JpaMetadataConversionTests.assertEquals((int)0, (int)((QueryContainer2_1)entity.getQueryContainer()).getNamedStoredProcedureQueriesSize());
        ListIterator procedureQueries = ((OrmQueryContainer2_1)entityMappings.getQueryContainer()).getNamedStoredProcedureQueries().iterator();
        OrmNamedStoredProcedureQuery2_1 procedureQuery1 = (OrmNamedStoredProcedureQuery2_1)procedureQueries.next();
        Generic2_1JpaMetadataConversionTests.assertEquals((String)"nq1", (String)procedureQuery1.getName());
        Generic2_1JpaMetadataConversionTests.assertEquals((String)"abcd", (String)procedureQuery1.getProcedureName());
        Generic2_1JpaMetadataConversionTests.assertEquals((int)2, (int)procedureQuery1.getParametersSize());
        Generic2_1JpaMetadataConversionTests.assertEquals((int)2, (int)procedureQuery1.getResultClassesSize());
        Generic2_1JpaMetadataConversionTests.assertEquals((int)2, (int)procedureQuery1.getResultSetMappingsSize());
        Generic2_1JpaMetadataConversionTests.assertEquals((int)2, (int)procedureQuery1.getHintsSize());
        ListIterator nq1prameters = procedureQuery1.getParameters().iterator();
        OrmStoredProcedureParameter2_1 nq1parameter1 = (OrmStoredProcedureParameter2_1)nq1prameters.next();
        Generic2_1JpaMetadataConversionTests.assertEquals((String)"nq1parameter1", (String)nq1parameter1.getName());
        Generic2_1JpaMetadataConversionTests.assertEquals((Object)ParameterMode2_1.INOUT, (Object)nq1parameter1.getMode());
        Generic2_1JpaMetadataConversionTests.assertEquals((String)"String", (String)nq1parameter1.getTypeName());
        OrmStoredProcedureParameter2_1 nq1parameter2 = (OrmStoredProcedureParameter2_1)nq1prameters.next();
        Generic2_1JpaMetadataConversionTests.assertEquals((String)"nq1parameter2", (String)nq1parameter2.getName());
        Generic2_1JpaMetadataConversionTests.assertEquals((Object)ParameterMode2_1.OUT, (Object)nq1parameter2.getMode());
        Generic2_1JpaMetadataConversionTests.assertEquals((String)"Integer", (String)nq1parameter2.getTypeName());
        ListIterator nq1ResultClasses = procedureQuery1.getResultClasses().iterator();
        Generic2_1JpaMetadataConversionTests.assertEquals((String)"Employee", (String)((String)nq1ResultClasses.next()));
        Generic2_1JpaMetadataConversionTests.assertEquals((String)"Address", (String)((String)nq1ResultClasses.next()));
        ListIterator nq1ResultSetMappings = procedureQuery1.getResultSetMappings().iterator();
        Generic2_1JpaMetadataConversionTests.assertEquals((String)"EmployeeRSM", (String)((String)nq1ResultSetMappings.next()));
        Generic2_1JpaMetadataConversionTests.assertEquals((String)"AddressRSM", (String)((String)nq1ResultSetMappings.next()));
        ListIterator nq1hints = procedureQuery1.getHints().iterator();
        OrmQueryHint nq1hint1 = (OrmQueryHint)nq1hints.next();
        Generic2_1JpaMetadataConversionTests.assertEquals((String)"nq1hint1", (String)nq1hint1.getName());
        Generic2_1JpaMetadataConversionTests.assertEquals((String)"aaa", (String)nq1hint1.getValue());
        OrmQueryHint nq1hint2 = (OrmQueryHint)nq1hints.next();
        Generic2_1JpaMetadataConversionTests.assertEquals((String)"nq1hint2", (String)nq1hint2.getName());
        Generic2_1JpaMetadataConversionTests.assertEquals((String)"bbb", (String)nq1hint2.getValue());
        OrmNamedStoredProcedureQuery2_1 procedureQuery2 = (OrmNamedStoredProcedureQuery2_1)procedureQueries.next();
        Generic2_1JpaMetadataConversionTests.assertEquals((String)"nq2", (String)procedureQuery2.getName());
        Generic2_1JpaMetadataConversionTests.assertEquals((String)"efgh", (String)procedureQuery2.getProcedureName());
        Generic2_1JpaMetadataConversionTests.assertEquals((int)1, (int)procedureQuery2.getParametersSize());
        Generic2_1JpaMetadataConversionTests.assertEquals((int)1, (int)procedureQuery2.getResultClassesSize());
        Generic2_1JpaMetadataConversionTests.assertEquals((int)1, (int)procedureQuery2.getResultSetMappingsSize());
        Generic2_1JpaMetadataConversionTests.assertEquals((int)1, (int)procedureQuery2.getHintsSize());
        OrmStoredProcedureParameter2_1 nq2parameter = (OrmStoredProcedureParameter2_1)procedureQuery2.getParameters().iterator().next();
        Generic2_1JpaMetadataConversionTests.assertEquals((String)"nq2parameter1", (String)nq2parameter.getName());
        Generic2_1JpaMetadataConversionTests.assertEquals((Object)ParameterMode2_1.INOUT, (Object)nq2parameter.getMode());
        Generic2_1JpaMetadataConversionTests.assertEquals((String)"Boolean", (String)nq2parameter.getTypeName());
        String nq2ResultClass = (String)procedureQuery2.getResultClasses().iterator().next();
        Generic2_1JpaMetadataConversionTests.assertEquals((String)"Project", (String)nq2ResultClass);
        String nq2ResultSetMapping = (String)procedureQuery2.getResultSetMappings().iterator().next();
        Generic2_1JpaMetadataConversionTests.assertEquals((String)"ProjectRSM", (String)nq2ResultSetMapping);
        OrmQueryHint nq2hint1 = (OrmQueryHint)procedureQuery2.getHints().iterator().next();
        Generic2_1JpaMetadataConversionTests.assertEquals((String)"nq2hint1", (String)nq2hint1.getName());
        Generic2_1JpaMetadataConversionTests.assertEquals((String)"ccc", (String)nq2hint1.getValue());
    }

    public void testConvertOverriddenQueries() throws Exception {
        this.createTestEntityWithQueries();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        this.addXmlMappingFileRef("META-INF/orm.xml");
        EntityMappings entityMappings = this.getEntityMappings();
        OrmNamedNativeQuery nnq = entityMappings.getQueryContainer().addNamedNativeQuery();
        nnq.setName("nq");
        OrmNamedQuery nq = entityMappings.getQueryContainer().addNamedQuery();
        nq.setName("nnq");
        JavaEntity entity = this.getJavaEntity();
        persistenceUnit.convertJavaQueries(entityMappings, this.progressMonitor);
        Generic2_1JpaMetadataConversionTests.assertEquals((int)1, (int)((QueryContainer2_1)entity.getQueryContainer()).getNamedStoredProcedureQueriesSize());
        Generic2_1JpaMetadataConversionTests.assertEquals((int)1, (int)entity.getQueryContainer().getNamedNativeQueriesSize());
        Generic2_1JpaMetadataConversionTests.assertEquals((int)1, (int)((QueryContainer2_1)entityMappings.getQueryContainer()).getNamedStoredProcedureQueriesSize());
        Generic2_1JpaMetadataConversionTests.assertEquals((int)1, (int)entityMappings.getQueryContainer().getNamedNativeQueriesSize());
        Generic2_1JpaMetadataConversionTests.assertEquals((int)1, (int)entityMappings.getQueryContainer().getNamedQueriesSize());
    }

    public void testConvertDuplicateQueries() throws Exception {
        this.createTestEntityWithDuplicateQueries();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        this.addXmlMappingFileRef("META-INF/orm.xml");
        EntityMappings entityMappings = this.getEntityMappings();
        persistenceUnit.convertJavaQueries(entityMappings, this.progressMonitor);
        JavaEntity entity = this.getJavaEntity();
        Generic2_1JpaMetadataConversionTests.assertEquals((int)1, (int)((QueryContainer2_1)entity.getQueryContainer()).getNamedStoredProcedureQueriesSize());
        Generic2_1JpaMetadataConversionTests.assertEquals((int)1, (int)entity.getQueryContainer().getNamedNativeQueriesSize());
        Generic2_1JpaMetadataConversionTests.assertEquals((int)1, (int)((QueryContainer2_1)entityMappings.getQueryContainer()).getNamedStoredProcedureQueriesSize());
        Generic2_1JpaMetadataConversionTests.assertEquals((int)1, (int)entityMappings.getQueryContainer().getNamedNativeQueriesSize());
    }

    public void testConvertNamedStoredProcedureQueriesOnMappedSuperclass() throws Exception {
        this.createTestMappedSuperWithNamedStoredProcedureQueries();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaMappedSuperclass mappedSuperclass = (JavaMappedSuperclass)this.getJavaPersistentType().getMapping();
        this.addXmlMappingFileRef("META-INF/orm.xml");
        EntityMappings entityMappings = this.getEntityMappings();
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        persistenceUnit.convertJavaQueries(entityMappings, this.progressMonitor);
        Generic2_1JpaMetadataConversionTests.assertEquals((int)2, (int)((QueryContainer2_1)entityMappings.getQueryContainer()).getNamedStoredProcedureQueriesSize());
        Generic2_1JpaMetadataConversionTests.assertEquals((int)0, (int)((QueryContainer2_1)mappedSuperclass.getQueryContainer()).getNamedStoredProcedureQueriesSize());
        ListIterator procedureQueries = ((OrmQueryContainer2_1)entityMappings.getQueryContainer()).getNamedStoredProcedureQueries().iterator();
        OrmNamedStoredProcedureQuery2_1 procedureQuery1 = (OrmNamedStoredProcedureQuery2_1)procedureQueries.next();
        Generic2_1JpaMetadataConversionTests.assertEquals((String)"nq1", (String)procedureQuery1.getName());
        Generic2_1JpaMetadataConversionTests.assertEquals((String)"abcd", (String)procedureQuery1.getProcedureName());
        Generic2_1JpaMetadataConversionTests.assertEquals((int)2, (int)procedureQuery1.getParametersSize());
        Generic2_1JpaMetadataConversionTests.assertEquals((int)2, (int)procedureQuery1.getResultClassesSize());
        Generic2_1JpaMetadataConversionTests.assertEquals((int)2, (int)procedureQuery1.getResultSetMappingsSize());
        Generic2_1JpaMetadataConversionTests.assertEquals((int)2, (int)procedureQuery1.getHintsSize());
        ListIterator nq1prameters = procedureQuery1.getParameters().iterator();
        OrmStoredProcedureParameter2_1 nq1parameter1 = (OrmStoredProcedureParameter2_1)nq1prameters.next();
        Generic2_1JpaMetadataConversionTests.assertEquals((String)"nq1parameter1", (String)nq1parameter1.getName());
        Generic2_1JpaMetadataConversionTests.assertEquals((Object)ParameterMode2_1.INOUT, (Object)nq1parameter1.getMode());
        Generic2_1JpaMetadataConversionTests.assertEquals((String)"String", (String)nq1parameter1.getTypeName());
        OrmStoredProcedureParameter2_1 nq1parameter2 = (OrmStoredProcedureParameter2_1)nq1prameters.next();
        Generic2_1JpaMetadataConversionTests.assertEquals((String)"nq1parameter2", (String)nq1parameter2.getName());
        Generic2_1JpaMetadataConversionTests.assertEquals((Object)ParameterMode2_1.OUT, (Object)nq1parameter2.getMode());
        Generic2_1JpaMetadataConversionTests.assertEquals((String)"Integer", (String)nq1parameter2.getTypeName());
        ListIterator nq1ResultClasses = procedureQuery1.getResultClasses().iterator();
        Generic2_1JpaMetadataConversionTests.assertEquals((String)"Employee", (String)((String)nq1ResultClasses.next()));
        Generic2_1JpaMetadataConversionTests.assertEquals((String)"Address", (String)((String)nq1ResultClasses.next()));
        ListIterator nq1ResultSetMappings = procedureQuery1.getResultSetMappings().iterator();
        Generic2_1JpaMetadataConversionTests.assertEquals((String)"EmployeeRSM", (String)((String)nq1ResultSetMappings.next()));
        Generic2_1JpaMetadataConversionTests.assertEquals((String)"AddressRSM", (String)((String)nq1ResultSetMappings.next()));
        ListIterator nq1hints = procedureQuery1.getHints().iterator();
        OrmQueryHint nq1hint1 = (OrmQueryHint)nq1hints.next();
        Generic2_1JpaMetadataConversionTests.assertEquals((String)"nq1hint1", (String)nq1hint1.getName());
        Generic2_1JpaMetadataConversionTests.assertEquals((String)"aaa", (String)nq1hint1.getValue());
        OrmQueryHint nq1hint2 = (OrmQueryHint)nq1hints.next();
        Generic2_1JpaMetadataConversionTests.assertEquals((String)"nq1hint2", (String)nq1hint2.getName());
        Generic2_1JpaMetadataConversionTests.assertEquals((String)"bbb", (String)nq1hint2.getValue());
        OrmNamedStoredProcedureQuery2_1 procedureQuery2 = (OrmNamedStoredProcedureQuery2_1)procedureQueries.next();
        Generic2_1JpaMetadataConversionTests.assertEquals((String)"nq2", (String)procedureQuery2.getName());
        Generic2_1JpaMetadataConversionTests.assertEquals((String)"efgh", (String)procedureQuery2.getProcedureName());
        Generic2_1JpaMetadataConversionTests.assertEquals((int)1, (int)procedureQuery2.getParametersSize());
        Generic2_1JpaMetadataConversionTests.assertEquals((int)1, (int)procedureQuery2.getResultClassesSize());
        Generic2_1JpaMetadataConversionTests.assertEquals((int)1, (int)procedureQuery2.getResultSetMappingsSize());
        Generic2_1JpaMetadataConversionTests.assertEquals((int)1, (int)procedureQuery2.getHintsSize());
        OrmStoredProcedureParameter2_1 nq2parameter = (OrmStoredProcedureParameter2_1)procedureQuery2.getParameters().iterator().next();
        Generic2_1JpaMetadataConversionTests.assertEquals((String)"nq2parameter1", (String)nq2parameter.getName());
        Generic2_1JpaMetadataConversionTests.assertEquals((Object)ParameterMode2_1.INOUT, (Object)nq2parameter.getMode());
        Generic2_1JpaMetadataConversionTests.assertEquals((String)"Boolean", (String)nq2parameter.getTypeName());
        String nq2ResultClass = (String)procedureQuery2.getResultClasses().iterator().next();
        Generic2_1JpaMetadataConversionTests.assertEquals((String)"Project", (String)nq2ResultClass);
        String nq2ResultSetMapping = (String)procedureQuery2.getResultSetMappings().iterator().next();
        Generic2_1JpaMetadataConversionTests.assertEquals((String)"ProjectRSM", (String)nq2ResultSetMapping);
        OrmQueryHint nq2hint1 = (OrmQueryHint)procedureQuery2.getHints().iterator().next();
        Generic2_1JpaMetadataConversionTests.assertEquals((String)"nq2hint1", (String)nq2hint1.getName());
        Generic2_1JpaMetadataConversionTests.assertEquals((String)"ccc", (String)nq2hint1.getValue());
    }
}

