/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2_1.resource.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.jpa2_1.resource.java.NamedStoredProcedureQueryAnnotation2_1;
import org.eclipse.jpt.jpa.core.jpa2_1.resource.java.StoredProcedureParameterAnnotation2_1;
import org.eclipse.jpt.jpa.core.resource.java.QueryHintAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2_1.resource.java.JavaResourceModel2_1TestCase;

public class NamedStoredProcedureQuery2_1AnnotationTests
extends JavaResourceModel2_1TestCase {
    private static final String QUERY_NAME = "myQuery";
    private static final String PROCEDURE_NAME = "myProcedure";

    public NamedStoredProcedureQuery2_1AnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestNamedStoredProcedureQuery() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.NamedStoredProcedureQuery"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@NamedStoredProcedureQuery");
            }
        });
    }

    private ICompilationUnit createTestNamedStoredProcedureQueryWithName() throws Exception {
        return this.createTestNamedStoredProcedureQueryWithStringElement("name", QUERY_NAME);
    }

    private ICompilationUnit createTestNamedNativeQueryWithProcedureName() throws Exception {
        return this.createTestNamedStoredProcedureQueryWithStringElement("procedureName", PROCEDURE_NAME);
    }

    private ICompilationUnit createTestNamedStoredProcedureQueryWithStringElement(final String elementName, final String value) throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.NamedStoredProcedureQuery"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@NamedStoredProcedureQuery(" + elementName + " = \"" + value + "\")");
            }
        });
    }

    private ICompilationUnit createTestNamedStoredProcedureQueryWithParameters() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.NamedStoredProcedureQuery", "javax.persistence.StoredProcedureParameter", "javax.persistence.ParameterMode"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@NamedStoredProcedureQuery(parameters = {@StoredProcedureParameter(name = \"BAR\", mode=ParameterMode.IN, type=Integer.class), @StoredProcedureParameter})");
            }
        });
    }

    private ICompilationUnit createTestNamedStoredProcedureQueryWithResultClasses() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.NamedStoredProcedureQuery"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@NamedStoredProcedureQuery(resultClasses = { Employee.class, Address.class })");
            }
        });
    }

    private ICompilationUnit createTestNamedStoredProcedureQueryWithResultSetMappings() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.NamedStoredProcedureQuery"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@NamedStoredProcedureQuery(resultSetMappings = { \"EmpRSMapping\", \"AddrRSMapping\" })");
            }
        });
    }

    private ICompilationUnit createTestNamedStoredProcedureQueryWithHints() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.NamedStoredProcedureQuery", "javax.persistence.QueryHint"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@NamedStoredProcedureQuery(hints = {@QueryHint(name = \"BAR\", value = \"FOO\"), @QueryHint})");
            }
        });
    }

    public void testNamedStoredProcedureQuery() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQuery();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        NamedStoredProcedureQuery2_1AnnotationTests.assertNotNull((Object)namedQuery);
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQueryWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)QUERY_NAME, (String)namedQuery.getName());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQueryWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)QUERY_NAME, (String)namedQuery.getName());
        namedQuery.setName("foo");
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"foo", (String)namedQuery.getName());
        this.assertSourceContains("@NamedStoredProcedureQuery(name = \"foo\")", cu);
        namedQuery.setName(null);
        NamedStoredProcedureQuery2_1AnnotationTests.assertNull((Object)namedQuery.getName());
        this.assertSourceDoesNotContain("@NamedStoredProcedureQuery(", cu);
    }

    public void testGetProcedureName() throws Exception {
        ICompilationUnit cu = this.createTestNamedNativeQueryWithProcedureName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)PROCEDURE_NAME, (String)namedQuery.getProcedureName());
    }

    public void testSetProcedureName() throws Exception {
        ICompilationUnit cu = this.createTestNamedNativeQueryWithProcedureName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)PROCEDURE_NAME, (String)namedQuery.getProcedureName());
        namedQuery.setProcedureName("foo");
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"foo", (String)namedQuery.getProcedureName());
        this.assertSourceContains("@NamedStoredProcedureQuery(procedureName = \"foo\")", cu);
        namedQuery.setProcedureName(null);
        NamedStoredProcedureQuery2_1AnnotationTests.assertNull((Object)namedQuery.getProcedureName());
        this.assertSourceDoesNotContain("@NamedStoredProcedureQuery(", cu);
    }

    public void testParameters1() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQuery();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)0, (int)namedQuery.getParametersSize());
    }

    public void testParameters2() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQuery();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        namedQuery.addParameter(0);
        namedQuery.addParameter(1);
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)2, (int)namedQuery.getParametersSize());
    }

    public void testParameters3() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQueryWithParameters();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)2, (int)namedQuery.getParametersSize());
        ListIterator iterator = namedQuery.getParameters().iterator();
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"BAR", (String)((StoredProcedureParameterAnnotation2_1)iterator.next()).getName());
        NamedStoredProcedureQuery2_1AnnotationTests.assertNull((Object)((StoredProcedureParameterAnnotation2_1)iterator.next()).getName());
    }

    public void testAddParameter() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQuery();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        namedQuery.addParameter(0).setName("FOO");
        namedQuery.addParameter(1);
        namedQuery.addParameter(0).setName("BAR");
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"BAR", (String)namedQuery.parameterAt(0).getName());
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"FOO", (String)namedQuery.parameterAt(1).getName());
        NamedStoredProcedureQuery2_1AnnotationTests.assertNull((Object)namedQuery.parameterAt(2).getName());
        this.assertSourceContains("@NamedStoredProcedureQuery(parameters = {@StoredProcedureParameter(name = \"BAR\"),@StoredProcedureParameter(name = \"FOO\"), @StoredProcedureParameter})", cu);
    }

    public void testRemoveParameter() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQueryWithParameters();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        namedQuery.addParameter(0).setName("BAZ");
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"BAZ", (String)namedQuery.parameterAt(0).getName());
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"BAR", (String)namedQuery.parameterAt(1).getName());
        NamedStoredProcedureQuery2_1AnnotationTests.assertNull((Object)namedQuery.parameterAt(2).getName());
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)3, (int)namedQuery.getParametersSize());
        namedQuery.removeParameter(2);
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"BAZ", (String)namedQuery.parameterAt(0).getName());
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"BAR", (String)namedQuery.parameterAt(1).getName());
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)2, (int)namedQuery.getParametersSize());
        this.assertSourceContains("@NamedStoredProcedureQuery(parameters = {@StoredProcedureParameter(name = \"BAZ\"), @StoredProcedureParameter(name = \"BAR\", mode=ParameterMode.IN, type=Integer.class)})", cu);
        namedQuery.removeParameter(0);
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"BAR", (String)namedQuery.parameterAt(0).getName());
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)1, (int)namedQuery.getParametersSize());
        this.assertSourceContains("@NamedStoredProcedureQuery(parameters = @StoredProcedureParameter(name = \"BAR\", mode=ParameterMode.IN, type=Integer.class))", cu);
        namedQuery.removeParameter(0);
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)0, (int)namedQuery.getParametersSize());
        this.assertSourceDoesNotContain("@NamedStoredProcedureQuery(", cu);
    }

    public void testMoveParameter1() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQueryWithParameters();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        namedQuery.addParameter(0).setName("BAZ");
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"BAZ", (String)namedQuery.parameterAt(0).getName());
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"BAR", (String)namedQuery.parameterAt(1).getName());
        NamedStoredProcedureQuery2_1AnnotationTests.assertNull((Object)namedQuery.parameterAt(2).getName());
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)3, (int)namedQuery.getParametersSize());
        namedQuery.moveParameter(2, 0);
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"BAR", (String)namedQuery.parameterAt(0).getName());
        NamedStoredProcedureQuery2_1AnnotationTests.assertNull((Object)namedQuery.parameterAt(1).getName());
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"BAZ", (String)namedQuery.parameterAt(2).getName());
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)3, (int)namedQuery.getParametersSize());
        this.assertSourceContains("@NamedStoredProcedureQuery(parameters = {@StoredProcedureParameter(name = \"BAR\", mode=ParameterMode.IN, type=Integer.class), @StoredProcedureParameter, @StoredProcedureParameter(name = \"BAZ\")})", cu);
    }

    public void testMoveParameter2() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQueryWithParameters();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        namedQuery.addParameter(0).setName("BAZ");
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"BAZ", (String)namedQuery.parameterAt(0).getName());
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"BAR", (String)namedQuery.parameterAt(1).getName());
        NamedStoredProcedureQuery2_1AnnotationTests.assertNull((Object)namedQuery.parameterAt(2).getName());
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)3, (int)namedQuery.getParametersSize());
        namedQuery.moveParameter(0, 2);
        NamedStoredProcedureQuery2_1AnnotationTests.assertNull((Object)namedQuery.parameterAt(0).getName());
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"BAZ", (String)namedQuery.parameterAt(1).getName());
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"BAR", (String)namedQuery.parameterAt(2).getName());
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)3, (int)namedQuery.getParametersSize());
        this.assertSourceContains("@NamedStoredProcedureQuery(parameters = {@StoredProcedureParameter, @StoredProcedureParameter(name = \"BAZ\"), @StoredProcedureParameter(name = \"BAR\", mode=ParameterMode.IN, type=Integer.class)})", cu);
    }

    public void testResultClasses1() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQuery();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)0, (int)namedQuery.getResultClassesSize());
    }

    public void testResultClasses2() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQueryWithResultClasses();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)2, (int)namedQuery.getResultClassesSize());
        ListIterator iterator = namedQuery.getResultClasses().iterator();
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"Employee", (String)((String)iterator.next()));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"Address", (String)((String)iterator.next()));
    }

    public void testAddResultClass() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQuery();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        namedQuery.addResultClass("Project");
        namedQuery.addResultClass("Phone");
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)2, (int)namedQuery.getResultClassesSize());
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"Project", (String)namedQuery.resultClassAt(0));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"Phone", (String)namedQuery.resultClassAt(1));
        this.assertSourceContains("@NamedStoredProcedureQuery(resultClasses = { Project.class, Phone.class })", cu);
    }

    public void testRemoveResultClass1() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQueryWithResultClasses();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        namedQuery.addResultClass("Project");
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"Employee", (String)namedQuery.resultClassAt(0));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"Address", (String)namedQuery.resultClassAt(1));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"Project", (String)namedQuery.resultClassAt(2));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)3, (int)namedQuery.getResultClassesSize());
        namedQuery.removeResultClass(1);
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"Employee", (String)namedQuery.resultClassAt(0));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"Project", (String)namedQuery.resultClassAt(1));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)2, (int)namedQuery.getResultClassesSize());
        this.assertSourceContains("@NamedStoredProcedureQuery(resultClasses = { Employee.class, Project.class })", cu);
        namedQuery.removeResultClass(0);
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"Project", (String)namedQuery.resultClassAt(0));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)1, (int)namedQuery.getResultClassesSize());
        this.assertSourceContains("@NamedStoredProcedureQuery(resultClasses = Project.class)", cu);
        namedQuery.removeResultClass(0);
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)0, (int)namedQuery.getResultClassesSize());
        this.assertSourceDoesNotContain("@NamedStoredProcedureQuery(", cu);
    }

    public void testRemoveResultClass2() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQueryWithResultClasses();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        namedQuery.addResultClass("Project");
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"Employee", (String)namedQuery.resultClassAt(0));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"Address", (String)namedQuery.resultClassAt(1));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"Project", (String)namedQuery.resultClassAt(2));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)3, (int)namedQuery.getResultClassesSize());
        namedQuery.removeResultClass("Address");
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"Employee", (String)namedQuery.resultClassAt(0));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"Project", (String)namedQuery.resultClassAt(1));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)2, (int)namedQuery.getResultClassesSize());
        this.assertSourceContains("@NamedStoredProcedureQuery(resultClasses = { Employee.class, Project.class })", cu);
        namedQuery.removeResultClass("Employee");
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"Project", (String)namedQuery.resultClassAt(0));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)1, (int)namedQuery.getResultClassesSize());
        this.assertSourceContains("@NamedStoredProcedureQuery(resultClasses = Project.class)", cu);
        namedQuery.removeResultClass("Project");
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)0, (int)namedQuery.getResultClassesSize());
        this.assertSourceDoesNotContain("@NamedStoredProcedureQuery(", cu);
    }

    public void testMoveResultClass1() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQueryWithResultClasses();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        namedQuery.addResultClass("Project");
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"Employee", (String)namedQuery.resultClassAt(0));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"Address", (String)namedQuery.resultClassAt(1));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"Project", (String)namedQuery.resultClassAt(2));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)3, (int)namedQuery.getResultClassesSize());
        namedQuery.moveResultClass(2, 0);
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"Address", (String)namedQuery.resultClassAt(0));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"Project", (String)namedQuery.resultClassAt(1));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"Employee", (String)namedQuery.resultClassAt(2));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)3, (int)namedQuery.getResultClassesSize());
        this.assertSourceContains("@NamedStoredProcedureQuery(resultClasses = { Address.class, Project.class, Employee.class })", cu);
    }

    public void testMoveResultClass2() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQueryWithResultClasses();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        namedQuery.addResultClass("Project");
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"Employee", (String)namedQuery.resultClassAt(0));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"Address", (String)namedQuery.resultClassAt(1));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"Project", (String)namedQuery.resultClassAt(2));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)3, (int)namedQuery.getResultClassesSize());
        namedQuery.moveResultClass(0, 2);
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"Project", (String)namedQuery.resultClassAt(0));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"Employee", (String)namedQuery.resultClassAt(1));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"Address", (String)namedQuery.resultClassAt(2));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)3, (int)namedQuery.getResultClassesSize());
        this.assertSourceContains("@NamedStoredProcedureQuery(resultClasses = { Project.class, Employee.class, Address.class })", cu);
    }

    public void testResultSetMappings1() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQuery();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)0, (int)namedQuery.getResultSetMappingsSize());
    }

    public void testResultSetMappings2() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQueryWithResultSetMappings();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)2, (int)namedQuery.getResultSetMappingsSize());
        ListIterator iterator = namedQuery.getResultSetMappings().iterator();
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"EmpRSMapping", (String)((String)iterator.next()));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"AddrRSMapping", (String)((String)iterator.next()));
        this.assertSourceContains("@NamedStoredProcedureQuery(resultSetMappings = { \"EmpRSMapping\", \"AddrRSMapping\" })", cu);
    }

    public void testAddResultSetMapping() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQuery();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        namedQuery.addResultSetMapping("ProjRSMapping");
        namedQuery.addResultSetMapping("PhRSMapping");
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)2, (int)namedQuery.getResultSetMappingsSize());
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"ProjRSMapping", (String)namedQuery.resultSetMappingAt(0));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"PhRSMapping", (String)namedQuery.resultSetMappingAt(1));
        this.assertSourceContains("@NamedStoredProcedureQuery(resultSetMappings = { \"ProjRSMapping\", \"PhRSMapping\" })", cu);
    }

    public void testRemoveResultSetMapping1() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQueryWithResultSetMappings();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        namedQuery.addResultSetMapping("ProjRSMapping");
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"EmpRSMapping", (String)namedQuery.resultSetMappingAt(0));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"AddrRSMapping", (String)namedQuery.resultSetMappingAt(1));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"ProjRSMapping", (String)namedQuery.resultSetMappingAt(2));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)3, (int)namedQuery.getResultSetMappingsSize());
        namedQuery.removeResultSetMapping(1);
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"EmpRSMapping", (String)namedQuery.resultSetMappingAt(0));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"ProjRSMapping", (String)namedQuery.resultSetMappingAt(1));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)2, (int)namedQuery.getResultSetMappingsSize());
        this.assertSourceContains("@NamedStoredProcedureQuery(resultSetMappings = { \"EmpRSMapping\", \"ProjRSMapping\" })", cu);
        namedQuery.removeResultSetMapping(0);
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"ProjRSMapping", (String)namedQuery.resultSetMappingAt(0));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)1, (int)namedQuery.getResultSetMappingsSize());
        this.assertSourceContains("@NamedStoredProcedureQuery(resultSetMappings = \"ProjRSMapping\")", cu);
        namedQuery.removeResultSetMapping(0);
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)0, (int)namedQuery.getResultSetMappingsSize());
        this.assertSourceDoesNotContain("@NamedStoredProcedureQuery(", cu);
    }

    public void testRemoveResultSetMapping2() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQueryWithResultSetMappings();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        namedQuery.addResultSetMapping("ProjRSMapping");
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"EmpRSMapping", (String)namedQuery.resultSetMappingAt(0));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"AddrRSMapping", (String)namedQuery.resultSetMappingAt(1));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"ProjRSMapping", (String)namedQuery.resultSetMappingAt(2));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)3, (int)namedQuery.getResultSetMappingsSize());
        namedQuery.removeResultSetMapping("AddrRSMapping");
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"EmpRSMapping", (String)namedQuery.resultSetMappingAt(0));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"ProjRSMapping", (String)namedQuery.resultSetMappingAt(1));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)2, (int)namedQuery.getResultSetMappingsSize());
        this.assertSourceContains("@NamedStoredProcedureQuery(resultSetMappings = { \"EmpRSMapping\", \"ProjRSMapping\" })", cu);
        namedQuery.removeResultSetMapping("EmpRSMapping");
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"ProjRSMapping", (String)namedQuery.resultSetMappingAt(0));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)1, (int)namedQuery.getResultSetMappingsSize());
        this.assertSourceContains("@NamedStoredProcedureQuery(resultSetMappings = \"ProjRSMapping\")", cu);
        namedQuery.removeResultSetMapping("ProjRSMapping");
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)0, (int)namedQuery.getResultSetMappingsSize());
        this.assertSourceDoesNotContain("@NamedStoredProcedureQuery(", cu);
    }

    public void testMoveResultSetMapping1() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQueryWithResultSetMappings();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        namedQuery.addResultSetMapping("ProjRSMapping");
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"EmpRSMapping", (String)namedQuery.resultSetMappingAt(0));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"AddrRSMapping", (String)namedQuery.resultSetMappingAt(1));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"ProjRSMapping", (String)namedQuery.resultSetMappingAt(2));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)3, (int)namedQuery.getResultSetMappingsSize());
        namedQuery.moveResultSetMapping(2, 0);
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"AddrRSMapping", (String)namedQuery.resultSetMappingAt(0));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"ProjRSMapping", (String)namedQuery.resultSetMappingAt(1));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"EmpRSMapping", (String)namedQuery.resultSetMappingAt(2));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)3, (int)namedQuery.getResultSetMappingsSize());
        this.assertSourceContains("@NamedStoredProcedureQuery(resultSetMappings = { \"AddrRSMapping\", \"ProjRSMapping\", \"EmpRSMapping\" })", cu);
    }

    public void testMoveResultSetMapping2() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQueryWithResultSetMappings();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        namedQuery.addResultSetMapping("ProjRSMapping");
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"EmpRSMapping", (String)namedQuery.resultSetMappingAt(0));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"AddrRSMapping", (String)namedQuery.resultSetMappingAt(1));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"ProjRSMapping", (String)namedQuery.resultSetMappingAt(2));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)3, (int)namedQuery.getResultSetMappingsSize());
        namedQuery.moveResultSetMapping(0, 2);
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"ProjRSMapping", (String)namedQuery.resultSetMappingAt(0));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"EmpRSMapping", (String)namedQuery.resultSetMappingAt(1));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"AddrRSMapping", (String)namedQuery.resultSetMappingAt(2));
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)3, (int)namedQuery.getResultSetMappingsSize());
        this.assertSourceContains("@NamedStoredProcedureQuery(resultSetMappings = { \"ProjRSMapping\", \"EmpRSMapping\", \"AddrRSMapping\" })", cu);
    }

    public void testHints1() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQuery();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)0, (int)namedQuery.getHintsSize());
    }

    public void testHints2() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQuery();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        namedQuery.addHint(0);
        namedQuery.addHint(1);
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)2, (int)namedQuery.getHintsSize());
    }

    public void testHints3() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQueryWithHints();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)2, (int)namedQuery.getHintsSize());
        ListIterator iterator = namedQuery.getHints().iterator();
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"BAR", (String)((QueryHintAnnotation)iterator.next()).getName());
        NamedStoredProcedureQuery2_1AnnotationTests.assertNull((Object)((QueryHintAnnotation)iterator.next()).getName());
    }

    public void testAddHint() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQuery();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        namedQuery.addHint(0).setName("FOO");
        namedQuery.addHint(1);
        namedQuery.addHint(0).setName("BAR");
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(0).getName());
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"FOO", (String)namedQuery.hintAt(1).getName());
        NamedStoredProcedureQuery2_1AnnotationTests.assertNull((Object)namedQuery.hintAt(2).getName());
        this.assertSourceContains("@NamedStoredProcedureQuery(hints = {@QueryHint(name = \"BAR\"),@QueryHint(name = \"FOO\"), @QueryHint})", cu);
    }

    public void testRemoveHint() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQueryWithHints();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        namedQuery.addHint(0).setName("BAZ");
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"BAZ", (String)namedQuery.hintAt(0).getName());
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(1).getName());
        NamedStoredProcedureQuery2_1AnnotationTests.assertNull((Object)namedQuery.hintAt(2).getName());
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)3, (int)namedQuery.getHintsSize());
        namedQuery.removeHint(2);
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"BAZ", (String)namedQuery.hintAt(0).getName());
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(1).getName());
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)2, (int)namedQuery.getHintsSize());
        this.assertSourceContains("@NamedStoredProcedureQuery(hints = {@QueryHint(name = \"BAZ\"), @QueryHint(name = \"BAR\", value = \"FOO\")})", cu);
        namedQuery.removeHint(0);
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(0).getName());
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)1, (int)namedQuery.getHintsSize());
        this.assertSourceContains("@NamedStoredProcedureQuery(hints = @QueryHint(name = \"BAR\", value = \"FOO\"))", cu);
        namedQuery.removeHint(0);
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)0, (int)namedQuery.getHintsSize());
        this.assertSourceDoesNotContain("@NamedStoredProcedureQuery(", cu);
    }

    public void testMoveHint1() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQueryWithHints();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        namedQuery.addHint(0).setName("BAZ");
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"BAZ", (String)namedQuery.hintAt(0).getName());
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(1).getName());
        NamedStoredProcedureQuery2_1AnnotationTests.assertNull((Object)namedQuery.hintAt(2).getName());
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)3, (int)namedQuery.getHintsSize());
        namedQuery.moveHint(2, 0);
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(0).getName());
        NamedStoredProcedureQuery2_1AnnotationTests.assertNull((Object)namedQuery.hintAt(1).getName());
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"BAZ", (String)namedQuery.hintAt(2).getName());
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)3, (int)namedQuery.getHintsSize());
        this.assertSourceContains("@NamedStoredProcedureQuery(hints = {@QueryHint(name = \"BAR\", value = \"FOO\"), @QueryHint, @QueryHint(name = \"BAZ\")})", cu);
    }

    public void testMoveHint2() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQueryWithHints();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        namedQuery.addHint(0).setName("BAZ");
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"BAZ", (String)namedQuery.hintAt(0).getName());
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(1).getName());
        NamedStoredProcedureQuery2_1AnnotationTests.assertNull((Object)namedQuery.hintAt(2).getName());
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)3, (int)namedQuery.getHintsSize());
        namedQuery.moveHint(0, 2);
        NamedStoredProcedureQuery2_1AnnotationTests.assertNull((Object)namedQuery.hintAt(0).getName());
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"BAZ", (String)namedQuery.hintAt(1).getName());
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(2).getName());
        NamedStoredProcedureQuery2_1AnnotationTests.assertEquals((int)3, (int)namedQuery.getHintsSize());
        this.assertSourceContains("@NamedStoredProcedureQuery(hints = {@QueryHint, @QueryHint(name = \"BAZ\"), @QueryHint(name = \"BAR\", value = \"FOO\")})", cu);
    }
}

