/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2_1.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.jpa2_1.resource.java.NamedStoredProcedureQueryAnnotation2_1;
import org.eclipse.jpt.jpa.core.jpa2_1.resource.java.ParameterMode_2_1;
import org.eclipse.jpt.jpa.core.jpa2_1.resource.java.StoredProcedureParameterAnnotation2_1;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2_1.resource.java.JavaResourceModel2_1TestCase;

public class StoredProcedureParameter2_1AnnotationTests
extends JavaResourceModel2_1TestCase {
    public StoredProcedureParameter2_1AnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestNamedStoredProcedureQueryWithParameters() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.NamedStoredProcedureQuery", "javax.persistence.StoredProcedureParameter", "javax.persistence.ParameterMode"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@NamedStoredProcedureQuery(parameters = {@StoredProcedureParameter(name = \"MyParameter\", mode = ParameterMode.IN, type = MyType.class), @StoredProcedureParameter})");
            }
        });
    }

    public void testNamedStoredProcedureQueryWithParameters() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQueryWithParameters();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        StoredProcedureParameter2_1AnnotationTests.assertEquals((int)2, (int)namedQuery.getParametersSize());
        StoredProcedureParameterAnnotation2_1 parameter = namedQuery.parameterAt(0);
        StoredProcedureParameter2_1AnnotationTests.assertEquals((String)"MyParameter", (String)parameter.getName());
        parameter = namedQuery.parameterAt(1);
        StoredProcedureParameter2_1AnnotationTests.assertNull((Object)parameter.getName());
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQueryWithParameters();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        StoredProcedureParameterAnnotation2_1 parameter = namedQuery.parameterAt(0);
        StoredProcedureParameter2_1AnnotationTests.assertEquals((String)"MyParameter", (String)parameter.getName());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQueryWithParameters();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        StoredProcedureParameterAnnotation2_1 parameter = namedQuery.parameterAt(0);
        StoredProcedureParameter2_1AnnotationTests.assertEquals((String)"MyParameter", (String)parameter.getName());
        parameter.setName("foo");
        StoredProcedureParameter2_1AnnotationTests.assertEquals((String)"foo", (String)parameter.getName());
        this.assertSourceContains("@StoredProcedureParameter(name = \"foo\", mode = ParameterMode.IN, type = MyType.class)", cu);
    }

    public void testGetMode() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQueryWithParameters();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        StoredProcedureParameterAnnotation2_1 parameter = namedQuery.parameterAt(0);
        StoredProcedureParameter2_1AnnotationTests.assertEquals((Object)ParameterMode_2_1.IN, (Object)parameter.getMode());
    }

    public void testSetMode() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQueryWithParameters();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        StoredProcedureParameterAnnotation2_1 parameter = namedQuery.parameterAt(0);
        StoredProcedureParameter2_1AnnotationTests.assertEquals((Object)ParameterMode_2_1.IN, (Object)parameter.getMode());
        parameter.setMode(ParameterMode_2_1.INOUT);
        StoredProcedureParameter2_1AnnotationTests.assertEquals((Object)ParameterMode_2_1.INOUT, (Object)parameter.getMode());
        this.assertSourceContains("@StoredProcedureParameter(name = \"MyParameter\", mode = INOUT, type = MyType.class)", cu);
        parameter.setMode(null);
        StoredProcedureParameter2_1AnnotationTests.assertNull((Object)parameter.getMode());
        this.assertSourceDoesNotContain("mode", cu);
        this.assertSourceContains("@StoredProcedureParameter(name = \"MyParameter\", type = MyType.class)", cu);
    }

    public void testGetType() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQueryWithParameters();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        StoredProcedureParameterAnnotation2_1 parameter = namedQuery.parameterAt(0);
        StoredProcedureParameter2_1AnnotationTests.assertEquals((String)"MyType", (String)parameter.getTypeName());
    }

    public void testSetType() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQueryWithParameters();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        StoredProcedureParameterAnnotation2_1 parameter = namedQuery.parameterAt(0);
        StoredProcedureParameter2_1AnnotationTests.assertEquals((String)"MyType", (String)parameter.getTypeName());
        parameter.setTypeName("Foo");
        StoredProcedureParameter2_1AnnotationTests.assertEquals((String)"Foo", (String)parameter.getTypeName());
        this.assertSourceContains("@StoredProcedureParameter(name = \"MyParameter\", mode = ParameterMode.IN, type = Foo.class", cu);
        parameter.setTypeName(null);
        StoredProcedureParameter2_1AnnotationTests.assertNull((Object)parameter.getTypeName());
        this.assertSourceDoesNotContain("type", cu);
        this.assertSourceContains("@StoredProcedureParameter(name = \"MyParameter\", mode = ParameterMode.IN", cu);
    }

    public void testGetFullyQualifiedClass() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQueryWithParameters();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        StoredProcedureParameterAnnotation2_1 parameter = namedQuery.parameterAt(0);
        StoredProcedureParameter2_1AnnotationTests.assertNotNull((Object)parameter.getTypeName());
        StoredProcedureParameter2_1AnnotationTests.assertEquals((String)"MyType", (String)parameter.getFullyQualifiedTypeName());
        parameter.setTypeName("AnnotationTestType");
        StoredProcedureParameter2_1AnnotationTests.assertEquals((String)"test.AnnotationTestType", (String)parameter.getFullyQualifiedTypeName());
        this.assertSourceContains("@StoredProcedureParameter(name = \"MyParameter\", mode = ParameterMode.IN, type = AnnotationTestType.class)", cu);
    }
}

