/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.model.value;

import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.transformer.AbstractTransformer;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.ChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.ChangeListener;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public class TransformationModifiablePropertyValueModelTests
extends TestCase {
    private ModifiablePropertyValueModel<Person> objectHolder;
    PropertyChangeEvent event;
    private ModifiablePropertyValueModel<Person> transformationObjectHolder;
    PropertyChangeEvent transformationEvent;
    private static final Transformer<Person, Person> PARENT_TRANSFORMER = new ParentTransformer();
    private static final Transformer<Person, Person> CHILD_TRANSFORMER = new ChildTransformer();

    public TransformationModifiablePropertyValueModelTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.objectHolder = new SimplePropertyValueModel((Object)new Person("Karen", "Peggy", null));
        this.transformationObjectHolder = new TransformationModifiablePropertyValueModel(this.objectHolder, PARENT_TRANSFORMER, CHILD_TRANSFORMER);
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testValue() {
        ChangeListener listener = this.buildTransformationListener();
        this.transformationObjectHolder.addChangeListener(listener);
        Person person = (Person)((Object)this.objectHolder.getValue());
        TransformationModifiablePropertyValueModelTests.assertEquals((String)"Karen", (String)person.getName());
        Person parent = (Person)((Object)this.transformationObjectHolder.getValue());
        TransformationModifiablePropertyValueModelTests.assertEquals((String)person.getParent().getName(), (String)parent.getName());
        TransformationModifiablePropertyValueModelTests.assertNotSame((Object)((Object)person.getParent()), (Object)this.transformationObjectHolder.getValue());
        TransformationModifiablePropertyValueModelTests.assertEquals((Object)((Object)parent), (Object)this.transformationObjectHolder.getValue());
        Person person1 = new Person("Matt", "Mitch", null);
        this.objectHolder.setValue((Object)person1);
        Person parent2 = (Person)((Object)this.transformationObjectHolder.getValue());
        TransformationModifiablePropertyValueModelTests.assertEquals((String)person1.getParent().getName(), (String)parent2.getName());
        TransformationModifiablePropertyValueModelTests.assertNotSame((Object)((Object)person1.getParent()), (Object)this.transformationObjectHolder.getValue());
        TransformationModifiablePropertyValueModelTests.assertEquals((Object)((Object)parent2), (Object)this.transformationObjectHolder.getValue());
        this.objectHolder.setValue(null);
        TransformationModifiablePropertyValueModelTests.assertNull((Object)this.objectHolder.getValue());
        TransformationModifiablePropertyValueModelTests.assertNull((Object)this.transformationObjectHolder.getValue());
        Person person3 = new Person("Karen", "Peggy", null);
        this.objectHolder.setValue((Object)person3);
        TransformationModifiablePropertyValueModelTests.assertEquals((String)"Karen", (String)person3.getName());
        Person parent3 = (Person)((Object)this.transformationObjectHolder.getValue());
        TransformationModifiablePropertyValueModelTests.assertEquals((String)person3.getParent().getName(), (String)parent3.getName());
        TransformationModifiablePropertyValueModelTests.assertNotSame((Object)((Object)person3.getParent()), (Object)this.transformationObjectHolder.getValue());
        TransformationModifiablePropertyValueModelTests.assertEquals((Object)((Object)parent3), (Object)this.transformationObjectHolder.getValue());
    }

    public void testSetValue() {
        ChangeListener listener = this.buildTransformationListener();
        this.transformationObjectHolder.addChangeListener(listener);
        Person person = new Person("Chris", "Noel", null);
        this.transformationObjectHolder.setValue((Object)person.getParent());
        TransformationModifiablePropertyValueModelTests.assertEquals((Object)((Object)person), (Object)this.objectHolder.getValue());
        TransformationModifiablePropertyValueModelTests.assertEquals((String)person.getParent().getName(), (String)((Person)((Object)this.transformationObjectHolder.getValue())).getName());
        TransformationModifiablePropertyValueModelTests.assertNotSame((Object)((Object)person.getParent()), (Object)this.transformationObjectHolder.getValue());
        Person person2 = new Person("Jon", "Elizabeth", null);
        this.transformationObjectHolder.setValue((Object)person2.getParent());
        TransformationModifiablePropertyValueModelTests.assertEquals((Object)((Object)person2), (Object)this.objectHolder.getValue());
        TransformationModifiablePropertyValueModelTests.assertEquals((String)person2.getParent().getName(), (String)((Person)((Object)this.transformationObjectHolder.getValue())).getName());
        TransformationModifiablePropertyValueModelTests.assertNotSame((Object)((Object)person2.getParent()), (Object)this.transformationObjectHolder.getValue());
        this.transformationObjectHolder.setValue(null);
        TransformationModifiablePropertyValueModelTests.assertNull((Object)this.objectHolder.getValue());
        TransformationModifiablePropertyValueModelTests.assertNull((Object)this.transformationObjectHolder.getValue());
        this.transformationObjectHolder.setValue((Object)person.getParent());
        TransformationModifiablePropertyValueModelTests.assertEquals((Object)((Object)person), (Object)this.objectHolder.getValue());
        TransformationModifiablePropertyValueModelTests.assertEquals((String)person.getParent().getName(), (String)((Person)((Object)this.transformationObjectHolder.getValue())).getName());
        TransformationModifiablePropertyValueModelTests.assertNotSame((Object)((Object)person.getParent()), (Object)this.transformationObjectHolder.getValue());
    }

    public void testLazyListening() {
        TransformationModifiablePropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.objectHolder).hasNoPropertyChangeListeners("value"));
        ChangeListener listener = this.buildTransformationListener();
        this.transformationObjectHolder.addChangeListener(listener);
        TransformationModifiablePropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.objectHolder).hasAnyPropertyChangeListeners("value"));
        this.transformationObjectHolder.removeChangeListener(listener);
        TransformationModifiablePropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.objectHolder).hasNoPropertyChangeListeners("value"));
        this.transformationObjectHolder.addPropertyChangeListener("value", (PropertyChangeListener)listener);
        TransformationModifiablePropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.objectHolder).hasAnyPropertyChangeListeners("value"));
        this.transformationObjectHolder.removePropertyChangeListener("value", (PropertyChangeListener)listener);
        TransformationModifiablePropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.objectHolder).hasNoPropertyChangeListeners("value"));
    }

    public void testPropertyChange1() {
        this.objectHolder.addChangeListener(this.buildListener());
        this.transformationObjectHolder.addChangeListener(this.buildTransformationListener());
        this.verifyPropertyChanges();
    }

    public void testPropertyChange2() {
        this.objectHolder.addPropertyChangeListener("value", (PropertyChangeListener)this.buildListener());
        this.transformationObjectHolder.addPropertyChangeListener("value", (PropertyChangeListener)this.buildTransformationListener());
        this.verifyPropertyChanges();
    }

    private void verifyPropertyChanges() {
        this.event = null;
        this.transformationEvent = null;
        Person oldPerson = (Person)((Object)this.objectHolder.getValue());
        Person oldParent = (Person)((Object)this.transformationObjectHolder.getValue());
        Person newPerson = new Person("Karen", "Peggy", null);
        this.objectHolder.setValue((Object)newPerson);
        Person newParent = (Person)((Object)this.transformationObjectHolder.getValue());
        this.verifyEvent(this.event, this.objectHolder, (Object)oldPerson, (Object)newPerson);
        this.verifyEvent(this.transformationEvent, this.transformationObjectHolder, (Object)oldParent, (Object)newParent);
    }

    private ChangeListener buildListener() {
        return new ChangeAdapter(){

            public void propertyChanged(PropertyChangeEvent e) {
                TransformationModifiablePropertyValueModelTests.this.event = e;
            }
        };
    }

    private ChangeListener buildTransformationListener() {
        return new ChangeAdapter(){

            public void propertyChanged(PropertyChangeEvent e) {
                TransformationModifiablePropertyValueModelTests.this.transformationEvent = e;
            }
        };
    }

    private void verifyEvent(PropertyChangeEvent e, Object source, Object oldValue, Object newValue) {
        TransformationModifiablePropertyValueModelTests.assertEquals((Object)source, (Object)e.getSource());
        TransformationModifiablePropertyValueModelTests.assertEquals((String)"value", (String)e.getPropertyName());
        TransformationModifiablePropertyValueModelTests.assertEquals((Object)oldValue, (Object)e.getOldValue());
        TransformationModifiablePropertyValueModelTests.assertEquals((Object)newValue, (Object)e.getNewValue());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ChildTransformer
    extends AbstractTransformer<Person, Person> {
        ChildTransformer() {
        }

        public Person transform_(Person p) {
            return p.getChild();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ParentTransformer
    extends AbstractTransformer<Person, Person> {
        ParentTransformer() {
        }

        public Person transform_(Person p) {
            return p.getParent();
        }
    }

    class Person
    extends AbstractModel {
        private String name;
        public static final String NAME_PROPERTY = "name";
        private String parentName;
        public static final String PARENT_NAME_PROPERTY = "parentName";
        private Person child;

        public Person(String name, String parentName, Person child) {
            this.name = name;
            this.parentName = parentName;
            this.child = child;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String newName) {
            String oldName = this.name;
            this.name = newName;
            this.firePropertyChanged(NAME_PROPERTY, oldName, newName);
        }

        public Person getParent() {
            return new Person(this.parentName, null, this);
        }

        public String getParentName() {
            return this.parentName;
        }

        public void setParentName(String newParentName) {
            String oldParentName = this.parentName;
            this.parentName = newParentName;
            this.firePropertyChanged(PARENT_NAME_PROPERTY, oldParentName, newParentName);
        }

        public Person getChild() {
            return this.child;
        }
    }
}

