/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.persistence;

import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnitProperties;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkLogger;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkLogging;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkLoggingLevel;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.persistence.EclipseLinkPersistenceUnitTestCase;

public class LoggingAdapterTests
extends EclipseLinkPersistenceUnitTestCase {
    private EclipseLinkLogging logging;
    public static final String LEVEL_KEY = "eclipselink.logging.level";
    public static final EclipseLinkLoggingLevel LEVEL_TEST_VALUE = EclipseLinkLoggingLevel.fine;
    public static final EclipseLinkLoggingLevel LEVEL_TEST_VALUE_2 = EclipseLinkLoggingLevel.finest;
    public static final String TIMESTAMP_KEY = "eclipselink.logging.timestamp";
    public static final Boolean TIMESTAMP_TEST_VALUE = false;
    public static final Boolean TIMESTAMP_TEST_VALUE_2 = TIMESTAMP_TEST_VALUE == false;
    public static final String THREAD_KEY = "eclipselink.logging.thread";
    public static final Boolean THREAD_TEST_VALUE = false;
    public static final Boolean THREAD_TEST_VALUE_2 = THREAD_TEST_VALUE == false;
    public static final String SESSION_KEY = "eclipselink.logging.session";
    public static final Boolean SESSION_TEST_VALUE = false;
    public static final Boolean SESSION_TEST_VALUE_2 = SESSION_TEST_VALUE == false;
    public static final String EXCEPTIONS_KEY = "eclipselink.logging.exceptions";
    public static final Boolean EXCEPTIONS_TEST_VALUE = false;
    public static final Boolean EXCEPTIONS_TEST_VALUE_2 = EXCEPTIONS_TEST_VALUE == false;
    private static final String LOG_FILE_LOCATION_KEY = "eclipselink.logging.file";
    private static final String LOG_FILE_LOCATION_TEST_VALUE = "C:/temp";
    private static final String LOG_FILE_LOCATION_TEST_VALUE_2 = "C:/tmp";
    private static final String LOGGER_KEY = "eclipselink.logging.logger";
    private static final EclipseLinkLogger LOGGER_TEST_VALUE = EclipseLinkLogger.java_logger;
    private static final String LOGGER_TEST_VALUE_2 = "custom.logger.test";

    public LoggingAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.logging = this.subject.getLogging();
        PropertyChangeListener propertyChangeListener = this.buildPropertyChangeListener();
        this.logging.addPropertyChangeListener("level", propertyChangeListener);
        this.logging.addPropertyChangeListener("timestamp", propertyChangeListener);
        this.logging.addPropertyChangeListener("thread", propertyChangeListener);
        this.logging.addPropertyChangeListener("session", propertyChangeListener);
        this.logging.addPropertyChangeListener("exceptions", propertyChangeListener);
        this.logging.addPropertyChangeListener("logFileLocation", propertyChangeListener);
        this.logging.addPropertyChangeListener("logger", propertyChangeListener);
        this.clearEvent();
    }

    protected void populatePu() {
        this.modelPropertiesSizeOriginal = 7;
        this.propertiesTotal = this.modelPropertiesSizeOriginal + 4;
        this.modelPropertiesSize = this.modelPropertiesSizeOriginal;
        this.persistenceUnitSetProperty("misc.property.1", "value.1");
        this.persistenceUnitSetProperty(TIMESTAMP_KEY, TIMESTAMP_TEST_VALUE.toString());
        this.persistenceUnitSetProperty("misc.property.2", "value.2");
        this.persistenceUnitSetProperty(LEVEL_KEY, LEVEL_TEST_VALUE);
        this.persistenceUnitSetProperty("misc.property.3", "value.3");
        this.persistenceUnitSetProperty(THREAD_KEY, THREAD_TEST_VALUE.toString());
        this.persistenceUnitSetProperty(SESSION_KEY, SESSION_TEST_VALUE.toString());
        this.persistenceUnitSetProperty(EXCEPTIONS_KEY, EXCEPTIONS_TEST_VALUE.toString());
        this.persistenceUnitSetProperty("misc.property.4", "value.4");
        this.persistenceUnitSetProperty(LOG_FILE_LOCATION_KEY, LOG_FILE_LOCATION_TEST_VALUE);
        this.persistenceUnitSetProperty(LOGGER_KEY, LOGGER_TEST_VALUE);
    }

    public void testSetLevel() throws Exception {
        this.verifyModelInitialized(LEVEL_KEY, LEVEL_TEST_VALUE);
        this.verifySetProperty(LEVEL_KEY, LEVEL_TEST_VALUE, LEVEL_TEST_VALUE_2);
    }

    public void testAddRemoveLevel() throws Exception {
        this.verifyAddRemoveProperty(LEVEL_KEY, LEVEL_TEST_VALUE, LEVEL_TEST_VALUE_2);
    }

    public void testSetTimestamp() throws Exception {
        this.verifyModelInitialized(TIMESTAMP_KEY, TIMESTAMP_TEST_VALUE);
        this.verifySetProperty(TIMESTAMP_KEY, TIMESTAMP_TEST_VALUE, TIMESTAMP_TEST_VALUE_2);
    }

    public void testAddRemoveTimestamp() throws Exception {
        this.verifyAddRemoveProperty(TIMESTAMP_KEY, TIMESTAMP_TEST_VALUE, TIMESTAMP_TEST_VALUE_2);
    }

    public void testSetThread() throws Exception {
        this.verifyModelInitialized(THREAD_KEY, THREAD_TEST_VALUE);
        this.verifySetProperty(THREAD_KEY, THREAD_TEST_VALUE, THREAD_TEST_VALUE_2);
    }

    public void testAddRemoveThread() throws Exception {
        this.verifyAddRemoveProperty(THREAD_KEY, THREAD_TEST_VALUE, THREAD_TEST_VALUE_2);
    }

    public void testSetSession() throws Exception {
        this.verifyModelInitialized(SESSION_KEY, SESSION_TEST_VALUE);
        this.verifySetProperty(SESSION_KEY, SESSION_TEST_VALUE, SESSION_TEST_VALUE_2);
    }

    public void testAddRemoveSession() throws Exception {
        this.verifyAddRemoveProperty(SESSION_KEY, SESSION_TEST_VALUE, SESSION_TEST_VALUE_2);
    }

    public void testSetExceptions() throws Exception {
        this.verifyModelInitialized(EXCEPTIONS_KEY, EXCEPTIONS_TEST_VALUE);
        this.verifySetProperty(EXCEPTIONS_KEY, EXCEPTIONS_TEST_VALUE, EXCEPTIONS_TEST_VALUE_2);
    }

    public void testAddRemoveExceptions() throws Exception {
        this.verifyAddRemoveProperty(EXCEPTIONS_KEY, EXCEPTIONS_TEST_VALUE, EXCEPTIONS_TEST_VALUE_2);
    }

    public void testSetLogFileLocation() throws Exception {
        this.verifyModelInitialized(LOG_FILE_LOCATION_KEY, LOG_FILE_LOCATION_TEST_VALUE);
        this.verifySetProperty(LOG_FILE_LOCATION_KEY, LOG_FILE_LOCATION_TEST_VALUE, LOG_FILE_LOCATION_TEST_VALUE_2);
    }

    public void testAddRemoveLogFileLocation() throws Exception {
        this.verifyAddRemoveProperty(LOG_FILE_LOCATION_KEY, LOG_FILE_LOCATION_TEST_VALUE, LOG_FILE_LOCATION_TEST_VALUE_2);
    }

    public void testSetEmptyFileLocation() throws Exception {
        String puKey = LOG_FILE_LOCATION_KEY;
        PersistenceUnit.Property property = this.getPersistenceUnit().getProperty(puKey);
        String propertyName = this.getModel().propertyIdOf(property);
        this.verifyPuHasProperty(puKey, "persistenceUnit.properties doesn't contains: ");
        this.setProperty(propertyName, "");
        this.verifyPuHasNotProperty(puKey, "Property was not deleted");
        this.verifyPutProperty(propertyName, null);
        LoggingAdapterTests.assertNull((Object)this.getPersistenceUnit().getProperty(puKey));
    }

    public void testSetLogger() throws Exception {
        this.verifyModelInitialized(LOGGER_KEY, this.getPropertyStringValueOf(LOGGER_TEST_VALUE));
        this.verifySetProperty(LOGGER_KEY, LOGGER_TEST_VALUE, LOGGER_TEST_VALUE_2);
        this.verifySetLogger(LOGGER_KEY, LOGGER_TEST_VALUE, LOGGER_TEST_VALUE_2);
    }

    public void testAddRemoveLogger() throws Exception {
        this.verifyAddRemoveProperty(LOGGER_KEY, LOGGER_TEST_VALUE, LOGGER_TEST_VALUE_2);
    }

    protected void verifySetLogger(String elKey, Object testValue1, Object testValue2) throws Exception {
        PersistenceUnit.Property property = this.getPersistenceUnit().getProperty(elKey);
        String propertyName = this.getModel().propertyIdOf(property);
        this.clearEvent();
        this.setProperty(propertyName, testValue2);
        this.verifyPutProperty(propertyName, testValue2);
        this.clearEvent();
        this.logging.setLogger(null);
        LoggingAdapterTests.assertNull((Object)this.getPersistenceUnit().getProperty(elKey));
        this.verifyPutProperty(propertyName, null);
        this.clearEvent();
        this.setProperty(propertyName, testValue1.toString());
        LoggingAdapterTests.assertNotNull((Object)this.getPersistenceUnit().getProperty(elKey));
        this.verifyPutProperty(propertyName, this.getPropertyStringValueOf(testValue1));
        this.clearEvent();
        this.logging.setLogger(null);
        LoggingAdapterTests.assertNull((Object)this.getPersistenceUnit().getProperty(elKey));
        this.verifyPutProperty(propertyName, null);
    }

    protected void setProperty(String propertyName, Object newValue) throws Exception {
        if (propertyName.equals("level")) {
            this.logging.setLevel((EclipseLinkLoggingLevel)newValue);
        } else if (propertyName.equals("timestamp")) {
            this.logging.setTimestamp((Boolean)newValue);
        } else if (propertyName.equals("thread")) {
            this.logging.setThread((Boolean)newValue);
        } else if (propertyName.equals("session")) {
            this.logging.setSession((Boolean)newValue);
        } else if (propertyName.equals("exceptions")) {
            this.logging.setExceptions((Boolean)newValue);
        } else if (propertyName.equals("logFileLocation")) {
            this.logging.setLogFileLocation((String)newValue);
        } else if (propertyName.equals("logger")) {
            if (newValue.getClass().isEnum()) {
                this.logging.setLogger((EclipseLinkLogger)newValue);
            } else {
                this.logging.setLogger((String)newValue);
            }
        } else {
            this.throwMissingDefinition("setProperty", propertyName);
        }
    }

    protected Object getProperty(String propertyName) throws NoSuchFieldException {
        Object modelValue = null;
        if (propertyName.equals("level")) {
            modelValue = this.logging.getLevel();
        } else if (propertyName.equals("timestamp")) {
            modelValue = this.logging.getTimestamp();
        } else if (propertyName.equals("thread")) {
            modelValue = this.logging.getThread();
        } else if (propertyName.equals("session")) {
            modelValue = this.logging.getSession();
        } else if (propertyName.equals("exceptions")) {
            modelValue = this.logging.getExceptions();
        } else if (propertyName.equals("logFileLocation")) {
            modelValue = this.logging.getLogFileLocation();
        } else if (propertyName.equals("logger")) {
            modelValue = this.logging.getLogger();
        } else {
            this.throwMissingDefinition("getProperty", propertyName);
        }
        return modelValue;
    }

    protected void verifyPutProperty(String propertyName, Object expectedValue) throws Exception {
        Object expectedValue_ = expectedValue;
        if (propertyName.equals("logger")) {
            expectedValue_ = expectedValue != null && expectedValue.getClass().isEnum() ? this.getPropertyStringValueOf(LOGGER_TEST_VALUE) : expectedValue;
        }
        super.verifyPutProperty(propertyName, expectedValue_);
    }

    protected PersistenceUnitProperties getModel() {
        return this.logging;
    }
}

