/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.ConvertAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.resource.java.EclipseLinkJavaResourceModelTestCase;

public class ConvertAnnotationTests
extends EclipseLinkJavaResourceModelTestCase {
    public ConvertAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestConvert() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"org.eclipse.persistence.annotations.Convert"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Convert");
            }
        });
    }

    private ICompilationUnit createTestConverterWithValue() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"org.eclipse.persistence.annotations.Convert"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Convert(value=\"myConverter\")");
            }
        });
    }

    public void testConvertAnnotation() throws Exception {
        ICompilationUnit cu = this.createTestConvert();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ConvertAnnotationTests.assertNotNull((Object)resourceField.getAnnotation("org.eclipse.persistence.annotations.Convert"));
        resourceField.removeAnnotation("org.eclipse.persistence.annotations.Convert");
        ConvertAnnotationTests.assertNull((Object)resourceField.getAnnotation("org.eclipse.persistence.annotations.Convert"));
        resourceField.addAnnotation("org.eclipse.persistence.annotations.Convert");
        ConvertAnnotationTests.assertNotNull((Object)resourceField.getAnnotation("org.eclipse.persistence.annotations.Convert"));
    }

    public void testGetValue() throws Exception {
        ICompilationUnit cu = this.createTestConverterWithValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ConvertAnnotation convert = (ConvertAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.Convert");
        ConvertAnnotationTests.assertEquals((String)"myConverter", (String)convert.getValue());
    }

    public void testSetValue() throws Exception {
        ICompilationUnit cu = this.createTestConverterWithValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ConvertAnnotation convert = (ConvertAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.Convert");
        ConvertAnnotationTests.assertEquals((String)"myConverter", (String)convert.getValue());
        convert.setValue("Bar");
        ConvertAnnotationTests.assertEquals((String)"Bar", (String)convert.getValue());
        this.assertSourceContains("@Convert(value=\"Bar\")", cu);
    }

    public void testSetValueNull() throws Exception {
        ICompilationUnit cu = this.createTestConverterWithValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ConvertAnnotation convert = (ConvertAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.Convert");
        ConvertAnnotationTests.assertEquals((String)"myConverter", (String)convert.getValue());
        convert.setValue(null);
        ConvertAnnotationTests.assertNull((Object)convert.getValue());
        this.assertSourceContains("@Convert", cu);
        this.assertSourceDoesNotContain("value", cu);
    }
}

