/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.resource.java.JaxbJavaResourceModelTestCase;

public class XmlElementAnnotationTests
extends JaxbJavaResourceModelTestCase {
    private static final String XML_ELEMENT_NAME = "elementName";
    private static final String XML_ELEMENT_NAMESPACE = "XmlElementNamespace";
    private static final String XML_ELEMENT_DEFAULT_VALUE = "myDefaultValue";
    private static final String XML_ELEMENT_TYPE = "String";

    public XmlElementAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestXmlElement() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlElement"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlElement");
            }
        });
    }

    private ICompilationUnit createTestXmlElementWithName() throws Exception {
        return this.createTestXmlElementWithStringElement("name", XML_ELEMENT_NAME);
    }

    private ICompilationUnit createTestXmlElementWithNamespace() throws Exception {
        return this.createTestXmlElementWithStringElement("namespace", XML_ELEMENT_NAMESPACE);
    }

    private ICompilationUnit createTestXmlElementWithDefaultValue() throws Exception {
        return this.createTestXmlElementWithStringElement("defaultValue", XML_ELEMENT_DEFAULT_VALUE);
    }

    private ICompilationUnit createTestXmlElementWithStringElement(final String element, final String value) throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlElement"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlElement(" + element + " = \"" + value + "\")");
            }
        });
    }

    private ICompilationUnit createTestXmlElementWithBooleanElement(final String booleanElement) throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlElement"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlElement(" + booleanElement + " = true)");
            }
        });
    }

    private ICompilationUnit createTestXmlElementWithType() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlElement"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlElement(type = String.class)");
            }
        });
    }

    public void testGetNull() throws Exception {
        ICompilationUnit cu = this.createTestXmlElement();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementAnnotation xmlElementAnnotation = (XmlElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement");
        XmlElementAnnotationTests.assertTrue((xmlElementAnnotation != null ? 1 : 0) != 0);
        XmlElementAnnotationTests.assertNull((Object)xmlElementAnnotation.getName());
        XmlElementAnnotationTests.assertNull((Object)xmlElementAnnotation.getNamespace());
        XmlElementAnnotationTests.assertNull((Object)xmlElementAnnotation.getDefaultValue());
        XmlElementAnnotationTests.assertNull((Object)xmlElementAnnotation.getNillable());
        XmlElementAnnotationTests.assertNull((Object)xmlElementAnnotation.getRequired());
        XmlElementAnnotationTests.assertNull((Object)xmlElementAnnotation.getType());
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementAnnotation xmlElementAnnotation = (XmlElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement");
        XmlElementAnnotationTests.assertTrue((xmlElementAnnotation != null ? 1 : 0) != 0);
        XmlElementAnnotationTests.assertEquals((String)XML_ELEMENT_NAME, (String)xmlElementAnnotation.getName());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestXmlElement();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementAnnotation xmlElementAnnotation = (XmlElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement");
        XmlElementAnnotationTests.assertNull((Object)xmlElementAnnotation.getName());
        xmlElementAnnotation.setName(XML_ELEMENT_NAME);
        XmlElementAnnotationTests.assertEquals((String)XML_ELEMENT_NAME, (String)xmlElementAnnotation.getName());
        this.assertSourceContains("@XmlElement(name = \"elementName\")", cu);
        xmlElementAnnotation.setName(null);
        XmlElementAnnotationTests.assertNull((Object)xmlElementAnnotation.getName());
        this.assertSourceContains("@XmlElement", cu);
        this.assertSourceDoesNotContain("@XmlElement(name = \"elementName\")", cu);
    }

    public void testGetNamespace() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementWithNamespace();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementAnnotation xmlElementAnnotation = (XmlElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement");
        XmlElementAnnotationTests.assertTrue((xmlElementAnnotation != null ? 1 : 0) != 0);
        XmlElementAnnotationTests.assertEquals((String)XML_ELEMENT_NAMESPACE, (String)xmlElementAnnotation.getNamespace());
    }

    public void testSetNamespace() throws Exception {
        ICompilationUnit cu = this.createTestXmlElement();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementAnnotation xmlElementAnnotation = (XmlElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement");
        XmlElementAnnotationTests.assertNull((Object)xmlElementAnnotation.getNamespace());
        xmlElementAnnotation.setNamespace(XML_ELEMENT_NAMESPACE);
        XmlElementAnnotationTests.assertEquals((String)XML_ELEMENT_NAMESPACE, (String)xmlElementAnnotation.getNamespace());
        this.assertSourceContains("@XmlElement(namespace = \"XmlElementNamespace\")", cu);
        xmlElementAnnotation.setNamespace(null);
        XmlElementAnnotationTests.assertNull((Object)xmlElementAnnotation.getNamespace());
        this.assertSourceContains("@XmlElement", cu);
        this.assertSourceDoesNotContain("@XmlElement(namespace = \"XmlElementNamespace\")", cu);
    }

    public void testGetDefaultValue() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementWithDefaultValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementAnnotation xmlElementAnnotation = (XmlElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement");
        XmlElementAnnotationTests.assertTrue((xmlElementAnnotation != null ? 1 : 0) != 0);
        XmlElementAnnotationTests.assertEquals((String)XML_ELEMENT_DEFAULT_VALUE, (String)xmlElementAnnotation.getDefaultValue());
    }

    public void testSetDefaultValue() throws Exception {
        ICompilationUnit cu = this.createTestXmlElement();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementAnnotation xmlElementAnnotation = (XmlElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement");
        XmlElementAnnotationTests.assertNull((Object)xmlElementAnnotation.getDefaultValue());
        xmlElementAnnotation.setDefaultValue(XML_ELEMENT_DEFAULT_VALUE);
        XmlElementAnnotationTests.assertEquals((String)XML_ELEMENT_DEFAULT_VALUE, (String)xmlElementAnnotation.getDefaultValue());
        this.assertSourceContains("@XmlElement(defaultValue = \"myDefaultValue\")", cu);
        xmlElementAnnotation.setDefaultValue(null);
        XmlElementAnnotationTests.assertNull((Object)xmlElementAnnotation.getDefaultValue());
        this.assertSourceContains("@XmlElement", cu);
        this.assertSourceDoesNotContain("@XmlElement(defaultValue = \"myDefaultValue\")", cu);
    }

    public void testGetNillable() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementWithBooleanElement("nillable");
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementAnnotation xmlElementAnnotation = (XmlElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement");
        XmlElementAnnotationTests.assertEquals((Object)Boolean.TRUE, (Object)xmlElementAnnotation.getNillable());
    }

    public void testSetNillable() throws Exception {
        ICompilationUnit cu = this.createTestXmlElement();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementAnnotation xmlElementAnnotation = (XmlElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement");
        XmlElementAnnotationTests.assertNotNull((Object)xmlElementAnnotation);
        XmlElementAnnotationTests.assertNull((Object)xmlElementAnnotation.getNillable());
        xmlElementAnnotation.setNillable(Boolean.FALSE);
        XmlElementAnnotationTests.assertEquals((Object)Boolean.FALSE, (Object)xmlElementAnnotation.getNillable());
        this.assertSourceContains("@XmlElement(nillable = false)", cu);
        xmlElementAnnotation.setNillable(null);
        this.assertSourceContains("@XmlElement", cu);
        this.assertSourceDoesNotContain("nillable", cu);
    }

    public void testGetRequired() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementWithBooleanElement("required");
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementAnnotation xmlElementAnnotation = (XmlElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement");
        XmlElementAnnotationTests.assertEquals((Object)Boolean.TRUE, (Object)xmlElementAnnotation.getRequired());
    }

    public void testSetRequired() throws Exception {
        ICompilationUnit cu = this.createTestXmlElement();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementAnnotation xmlElementAnnotation = (XmlElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement");
        XmlElementAnnotationTests.assertNotNull((Object)xmlElementAnnotation);
        XmlElementAnnotationTests.assertNull((Object)xmlElementAnnotation.getRequired());
        xmlElementAnnotation.setRequired(Boolean.FALSE);
        XmlElementAnnotationTests.assertEquals((Object)Boolean.FALSE, (Object)xmlElementAnnotation.getRequired());
        this.assertSourceContains("@XmlElement(required = false)", cu);
        xmlElementAnnotation.setRequired(null);
        this.assertSourceContains("@XmlElement", cu);
        this.assertSourceDoesNotContain("required", cu);
    }

    public void testGetType() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementWithType();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementAnnotation xmlElementAnnotation = (XmlElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement");
        XmlElementAnnotationTests.assertTrue((xmlElementAnnotation != null ? 1 : 0) != 0);
        XmlElementAnnotationTests.assertEquals((String)XML_ELEMENT_TYPE, (String)xmlElementAnnotation.getType());
        XmlElementAnnotationTests.assertEquals((String)"java.lang.String", (String)xmlElementAnnotation.getFullyQualifiedTypeName());
    }

    public void testSetType() throws Exception {
        ICompilationUnit cu = this.createTestXmlElement();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementAnnotation xmlElementAnnotation = (XmlElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement");
        XmlElementAnnotationTests.assertNull((Object)xmlElementAnnotation.getType());
        xmlElementAnnotation.setType(XML_ELEMENT_TYPE);
        XmlElementAnnotationTests.assertEquals((String)XML_ELEMENT_TYPE, (String)xmlElementAnnotation.getType());
        this.assertSourceContains("@XmlElement(type = String.class", cu);
        xmlElementAnnotation.setType(null);
        XmlElementAnnotationTests.assertNull((Object)xmlElementAnnotation.getType());
        this.assertSourceContains("@XmlElement", cu);
        this.assertSourceDoesNotContain("@XmlElement(type = String.class", cu);
    }
}

