/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementsAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.resource.java.JaxbJavaResourceModelTestCase;

public class XmlElementsAnnotationTests
extends JaxbJavaResourceModelTestCase {
    private static final String XML_ELEMENT_NAME = "elementName";
    private static final String XML_ELEMENT_NAMESPACE = "XmlElementNamespace";
    private static final String XML_ELEMENT_DEFAULT_VALUE = "myDefaultValue";
    private static final String XML_ELEMENT_TYPE = "String";

    public XmlElementsAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestXmlElement() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlElements", "javax.xml.bind.annotation.XmlElement"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlElements(@XmlElement)");
            }
        });
    }

    private ICompilationUnit createTestXmlElementWithName() throws Exception {
        return this.createTestXmlElementWithStringElement("name", XML_ELEMENT_NAME);
    }

    private ICompilationUnit createTestXmlElementWithNamespace() throws Exception {
        return this.createTestXmlElementWithStringElement("namespace", XML_ELEMENT_NAMESPACE);
    }

    private ICompilationUnit createTestXmlElementWithDefaultValue() throws Exception {
        return this.createTestXmlElementWithStringElement("defaultValue", XML_ELEMENT_DEFAULT_VALUE);
    }

    private ICompilationUnit createTestXmlElementWithStringElement(final String element, final String value) throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlElements", "javax.xml.bind.annotation.XmlElement"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlElements(@XmlElement(" + element + " = \"" + value + "\"))");
            }
        });
    }

    private ICompilationUnit createTestXmlElementWithBooleanElement(final String booleanElement) throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlElements", "javax.xml.bind.annotation.XmlElement"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlElements(@XmlElement(" + booleanElement + " = true))");
            }
        });
    }

    private ICompilationUnit createTestXmlElementWithType() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlElements", "javax.xml.bind.annotation.XmlElement"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlElements(@XmlElement(type = String.class))");
            }
        });
    }

    private XmlElementAnnotation getXmlElementAnnotation(JavaResourceAttribute resourceAttribute) {
        XmlElementsAnnotation annotation = (XmlElementsAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElements");
        return annotation.xmlElementAt(0);
    }

    private XmlElementAnnotation addXmlElementAnnotation(int index, JavaResourceAttribute resourceAttribute) {
        XmlElementsAnnotation annotation = (XmlElementsAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElements");
        return annotation.addXmlElement(index);
    }

    private void removeXmlElementAnnotation(int index, JavaResourceAttribute resourceAttribute) {
        XmlElementsAnnotation annotation = (XmlElementsAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElements");
        annotation.removeXmlElement(index);
    }

    public void testGetNull() throws Exception {
        ICompilationUnit cu = this.createTestXmlElement();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementAnnotation xmlElementAnnotation = this.getXmlElementAnnotation((JavaResourceAttribute)resourceAttribute);
        XmlElementsAnnotationTests.assertTrue((xmlElementAnnotation != null ? 1 : 0) != 0);
        XmlElementsAnnotationTests.assertNull((Object)xmlElementAnnotation.getName());
        XmlElementsAnnotationTests.assertNull((Object)xmlElementAnnotation.getNamespace());
        XmlElementsAnnotationTests.assertNull((Object)xmlElementAnnotation.getDefaultValue());
        XmlElementsAnnotationTests.assertNull((Object)xmlElementAnnotation.getNillable());
        XmlElementsAnnotationTests.assertNull((Object)xmlElementAnnotation.getRequired());
        XmlElementsAnnotationTests.assertNull((Object)xmlElementAnnotation.getType());
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementAnnotation xmlElementAnnotation = this.getXmlElementAnnotation((JavaResourceAttribute)resourceAttribute);
        XmlElementsAnnotationTests.assertTrue((xmlElementAnnotation != null ? 1 : 0) != 0);
        XmlElementsAnnotationTests.assertEquals((String)XML_ELEMENT_NAME, (String)xmlElementAnnotation.getName());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestXmlElement();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementAnnotation xmlElementAnnotation = this.getXmlElementAnnotation((JavaResourceAttribute)resourceAttribute);
        XmlElementsAnnotationTests.assertNull((Object)xmlElementAnnotation.getName());
        xmlElementAnnotation.setName(XML_ELEMENT_NAME);
        XmlElementsAnnotationTests.assertEquals((String)XML_ELEMENT_NAME, (String)xmlElementAnnotation.getName());
        this.assertSourceContains("@XmlElement(name = \"elementName\")", cu);
        xmlElementAnnotation.setName(null);
        XmlElementsAnnotationTests.assertNull((Object)xmlElementAnnotation.getName());
        this.assertSourceContains("@XmlElement", cu);
        this.assertSourceDoesNotContain("@XmlElement(name = \"elementName\")", cu);
    }

    public void testGetNamespace() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementWithNamespace();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementAnnotation xmlElementAnnotation = this.getXmlElementAnnotation((JavaResourceAttribute)resourceAttribute);
        XmlElementsAnnotationTests.assertTrue((xmlElementAnnotation != null ? 1 : 0) != 0);
        XmlElementsAnnotationTests.assertEquals((String)XML_ELEMENT_NAMESPACE, (String)xmlElementAnnotation.getNamespace());
    }

    public void testSetNamespace() throws Exception {
        ICompilationUnit cu = this.createTestXmlElement();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementAnnotation xmlElementAnnotation = this.getXmlElementAnnotation((JavaResourceAttribute)resourceAttribute);
        XmlElementsAnnotationTests.assertNull((Object)xmlElementAnnotation.getNamespace());
        xmlElementAnnotation.setNamespace(XML_ELEMENT_NAMESPACE);
        XmlElementsAnnotationTests.assertEquals((String)XML_ELEMENT_NAMESPACE, (String)xmlElementAnnotation.getNamespace());
        this.assertSourceContains("@XmlElement(namespace = \"XmlElementNamespace\")", cu);
        xmlElementAnnotation.setNamespace(null);
        XmlElementsAnnotationTests.assertNull((Object)xmlElementAnnotation.getNamespace());
        this.assertSourceContains("@XmlElement", cu);
        this.assertSourceDoesNotContain("@XmlElement(namespace = \"XmlElementNamespace\")", cu);
    }

    public void testGetDefaultValue() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementWithDefaultValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementAnnotation xmlElementAnnotation = this.getXmlElementAnnotation((JavaResourceAttribute)resourceAttribute);
        XmlElementsAnnotationTests.assertTrue((xmlElementAnnotation != null ? 1 : 0) != 0);
        XmlElementsAnnotationTests.assertEquals((String)XML_ELEMENT_DEFAULT_VALUE, (String)xmlElementAnnotation.getDefaultValue());
    }

    public void testSetDefaultValue() throws Exception {
        ICompilationUnit cu = this.createTestXmlElement();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementAnnotation xmlElementAnnotation = this.getXmlElementAnnotation((JavaResourceAttribute)resourceAttribute);
        XmlElementsAnnotationTests.assertNull((Object)xmlElementAnnotation.getDefaultValue());
        xmlElementAnnotation.setDefaultValue(XML_ELEMENT_DEFAULT_VALUE);
        XmlElementsAnnotationTests.assertEquals((String)XML_ELEMENT_DEFAULT_VALUE, (String)xmlElementAnnotation.getDefaultValue());
        this.assertSourceContains("@XmlElement(defaultValue = \"myDefaultValue\")", cu);
        xmlElementAnnotation.setDefaultValue(null);
        XmlElementsAnnotationTests.assertNull((Object)xmlElementAnnotation.getDefaultValue());
        this.assertSourceContains("@XmlElement", cu);
        this.assertSourceDoesNotContain("@XmlElement(defaultValue = \"myDefaultValue\")", cu);
    }

    public void testGetNillable() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementWithBooleanElement("nillable");
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementAnnotation xmlElementAnnotation = this.getXmlElementAnnotation((JavaResourceAttribute)resourceAttribute);
        XmlElementsAnnotationTests.assertEquals((Object)Boolean.TRUE, (Object)xmlElementAnnotation.getNillable());
    }

    public void testSetNillable() throws Exception {
        ICompilationUnit cu = this.createTestXmlElement();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementAnnotation xmlElementAnnotation = this.getXmlElementAnnotation((JavaResourceAttribute)resourceAttribute);
        XmlElementsAnnotationTests.assertNotNull((Object)xmlElementAnnotation);
        XmlElementsAnnotationTests.assertNull((Object)xmlElementAnnotation.getNillable());
        xmlElementAnnotation.setNillable(Boolean.FALSE);
        XmlElementsAnnotationTests.assertEquals((Object)Boolean.FALSE, (Object)xmlElementAnnotation.getNillable());
        this.assertSourceContains("@XmlElement(nillable = false)", cu);
        xmlElementAnnotation.setNillable(null);
        this.assertSourceContains("@XmlElement", cu);
        this.assertSourceDoesNotContain("nillable", cu);
    }

    public void testGetRequired() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementWithBooleanElement("required");
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementAnnotation xmlElementAnnotation = this.getXmlElementAnnotation((JavaResourceAttribute)resourceAttribute);
        XmlElementsAnnotationTests.assertEquals((Object)Boolean.TRUE, (Object)xmlElementAnnotation.getRequired());
    }

    public void testSetRequired() throws Exception {
        ICompilationUnit cu = this.createTestXmlElement();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementAnnotation xmlElementAnnotation = this.getXmlElementAnnotation((JavaResourceAttribute)resourceAttribute);
        XmlElementsAnnotationTests.assertNotNull((Object)xmlElementAnnotation);
        XmlElementsAnnotationTests.assertNull((Object)xmlElementAnnotation.getRequired());
        xmlElementAnnotation.setRequired(Boolean.FALSE);
        XmlElementsAnnotationTests.assertEquals((Object)Boolean.FALSE, (Object)xmlElementAnnotation.getRequired());
        this.assertSourceContains("@XmlElement(required = false)", cu);
        xmlElementAnnotation.setRequired(null);
        this.assertSourceContains("@XmlElement", cu);
        this.assertSourceDoesNotContain("required", cu);
    }

    public void testGetType() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementWithType();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementAnnotation xmlElementAnnotation = this.getXmlElementAnnotation((JavaResourceAttribute)resourceAttribute);
        XmlElementsAnnotationTests.assertTrue((xmlElementAnnotation != null ? 1 : 0) != 0);
        XmlElementsAnnotationTests.assertEquals((String)XML_ELEMENT_TYPE, (String)xmlElementAnnotation.getType());
        XmlElementsAnnotationTests.assertEquals((String)"java.lang.String", (String)xmlElementAnnotation.getFullyQualifiedTypeName());
    }

    public void testSetType() throws Exception {
        ICompilationUnit cu = this.createTestXmlElement();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementAnnotation xmlElementAnnotation = this.getXmlElementAnnotation((JavaResourceAttribute)resourceAttribute);
        XmlElementsAnnotationTests.assertNull((Object)xmlElementAnnotation.getType());
        xmlElementAnnotation.setType(XML_ELEMENT_TYPE);
        XmlElementsAnnotationTests.assertEquals((String)XML_ELEMENT_TYPE, (String)xmlElementAnnotation.getType());
        this.assertSourceContains("@XmlElement(type = String.class", cu);
        xmlElementAnnotation.setType(null);
        XmlElementsAnnotationTests.assertNull((Object)xmlElementAnnotation.getType());
        this.assertSourceContains("@XmlElement", cu);
        this.assertSourceDoesNotContain("@XmlElement(type = String.class", cu);
    }

    public void testAddXmlElement() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        this.addXmlElementAnnotation(1, (JavaResourceAttribute)resourceAttribute);
        XmlElementsAnnotation annotation = (XmlElementsAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElements");
        this.assertSourceContains("@XmlElements({@XmlElement(name = \"elementName\"),@XmlElement})", cu);
        XmlElementsAnnotationTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement"));
        XmlElementsAnnotationTests.assertNotNull((Object)annotation);
        XmlElementsAnnotationTests.assertEquals((int)2, (int)annotation.getXmlElementsSize());
    }

    public void testAddXmlElementToBeginningOfList() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        this.addXmlElementAnnotation(1, (JavaResourceAttribute)resourceAttribute);
        XmlElementsAnnotation annotation = (XmlElementsAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElements");
        this.assertSourceContains("@XmlElements({@XmlElement(name = \"elementName\"),@XmlElement})", cu);
        this.addXmlElementAnnotation(0, (JavaResourceAttribute)resourceAttribute);
        this.assertSourceContains("@XmlElements({@XmlElement,@XmlElement(name = \"elementName\"), @XmlElement})", cu);
        XmlElementsAnnotationTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement"));
        XmlElementsAnnotationTests.assertNotNull((Object)annotation);
        XmlElementsAnnotationTests.assertEquals((int)3, (int)annotation.getXmlElementsSize());
    }

    public void testRemoveXmlElement() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        this.addXmlElementAnnotation(1, (JavaResourceAttribute)resourceAttribute);
        this.assertSourceContains("@XmlElements({@XmlElement(name = \"elementName\"),@XmlElement})", cu);
        this.removeXmlElementAnnotation(1, (JavaResourceAttribute)resourceAttribute);
        this.assertSourceContains("@XmlElement(name = \"elementName\")", cu);
    }
}

