/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.FunctionRef;
import org.eclipse.wst.jsdt.core.dom.FunctionRefParameter;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.JSdoc;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.MemberRef;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.TagElement;
import org.eclipse.wst.jsdt.core.dom.TextElement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.corext.Corext;
import org.eclipse.wst.jsdt.internal.corext.SourceRange;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.dom.Selection;
import org.eclipse.wst.jsdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.ExceptionInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.wst.jsdt.internal.corext.refactoring.ReturnTypeInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.StubTypeContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.TypeContextChecker;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStringStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.delegates.DelegateMethodCreator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RefactoringAnalyzeUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RippleMethodFinder2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.TempOccurrenceAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.BodyUpdater;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ConstructorReferenceFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.IDefaultValueAdvisor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ImportRemover;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IDelegateUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.JavadocUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TightSourceRangeComputer;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabels;

public class ChangeSignatureRefactoring
extends ScriptableRefactoring
implements IDelegateUpdating {
    private static final String ATTRIBUTE_RETURN = "return";
    private static final String ATTRIBUTE_VISIBILITY = "visibility";
    private static final String ATTRIBUTE_PARAMETER = "parameter";
    private static final String ATTRIBUTE_DEFAULT = "default";
    private static final String ATTRIBUTE_KIND = "kind";
    private static final String ATTRIBUTE_DELEGATE = "delegate";
    private static final String ATTRIBUTE_DEPRECATE = "deprecate";
    private static final String ATTRIBUTE_FUNCTION_HEAD = "function";
    private static final boolean PREFIX_FUNCTION_HEAD = true;
    private List fParameterInfos;
    private CompilationUnitRewrite fBaseCuRewrite;
    private List fExceptionInfos;
    protected TextChangeManager fChangeManager;
    protected List fOtherChanges;
    private IFunction fMethod;
    private IFunction fTopMethod;
    private IFunction[] fRippleMethods;
    private SearchResultGroup[] fOccurrences;
    private ReturnTypeInfo fReturnTypeInfo;
    private String fMethodName;
    private int fVisibility;
    private static final String CONST_ASSIGN = " i=";
    private static final String CONST_CLOSE = ";";
    private StubTypeContext fContextCuStartEnd;
    private int fOldVarargIndex;
    private BodyUpdater fBodyUpdater;
    private IDefaultValueAdvisor fDefaultValueAdvisor;
    private ITypeHierarchy fCachedTypeHierarchy = null;
    private boolean fDelegateUpdating;
    private boolean fDelegateDeprecation;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ChangeSignatureRefactoring(IFunction method) throws JavaScriptModelException {
        this.fMethod = method;
        this.fOldVarargIndex = -1;
        this.fDelegateUpdating = false;
        this.fDelegateDeprecation = true;
        if (this.fMethod != null) {
            this.fParameterInfos = ChangeSignatureRefactoring.createParameterInfoList(method);
            this.fReturnTypeInfo = new ReturnTypeInfo(Signature.toString((String)Signature.getReturnType((String)this.fMethod.getSignature())));
            this.fMethodName = this.fMethod.getElementName();
            this.fVisibility = JdtFlags.getVisibilityCode((IMember)this.fMethod);
        }
    }

    private static List createParameterInfoList(IFunction method) {
        try {
            String[] typeNames = method.getParameterTypes();
            String[] oldNames = method.getParameterNames();
            ArrayList<ParameterInfo> result = new ArrayList<ParameterInfo>(typeNames.length);
            int i = 0;
            while (i < oldNames.length) {
                ParameterInfo parameterInfo;
                if (i == oldNames.length - 1 && Flags.isVarargs((int)method.getFlags())) {
                    String varargSignature = typeNames[i];
                    int arrayCount = Signature.getArrayCount((String)varargSignature);
                    String baseSignature = Signature.getElementType((String)varargSignature);
                    if (arrayCount > 1) {
                        baseSignature = Signature.createArraySignature((String)baseSignature, (int)(arrayCount - 1));
                    }
                    parameterInfo = new ParameterInfo(String.valueOf(Signature.toString((String)baseSignature)) + "...", oldNames[i], i);
                } else {
                    parameterInfo = new ParameterInfo(Signature.toString((String)typeNames[i]), oldNames[i], i);
                }
                result.add(parameterInfo);
                ++i;
            }
            return result;
        }
        catch (JavaScriptModelException e) {
            JavaScriptPlugin.log(e);
            return new ArrayList(0);
        }
    }

    public String getName() {
        return RefactoringCoreMessages.ChangeSignatureRefactoring_modify_Parameters;
    }

    public IFunction getMethod() {
        return this.fMethod;
    }

    public String getMethodName() {
        return this.fMethodName;
    }

    public String getReturnTypeString() {
        return this.fReturnTypeInfo.getNewTypeName();
    }

    public void setNewMethodName(String newMethodName) {
        Assert.isNotNull((Object)newMethodName);
        this.fMethodName = newMethodName;
    }

    public void setNewReturnTypeName(String newReturnTypeName) {
        Assert.isNotNull((Object)newReturnTypeName);
        this.fReturnTypeInfo.setNewTypeName(newReturnTypeName);
    }

    public boolean canChangeNameAndReturnType() {
        try {
            return !this.fMethod.isConstructor();
        }
        catch (JavaScriptModelException e) {
            JavaScriptPlugin.log(e);
            return false;
        }
    }

    public int getVisibility() {
        return this.fVisibility;
    }

    public void setVisibility(int visibility) {
        Assert.isTrue((visibility == 1 || visibility == 4 || visibility == 0 || visibility == 2 ? 1 : 0) != 0);
        this.fVisibility = visibility;
    }

    public int[] getAvailableVisibilities() throws JavaScriptModelException {
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[1] = 4;
        nArray[3] = 2;
        return nArray;
    }

    public List getParameterInfos() {
        return this.fParameterInfos;
    }

    public List getExceptionInfos() {
        return this.fExceptionInfos;
    }

    public void setBodyUpdater(BodyUpdater bodyUpdater) {
        this.fBodyUpdater = bodyUpdater;
    }

    public CompilationUnitRewrite getBaseCuRewrite() {
        return this.fBaseCuRewrite;
    }

    public boolean canEnableDelegateUpdating() {
        return true;
    }

    public boolean getDelegateUpdating() {
        return this.fDelegateUpdating;
    }

    public void setDelegateUpdating(boolean updating) {
        this.fDelegateUpdating = updating;
    }

    public void setDeprecateDelegates(boolean deprecate) {
        this.fDelegateDeprecation = deprecate;
    }

    public boolean getDeprecateDelegates() {
        return this.fDelegateDeprecation;
    }

    public RefactoringStatus checkSignature() {
        return this.checkSignature(false, this.doGetProblemVerifier());
    }

    private RefactoringStatus checkSignature(boolean resolveBindings, TypeContextChecker.IProblemVerifier problemVerifier) {
        RefactoringStatus result = new RefactoringStatus();
        this.checkMethodName(result);
        if (result.hasFatalError()) {
            return result;
        }
        this.checkParameterNamesAndValues(result);
        if (result.hasFatalError()) {
            return result;
        }
        this.checkForDuplicateParameterNames(result);
        if (result.hasFatalError()) {
            return result;
        }
        try {
            RefactoringStatus[] typeStati = resolveBindings ? TypeContextChecker.checkAndResolveMethodTypes(this.fMethod, this.getStubTypeContext(), this.getNotDeletedInfos(), this.fReturnTypeInfo, problemVerifier) : TypeContextChecker.checkMethodTypesSyntax(this.fMethod, this.getNotDeletedInfos(), this.fReturnTypeInfo);
            int i = 0;
            while (i < typeStati.length) {
                result.merge(typeStati[i]);
                ++i;
            }
            result.merge(this.checkVarargs());
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public boolean isSignatureSameAsInitial() throws JavaScriptModelException {
        if (!this.isVisibilitySameAsInitial()) {
            return false;
        }
        if (!this.isMethodNameSameAsInitial()) {
            return false;
        }
        if (!this.isReturnTypeSameAsInitial()) {
            return false;
        }
        if (!this.areExceptionsSameAsInitial()) {
            return false;
        }
        if (this.fMethod.getNumberOfParameters() == 0 && this.fParameterInfos.isEmpty()) {
            return true;
        }
        return this.areNamesSameAsInitial() && this.isOrderSameAsInitial() && this.areParameterTypesSameAsInitial();
    }

    public boolean isSignatureClashWithInitial() throws JavaScriptModelException {
        if (!this.isMethodNameSameAsInitial()) {
            return false;
        }
        if (this.fMethod.getNumberOfParameters() == 0 && this.fParameterInfos.isEmpty()) {
            return true;
        }
        int no = this.getNotDeletedInfos().size();
        if (this.fMethod.getNumberOfParameters() != no) {
            return false;
        }
        if (this.isOrderSameAsInitial()) {
            return this.areParameterTypesSameAsInitial();
        }
        return false;
    }

    private boolean areParameterTypesSameAsInitial() {
        Iterator iter = this.fParameterInfos.iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            if (info.isAdded() || info.isDeleted() || !info.isTypeNameChanged()) continue;
            return false;
        }
        return true;
    }

    private boolean isReturnTypeSameAsInitial() throws JavaScriptModelException {
        return !this.fReturnTypeInfo.isTypeNameChanged();
    }

    private boolean isMethodNameSameAsInitial() {
        return this.fMethodName.equals(this.fMethod.getElementName());
    }

    private boolean areExceptionsSameAsInitial() {
        Iterator iter = this.fExceptionInfos.iterator();
        while (iter.hasNext()) {
            ExceptionInfo info = (ExceptionInfo)iter.next();
            if (info.isOld()) continue;
            return false;
        }
        return true;
    }

    private void checkParameterNamesAndValues(RefactoringStatus result) {
        int i = 1;
        Iterator iter = this.fParameterInfos.iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            if (!info.isDeleted()) {
                this.checkParameterName(result, info, i);
                if (result.hasFatalError()) {
                    return;
                }
                if (info.isAdded()) {
                    this.checkParameterDefaultValue(result, info);
                    if (result.hasFatalError()) {
                        return;
                    }
                }
            }
            ++i;
        }
    }

    private void checkParameterName(RefactoringStatus result, ParameterInfo info, int position) {
        if (info.getNewName().trim().length() == 0) {
            result.addFatalError(Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_param_name_not_empty, Integer.toString(position)));
        } else {
            result.merge(Checks.checkTempName(info.getNewName()));
        }
    }

    private void checkMethodName(RefactoringStatus result) {
        if (this.isMethodNameSameAsInitial() || !this.canChangeNameAndReturnType()) {
            return;
        }
        if ("".equals(this.fMethodName.trim())) {
            String msg = RefactoringCoreMessages.ChangeSignatureRefactoring_method_name_not_empty;
            result.addFatalError(msg);
            return;
        }
        if (this.fMethod.getDeclaringType() != null && this.fMethodName.equals(this.fMethod.getDeclaringType().getElementName())) {
            String msg = RefactoringCoreMessages.ChangeSignatureRefactoring_constructor_name;
            result.addWarning(msg);
        }
        result.merge(Checks.checkMethodName(this.fMethodName));
    }

    private void checkParameterDefaultValue(RefactoringStatus result, ParameterInfo info) {
        if (this.fDefaultValueAdvisor != null) {
            return;
        }
        if (info.isNewVarargs()) {
            if (!ChangeSignatureRefactoring.isValidVarargsExpression(info.getDefaultValue())) {
                String msg = Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_invalid_expression, new String[]{info.getDefaultValue()});
                result.addFatalError(msg);
            }
            return;
        }
        if (info.getDefaultValue().trim().equals("")) {
            String msg = Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_default_value, new String[]{info.getNewName()});
            result.addFatalError(msg);
            return;
        }
        if (!ChangeSignatureRefactoring.isValidExpression(info.getDefaultValue())) {
            String msg = Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_invalid_expression, new String[]{info.getDefaultValue()});
            result.addFatalError(msg);
        }
    }

    private RefactoringStatus checkVarargs() throws JavaScriptModelException {
        RefactoringStatus result = this.checkOriginalVarargs();
        if (result != null) {
            return result;
        }
        if (this.fRippleMethods != null) {
            int iRipple = 0;
            while (iRipple < this.fRippleMethods.length) {
                IFunction rippleMethod = this.fRippleMethods[iRipple];
                if (JdtFlags.isVarargs(rippleMethod)) {
                    this.fOldVarargIndex = rippleMethod.getNumberOfParameters() - 1;
                    List notDeletedInfos = this.getNotDeletedInfos();
                    int i = 0;
                    while (i < notDeletedInfos.size()) {
                        ParameterInfo info = (ParameterInfo)notDeletedInfos.get(i);
                        if (this.fOldVarargIndex != -1 && info.getOldIndex() == this.fOldVarargIndex && !info.isNewVarargs()) {
                            String rippleMethodType = JavaModelUtil.getFullyQualifiedName(rippleMethod.getDeclaringType());
                            String message = Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_ripple_cannot_convert_vararg, new Object[]{info.getNewName(), rippleMethodType});
                            return RefactoringStatus.createFatalErrorStatus((String)message, (RefactoringStatusContext)JavaStatusContext.create((IMember)rippleMethod));
                        }
                        ++i;
                    }
                }
                ++iRipple;
            }
        }
        return null;
    }

    private RefactoringStatus checkOriginalVarargs() throws JavaScriptModelException {
        if (JdtFlags.isVarargs(this.fMethod)) {
            this.fOldVarargIndex = this.fMethod.getNumberOfParameters() - 1;
        }
        List notDeletedInfos = this.getNotDeletedInfos();
        int i = 0;
        while (i < notDeletedInfos.size()) {
            ParameterInfo info = (ParameterInfo)notDeletedInfos.get(i);
            if (info.isOldVarargs() && !info.isNewVarargs()) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_cannot_convert_vararg, info.getNewName()));
            }
            if (i != notDeletedInfos.size() - 1 && info.isNewVarargs()) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_vararg_must_be_last, info.getNewName()));
            }
            ++i;
        }
        return null;
    }

    private RefactoringStatus checkTypeVariables() throws JavaScriptModelException {
        if (this.fRippleMethods.length == 1) {
            return null;
        }
        RefactoringStatus result = new RefactoringStatus();
        if (this.fReturnTypeInfo.isTypeNameChanged() && this.fReturnTypeInfo.getNewTypeBinding() != null) {
            HashSet typeVariablesCollector = new HashSet();
            this.collectTypeVariables(this.fReturnTypeInfo.getNewTypeBinding(), typeVariablesCollector);
            if (typeVariablesCollector.size() != 0) {
                ITypeBinding first = (ITypeBinding)typeVariablesCollector.iterator().next();
                String msg = Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_return_type_contains_type_variable, new String[]{this.fReturnTypeInfo.getNewTypeName(), first.getName()});
                result.addError(msg);
            }
        }
        Iterator iter = this.getNotDeletedInfos().iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            if (!info.isTypeNameChanged() || info.getNewTypeBinding() == null) continue;
            HashSet typeVariablesCollector = new HashSet();
            this.collectTypeVariables(info.getNewTypeBinding(), typeVariablesCollector);
            if (typeVariablesCollector.size() == 0) continue;
            ITypeBinding first = (ITypeBinding)typeVariablesCollector.iterator().next();
            String msg = Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_parameter_type_contains_type_variable, new String[]{info.getNewTypeName(), info.getNewName(), first.getName()});
            result.addError(msg);
        }
        return result;
    }

    private void collectTypeVariables(ITypeBinding typeBinding, Set typeVariablesCollector) {
        if (typeBinding.isArray()) {
            this.collectTypeVariables(typeBinding.getElementType(), typeVariablesCollector);
        }
    }

    public static boolean isValidExpression(String string) {
        String trimmed = string.trim();
        StringBuffer cuBuff = new StringBuffer();
        cuBuff.append(CONST_ASSIGN);
        int offset = cuBuff.length();
        cuBuff.append(trimmed).append(CONST_CLOSE);
        ASTParser p = ASTParser.newParser((int)3);
        p.setSource(cuBuff.toString().toCharArray());
        JavaScriptUnit cu = (JavaScriptUnit)p.createAST(null);
        Selection selection = Selection.createFromStartLength(offset, trimmed.length());
        SelectionAnalyzer analyzer = new SelectionAnalyzer(selection, false);
        cu.accept((ASTVisitor)analyzer);
        ASTNode selected = analyzer.getFirstSelectedNode();
        return selected instanceof Expression && trimmed.equals(cuBuff.substring(cu.getExtendedStartPosition(selected), cu.getExtendedStartPosition(selected) + cu.getExtendedLength(selected)));
    }

    public static boolean isValidVarargsExpression(String string) {
        String trimmed = string.trim();
        if ("".equals(trimmed)) {
            return true;
        }
        StringBuffer cuBuff = new StringBuffer();
        cuBuff.append("class A{ {m(");
        int offset = cuBuff.length();
        cuBuff.append(trimmed).append(");}}");
        ASTParser p = ASTParser.newParser((int)3);
        p.setSource(cuBuff.toString().toCharArray());
        JavaScriptUnit cu = (JavaScriptUnit)p.createAST(null);
        Selection selection = Selection.createFromStartLength(offset, trimmed.length());
        SelectionAnalyzer analyzer = new SelectionAnalyzer(selection, false);
        cu.accept((ASTVisitor)analyzer);
        ASTNode[] selectedNodes = analyzer.getSelectedNodes();
        if (selectedNodes.length == 0) {
            return false;
        }
        int i = 0;
        while (i < selectedNodes.length) {
            if (!(selectedNodes[i] instanceof Expression)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public StubTypeContext getStubTypeContext() {
        try {
            if (this.fContextCuStartEnd == null) {
                this.fContextCuStartEnd = TypeContextChecker.createStubTypeContext(this.getCu(), this.fBaseCuRewrite.getRoot(), this.fMethod.getSourceRange().getOffset());
            }
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        return this.fContextCuStartEnd;
    }

    private ITypeHierarchy getCachedTypeHierarchy(IProgressMonitor monitor) throws JavaScriptModelException {
        if (this.fCachedTypeHierarchy == null) {
            this.fCachedTypeHierarchy = this.fMethod.getDeclaringType().newTypeHierarchy((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        return this.fCachedTypeHierarchy;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException {
        RefactoringStatus result;
        block12: {
            block11: {
                block10: {
                    RefactoringStatus refactoringStatus;
                    try {
                        monitor.beginTask("", 5);
                        result = Checks.checkIfCuBroken((IMember)this.fMethod);
                        if (!result.hasFatalError()) break block10;
                        refactoringStatus = result;
                        Object var5_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_11 = null;
                        monitor.done();
                        throw throwable;
                    }
                    monitor.done();
                    return refactoringStatus;
                }
                if (this.fMethod != null && this.fMethod.exists()) break block11;
                String message = Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_method_deleted, this.getCu().getElementName());
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)message);
                Object var5_8 = null;
                monitor.done();
                return refactoringStatus;
            }
            if (MethodChecks.isVirtual(this.fMethod)) {
                ITypeHierarchy hierarchy = this.getCachedTypeHierarchy((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.fTopMethod = null;
                if (this.fTopMethod == null) {
                    this.fTopMethod = MethodChecks.overridesAnotherMethod(this.fMethod, hierarchy);
                }
            }
            if (this.fTopMethod == null) {
                this.fTopMethod = this.fMethod;
            }
            if (this.fTopMethod.equals(this.fMethod)) break block12;
            RefactoringStatusContext context = JavaStatusContext.create((IMember)this.fTopMethod);
            String message = Messages.format(RefactoringCoreMessages.MethodChecks_overrides, new String[]{JavaElementUtil.createMethodSignature(this.fTopMethod), JavaModelUtil.getFullyQualifiedName(this.fTopMethod.getDeclaringType())});
            RefactoringStatus refactoringStatus = RefactoringStatus.createStatus((int)4, (String)message, (RefactoringStatusContext)context, (String)Corext.getPluginId(), (int)1, (Object)this.fTopMethod);
            Object var5_9 = null;
            monitor.done();
            return refactoringStatus;
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (this.fBaseCuRewrite == null || !this.fBaseCuRewrite.getCu().equals(this.getCu())) {
            this.fBaseCuRewrite = new CompilationUnitRewrite(this.getCu());
            this.fBaseCuRewrite.getASTRewrite().setTargetSourceRangeComputer((TargetSourceRangeComputer)new TightSourceRangeComputer());
        }
        monitor.worked(1);
        result.merge(this.createExceptionInfoList());
        monitor.worked(1);
        RefactoringStatus refactoringStatus = result;
        Object var5_10 = null;
        monitor.done();
        return refactoringStatus;
    }

    private RefactoringStatus createExceptionInfoList() {
        if (this.fExceptionInfos == null || this.fExceptionInfos.isEmpty()) {
            ASTNode nameNode;
            block6: {
                this.fExceptionInfos = new ArrayList(0);
                nameNode = NodeFinder.perform((ASTNode)this.fBaseCuRewrite.getRoot(), this.fMethod.getNameRange());
                if (nameNode != null && nameNode instanceof Name && nameNode.getParent() instanceof FunctionDeclaration) break block6;
                return null;
            }
            try {
                FunctionDeclaration methodDeclaration = (FunctionDeclaration)nameNode.getParent();
                List exceptions = methodDeclaration.thrownExceptions();
                ArrayList<ExceptionInfo> result = new ArrayList<ExceptionInfo>(exceptions.size());
                int i = 0;
                while (i < exceptions.size()) {
                    Name name = (Name)exceptions.get(i);
                    ITypeBinding typeBinding = name.resolveTypeBinding();
                    if (typeBinding == null) {
                        return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ChangeSignatureRefactoring_no_exception_binding);
                    }
                    IType type = (IType)typeBinding.getJavaElement();
                    result.add(ExceptionInfo.createInfoForOldException(type, typeBinding));
                    ++i;
                }
                this.fExceptionInfos = result;
            }
            catch (JavaScriptModelException e) {
                JavaScriptPlugin.log(e);
            }
        }
        return null;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result;
        block17: {
            block16: {
                block15: {
                    block14: {
                        block13: {
                            RefactoringStatus refactoringStatus;
                            try {
                                pm.beginTask(RefactoringCoreMessages.ChangeSignatureRefactoring_checking_preconditions, 8);
                                result = new RefactoringStatus();
                                this.clearManagers();
                                this.fBaseCuRewrite.clearASTAndImportRewrites();
                                this.fBaseCuRewrite.getASTRewrite().setTargetSourceRangeComputer((TargetSourceRangeComputer)new TightSourceRangeComputer());
                                if (!this.isSignatureSameAsInitial()) break block13;
                                refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ChangeSignatureRefactoring_unchanged);
                                Object var3_9 = null;
                            }
                            catch (Throwable throwable) {
                                Object var3_15 = null;
                                pm.done();
                                throw throwable;
                            }
                            pm.done();
                            return refactoringStatus;
                        }
                        result.merge(this.checkSignature(true, this.doGetProblemVerifier()));
                        if (!result.hasFatalError()) break block14;
                        RefactoringStatus refactoringStatus = result;
                        Object var3_10 = null;
                        pm.done();
                        return refactoringStatus;
                    }
                    if (this.fDelegateUpdating && this.isSignatureClashWithInitial()) {
                        result.merge(RefactoringStatus.createErrorStatus((String)RefactoringCoreMessages.ChangeSignatureRefactoring_old_and_new_signatures_not_sufficiently_different));
                    }
                    this.fRippleMethods = RippleMethodFinder2.getRelatedMethods(this.fMethod, (IProgressMonitor)new SubProgressMonitor(pm, 1), null);
                    result.merge(this.checkVarargs());
                    if (!result.hasFatalError()) break block15;
                    RefactoringStatus refactoringStatus = result;
                    Object var3_11 = null;
                    pm.done();
                    return refactoringStatus;
                }
                this.fOccurrences = this.findOccurrences((IProgressMonitor)new SubProgressMonitor(pm, 1), result);
                result.merge(this.checkVisibilityChanges());
                result.merge(this.checkTypeVariables());
                if (!this.isOrderSameAsInitial()) {
                    result.merge(this.checkReorderings((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                } else {
                    pm.worked(1);
                }
                if (!this.areNamesSameAsInitial()) {
                    result.merge(this.checkRenamings((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                } else {
                    pm.worked(1);
                }
                if (!result.hasFatalError()) break block16;
                RefactoringStatus refactoringStatus = result;
                Object var3_12 = null;
                pm.done();
                return refactoringStatus;
            }
            this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 1), result);
            this.fCachedTypeHierarchy = null;
            if (this.mustAnalyzeAstOfDeclaringCu()) {
                result.merge(this.checkCompilationofDeclaringCu());
            }
            if (!result.hasFatalError()) break block17;
            RefactoringStatus refactoringStatus = result;
            Object var3_13 = null;
            pm.done();
            return refactoringStatus;
        }
        result.merge(this.validateModifiesFiles());
        RefactoringStatus refactoringStatus = result;
        Object var3_14 = null;
        pm.done();
        return refactoringStatus;
    }

    protected TypeContextChecker.IProblemVerifier doGetProblemVerifier() {
        return null;
    }

    private void clearManagers() {
        this.fChangeManager = null;
        this.fOtherChanges = new ArrayList();
    }

    private RefactoringStatus checkVisibilityChanges() throws JavaScriptModelException {
        if (this.isVisibilitySameAsInitial()) {
            return null;
        }
        if (this.fRippleMethods.length == 1) {
            return null;
        }
        Assert.isTrue((JdtFlags.getVisibilityCode((IMember)this.fMethod) != 2 ? 1 : 0) != 0);
        if (this.fVisibility == 2) {
            return RefactoringStatus.createWarningStatus((String)RefactoringCoreMessages.ChangeSignatureRefactoring_non_virtual);
        }
        return null;
    }

    public String getOldMethodSignature() throws JavaScriptModelException {
        StringBuffer buff = new StringBuffer();
        int flags = this.getMethod().getFlags();
        buff.append("function ");
        this.getMethod().isConstructor();
        buff.append(JavaScriptElementLabels.getElementLabel(this.fMethod.getParent(), JavaScriptElementLabels.ALL_FULLY_QUALIFIED));
        buff.append('.');
        buff.append(this.fMethod.getElementName()).append('(').append(this.getOldMethodParameters()).append(')');
        buff.append(this.getOldMethodThrows());
        return buff.toString();
    }

    public String getNewMethodSignature() throws JavaScriptModelException {
        StringBuffer buff = new StringBuffer();
        buff.append("function ");
        this.getMethod().isConstructor();
        buff.append(this.getMethodName()).append('(').append(this.getMethodParameters()).append(')');
        return buff.toString();
    }

    private String getVisibilityString(int visibility) {
        String visibilityString = JdtFlags.getVisibilityString(visibility);
        if ("".equals(visibilityString)) {
            return visibilityString;
        }
        return String.valueOf(visibilityString) + ' ';
    }

    private String getMethodThrows() {
        StringBuffer buff = new StringBuffer(" throws ");
        Iterator iter = this.fExceptionInfos.iterator();
        while (iter.hasNext()) {
            ExceptionInfo info = (ExceptionInfo)iter.next();
            if (info.isDeleted()) continue;
            buff.append(info.getType().getElementName());
            buff.append(", ");
        }
        if (buff.length() == " throws ".length()) {
            return "";
        }
        buff.delete(buff.length() - 2, buff.length());
        return buff.toString();
    }

    private String getOldMethodThrows() {
        StringBuffer buff = new StringBuffer(" throws ");
        Iterator iter = this.fExceptionInfos.iterator();
        while (iter.hasNext()) {
            ExceptionInfo info = (ExceptionInfo)iter.next();
            if (info.isAdded()) continue;
            buff.append(info.getType().getElementName());
            buff.append(", ");
        }
        if (buff.length() == " throws ".length()) {
            return "";
        }
        buff.delete(buff.length() - 2, buff.length());
        return buff.toString();
    }

    private void checkForDuplicateParameterNames(RefactoringStatus result) {
        HashSet<String> found = new HashSet<String>();
        HashSet<String> doubled = new HashSet<String>();
        Iterator iter = this.getNotDeletedInfos().iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            String newName = info.getNewName();
            if (found.contains(newName) && !doubled.contains(newName)) {
                result.addFatalError(Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_duplicate_name, newName));
                doubled.add(newName);
                continue;
            }
            found.add(newName);
        }
    }

    private IJavaScriptUnit getCu() {
        return this.fMethod.getJavaScriptUnit();
    }

    private boolean mustAnalyzeAstOfDeclaringCu() throws JavaScriptModelException {
        return !JdtFlags.isAbstract((IMember)this.getMethod());
    }

    private RefactoringStatus checkCompilationofDeclaringCu() throws CoreException {
        IJavaScriptUnit cu = this.getCu();
        TextChange change = this.fChangeManager.get(cu);
        String newCuSource = change.getPreviewContent((IProgressMonitor)new NullProgressMonitor());
        JavaScriptUnit newCUNode = new RefactoringASTParser(3).parse(newCuSource, cu, true, false, null);
        IProblem[] problems = RefactoringAnalyzeUtil.getIntroducedCompileProblems(newCUNode, this.fBaseCuRewrite.getRoot());
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < problems.length) {
            IProblem problem = problems[i];
            if (this.shouldReport(problem, newCUNode)) {
                result.addEntry(new RefactoringStatusEntry(problem.isError() ? 3 : 2, problem.getMessage(), (RefactoringStatusContext)new JavaStringStatusContext(newCuSource, new SourceRange(problem))));
            }
            ++i;
        }
        return result;
    }

    private boolean shouldReport(IProblem problem, JavaScriptUnit cu) {
        if (!problem.isError()) {
            return false;
        }
        if (problem.getID() == 0x1000002) {
            return false;
        }
        ASTNode node = ASTNodeSearchUtil.getAstNode(cu, problem.getSourceStart(), problem.getSourceEnd() - problem.getSourceStart());
        TypeContextChecker.IProblemVerifier verifier = this.doGetProblemVerifier();
        if (verifier != null) {
            return verifier.isError(problem, node);
        }
        return true;
    }

    private String getOldMethodParameters() {
        StringBuffer buff = new StringBuffer();
        int i = 0;
        Iterator iter = this.getNotAddedInfos().iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            if (i != 0) {
                buff.append(", ");
            }
            buff.append(ChangeSignatureRefactoring.createDeclarationString(info));
            ++i;
        }
        return buff.toString();
    }

    private String getMethodParameters() {
        StringBuffer buff = new StringBuffer();
        int i = 0;
        Iterator iter = this.getNotDeletedInfos().iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            if (i != 0) {
                buff.append(", ");
            }
            buff.append(ChangeSignatureRefactoring.createDeclarationString(info));
            ++i;
        }
        return buff.toString();
    }

    private List getAddedInfos() {
        ArrayList<ParameterInfo> result = new ArrayList<ParameterInfo>(1);
        Iterator iter = this.fParameterInfos.iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            if (!info.isAdded()) continue;
            result.add(info);
        }
        return result;
    }

    private List getDeletedInfos() {
        ArrayList<ParameterInfo> result = new ArrayList<ParameterInfo>(1);
        Iterator iter = this.fParameterInfos.iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            if (!info.isDeleted()) continue;
            result.add(info);
        }
        return result;
    }

    private List getNotAddedInfos() {
        ArrayList all = new ArrayList(this.fParameterInfos);
        all.removeAll(this.getAddedInfos());
        return all;
    }

    private List getNotDeletedInfos() {
        ArrayList all = new ArrayList(this.fParameterInfos);
        all.removeAll(this.getDeletedInfos());
        return all;
    }

    private boolean areNamesSameAsInitial() {
        Iterator iter = this.fParameterInfos.iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            if (!info.isRenamed()) continue;
            return false;
        }
        return true;
    }

    private boolean isOrderSameAsInitial() {
        int i = 0;
        Iterator iter = this.fParameterInfos.iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            if (info.getOldIndex() != i) {
                return false;
            }
            if (info.isDeleted()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private RefactoringStatus checkReorderings(IProgressMonitor pm) throws JavaScriptModelException {
        RefactoringStatus refactoringStatus;
        try {
            pm.beginTask(RefactoringCoreMessages.ChangeSignatureRefactoring_checking_preconditions, 1);
            refactoringStatus = this.checkNativeMethods();
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return refactoringStatus;
    }

    private RefactoringStatus checkRenamings(IProgressMonitor pm) throws JavaScriptModelException {
        RefactoringStatus refactoringStatus;
        try {
            pm.beginTask(RefactoringCoreMessages.ChangeSignatureRefactoring_checking_preconditions, 1);
            refactoringStatus = this.checkParameterNamesInRippleMethods();
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return refactoringStatus;
    }

    private RefactoringStatus checkParameterNamesInRippleMethods() throws JavaScriptModelException {
        RefactoringStatus result = new RefactoringStatus();
        Set newParameterNames = this.getNewParameterNamesList();
        int i = 0;
        while (i < this.fRippleMethods.length) {
            String[] paramNames = this.fRippleMethods[i].getParameterNames();
            int j = 0;
            while (j < paramNames.length) {
                if (newParameterNames.contains(paramNames[j])) {
                    Object[] args = new String[]{JavaElementUtil.createMethodSignature(this.fRippleMethods[i]), paramNames[j]};
                    String msg = Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_already_has, args);
                    RefactoringStatusContext context = JavaStatusContext.create((ITypeRoot)this.fRippleMethods[i].getJavaScriptUnit(), this.fRippleMethods[i].getNameRange());
                    result.addError(msg, context);
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    private Set getNewParameterNamesList() {
        Set oldNames = this.getOriginalParameterNames();
        Set currentNames = this.getNamesOfNotDeletedParameters();
        currentNames.removeAll(oldNames);
        return currentNames;
    }

    private Set getNamesOfNotDeletedParameters() {
        HashSet<String> result = new HashSet<String>();
        Iterator iter = this.getNotDeletedInfos().iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            result.add(info.getNewName());
        }
        return result;
    }

    private Set getOriginalParameterNames() {
        HashSet<String> result = new HashSet<String>();
        Iterator iter = this.fParameterInfos.iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            if (info.isAdded()) continue;
            result.add(info.getOldName());
        }
        return result;
    }

    private RefactoringStatus checkNativeMethods() throws JavaScriptModelException {
        RefactoringStatus result = new RefactoringStatus();
        return result;
    }

    private IFile[] getAllFilesToModify() {
        return ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits());
    }

    private RefactoringStatus validateModifiesFiles() {
        return Checks.validateModifiesFiles(this.getAllFilesToModify(), this.getValidationContext());
    }

    public Change createChange(IProgressMonitor pm) {
        JDTRefactoringDescriptor descriptor;
        ArrayList<TextChange> list;
        pm.beginTask("", 1);
        try {
            TextChange[] changes = this.fChangeManager.getAllChanges();
            list = new ArrayList<TextChange>(changes.length);
            list.addAll(this.fOtherChanges);
            list.addAll(Arrays.asList(changes));
            HashMap<String, String> arguments = new HashMap<String, String>();
            String project = null;
            IJavaScriptProject javaProject = this.fMethod.getJavaScriptProject();
            if (javaProject != null) {
                project = javaProject.getElementName();
            }
            int flags = 589826;
            try {
                IType declaring;
                if (!Flags.isPrivate((int)this.fMethod.getFlags())) {
                    flags |= 4;
                }
                if ((declaring = this.fMethod.getDeclaringType()) != null && (declaring.isAnonymous() || declaring.isLocal())) {
                    flags |= 0x40000;
                }
            }
            catch (JavaScriptModelException exception) {
                JavaScriptPlugin.log(exception);
            }
            descriptor = null;
            try {
                Object info;
                Object info2;
                String description = Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_descriptor_description_short, this.fMethod.getElementName());
                String header = Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_descriptor_description, new String[]{this.getOldMethodSignature(), this.getNewMethodSignature()});
                JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, this, header);
                if (!this.fMethod.getElementName().equals(this.fMethodName)) {
                    comment.addSetting(Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_new_name_pattern, this.fMethodName));
                }
                if (!this.isVisibilitySameAsInitial()) {
                    String visibility = JdtFlags.getVisibilityString(this.fVisibility);
                    if ("".equals(visibility)) {
                        visibility = RefactoringCoreMessages.ChangeSignatureRefactoring_default_visibility;
                    }
                    comment.addSetting(Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_new_visibility_pattern, visibility));
                }
                if (this.fReturnTypeInfo.isTypeNameChanged()) {
                    comment.addSetting(Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_new_return_type_pattern, this.fReturnTypeInfo.getNewTypeName()));
                }
                ArrayList<String> deleted = new ArrayList<String>();
                ArrayList<String> added = new ArrayList<String>();
                ArrayList<String> changed = new ArrayList<String>();
                Iterator iterator = this.fParameterInfos.iterator();
                while (iterator.hasNext()) {
                    info2 = (ParameterInfo)iterator.next();
                    if (((ParameterInfo)info2).isDeleted()) {
                        deleted.add(Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_deleted_parameter_pattern, new String[]{((ParameterInfo)info2).getOldTypeName(), ((ParameterInfo)info2).getOldName()}));
                        continue;
                    }
                    if (((ParameterInfo)info2).isAdded()) {
                        added.add(Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_added_parameter_pattern, new String[]{((ParameterInfo)info2).getNewTypeName(), ((ParameterInfo)info2).getNewName()}));
                        continue;
                    }
                    if (!((ParameterInfo)info2).isRenamed() && !((ParameterInfo)info2).isTypeNameChanged() && !((ParameterInfo)info2).isVarargChanged()) continue;
                    changed.add(Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_changed_parameter_pattern, new String[]{((ParameterInfo)info2).getOldTypeName(), ((ParameterInfo)info2).getOldName()}));
                }
                if (!added.isEmpty()) {
                    comment.addSetting(JDTRefactoringDescriptorComment.createCompositeSetting(RefactoringCoreMessages.ChangeSignatureRefactoring_added_parameters, added.toArray(new String[added.size()])));
                }
                if (!deleted.isEmpty()) {
                    comment.addSetting(JDTRefactoringDescriptorComment.createCompositeSetting(RefactoringCoreMessages.ChangeSignatureRefactoring_removed_parameters, deleted.toArray(new String[deleted.size()])));
                }
                if (!changed.isEmpty()) {
                    comment.addSetting(JDTRefactoringDescriptorComment.createCompositeSetting(RefactoringCoreMessages.ChangeSignatureRefactoring_changed_parameters, changed.toArray(new String[changed.size()])));
                }
                added.clear();
                deleted.clear();
                changed.clear();
                iterator = this.fExceptionInfos.iterator();
                while (iterator.hasNext()) {
                    info2 = (ExceptionInfo)iterator.next();
                    if (((ExceptionInfo)info2).isAdded()) {
                        added.add(((ExceptionInfo)info2).getType().getElementName());
                        continue;
                    }
                    if (!((ExceptionInfo)info2).isDeleted()) continue;
                    deleted.add(((ExceptionInfo)info2).getType().getElementName());
                }
                if (!added.isEmpty()) {
                    comment.addSetting(JDTRefactoringDescriptorComment.createCompositeSetting(RefactoringCoreMessages.ChangeSignatureRefactoring_added_exceptions, added.toArray(new String[added.size()])));
                }
                if (!deleted.isEmpty()) {
                    comment.addSetting(JDTRefactoringDescriptorComment.createCompositeSetting(RefactoringCoreMessages.ChangeSignatureRefactoring_removed_exceptions, deleted.toArray(new String[deleted.size()])));
                }
                descriptor = new JDTRefactoringDescriptor("org.eclipse.wst.jsdt.ui.change.method.signature", project, description, comment.asString(), arguments, flags);
                arguments.put("input", descriptor.elementToHandle((IJavaScriptElement)this.fMethod));
                arguments.put("name", this.fMethodName);
                arguments.put(ATTRIBUTE_DELEGATE, Boolean.valueOf(this.fDelegateUpdating).toString());
                arguments.put(ATTRIBUTE_DEPRECATE, Boolean.valueOf(this.fDelegateDeprecation).toString());
                if (this.fReturnTypeInfo.isTypeNameChanged()) {
                    arguments.put(ATTRIBUTE_RETURN, this.fReturnTypeInfo.getNewTypeName());
                }
                try {
                    if (!this.isVisibilitySameAsInitial()) {
                        arguments.put(ATTRIBUTE_VISIBILITY, new Integer(this.fVisibility).toString());
                    }
                }
                catch (JavaScriptModelException exception) {
                    JavaScriptPlugin.log(exception);
                }
                int count = 1;
                Iterator iterator2 = this.fParameterInfos.iterator();
                while (iterator2.hasNext()) {
                    info = (ParameterInfo)iterator2.next();
                    StringBuffer buffer = new StringBuffer(64);
                    buffer.append(((ParameterInfo)info).getOldTypeName());
                    buffer.append(" ");
                    buffer.append(((ParameterInfo)info).getOldName());
                    buffer.append(" ");
                    buffer.append(((ParameterInfo)info).getOldIndex());
                    buffer.append(" ");
                    buffer.append(((ParameterInfo)info).getNewTypeName());
                    buffer.append(" ");
                    buffer.append(((ParameterInfo)info).getNewName());
                    buffer.append(" ");
                    buffer.append(((ParameterInfo)info).isDeleted());
                    arguments.put(ATTRIBUTE_PARAMETER + count, buffer.toString());
                    String value = ((ParameterInfo)info).getDefaultValue();
                    if (value != null && !"".equals(value)) {
                        arguments.put(ATTRIBUTE_DEFAULT + count, value);
                    }
                    ++count;
                }
                count = 1;
                iterator2 = this.fExceptionInfos.iterator();
                while (iterator2.hasNext()) {
                    info = (ExceptionInfo)iterator2.next();
                    arguments.put("element" + count, descriptor.elementToHandle((IJavaScriptElement)((ExceptionInfo)info).getType()));
                    arguments.put(ATTRIBUTE_KIND + count, new Integer(((ExceptionInfo)info).getKind()).toString());
                    ++count;
                }
            }
            catch (JavaScriptModelException exception) {
                JavaScriptPlugin.log(exception);
                Object var20_24 = null;
                pm.done();
                this.clearManagers();
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var20_26 = null;
            pm.done();
            this.clearManagers();
            throw throwable;
        }
        DynamicValidationRefactoringChange dynamicValidationRefactoringChange = new DynamicValidationRefactoringChange(descriptor, this.doGetRefactoringChangeName(), list.toArray(new Change[list.size()]));
        Object var20_25 = null;
        pm.done();
        this.clearManagers();
        return dynamicValidationRefactoringChange;
    }

    protected String doGetRefactoringChangeName() {
        return RefactoringCoreMessages.ChangeSignatureRefactoring_restructure_parameters;
    }

    private TextChangeManager createChangeManager(IProgressMonitor pm, RefactoringStatus result) throws CoreException {
        pm.beginTask(RefactoringCoreMessages.ChangeSignatureRefactoring_preview, 2);
        this.fChangeManager = new TextChangeManager();
        boolean isNoArgConstructor = this.isNoArgConstructor();
        Map namedSubclassMapping = null;
        if (isNoArgConstructor) {
            namedSubclassMapping = this.createNamedSubclassMapping((IProgressMonitor)new SubProgressMonitor(pm, 1));
        } else {
            pm.worked(1);
        }
        int i = 0;
        while (i < this.fOccurrences.length) {
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            SearchResultGroup group = this.fOccurrences[i];
            IJavaScriptUnit cu = group.getCompilationUnit();
            if (cu != null) {
                CompilationUnitChange change;
                CompilationUnitRewrite cuRewrite;
                if (cu.equals(this.getCu())) {
                    cuRewrite = this.fBaseCuRewrite;
                } else {
                    cuRewrite = new CompilationUnitRewrite(cu);
                    cuRewrite.getASTRewrite().setTargetSourceRangeComputer((TargetSourceRangeComputer)new TightSourceRangeComputer());
                }
                ASTNode[] nodes = ASTNodeSearchUtil.findNodes(group.getSearchResults(), cuRewrite.getRoot());
                ArrayList<OccurrenceUpdate> deferredUpdates = new ArrayList<OccurrenceUpdate>();
                int j = 0;
                while (j < nodes.length) {
                    OccurrenceUpdate update = this.createOccurrenceUpdate(nodes[j], cuRewrite, result);
                    if (update instanceof DeclarationUpdate) {
                        update.updateNode();
                    } else {
                        deferredUpdates.add(update);
                    }
                    ++j;
                }
                Iterator iter = deferredUpdates.iterator();
                while (iter.hasNext()) {
                    ((OccurrenceUpdate)iter.next()).updateNode();
                }
                if (isNoArgConstructor && namedSubclassMapping.containsKey(cu)) {
                    Set subtypes = (Set)namedSubclassMapping.get(cu);
                    Iterator iter2 = subtypes.iterator();
                    while (iter2.hasNext()) {
                        IType subtype = (IType)iter2.next();
                        AbstractTypeDeclaration subtypeNode = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(subtype, cuRewrite.getRoot());
                        if (subtypeNode == null) continue;
                        this.modifyImplicitCallsToNoArgConstructor(subtypeNode, cuRewrite);
                    }
                }
                if ((change = cuRewrite.createChange()) != null) {
                    this.fChangeManager.manage(cu, (TextChange)change);
                }
            }
            ++i;
        }
        pm.done();
        return this.fChangeManager;
    }

    private Map createNamedSubclassMapping(IProgressMonitor pm) throws JavaScriptModelException {
        IType[] subclasses = this.getCachedTypeHierarchy((IProgressMonitor)new SubProgressMonitor(pm, 1)).getSubclasses(this.fMethod.getDeclaringType());
        HashMap result = new HashMap();
        int i = 0;
        while (i < subclasses.length) {
            IType subclass = subclasses[i];
            if (!subclass.isAnonymous()) {
                IJavaScriptUnit cu = subclass.getJavaScriptUnit();
                if (!result.containsKey(cu)) {
                    result.put(cu, new HashSet());
                }
                ((Set)result.get(cu)).add(subclass);
            }
            ++i;
        }
        return result;
    }

    private void modifyImplicitCallsToNoArgConstructor(AbstractTypeDeclaration subclass, CompilationUnitRewrite cuRewrite) {
        FunctionDeclaration[] constructors = this.getAllConstructors(subclass);
        if (constructors.length == 0) {
            this.addNewConstructorToSubclass(subclass, cuRewrite);
        } else {
            int i = 0;
            while (i < constructors.length) {
                if (ChangeSignatureRefactoring.containsImplicitCallToSuperConstructor(constructors[i])) {
                    this.addExplicitSuperConstructorCall(constructors[i], cuRewrite);
                }
                ++i;
            }
        }
    }

    private void addExplicitSuperConstructorCall(FunctionDeclaration constructor, CompilationUnitRewrite cuRewrite) {
        SuperConstructorInvocation superCall = constructor.getAST().newSuperConstructorInvocation();
        this.addArgumentsToNewSuperConstructorCall(superCall, cuRewrite);
        String msg = RefactoringCoreMessages.ChangeSignatureRefactoring_add_super_call;
        TextEditGroup description = cuRewrite.createGroupDescription(msg);
        cuRewrite.getASTRewrite().getListRewrite((ASTNode)constructor.getBody(), Block.STATEMENTS_PROPERTY).insertFirst((ASTNode)superCall, description);
    }

    private void addArgumentsToNewSuperConstructorCall(SuperConstructorInvocation superCall, CompilationUnitRewrite cuRewrite) {
        Iterator iter = this.getNotDeletedInfos().iterator();
        while (iter.hasNext()) {
            Expression newExpression;
            ParameterInfo info = (ParameterInfo)iter.next();
            List list = this.getParameterInfos();
            List list2 = superCall.arguments();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.wst.jsdt.core.dom.FunctionDeclaration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((newExpression = this.createNewExpression(info, list, list2, cuRewrite, (FunctionDeclaration)ASTNodes.getParent((ASTNode)superCall, clazz))) == null) continue;
            superCall.arguments().add(newExpression);
        }
    }

    private static boolean containsImplicitCallToSuperConstructor(FunctionDeclaration constructor) {
        Assert.isTrue((boolean)constructor.isConstructor());
        Block body = constructor.getBody();
        if (body == null) {
            return false;
        }
        if (body.statements().size() == 0) {
            return true;
        }
        if (body.statements().get(0) instanceof ConstructorInvocation) {
            return false;
        }
        return !(body.statements().get(0) instanceof SuperConstructorInvocation);
    }

    private void addNewConstructorToSubclass(AbstractTypeDeclaration subclass, CompilationUnitRewrite cuRewrite) {
        AST ast = subclass.getAST();
        FunctionDeclaration newConstructor = ast.newFunctionDeclaration();
        newConstructor.setName(ast.newSimpleName(subclass.getName().getIdentifier()));
        newConstructor.setConstructor(true);
        newConstructor.setExtraDimensions(0);
        newConstructor.setJavadoc(null);
        newConstructor.modifiers().addAll(ASTNodeFactory.newModifiers(ast, ChangeSignatureRefactoring.getAccessModifier(subclass)));
        newConstructor.setReturnType2((Type)ast.newPrimitiveType(PrimitiveType.VOID));
        Block body = ast.newBlock();
        newConstructor.setBody(body);
        SuperConstructorInvocation superCall = ast.newSuperConstructorInvocation();
        this.addArgumentsToNewSuperConstructorCall(superCall, cuRewrite);
        body.statements().add(superCall);
        String msg = RefactoringCoreMessages.ChangeSignatureRefactoring_add_constructor;
        TextEditGroup description = cuRewrite.createGroupDescription(msg);
        cuRewrite.getASTRewrite().getListRewrite((ASTNode)subclass, subclass.getBodyDeclarationsProperty()).insertFirst((ASTNode)newConstructor, description);
    }

    private static int getAccessModifier(AbstractTypeDeclaration subclass) {
        int modifiers = subclass.getModifiers();
        if (Modifier.isPublic((int)modifiers)) {
            return 1;
        }
        if (Modifier.isProtected((int)modifiers)) {
            return 4;
        }
        if (Modifier.isPrivate((int)modifiers)) {
            return 2;
        }
        return 0;
    }

    private FunctionDeclaration[] getAllConstructors(AbstractTypeDeclaration typeDeclaration) {
        ArrayList<BodyDeclaration> result = new ArrayList<BodyDeclaration>(1);
        ListIterator it = typeDeclaration.bodyDeclarations().listIterator();
        while (it.hasNext()) {
            BodyDeclaration decl = (BodyDeclaration)it.next();
            if (!(decl instanceof FunctionDeclaration) || !((FunctionDeclaration)decl).isConstructor()) continue;
            result.add(decl);
        }
        return result.toArray(new FunctionDeclaration[result.size()]);
    }

    private boolean isNoArgConstructor() throws JavaScriptModelException {
        return this.fMethod.isConstructor() && this.fMethod.getNumberOfParameters() == 0;
    }

    private Expression createNewExpression(ParameterInfo info, List parameterInfos, List nodes, CompilationUnitRewrite cuRewrite, FunctionDeclaration method) {
        if (info.isNewVarargs() && info.getDefaultValue().trim().length() == 0) {
            return null;
        }
        if (this.fDefaultValueAdvisor == null) {
            return (Expression)cuRewrite.getASTRewrite().createStringPlaceholder(info.getDefaultValue(), 32);
        }
        return this.fDefaultValueAdvisor.createDefaultExpression(nodes, info, parameterInfos, method, false, cuRewrite);
    }

    private boolean isVisibilitySameAsInitial() throws JavaScriptModelException {
        return this.fVisibility == JdtFlags.getVisibilityCode((IMember)this.fMethod);
    }

    private IJavaScriptSearchScope createRefactoringScope() throws JavaScriptModelException {
        return RefactoringScopeFactory.create((IJavaScriptElement)this.fMethod);
    }

    private SearchResultGroup[] findOccurrences(IProgressMonitor pm, RefactoringStatus status) throws JavaScriptModelException {
        if (this.fMethod.isConstructor()) {
            return ConstructorReferenceFinder.getConstructorOccurrences(this.fMethod, pm, status);
        }
        SearchPattern pattern = RefactoringSearchEngine.createOrPattern((IJavaScriptElement[])this.fRippleMethods, 3);
        return RefactoringSearchEngine.search(pattern, this.createRefactoringScope(), pm, status);
    }

    private static String createDeclarationString(ParameterInfo info) {
        return info.getNewName();
    }

    private OccurrenceUpdate createOccurrenceUpdate(ASTNode node, CompilationUnitRewrite cuRewrite, RefactoringStatus result) {
        if (ChangeSignatureRefactoring.isReferenceNode(node)) {
            return new ReferenceUpdate(node, cuRewrite, result);
        }
        if (node instanceof SimpleName && node.getParent() instanceof FunctionDeclaration) {
            return new DeclarationUpdate((FunctionDeclaration)node.getParent(), cuRewrite, result);
        }
        if (node instanceof MemberRef || node instanceof FunctionRef) {
            return new DocReferenceUpdate(node, cuRewrite, result);
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.jsdt.core.dom.ImportDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (ASTNodes.getParent(node, clazz) != null) {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.wst.jsdt.core.dom.ImportDeclaration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return new StaticImportUpdate((ImportDeclaration)ASTNodes.getParent(node, clazz2), cuRewrite, result);
        }
        return new NullOccurrenceUpdate(node, cuRewrite, result);
    }

    private static boolean isReferenceNode(ASTNode node) {
        switch (node.getNodeType()) {
            case 14: 
            case 17: 
            case 32: 
            case 46: 
            case 48: {
                return true;
            }
        }
        return false;
    }

    public RefactoringStatus initialize(RefactoringArguments arguments) {
        String delegate;
        if (arguments instanceof JavaRefactoringArguments) {
            String visibility;
            JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
            String handle = extended.getAttribute("input");
            if (handle != null) {
                IJavaScriptElement element = JDTRefactoringDescriptor.handleToElement(extended.getProject(), handle, false);
                if (element == null || !element.exists() || element.getElementType() != 9) {
                    return this.createInputFatalStatus(element, "org.eclipse.wst.jsdt.ui.change.method.signature");
                }
                this.fMethod = (IFunction)element;
                this.fMethodName = this.fMethod.getElementName();
                try {
                    this.fVisibility = JdtFlags.getVisibilityCode((IMember)this.fMethod);
                    this.fReturnTypeInfo = new ReturnTypeInfo(Signature.toString((String)Signature.getReturnType((String)this.fMethod.getSignature())));
                }
                catch (JavaScriptModelException javaScriptModelException) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, ATTRIBUTE_VISIBILITY));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            String name = extended.getAttribute("name");
            if (name != null) {
                this.fMethodName = name;
                RefactoringStatus status = Checks.checkMethodName(this.fMethodName);
                if (status.hasError()) {
                    return status;
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
            }
            String type = extended.getAttribute(ATTRIBUTE_RETURN);
            if (type != null && !"".equals(type)) {
                this.fReturnTypeInfo = new ReturnTypeInfo(type);
            }
            if ((visibility = extended.getAttribute(ATTRIBUTE_VISIBILITY)) != null && !"".equals(visibility)) {
                int flag = 0;
                try {
                    flag = Integer.parseInt(visibility);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_VISIBILITY));
                }
                this.fVisibility = flag;
            }
            int count = 1;
            String attribute = ATTRIBUTE_PARAMETER + count;
            String value = null;
            this.fParameterInfos = new ArrayList(3);
            while ((value = extended.getAttribute(attribute)) != null) {
                StringTokenizer tokenizer = new StringTokenizer(value);
                if (tokenizer.countTokens() < 6) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, ATTRIBUTE_PARAMETER));
                }
                String oldTypeName = tokenizer.nextToken();
                String oldName = tokenizer.nextToken();
                String oldIndex = tokenizer.nextToken();
                String newTypeName = tokenizer.nextToken();
                String newName = tokenizer.nextToken();
                String deleted = tokenizer.nextToken();
                ParameterInfo info = null;
                try {
                    info = new ParameterInfo(oldTypeName, oldName, Integer.valueOf(oldIndex));
                    info.setNewTypeName(newTypeName);
                    info.setNewName(newName);
                    if (Boolean.valueOf(deleted).booleanValue()) {
                        info.markAsDeleted();
                    }
                    this.fParameterInfos.add(info);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, ATTRIBUTE_PARAMETER));
                }
                String result = extended.getAttribute(ATTRIBUTE_DEFAULT + count);
                if (result != null && !"".equals(result)) {
                    info.setDefaultValue(result);
                }
                attribute = ATTRIBUTE_PARAMETER + ++count;
            }
            count = 1;
            this.fExceptionInfos = new ArrayList(2);
            attribute = "element" + count;
            while ((value = extended.getAttribute(attribute)) != null) {
                ExceptionInfo info = null;
                String kind = extended.getAttribute(ATTRIBUTE_KIND + count);
                if (kind != null) {
                    IJavaScriptElement element = JDTRefactoringDescriptor.handleToElement(extended.getProject(), value, false);
                    if (element == null || !element.exists()) {
                        return this.createInputFatalStatus(element, "org.eclipse.wst.jsdt.ui.change.method.signature");
                    }
                    try {
                        info = new ExceptionInfo((IType)element, Integer.valueOf(kind), null);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, ATTRIBUTE_KIND));
                    }
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, ATTRIBUTE_KIND));
                }
                this.fExceptionInfos.add(info);
                attribute = "element" + ++count;
            }
            String deprecate = extended.getAttribute(ATTRIBUTE_DEPRECATE);
            if (deprecate == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_DEPRECATE));
            }
            this.fDelegateDeprecation = Boolean.valueOf(deprecate);
            delegate = extended.getAttribute(ATTRIBUTE_DELEGATE);
            if (delegate == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_DELEGATE));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.fDelegateUpdating = Boolean.valueOf(delegate);
        return new RefactoringStatus();
    }

    protected ASTNode moveNode(ASTNode oldNode, ASTRewrite rewrite) {
        ASTNode movedNode = ASTNodes.isExistingNode(oldNode) ? rewrite.createMoveTarget(oldNode) : ASTNode.copySubtree((AST)rewrite.getAST(), (ASTNode)oldNode);
        return movedNode;
    }

    public String getDelegateUpdatingTitle(boolean plural) {
        if (plural) {
            return RefactoringCoreMessages.DelegateCreator_keep_original_changed_plural;
        }
        return RefactoringCoreMessages.DelegateCreator_keep_original_changed_singular;
    }

    public IDefaultValueAdvisor getDefaultValueAdvisor() {
        return this.fDefaultValueAdvisor;
    }

    public void setDefaultValueAdvisor(IDefaultValueAdvisor defaultValueAdvisor) {
        this.fDefaultValueAdvisor = defaultValueAdvisor;
    }

    class DeclarationUpdate
    extends OccurrenceUpdate {
        private FunctionDeclaration fMethDecl;

        protected DeclarationUpdate(FunctionDeclaration decl, CompilationUnitRewrite cuRewrite, RefactoringStatus result) {
            super(cuRewrite, cuRewrite.createGroupDescription(RefactoringCoreMessages.ChangeSignatureRefactoring_change_signature), result);
            this.fMethDecl = decl;
        }

        protected void registerImportRemoveNode(ASTNode node) {
            if (!ChangeSignatureRefactoring.this.fDelegateUpdating) {
                super.registerImportRemoveNode(node);
            }
        }

        public void updateNode() throws CoreException {
            this.changeParamguments();
            if (ChangeSignatureRefactoring.this.canChangeNameAndReturnType()) {
                this.changeMethodName();
                this.changeReturnType();
            }
            if (this.needsVisibilityUpdate()) {
                this.changeVisibility();
            }
            this.reshuffleElements();
            this.changeExceptions();
            this.changeJavadocTags();
            if (ChangeSignatureRefactoring.this.fBodyUpdater == null || ChangeSignatureRefactoring.this.fBodyUpdater.needsParameterUsedCheck()) {
                this.checkIfDeletedParametersUsed();
            }
            if (ChangeSignatureRefactoring.this.fBodyUpdater != null) {
                ChangeSignatureRefactoring.this.fBodyUpdater.updateBody(this.fMethDecl, this.fCuRewrite, this.fResult);
            }
            if (ChangeSignatureRefactoring.this.fDelegateUpdating) {
                this.addDelegate();
            }
        }

        private void addDelegate() throws JavaScriptModelException {
            DelegateMethodCreator creator = new DelegateMethodCreator();
            creator.setDeclaration((BodyDeclaration)this.fMethDecl);
            creator.setDeclareDeprecated(ChangeSignatureRefactoring.this.fDelegateDeprecation);
            creator.setSourceRewrite(this.fCuRewrite);
            creator.prepareDelegate();
            ASTNode delegateInvocation = creator.getDelegateInvocation();
            if (delegateInvocation != null) {
                new ReferenceUpdate(delegateInvocation, creator.getDelegateRewrite(), this.fResult).updateNode();
            }
            new DocReferenceUpdate((ASTNode)creator.getJavadocReference(), creator.getDelegateRewrite(), this.fResult).updateNode();
            creator.createEdit();
        }

        protected ListRewrite getParamgumentsRewrite() {
            return this.getASTRewrite().getListRewrite((ASTNode)this.fMethDecl, FunctionDeclaration.PARAMETERS_PROPERTY);
        }

        protected void changeParamgumentName(ParameterInfo info) {
            SingleVariableDeclaration param = (SingleVariableDeclaration)this.fMethDecl.parameters().get(info.getOldIndex());
            if (!info.getOldName().equals(param.getName().getIdentifier())) {
                return;
            }
            String msg = RefactoringCoreMessages.ChangeSignatureRefactoring_update_parameter_references;
            TextEditGroup description = this.fCuRewrite.createGroupDescription(msg);
            TempOccurrenceAnalyzer analyzer = new TempOccurrenceAnalyzer((VariableDeclaration)param, false);
            analyzer.perform();
            SimpleName[] paramOccurrences = analyzer.getReferenceAndDeclarationNodes();
            int j = 0;
            while (j < paramOccurrences.length) {
                SimpleName occurence = paramOccurrences[j];
                this.getASTRewrite().set((ASTNode)occurence, (StructuralPropertyDescriptor)SimpleName.IDENTIFIER_PROPERTY, (Object)info.getNewName(), description);
                ++j;
            }
        }

        protected void changeParamgumentType(ParameterInfo info) {
            SingleVariableDeclaration oldParam = (SingleVariableDeclaration)this.fMethDecl.parameters().get(info.getOldIndex());
            this.getASTRewrite().set((ASTNode)oldParam, (StructuralPropertyDescriptor)SingleVariableDeclaration.VARARGS_PROPERTY, (Object)info.isNewVarargs(), this.fDescription);
            this.replaceTypeNode(oldParam.getType(), ParameterInfo.stripEllipsis(info.getNewTypeName()), info.getNewTypeBinding());
            this.removeExtraDimensions(oldParam);
        }

        private void removeExtraDimensions(SingleVariableDeclaration oldParam) {
            if (oldParam.getExtraDimensions() != 0) {
                this.getASTRewrite().set((ASTNode)oldParam, (StructuralPropertyDescriptor)SingleVariableDeclaration.EXTRA_DIMENSIONS_PROPERTY, (Object)new Integer(0), this.fDescription);
            }
        }

        private void changeReturnType() throws JavaScriptModelException {
            if (ChangeSignatureRefactoring.this.isReturnTypeSameAsInitial()) {
                return;
            }
            this.replaceTypeNode(this.fMethDecl.getReturnType2(), ChangeSignatureRefactoring.this.fReturnTypeInfo.getNewTypeName(), ChangeSignatureRefactoring.this.fReturnTypeInfo.getNewTypeBinding());
            this.removeExtraDimensions(this.fMethDecl);
        }

        private void removeExtraDimensions(FunctionDeclaration methDecl) {
            if (methDecl.getExtraDimensions() != 0) {
                this.getASTRewrite().set((ASTNode)methDecl, (StructuralPropertyDescriptor)FunctionDeclaration.EXTRA_DIMENSIONS_PROPERTY, (Object)new Integer(0), this.fDescription);
            }
        }

        private boolean needsVisibilityUpdate() throws JavaScriptModelException {
            if (ChangeSignatureRefactoring.this.isVisibilitySameAsInitial()) {
                return false;
            }
            if (this.isIncreasingVisibility()) {
                return JdtFlags.isHigherVisibility(ChangeSignatureRefactoring.this.fVisibility, JdtFlags.getVisibilityCode((BodyDeclaration)this.fMethDecl));
            }
            return JdtFlags.isHigherVisibility(JdtFlags.getVisibilityCode((BodyDeclaration)this.fMethDecl), ChangeSignatureRefactoring.this.fVisibility);
        }

        private boolean isIncreasingVisibility() throws JavaScriptModelException {
            return JdtFlags.isHigherVisibility(ChangeSignatureRefactoring.this.fVisibility, JdtFlags.getVisibilityCode((IMember)ChangeSignatureRefactoring.this.fMethod));
        }

        private void changeVisibility() {
            ModifierRewrite.create(this.getASTRewrite(), (ASTNode)this.fMethDecl).setVisibility(ChangeSignatureRefactoring.this.fVisibility, this.fDescription);
        }

        private void changeExceptions() {
            Iterator iter = ChangeSignatureRefactoring.this.fExceptionInfos.iterator();
            while (iter.hasNext()) {
                ExceptionInfo info = (ExceptionInfo)iter.next();
                if (info.isOld()) continue;
                if (info.isDeleted()) {
                    this.removeExceptionFromNodeList(info, this.fMethDecl.thrownExceptions());
                    continue;
                }
                this.addExceptionToNodeList(info, this.getASTRewrite().getListRewrite((ASTNode)this.fMethDecl, FunctionDeclaration.THROWN_EXCEPTIONS_PROPERTY));
            }
        }

        private void removeExceptionFromNodeList(ExceptionInfo toRemove, List exceptionsNodeList) {
            ITypeBinding typeToRemove = toRemove.getTypeBinding();
            Iterator iter = exceptionsNodeList.iterator();
            while (iter.hasNext()) {
                Name currentName = (Name)iter.next();
                ITypeBinding currentType = currentName.resolveTypeBinding();
                if (currentType == null || !Bindings.equals((IBinding)currentType, (IBinding)typeToRemove) && !toRemove.getType().getElementName().equals(currentType.getName())) continue;
                this.getASTRewrite().remove((ASTNode)currentName, this.fDescription);
                this.registerImportRemoveNode((ASTNode)currentName);
            }
        }

        private void addExceptionToNodeList(ExceptionInfo exceptionInfo, ListRewrite exceptionListRewrite) {
            String fullyQualified = JavaModelUtil.getFullyQualifiedName(exceptionInfo.getType());
            Iterator iter = exceptionListRewrite.getOriginalList().iterator();
            while (iter.hasNext()) {
                Name exName = (Name)iter.next();
                ITypeBinding typeBinding = exName.resolveTypeBinding();
                if (typeBinding == null || !typeBinding.getQualifiedName().equals(fullyQualified)) continue;
                return;
            }
            String importedType = this.getImportRewrite().addImport(JavaModelUtil.getFullyQualifiedName(exceptionInfo.getType()));
            this.getImportRemover().registerAddedImport(importedType);
            ASTNode exNode = this.getASTRewrite().createStringPlaceholder(importedType, 42);
            exceptionListRewrite.insertLast(exNode, this.fDescription);
        }

        private void changeJavadocTags() throws JavaScriptModelException {
            TagElement movedTag;
            TagElement tag;
            TagElement previousTag;
            JSdoc javadoc = this.fMethDecl.getJavadoc();
            if (javadoc == null) {
                return;
            }
            ITypeBinding typeBinding = Bindings.getBindingOfParentType((ASTNode)this.fMethDecl);
            if (typeBinding == null) {
                return;
            }
            IFunctionBinding methodBinding = this.fMethDecl.resolveBinding();
            if (methodBinding == null) {
                return;
            }
            boolean isTopOfRipple = Bindings.findOverriddenMethod(methodBinding, false) == null;
            List tags = javadoc.tags();
            ListRewrite tagsRewrite = this.getASTRewrite().getListRewrite((ASTNode)javadoc, JSdoc.TAGS_PROPERTY);
            if (!ChangeSignatureRefactoring.this.isReturnTypeSameAsInitial()) {
                if (PrimitiveType.VOID.toString().equals(ChangeSignatureRefactoring.this.fReturnTypeInfo.getNewTypeName())) {
                    int i = 0;
                    while (i < tags.size()) {
                        TagElement tag2 = (TagElement)tags.get(i);
                        if ("@return".equals(tag2.getTagName())) {
                            this.getASTRewrite().remove((ASTNode)tag2, this.fDescription);
                            this.registerImportRemoveNode((ASTNode)tag2);
                        }
                        ++i;
                    }
                } else if (isTopOfRipple && "V".equals(ChangeSignatureRefactoring.this.fMethod.getReturnType())) {
                    TagElement returnNode = this.createReturnTag();
                    previousTag = this.findTagElementToInsertAfter(tags, "@return");
                    this.insertTag(returnNode, previousTag, tagsRewrite);
                    tags = tagsRewrite.getRewrittenList();
                }
            }
            if (!ChangeSignatureRefactoring.this.areNamesSameAsInitial() || !ChangeSignatureRefactoring.this.isOrderSameAsInitial()) {
                ArrayList<TagElement> paramTags = new ArrayList<TagElement>();
                Iterator iter = tags.iterator();
                while (iter.hasNext()) {
                    tag = (TagElement)iter.next();
                    String tagName = tag.getTagName();
                    List fragments = tag.fragments();
                    if (!"@param".equals(tagName) || fragments.size() <= 0 || !(fragments.get(0) instanceof SimpleName)) continue;
                    SimpleName simpleName = (SimpleName)fragments.get(0);
                    String identifier = simpleName.getIdentifier();
                    boolean removed = false;
                    int i = 0;
                    while (i < ChangeSignatureRefactoring.this.fParameterInfos.size()) {
                        ParameterInfo info = (ParameterInfo)ChangeSignatureRefactoring.this.fParameterInfos.get(i);
                        if (identifier.equals(info.getOldName())) {
                            if (info.isDeleted()) {
                                this.getASTRewrite().remove((ASTNode)tag, this.fDescription);
                                this.registerImportRemoveNode((ASTNode)tag);
                                removed = true;
                                break;
                            }
                            if (!info.isRenamed()) break;
                            SimpleName newName = simpleName.getAST().newSimpleName(info.getNewName());
                            this.getASTRewrite().replace((ASTNode)simpleName, (ASTNode)newName, this.fDescription);
                            this.registerImportRemoveNode((ASTNode)tag);
                            break;
                        }
                        ++i;
                    }
                    if (removed) continue;
                    paramTags.add(tag);
                }
                tags = tagsRewrite.getRewrittenList();
                if (!ChangeSignatureRefactoring.this.isOrderSameAsInitial()) {
                    previousTag = this.findTagElementToInsertAfter(tags, "@param");
                    boolean first = true;
                    Iterator infoIter = ChangeSignatureRefactoring.this.fParameterInfos.iterator();
                    while (infoIter.hasNext()) {
                        ParameterInfo info = (ParameterInfo)infoIter.next();
                        String oldName = info.getOldName();
                        String newName = info.getNewName();
                        if (info.isAdded()) {
                            first = false;
                            if (!isTopOfRipple) continue;
                            TagElement paramNode = JavadocUtil.createParamTag(newName, this.fCuRewrite.getRoot().getAST(), this.fCuRewrite.getCu().getJavaScriptProject());
                            this.insertTag(paramNode, previousTag, tagsRewrite);
                            previousTag = paramNode;
                            continue;
                        }
                        Iterator tagIter = paramTags.iterator();
                        while (tagIter.hasNext()) {
                            TagElement tag3 = (TagElement)tagIter.next();
                            SimpleName tagName = (SimpleName)tag3.fragments().get(0);
                            if (oldName.equals(tagName.getIdentifier())) {
                                tagIter.remove();
                                if (first) {
                                    previousTag = tag3;
                                } else {
                                    movedTag = (TagElement)this.getASTRewrite().createMoveTarget((ASTNode)tag3);
                                    this.getASTRewrite().remove((ASTNode)tag3, this.fDescription);
                                    this.insertTag(movedTag, previousTag, tagsRewrite);
                                    previousTag = movedTag;
                                }
                            }
                            first = false;
                        }
                    }
                    Iterator iter2 = paramTags.iterator();
                    while (iter2.hasNext()) {
                        TagElement tag4 = (TagElement)iter2.next();
                        TagElement movedTag2 = (TagElement)this.getASTRewrite().createMoveTarget((ASTNode)tag4);
                        this.getASTRewrite().remove((ASTNode)tag4, this.fDescription);
                        this.insertTag(movedTag2, previousTag, tagsRewrite);
                        previousTag = movedTag2;
                    }
                }
                tags = tagsRewrite.getRewrittenList();
            }
            if (!ChangeSignatureRefactoring.this.areExceptionsSameAsInitial()) {
                ITypeBinding infoBinding;
                ArrayList<TagElement> exceptionTags = new ArrayList<TagElement>();
                int i = 0;
                while (i < tags.size()) {
                    tag = (TagElement)tags.get(i);
                    if (("@throws".equals(tag.getTagName()) || "@exception".equals(tag.getTagName())) && tag.fragments().size() > 0 && tag.fragments().get(0) instanceof Name) {
                        boolean tagDeleted = false;
                        Name name = (Name)tag.fragments().get(0);
                        int j = 0;
                        while (j < ChangeSignatureRefactoring.this.fExceptionInfos.size()) {
                            ExceptionInfo info = (ExceptionInfo)ChangeSignatureRefactoring.this.fExceptionInfos.get(j);
                            if (info.isDeleted()) {
                                boolean remove = false;
                                ITypeBinding nameBinding = name.resolveTypeBinding();
                                if (nameBinding != null) {
                                    infoBinding = info.getTypeBinding();
                                    if (infoBinding != null && Bindings.equals((IBinding)infoBinding, (IBinding)nameBinding)) {
                                        remove = true;
                                    } else if (info.getType().getElementName().equals(nameBinding.getName())) {
                                        remove = true;
                                    }
                                    if (remove) {
                                        this.getASTRewrite().remove((ASTNode)tag, this.fDescription);
                                        this.registerImportRemoveNode((ASTNode)tag);
                                        tagDeleted = true;
                                        break;
                                    }
                                }
                            }
                            ++j;
                        }
                        if (!tagDeleted) {
                            exceptionTags.add(tag);
                        }
                    }
                    ++i;
                }
                tags = tagsRewrite.getRewrittenList();
                TagElement previousTag2 = this.findTagElementToInsertAfter(tags, "@throws");
                Iterator infoIter = ChangeSignatureRefactoring.this.fExceptionInfos.iterator();
                while (infoIter.hasNext()) {
                    ExceptionInfo info = (ExceptionInfo)infoIter.next();
                    if (info.isAdded()) {
                        if (!isTopOfRipple) continue;
                        TagElement excptNode = this.createExceptionTag(info.getType().getElementName());
                        this.insertTag(excptNode, previousTag2, tagsRewrite);
                        previousTag2 = excptNode;
                        continue;
                    }
                    Iterator tagIter = exceptionTags.iterator();
                    while (tagIter.hasNext()) {
                        TagElement tag5 = (TagElement)tagIter.next();
                        Name tagName = (Name)tag5.fragments().get(0);
                        ITypeBinding nameBinding = tagName.resolveTypeBinding();
                        if (nameBinding == null) continue;
                        boolean process = false;
                        infoBinding = info.getTypeBinding();
                        if (infoBinding != null && Bindings.equals((IBinding)infoBinding, (IBinding)nameBinding)) {
                            process = true;
                        } else if (info.getType().getElementName().equals(nameBinding.getName())) {
                            process = true;
                        }
                        if (!process) continue;
                        tagIter.remove();
                        movedTag = (TagElement)this.getASTRewrite().createMoveTarget((ASTNode)tag5);
                        this.getASTRewrite().remove((ASTNode)tag5, this.fDescription);
                        this.insertTag(movedTag, previousTag2, tagsRewrite);
                        previousTag2 = movedTag;
                    }
                }
                Iterator iter = exceptionTags.iterator();
                while (iter.hasNext()) {
                    TagElement tag6 = (TagElement)iter.next();
                    TagElement movedTag3 = (TagElement)this.getASTRewrite().createMoveTarget((ASTNode)tag6);
                    this.getASTRewrite().remove((ASTNode)tag6, this.fDescription);
                    this.insertTag(movedTag3, previousTag2, tagsRewrite);
                    previousTag2 = movedTag3;
                }
            }
        }

        private TagElement createReturnTag() {
            TagElement returnNode = this.getASTRewrite().getAST().newTagElement();
            returnNode.setTagName("@return");
            TextElement textElement = this.getASTRewrite().getAST().newTextElement();
            String text = StubUtility.getTodoTaskTag(this.fCuRewrite.getCu().getJavaScriptProject());
            if (text != null) {
                textElement.setText(text);
            }
            returnNode.fragments().add(textElement);
            return returnNode;
        }

        private TagElement createExceptionTag(String simpleName) {
            TagElement excptNode = this.getASTRewrite().getAST().newTagElement();
            excptNode.setTagName("@throws");
            SimpleName nameNode = this.getASTRewrite().getAST().newSimpleName(simpleName);
            excptNode.fragments().add(nameNode);
            TextElement textElement = this.getASTRewrite().getAST().newTextElement();
            String text = StubUtility.getTodoTaskTag(this.fCuRewrite.getCu().getJavaScriptProject());
            if (text != null) {
                textElement.setText(text);
            }
            excptNode.fragments().add(textElement);
            return excptNode;
        }

        private void insertTag(TagElement tag, TagElement previousTag, ListRewrite tagsRewrite) {
            if (previousTag == null) {
                tagsRewrite.insertFirst((ASTNode)tag, this.fDescription);
            } else {
                tagsRewrite.insertAfter((ASTNode)tag, (ASTNode)previousTag, this.fDescription);
            }
        }

        private TagElement findTagElementToInsertAfter(List tags, String tagName) {
            List<String> tagOrder = Arrays.asList("@author", "@version", "@param", "@return", "@throws", "@exception", "@see", "@since", "@serial", "@serialField", "@serialData", "@deprecated", "@value");
            int goalOrdinal = tagOrder.indexOf(tagName);
            if (goalOrdinal == -1) {
                return tags.size() == 0 ? null : (TagElement)tags.get(tags.size());
            }
            int i = 0;
            while (i < tags.size()) {
                int tagOrdinal = tagOrder.indexOf(((TagElement)tags.get(i)).getTagName());
                if (tagOrdinal >= goalOrdinal) {
                    return i == 0 ? null : (TagElement)tags.get(i - 1);
                }
                ++i;
            }
            return tags.size() == 0 ? null : (TagElement)tags.get(tags.size() - 1);
        }

        private void checkIfDeletedParametersUsed() {
            Iterator iter = ChangeSignatureRefactoring.this.getDeletedInfos().iterator();
            while (iter.hasNext()) {
                ParameterInfo info = (ParameterInfo)iter.next();
                SingleVariableDeclaration paramDecl = (SingleVariableDeclaration)this.fMethDecl.parameters().get(info.getOldIndex());
                TempOccurrenceAnalyzer analyzer = new TempOccurrenceAnalyzer((VariableDeclaration)paramDecl, false);
                analyzer.perform();
                SimpleName[] paramRefs = analyzer.getReferenceNodes();
                if (paramRefs.length <= 0) continue;
                RefactoringStatusContext context = JavaStatusContext.create((ITypeRoot)this.fCuRewrite.getCu(), (ASTNode)paramRefs[0]);
                String typeName = this.getFullTypeName(this.fMethDecl);
                Object[] keys = new String[]{paramDecl.getName().getIdentifier(), this.fMethDecl.getName().getIdentifier(), typeName};
                String msg = Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_parameter_used, keys);
                this.fResult.addError(msg, context);
            }
        }

        private String getFullTypeName(FunctionDeclaration decl) {
            FunctionDeclaration node = decl;
            do {
                if (!((node = node.getParent()) instanceof AbstractTypeDeclaration)) continue;
                return ((AbstractTypeDeclaration)node).getName().getIdentifier();
            } while (!(node instanceof ClassInstanceCreation));
            ClassInstanceCreation cic = (ClassInstanceCreation)node;
            return Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_anonymous_subclass, new String[]{ASTNodes.asString((ASTNode)cic.getType())});
        }

        protected ASTNode createNewParamgument(ParameterInfo info, List parameterInfos, List nodes) {
            return this.createNewSingleVariableDeclaration(info);
        }

        private SingleVariableDeclaration createNewSingleVariableDeclaration(ParameterInfo info) {
            SingleVariableDeclaration newP = this.getASTRewrite().getAST().newSingleVariableDeclaration();
            newP.setName(this.getASTRewrite().getAST().newSimpleName(info.getNewName()));
            newP.setType(this.createNewTypeNode(ParameterInfo.stripEllipsis(info.getNewTypeName()), info.getNewTypeBinding()));
            newP.setVarargs(info.isNewVarargs());
            return newP;
        }

        protected SimpleName getMethodNameNode() {
            return this.fMethDecl.getName();
        }
    }

    class DocReferenceUpdate
    extends OccurrenceUpdate {
        private ASTNode fNode;

        protected DocReferenceUpdate(ASTNode node, CompilationUnitRewrite cuRewrite, RefactoringStatus result) {
            super(cuRewrite, cuRewrite.createGroupDescription(RefactoringCoreMessages.ChangeSignatureRefactoring_update_javadoc_reference), result);
            this.fNode = node;
        }

        public void updateNode() {
            if (this.fNode instanceof FunctionRef) {
                this.changeParamguments();
                this.reshuffleElements();
            }
            if (ChangeSignatureRefactoring.this.canChangeNameAndReturnType()) {
                this.changeMethodName();
            }
        }

        protected ASTNode createNewParamgument(ParameterInfo info, List parameterInfos, List nodes) {
            return this.createNewMethodRefParameter(info);
        }

        private FunctionRefParameter createNewMethodRefParameter(ParameterInfo info) {
            FunctionRefParameter newP = this.getASTRewrite().getAST().newFunctionRefParameter();
            List parameters = this.getParamgumentsRewrite().getOriginalList();
            if (parameters.size() > 0 && ((FunctionRefParameter)parameters.get(0)).getName() != null) {
                newP.setName(this.getASTRewrite().getAST().newSimpleName(info.getNewName()));
            }
            newP.setType(this.createNewDocRefType(info));
            newP.setVarargs(info.isNewVarargs());
            return newP;
        }

        private Type createNewDocRefType(ParameterInfo info) {
            String newTypeName = ParameterInfo.stripEllipsis(info.getNewTypeName());
            ITypeBinding newTypeBinding = info.getNewTypeBinding();
            if (newTypeBinding != null) {
                newTypeBinding = newTypeBinding.getErasure();
            }
            return this.createNewTypeNode(newTypeName, newTypeBinding);
        }

        protected SimpleName getMethodNameNode() {
            if (this.fNode instanceof MemberRef) {
                return ((MemberRef)this.fNode).getName();
            }
            if (this.fNode instanceof FunctionRef) {
                return ((FunctionRef)this.fNode).getName();
            }
            return null;
        }

        protected ListRewrite getParamgumentsRewrite() {
            return this.getASTRewrite().getListRewrite(this.fNode, FunctionRef.PARAMETERS_PROPERTY);
        }

        protected void changeParamgumentName(ParameterInfo info) {
            if (!(this.fNode instanceof FunctionRef)) {
                return;
            }
            FunctionRefParameter oldParam = (FunctionRefParameter)((FunctionRef)this.fNode).parameters().get(info.getOldIndex());
            SimpleName oldParamName = oldParam.getName();
            if (oldParamName != null) {
                this.getASTRewrite().set((ASTNode)oldParamName, (StructuralPropertyDescriptor)SimpleName.IDENTIFIER_PROPERTY, (Object)info.getNewName(), this.fDescription);
            }
        }

        protected void changeParamgumentType(ParameterInfo info) {
            if (!(this.fNode instanceof FunctionRef)) {
                return;
            }
            FunctionRefParameter oldParam = (FunctionRefParameter)((FunctionRef)this.fNode).parameters().get(info.getOldIndex());
            Type oldTypeNode = oldParam.getType();
            Type newTypeNode = this.createNewDocRefType(info);
            if (info.isNewVarargs()) {
                if (info.isOldVarargs() && !oldParam.isVarargs()) {
                    newTypeNode = this.getASTRewrite().getAST().newArrayType(newTypeNode);
                } else {
                    this.getASTRewrite().set((ASTNode)oldParam, (StructuralPropertyDescriptor)FunctionRefParameter.VARARGS_PROPERTY, (Object)Boolean.TRUE, this.fDescription);
                }
            } else if (oldParam.isVarargs()) {
                this.getASTRewrite().set((ASTNode)oldParam, (StructuralPropertyDescriptor)FunctionRefParameter.VARARGS_PROPERTY, (Object)Boolean.FALSE, this.fDescription);
            }
            this.getASTRewrite().replace((ASTNode)oldTypeNode, (ASTNode)newTypeNode, this.fDescription);
            this.registerImportRemoveNode((ASTNode)oldTypeNode);
        }
    }

    class NullOccurrenceUpdate
    extends OccurrenceUpdate {
        private ASTNode fNode;

        protected NullOccurrenceUpdate(ASTNode node, CompilationUnitRewrite cuRewrite, RefactoringStatus result) {
            super(cuRewrite, null, result);
            this.fNode = node;
        }

        public void updateNode() throws JavaScriptModelException {
            int start = this.fNode.getStartPosition();
            int length = this.fNode.getLength();
            String msg = "Cannot update found node: nodeType=" + this.fNode.getNodeType() + "; " + this.fNode.toString() + "[" + start + ", " + length + "]";
            JavaScriptPlugin.log(new Exception(String.valueOf(msg) + ":\n" + this.fCuRewrite.getCu().getSource().substring(start, start + length)));
            this.fResult.addError(msg, JavaStatusContext.create((ITypeRoot)this.fCuRewrite.getCu(), this.fNode));
        }

        protected ListRewrite getParamgumentsRewrite() {
            return null;
        }

        protected ASTNode createNewParamgument(ParameterInfo info, List parameterInfos, List nodes) {
            return null;
        }

        protected SimpleName getMethodNameNode() {
            return null;
        }
    }

    abstract class OccurrenceUpdate {
        protected final CompilationUnitRewrite fCuRewrite;
        protected final TextEditGroup fDescription;
        protected RefactoringStatus fResult;

        protected OccurrenceUpdate(CompilationUnitRewrite cuRewrite, TextEditGroup description, RefactoringStatus result) {
            this.fCuRewrite = cuRewrite;
            this.fDescription = description;
            this.fResult = result;
        }

        protected final ASTRewrite getASTRewrite() {
            return this.fCuRewrite.getASTRewrite();
        }

        protected final ImportRewrite getImportRewrite() {
            return this.fCuRewrite.getImportRewrite();
        }

        protected final ImportRemover getImportRemover() {
            return this.fCuRewrite.getImportRemover();
        }

        protected final CompilationUnitRewrite getCompilationUnitRewrite() {
            return this.fCuRewrite;
        }

        public abstract void updateNode() throws CoreException;

        protected void registerImportRemoveNode(ASTNode node) {
            this.getImportRemover().registerRemovedNode(node);
        }

        protected final void reshuffleElements() {
            if (ChangeSignatureRefactoring.this.isOrderSameAsInitial()) {
                return;
            }
            ListRewrite listRewrite = this.getParamgumentsRewrite();
            LinkedHashMap newOldMap = new LinkedHashMap();
            List nodes = listRewrite.getRewrittenList();
            Iterator rewriteIter = nodes.iterator();
            List original = listRewrite.getOriginalList();
            Iterator iter = original.iterator();
            while (iter.hasNext()) {
                newOldMap.put(rewriteIter.next(), iter.next());
            }
            ArrayList<ASTNode> newNodes = new ArrayList<ASTNode>();
            int i = 0;
            while (i < ChangeSignatureRefactoring.this.fParameterInfos.size()) {
                ParameterInfo info = (ParameterInfo)ChangeSignatureRefactoring.this.fParameterInfos.get(i);
                int oldIndex = info.getOldIndex();
                if (info.isDeleted()) {
                    if (oldIndex != ChangeSignatureRefactoring.this.fOldVarargIndex) {
                        this.registerImportRemoveNode((ASTNode)nodes.get(oldIndex));
                    } else {
                        int n = oldIndex;
                        while (n < nodes.size()) {
                            this.registerImportRemoveNode((ASTNode)nodes.get(n));
                            ++n;
                        }
                    }
                } else if (info.isAdded()) {
                    ASTNode newParamgument = this.createNewParamgument(info, ChangeSignatureRefactoring.this.fParameterInfos, nodes);
                    if (newParamgument != null) {
                        newNodes.add(newParamgument);
                    }
                } else if (oldIndex != ChangeSignatureRefactoring.this.fOldVarargIndex) {
                    ASTNode oldNode = (ASTNode)nodes.get(oldIndex);
                    ASTNode movedNode = ChangeSignatureRefactoring.this.moveNode(oldNode, this.getASTRewrite());
                    newNodes.add(movedNode);
                } else {
                    int n = oldIndex;
                    while (n < nodes.size()) {
                        ASTNode oldNode = (ASTNode)nodes.get(n);
                        ASTNode movedNode = ChangeSignatureRefactoring.this.moveNode(oldNode, this.getASTRewrite());
                        newNodes.add(movedNode);
                        ++n;
                    }
                }
                ++i;
            }
            Iterator nodesIter = nodes.iterator();
            Iterator newIter = newNodes.iterator();
            while (nodesIter.hasNext() && newIter.hasNext()) {
                ASTNode node = (ASTNode)nodesIter.next();
                ASTNode newNode = (ASTNode)newIter.next();
                if (!ASTNodes.isExistingNode(node)) {
                    listRewrite.replace((ASTNode)newOldMap.get(node), newNode, this.fDescription);
                    continue;
                }
                listRewrite.replace(node, newNode, this.fDescription);
            }
            while (nodesIter.hasNext()) {
                ASTNode node = (ASTNode)nodesIter.next();
                if (!ASTNodes.isExistingNode(node)) {
                    listRewrite.remove((ASTNode)newOldMap.get(node), this.fDescription);
                    continue;
                }
                listRewrite.remove(node, this.fDescription);
            }
            while (newIter.hasNext()) {
                ASTNode node = (ASTNode)newIter.next();
                listRewrite.insertLast(node, this.fDescription);
            }
        }

        protected abstract ListRewrite getParamgumentsRewrite();

        protected final void changeParamguments() {
            Iterator iter = ChangeSignatureRefactoring.this.getParameterInfos().iterator();
            while (iter.hasNext()) {
                ParameterInfo info = (ParameterInfo)iter.next();
                if (info.isAdded() || info.isDeleted()) continue;
                if (info.isRenamed()) {
                    this.changeParamgumentName(info);
                }
                if (!info.isTypeNameChanged()) continue;
                this.changeParamgumentType(info);
            }
        }

        protected void changeParamgumentName(ParameterInfo info) {
        }

        protected void changeParamgumentType(ParameterInfo info) {
        }

        protected final void replaceTypeNode(Type typeNode, String newTypeName, ITypeBinding newTypeBinding) {
            Type newTypeNode = this.createNewTypeNode(newTypeName, newTypeBinding);
            this.getASTRewrite().replace((ASTNode)typeNode, (ASTNode)newTypeNode, this.fDescription);
            this.registerImportRemoveNode((ASTNode)typeNode);
            this.getTightSourceRangeComputer().addTightSourceNode((ASTNode)typeNode);
        }

        protected abstract ASTNode createNewParamgument(ParameterInfo var1, List var2, List var3);

        protected abstract SimpleName getMethodNameNode();

        protected final void changeMethodName() {
            if (!ChangeSignatureRefactoring.this.isMethodNameSameAsInitial()) {
                SimpleName nameNode = this.getMethodNameNode();
                SimpleName newNameNode = nameNode.getAST().newSimpleName(ChangeSignatureRefactoring.this.fMethodName);
                this.getASTRewrite().replace((ASTNode)nameNode, (ASTNode)newNameNode, this.fDescription);
                this.registerImportRemoveNode((ASTNode)nameNode);
                this.getTightSourceRangeComputer().addTightSourceNode((ASTNode)nameNode);
            }
        }

        protected final Type createNewTypeNode(String newTypeName, ITypeBinding newTypeBinding) {
            Type newTypeNode;
            if (newTypeBinding == null) {
                newTypeNode = ChangeSignatureRefactoring.this.fDefaultValueAdvisor != null ? ChangeSignatureRefactoring.this.fDefaultValueAdvisor.createType(newTypeName, this.getMethodNameNode().getStartPosition(), this.getCompilationUnitRewrite()) : (Type)this.getASTRewrite().createStringPlaceholder(newTypeName, 43);
            } else {
                newTypeNode = this.getImportRewrite().addImport(newTypeBinding, this.fCuRewrite.getAST());
                this.getImportRemover().registerAddedImports(newTypeNode);
            }
            return newTypeNode;
        }

        protected final TightSourceRangeComputer getTightSourceRangeComputer() {
            return (TightSourceRangeComputer)this.fCuRewrite.getASTRewrite().getExtendedSourceRangeComputer();
        }
    }

    class ReferenceUpdate
    extends OccurrenceUpdate {
        private ASTNode fNode;

        protected ReferenceUpdate(ASTNode node, CompilationUnitRewrite cuRewrite, RefactoringStatus result) {
            super(cuRewrite, cuRewrite.createGroupDescription(RefactoringCoreMessages.ChangeSignatureRefactoring_update_reference), result);
            this.fNode = node;
        }

        public void updateNode() {
            this.reshuffleElements();
            this.changeMethodName();
        }

        protected ListRewrite getParamgumentsRewrite() {
            if (this.fNode instanceof FunctionInvocation) {
                return this.getASTRewrite().getListRewrite(this.fNode, FunctionInvocation.ARGUMENTS_PROPERTY);
            }
            if (this.fNode instanceof SuperMethodInvocation) {
                return this.getASTRewrite().getListRewrite(this.fNode, SuperMethodInvocation.ARGUMENTS_PROPERTY);
            }
            if (this.fNode instanceof ClassInstanceCreation) {
                return this.getASTRewrite().getListRewrite(this.fNode, ClassInstanceCreation.ARGUMENTS_PROPERTY);
            }
            if (this.fNode instanceof ConstructorInvocation) {
                return this.getASTRewrite().getListRewrite(this.fNode, ConstructorInvocation.ARGUMENTS_PROPERTY);
            }
            if (this.fNode instanceof SuperConstructorInvocation) {
                return this.getASTRewrite().getListRewrite(this.fNode, SuperConstructorInvocation.ARGUMENTS_PROPERTY);
            }
            return null;
        }

        protected ASTNode createNewParamgument(ParameterInfo info, List parameterInfos, List nodes) {
            CompilationUnitRewrite cuRewrite = this.getCompilationUnitRewrite();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.FunctionDeclaration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            FunctionDeclaration declaration = (FunctionDeclaration)ASTNodes.getParent(this.fNode, clazz);
            if (this.isRecursiveReference()) {
                return this.createNewExpressionRecursive(info, parameterInfos, nodes, cuRewrite, declaration);
            }
            return ChangeSignatureRefactoring.this.createNewExpression(info, parameterInfos, nodes, cuRewrite, declaration);
        }

        private Expression createNewExpressionRecursive(ParameterInfo info, List parameterInfos, List nodes, CompilationUnitRewrite cuRewrite, FunctionDeclaration methodDeclaration) {
            if (ChangeSignatureRefactoring.this.fDefaultValueAdvisor != null && info.isAdded()) {
                return ChangeSignatureRefactoring.this.fDefaultValueAdvisor.createDefaultExpression(nodes, info, parameterInfos, methodDeclaration, true, cuRewrite);
            }
            return (Expression)this.getASTRewrite().createStringPlaceholder(info.getNewName(), 32);
        }

        protected SimpleName getMethodNameNode() {
            if (this.fNode instanceof FunctionInvocation) {
                return ((FunctionInvocation)this.fNode).getName();
            }
            if (this.fNode instanceof SuperMethodInvocation) {
                return ((SuperMethodInvocation)this.fNode).getName();
            }
            return null;
        }

        private boolean isRecursiveReference() {
            FunctionDeclaration enclosingMethodDeclaration;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.FunctionDeclaration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((enclosingMethodDeclaration = (FunctionDeclaration)ASTNodes.getParent(this.fNode, clazz)) == null) {
                return false;
            }
            IFunctionBinding enclosingMethodBinding = enclosingMethodDeclaration.resolveBinding();
            if (enclosingMethodBinding == null) {
                return false;
            }
            if (this.fNode instanceof FunctionInvocation) {
                return enclosingMethodBinding == ((FunctionInvocation)this.fNode).resolveMethodBinding();
            }
            if (this.fNode instanceof SuperMethodInvocation) {
                IFunctionBinding methodBinding = ((SuperMethodInvocation)this.fNode).resolveMethodBinding();
                return this.isSameMethod(methodBinding, enclosingMethodBinding);
            }
            if (this.fNode instanceof ClassInstanceCreation) {
                return enclosingMethodBinding == ((ClassInstanceCreation)this.fNode).resolveConstructorBinding();
            }
            if (this.fNode instanceof ConstructorInvocation) {
                return enclosingMethodBinding == ((ConstructorInvocation)this.fNode).resolveConstructorBinding();
            }
            if (this.fNode instanceof SuperConstructorInvocation) {
                return false;
            }
            Assert.isTrue((boolean)false);
            return false;
        }

        private boolean isSameMethod(IFunctionBinding m1, IFunctionBinding m2) {
            ITypeBinding[] m2Parameters;
            if (m1.isConstructor() ? !m2.isConstructor() : !m1.getName().equals(m2.getName())) {
                return false;
            }
            ITypeBinding[] m1Parameters = m1.getParameterTypes();
            if (m1Parameters.length != (m2Parameters = m2.getParameterTypes()).length) {
                return false;
            }
            int i = 0;
            while (i < m1Parameters.length) {
                if (m1Parameters[i].getErasure() != m2Parameters[i].getErasure()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    class StaticImportUpdate
    extends OccurrenceUpdate {
        private final ImportDeclaration fImportDecl;

        public StaticImportUpdate(ImportDeclaration importDecl, CompilationUnitRewrite cuRewrite, RefactoringStatus result) {
            super(cuRewrite, null, result);
            this.fImportDecl = importDecl;
        }

        public void updateNode() throws JavaScriptModelException {
            ImportRewrite importRewrite = this.fCuRewrite.getImportRewrite();
            QualifiedName name = (QualifiedName)this.fImportDecl.getName();
            importRewrite.addStaticImport(name.getQualifier().getFullyQualifiedName(), ChangeSignatureRefactoring.this.fMethodName, false);
        }

        protected ListRewrite getParamgumentsRewrite() {
            return null;
        }

        protected ASTNode createNewParamgument(ParameterInfo info, List parameterInfos, List nodes) {
            return null;
        }

        protected SimpleName getMethodNameNode() {
            return null;
        }
    }
}

