/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.rewrite.modifying;

import java.util.List;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.tests.model.SuiteOfTestCases;
import org.eclipse.wst.jsdt.core.tests.rewrite.modifying.ASTRewritingModifyingTest;

public class ASTRewritingModifyingRemoveTest
extends ASTRewritingModifyingTest {
    private static final Class THIS;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.rewrite.modifying.ASTRewritingModifyingRemoveTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        THIS = clazz;
    }

    public ASTRewritingModifyingRemoveTest(String name) {
        super(name);
    }

    public static Test allTests() {
        return new SuiteOfTestCases.Suite(THIS);
    }

    public static Test suite() {
        return ASTRewritingModifyingRemoveTest.allTests();
    }

    public void test0003() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0003", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("function X() {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("function Y() {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("function Z() {\n");
        buf.append("\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        astRoot.recordModifications();
        List functions = astRoot.statements();
        functions.remove(1);
        String preview = this.evaluateRewrite(cu, astRoot);
        buf = new StringBuffer();
        buf.append("function X() {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("function Z() {\n");
        buf.append("\n");
        buf.append("}\n");
        ASTRewritingModifyingRemoveTest.assertEqualString(preview, buf.toString());
    }

    public void test0004() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0004", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("function X() {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("function Y() {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("function Z() {\n");
        buf.append("\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        astRoot.recordModifications();
        AST a = astRoot.getAST();
        List functions = astRoot.statements();
        FunctionDeclaration declaration1 = a.newFunctionDeclaration();
        declaration1.setName(a.newSimpleName("A"));
        functions.add(1, declaration1);
        functions.remove(1);
        String preview = this.evaluateRewrite(cu, astRoot);
        buf = new StringBuffer();
        buf.append("function X() {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("function Y() {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("function Z() {\n");
        buf.append("\n");
        buf.append("}\n");
        ASTRewritingModifyingRemoveTest.assertEqualString(preview, buf.toString());
    }

    public void test0005() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0005", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("/**\n");
        buf.append(" * NOTHING\n");
        buf.append(" * @since now\n");
        buf.append(" */\n");
        buf.append("function X() {\n");
        buf.append("\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        astRoot.recordModifications();
        List functions = astRoot.statements();
        FunctionDeclaration functionDeclaration = (FunctionDeclaration)functions.get(0);
        functionDeclaration.setJavadoc(null);
        String preview = this.evaluateRewrite(cu, astRoot);
        buf = new StringBuffer();
        buf.append("function X() {\n");
        buf.append("\n");
        buf.append("}\n");
        ASTRewritingModifyingRemoveTest.assertEqualString(preview, buf.toString());
    }

    public void Xtest0006() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0006", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("function foo() {\n");
        buf.append("    bar1();\n");
        buf.append("    \n");
        buf.append("    //comment1\n");
        buf.append("    bar2();//comment2\n");
        buf.append("    //comment3\n");
        buf.append("    bar3();\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        astRoot.recordModifications();
        List functions = astRoot.statements();
        FunctionDeclaration functionDeclaration = (FunctionDeclaration)functions.get(0);
        Block body = functionDeclaration.getBody();
        List statements = body.statements();
        statements.remove(1);
        String preview = this.evaluateRewrite(cu, astRoot);
        buf = new StringBuffer();
        buf.append("function foo() {\n");
        buf.append("    bar1();\n");
        buf.append("    \n");
        buf.append("    //comment3\n");
        buf.append("    bar3();\n");
        buf.append("}\n");
        ASTRewritingModifyingRemoveTest.assertEqualString(preview, buf.toString());
    }

    public void test0011() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0011", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("function X() {\n");
        buf.append("    // one line comment\n");
        buf.append("    function foo(){\n");
        buf.append("    }\n");
        buf.append("\n");
        buf.append("    /**\n");
        buf.append("     *\n");
        buf.append("     */\n");
        buf.append("    function foo1(){\n");
        buf.append("    }\n");
        buf.append("\n");
        buf.append("    function foo2(){\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        astRoot.recordModifications();
        List functions = astRoot.statements();
        FunctionDeclaration functionDeclaration = (FunctionDeclaration)functions.get(0);
        functionDeclaration.getBody().statements().remove(0);
        String preview = this.evaluateRewrite(cu, astRoot);
        buf = new StringBuffer();
        buf.append("function X() {\n");
        buf.append("    // one line comment\n");
        buf.append("    /**\n");
        buf.append("     *\n");
        buf.append("     */\n");
        buf.append("    function foo1(){\n");
        buf.append("    }\n");
        buf.append("\n");
        buf.append("    function foo2(){\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingModifyingRemoveTest.assertEqualString(preview, buf.toString());
    }
}

