/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.tests.contentassist;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.wst.jsdt.ui.tests.contentassist.ContentAssistTestUtilities;
import org.eclipse.wst.jsdt.ui.tests.utils.TestProjectSetup;

public class GlobalFunctionTests_Edited
extends TestCase {
    private static final String TEST_NAME = "Test Global Functions JavaScript Content Assist after Edit";
    private static TestProjectSetup fTestProjectSetup;
    static /* synthetic */ Class class$0;

    public GlobalFunctionTests_Edited() {
        super(TEST_NAME);
    }

    public GlobalFunctionTests_Edited(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.ui.tests.contentassist.GlobalFunctionTests_Edited");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite ts = new TestSuite((Class)clazz, TEST_NAME);
        fTestProjectSetup = new TestProjectSetup((Test)ts, "ContentAssist", "root", false){

            public void additionalSetUp() throws Exception {
                GlobalFunctionTests_Edited.editFile_test0_0();
                GlobalFunctionTests_Edited.editFile_TestNamedFunctionsAssignedToVariables_0();
            }
        };
        return fTestProjectSetup;
    }

    public void testFindFunctions_ThisFile_AfterEdit_EmptyLine() throws Exception {
        String[][] expectedProposals = new String[][]{{"functionOne() - Global", "functionTwo() : String - Global", "funcThree(paramOne) - Global", "funcFour(paramOne, paramTwo) : Number - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "test0_0.js", 55, 0, expectedProposals);
    }

    public void testFindFunctions_ThisFile_After_EditExpressionStarted_0() throws Exception {
        String[][] expectedProposals = new String[][]{{"functionOne() - Global", "functionTwo() : String - Global", "funcThree(paramOne) - Global", "funcFour(paramOne, paramTwo) : Number - Global", "funcFive(Number paramOne, String paramTwo) : String - Global", "funcSix(paramOne, String paramTwo) : Number - Global", "funcSeven(String paramOne, paramTwo) : Number - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "test0_0.js", 57, 1, expectedProposals);
    }

    public void testFindFunctions_ThisFile_AfterEdit_ExpressionStarted_1() throws Exception {
        String[][] expectedProposals = new String[][]{{"functionOne() - Global", "functionTwo() : String - Global", "funcThree(paramOne) - Global", "funcFour(paramOne, paramTwo) : Number - Global", "funcFive(Number paramOne, String paramTwo) : String - Global", "funcSix(paramOne, String paramTwo) : Number - Global", "funcSeven(String paramOne, paramTwo) : Number - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "test0_0.js", 59, 4, expectedProposals);
    }

    public void testFindFunctions_ThisFile_AfterEdit_ExpressionStarted_2() throws Exception {
        String[][] expectedProposals = new String[][]{{"functionTwo() : String - Global", "funcThree(paramOne) - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "test0_0.js", 61, 5, expectedProposals);
    }

    public void testFindFunctions_OtherFile_AferEdit_ExpressionStarted_0() throws Exception {
        String[][] expectedProposals = new String[][]{{"functionOne() - Global", "functionTwo() : String - Global", "funcThree(paramOne) - Global", "funcFour(paramOne, paramTwo) : Number - Global", "funcFive(Number paramOne, String paramTwo) : String - Global", "funcSix(paramOne, String paramTwo) : Number - Global", "funcSeven(String paramOne, paramTwo) : Number - Global", "funcEight(paramOne) : String - Global", "funcNine(paramOne) : Number - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "test0_1.js", 0, 1, expectedProposals);
    }

    public void testFindFunctions_OtherFile_AfterEdit_ExpressionStarted_1() throws Exception {
        String[][] expectedProposals = new String[][]{{"functionOne() - Global", "functionTwo() : String - Global", "funcThree(paramOne) - Global", "funcFour(paramOne, paramTwo) : Number - Global", "funcFive(Number paramOne, String paramTwo) : String - Global", "funcSix(paramOne, String paramTwo) : Number - Global", "funcSeven(String paramOne, paramTwo) : Number - Global", "funcEight(paramOne) : String - Global", "funcNine(paramOne) : Number - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "test0_1.js", 2, 4, expectedProposals);
    }

    public void testFindFunctions_OtherFile_AfterEdit_ExpressionStarted_2() throws Exception {
        String[][] expectedProposals = new String[][]{{"functionTwo() : String - Global", "funcThree(paramOne) - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "test0_1.js", 4, 5, expectedProposals);
    }

    public void testNamedFunctionsAssignedToVariables_ThisFile_AfterEdit_ExpressionNotStarted() throws Exception {
        String[][] expectedProposals = new String[][]{{"foo1Edit : Function - Global", "foo1Edit(param2) - Global", "foo2Edit : Function - Global", "foo2Edit(param3, param4) - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestNamedFunctionsAssignedToVariables_0.js", 8, 0, expectedProposals);
    }

    public void testNamedFunctionsAssignedToVariables_ThisFile_AfterEdit_ExpressionStarted1() throws Exception {
        String[][] expectedProposals = new String[][]{{"foo1Edit : Function - Global", "foo1Edit(param2) - Global", "foo2Edit : Function - Global", "foo2Edit(param3, param4) - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestNamedFunctionsAssignedToVariables_0.js", 10, 1, expectedProposals);
    }

    public void testNamedFunctionsAssignedToVariables_ThisFile_AfterEdit_ExpressionNotStarted_NegativeTest() throws Exception {
        String[][] expectedProposals = new String[][]{{"foo1Ignored", "foo2Ignored", "foo1EditIgnored", "foo2EditIgnored", "foo1 : Function - Global", "foo1(param2) - Global", "foo2 : Function - Global", "foo2(param3, param4) - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestNamedFunctionsAssignedToVariables_0.js", 8, 0, expectedProposals, true, false);
    }

    public void testNamedFunctionsAssignedToVariables_ThisFile_AfterEdit_ExpressionStarted1_NegativeTest() throws Exception {
        String[][] expectedProposals = new String[][]{{"foo1Ignored", "foo2Ignored", "foo1EditIgnored", "foo2EditIgnored", "foo1 : Function - Global", "foo1(param2) - Global", "foo2 : Function - Global", "foo2(param3, param4) - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestNamedFunctionsAssignedToVariables_0.js", 10, 1, expectedProposals, true, false);
    }

    public void testNamedFunctionsAssignedToVariables_OtherFile_AfterEdit_ExpressionNotStarted() throws Exception {
        String[][] expectedProposals = new String[][]{{"foo1Edit : Function - Global", "foo1Edit(param2) - Global", "foo2Edit : Function - Global", "foo2Edit(param3, param4) - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestNamedFunctionsAssignedToVariables_1.js", 0, 0, expectedProposals);
    }

    public void testNamedFunctionsAssignedToVariables_OtherFile_AfterEdit_ExpressionStarted1() throws Exception {
        String[][] expectedProposals = new String[][]{{"foo1Edit : Function - Global", "foo1Edit(param2) - Global", "foo2Edit : Function - Global", "foo2Edit(param3, param4) - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestNamedFunctionsAssignedToVariables_1.js", 2, 1, expectedProposals);
    }

    public void testNamedFunctionsAssignedToVariables_OtherFile_AfterEdit_ExpressionNotStarted_NegativeTest() throws Exception {
        String[][] expectedProposals = new String[][]{{"foo1Ignored", "foo2Ignored", "foo1EditIgnored", "foo2EditIgnored", "foo1 : Function - Global", "foo1(param2) - Global", "foo2 : Function - Global", "foo2(param3, param4) - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestNamedFunctionsAssignedToVariables_1.js", 0, 0, expectedProposals, true, false);
    }

    public void testNamedFunctionsAssignedToVariables_OtherFile_AfterEdit_ExpressionStarted1_NegativeTest() throws Exception {
        String[][] expectedProposals = new String[][]{{"foo1Ignored", "foo2Ignored", "foo1EditIgnored", "foo2EditIgnored", "foo1 : Function - Global", "foo1(param2) - Global", "foo2 : Function - Global", "foo2(param3, param4) - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestNamedFunctionsAssignedToVariables_1.js", 2, 1, expectedProposals, true, false);
    }

    private static void editFile_test0_0() throws Exception {
        fTestProjectSetup.editFile("test0_0.js", 0, 9, 4, "function");
        fTestProjectSetup.editFile("test0_0.js", 4, 9, 4, "function");
    }

    private static void editFile_TestNamedFunctionsAssignedToVariables_0() throws Exception {
        fTestProjectSetup.editFile("TestNamedFunctionsAssignedToVariables_0.js", 0, 4, 4, "foo1Edit");
        fTestProjectSetup.editFile("TestNamedFunctionsAssignedToVariables_0.js", 0, 24, 4, "foo1Edit");
        fTestProjectSetup.editFile("TestNamedFunctionsAssignedToVariables_0.js", 4, 0, 4, "foo2Edit");
        fTestProjectSetup.editFile("TestNamedFunctionsAssignedToVariables_0.js", 4, 20, 4, "foo2Edit");
    }
}

